/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.EmployeeAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XEmployeeCriteria;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.controls.form.combo.BooleanFilterCombo;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchComposite;
import ca.infodata.ofys.ui.controls.plugins.searchview.ErrorWhileSearchingException;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumn;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchColumnChoiceElement;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.person.employee.EmployeeMultiEditor;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EmployeeSearchComposite
extends BaseSearchComposite {
    private static final Logger logger = Logger.getLogger(EmployeeSearchComposite.class.getName());
    protected MyLabel lblName;
    protected MyText txtName;
    protected FontAwareSection secPlus;
    protected BooleanFilterCombo cmbDeleted;

    public EmployeeSearchComposite(Composite parent, FormToolkit toolkit, int style, boolean applySoundHelper) {
        super(parent, toolkit, style, applySoundHelper);
    }

    public EmployeeSearchComposite(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
    }

    public EmployeeSearchComposite(Composite parent, int style, boolean applySoundHelper) {
        super(parent, style, applySoundHelper);
    }

    public EmployeeSearchComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void setFocus() {
        this.txtName.setFocus();
    }

    public void createMyPartControl(Composite theParent, FormToolkit toolkit, int style) {
        this.isWithTemplateTool = false;
        this.templateType = null;
        super.createMyPartControl(theParent, toolkit, style);
    }

    protected void createMyControl(Composite parent, FormToolkit toolkit) {
        this.lblName = new MyLabel(parent, Messages.getString((String)"NOM", (String[])new String[0]), 0, toolkit);
        this.txtName = new MyText(parent, toolkit);
        this.txtName.setTextLimit(95);
        this.txtName.addKeyListener(this.enterCtrlEnterListener);
        this.txtName.setToolTipText(ENTER_CTRL_ENTER_TOOLTIP);
        this.secPlus = new FontAwareSection(parent, 2050, toolkit);
        toolkit.createCompositeSeparator((Composite)this.secPlus);
        this.secPlus.setText(Messages.getString((String)"RAFFINER", (String[])new String[0]));
        Composite compPlus = toolkit.createComposite((Composite)this.secPlus);
        compPlus.setLayout((Layout)new FormLayout());
        this.secPlus.setClient((Control)compPlus);
        MyLabel lblDeleted = new MyLabel(compPlus, String.valueOf(Messages.getString((String)"DESACTIVEE", (String[])new String[0])) + " : ", 0, toolkit);
        this.cmbDeleted = new BooleanFilterCombo(compPlus, toolkit);
        this.cmbDeleted.select((Object)Boolean.FALSE);
        FormLayout layout = new FormLayout();
        layout.marginBottom = 5;
        layout.marginHeight = 5;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.txtName.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.secPlus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbDeleted.getControl(), 0, 0x1000000);
        data.left = new FormAttachment(0);
        lblDeleted.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(lblDeleted.getControl());
        this.cmbDeleted.setLayoutData(data);
    }

    protected void search() throws ErrorWhileSearchingException {
        block4: {
            this.disposeTableColumns();
            this.createLoadingTableColumns();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                public void responseReceived(ReturnObject response) {
                    if (response == null || response.getObj() == null) {
                        EmployeeSearchComposite.this.searchResponse(new XBaseEmployee[0]);
                    } else {
                        EmployeeSearchComposite.this.searchResponse((XBaseEmployee[])response.getObj());
                    }
                }
            };
            try {
                XEmployeeCriteria criteria = new XEmployeeCriteria();
                criteria.name = StringUtils.trim((String)this.txtName.getText());
                criteria.deleted = (Boolean)this.cmbDeleted.getSelection();
                criteria.inObjectUsage = this.inLastUsed;
                EmployeeAccessorClient.getInstance().find(Application.get().getGlobalInstances().getSession(), (ICallback)callback, criteria);
            }
            catch (CannotConnectToServerException e) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
                throw new ErrorWhileSearchingException((Exception)((Object)e));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    private void searchResponse(final XBaseEmployee[] xBaseEmployees) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!EmployeeSearchComposite.this.parent.isDisposed()) {
                        if (Application.get().getGlobalInstances().getSession().getClientPreferences().getReturnListLength() <= xBaseEmployees.length) {
                            EmployeeSearchComposite.this.setMessage(MSG_TROP_DONNEES);
                        } else if (xBaseEmployees.length == 0) {
                            EmployeeSearchComposite.this.setMessage(MSG_AUCUNES_DONNEES);
                            EmployeeSearchComposite.this.txtName.setFocus();
                        } else {
                            EmployeeSearchComposite.this.setMessage(null);
                        }
                        EmployeeSearchComposite.this.disposeTableColumns();
                        EmployeeSearchComposite.this.createTableColumns();
                        SearchItem[] search = new SearchItem[xBaseEmployees.length];
                        int i = 0;
                        while (i < xBaseEmployees.length) {
                            XBaseEmployee p = xBaseEmployees[i];
                            search[i] = EmployeeSearchComposite.this.newSearchItem(p);
                            ++i;
                        }
                        EmployeeSearchComposite.this.loadSearchListInTable(search);
                        EmployeeSearchComposite.this.callbackContainerReferenceControlFromTableItems();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "", e);
                }
            }
        });
    }

    protected void createTableColumns() {
        this.tblSearch.setLinesVisible(false);
        this.tblSearch.setHeaderVisible(true);
        this.tableColumns = new ArrayList();
        if (Application.get().getGlobalInstances().inDebugMode()) {
            this.tableColumns.add(new SearchColumn<XBaseEmployee>((Table)this.tblSearch, "ID"){

                public String getText(XBaseEmployee e) {
                    return String.valueOf(e.getId());
                }
            });
        }
        SearchColumn sc = new SearchColumn<XBaseEmployee>((Table)this.tblSearch, Messages.getString((String)"NOM", (String[])new String[0])){

            public String getText(XBaseEmployee e) {
                return e.getName();
            }
        };
        sc.getColumn().setData("maxWidth", (Object)150);
        this.tableColumns.add(sc);
        sc = new SearchColumn<XBaseEmployee>((Table)this.tblSearch, Messages.getString((String)"TYPE", (String[])new String[0])){

            public String getText(XBaseEmployee e) {
                return e.getEmployeeType() == null ? "" : e.getEmployeeType().toString();
            }
        };
        sc.getColumn().setData("maxWidth", (Object)150);
        this.tableColumns.add(sc);
        sc = new SearchColumn<XBaseEmployee>((Table)this.tblSearch, Messages.getString((String)"DESACTIVEE", (String[])new String[0])){

            public String getText(XBaseEmployee e) {
                return e.getIsDeleted() != false ? "\u221a" : "";
            }
        };
        sc.getColumn().setData("maxWidth", (Object)100);
        this.tableColumns.add(sc);
    }

    protected void createNew() {
        XEmployee employee = new XEmployee();
        employee.initialize();
        BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)employee), (String)EmployeeMultiEditor.class.getName());
    }

    protected void processSelection(SearchItem item) {
        if (item != null && item.getData() instanceof XBaseEmployee && this.getSelectionReferenceControl() == null) {
            BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)item.getData()), (String)EmployeeMultiEditor.class.getName());
        }
    }

    protected SearchColumnChoiceElement[] getSearchColumnChoiceElements() {
        return null;
    }

    protected String getPreferencesKeys() {
        return null;
    }
}

