/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.professionnal;

import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.controls.ICombo;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.NullXBaseProfessionnal;
import ca.infodata.ofys.ui.person.professionnal.SOXBaseProfessionnal;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.IPair;
import ca.infodata.util1.Pair;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ProfessionalBySiteCombo
implements IControl,
ICombo<IPair<XBaseProfessionnal, XSite>> {
    private MyCombo<IPair<XBaseProfessionnal, XSite>> combo;
    private final int workSitesSize = SitePlugin.getDefault().getWorkSites().size();
    private final boolean cso;
    private final boolean cnull;
    private static final int STANDARD_TEXT_LIMIT = 100;
    private Map<IPair<XBaseProfessionnal, XSite>, String> labels;

    public ProfessionalBySiteCombo(Composite parent, int style, FormToolkit toolkit) {
        this.combo = new MyCombo(parent, style, toolkit);
        this.labels = new HashMap<IPair<XBaseProfessionnal, XSite>, String>();
        this.cso = (style | 0x2000) == style;
        this.cnull = (style | 0x10000) == style;
        this.combo.setLabelProvider((ProviderAR)new ProviderAR<IPair<XBaseProfessionnal, XSite>, String>(){

            public String get(IPair<XBaseProfessionnal, XSite> e) {
                if (e == null) {
                    return "";
                }
                String s = (String)ProfessionalBySiteCombo.this.labels.get(e);
                return s == null ? "" : s;
            }
        });
        this.combo.setDisplayPredicate((PredicateA)new PredicateA<IPair<XBaseProfessionnal, XSite>>(){

            public boolean evaluate(IPair<XBaseProfessionnal, XSite> c) {
                return c == null || !Boolean.TRUE.equals(((XBaseProfessionnal)c.getFirst()).getIsDeleted());
            }
        });
        this.combo.setTextLimit(100);
    }

    public void fill() {
        this.fill(PersonUiPlugin.getDefault().getTreatingProfessionnals());
    }

    public void setItems(Collection<XBaseProfessionnal> professionals) {
        this.fill(professionals == null ? null : professionals.stream());
    }

    public void fill(Stream<XBaseProfessionnal> professionals) {
        if (professionals != null) {
            List<IPair<XBaseProfessionnal, XSite>> items = ProfessionalBySiteCombo.toProfessionnalBySiteList(professionals);
            Pair so = null;
            if (this.cso) {
                so = new Pair((Object)new SOXBaseProfessionnal(), null);
                items.add((IPair<XBaseProfessionnal, XSite>)so);
            }
            Pair snull = null;
            if (this.cnull) {
                snull = new Pair((Object)new NullXBaseProfessionnal(), null);
                items.add((IPair<XBaseProfessionnal, XSite>)snull);
            }
            if (this.workSitesSize > 1) {
                ProfessionalBySiteCombo.sortBySiteAndProf(items);
            } else {
                ProfessionalBySiteCombo.sortByProf(items);
            }
            this.labels.clear();
            for (IPair<XBaseProfessionnal, XSite> e : items) {
                this.labels.put(e, this.getLabelForItem(e));
            }
            String text = this.combo.getText();
            IPair<XBaseProfessionnal, XSite> selection = this.getSelectionItem();
            IPair<XBaseProfessionnal, XSite> defaultSelection = (IPair<XBaseProfessionnal, XSite>)this.combo.getDefaultSelection();
            if (defaultSelection != null) {
                for (IPair<XBaseProfessionnal, XSite> i : items) {
                    if (!defaultSelection.equals(i)) continue;
                    defaultSelection = i;
                    break;
                }
            }
            this.combo.setItems(items);
            if (this.cso && defaultSelection == null) {
                defaultSelection = so;
            }
            if (this.cnull && defaultSelection == null) {
                defaultSelection = snull;
            }
            if (defaultSelection != null) {
                this.combo.setDefaultSelection((Object)defaultSelection);
            }
            if (selection != null) {
                this.combo.selectNoNotify(selection);
            } else {
                this.combo.setTextNoNotify(text);
            }
        }
    }

    protected String getLabelForItem(IPair<XBaseProfessionnal, XSite> e) {
        String text = e == null ? "" : (this.workSitesSize > 1 ? (e.getSecond() == null ? ((XBaseProfessionnal)e.getFirst()).getName() : String.valueOf(((XSite)e.getSecond()).getNameCommon()) + " - " + ((XBaseProfessionnal)e.getFirst()).getName()) : ((XBaseProfessionnal)e.getFirst()).getName());
        return text;
    }

    public static void sort(List<IPair<XBaseProfessionnal, XSite>> list) {
        int workSitesSize = SitePlugin.getDefault().getWorkSites().size();
        if (workSitesSize > 1) {
            ProfessionalBySiteCombo.sortBySiteAndProf(list);
        } else {
            ProfessionalBySiteCombo.sortByProf(list);
        }
    }

    public static void sortByProf(List<IPair<XBaseProfessionnal, XSite>> list) {
        Collections.sort(list, new Comparator<IPair<XBaseProfessionnal, XSite>>(){

            @Override
            public int compare(IPair<XBaseProfessionnal, XSite> o1, IPair<XBaseProfessionnal, XSite> o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getFirst() instanceof NullXBaseProfessionnal) {
                    return -1;
                }
                if (o1.getFirst() instanceof SOXBaseProfessionnal) {
                    return -1;
                }
                if (o2.getFirst() instanceof NullXBaseProfessionnal) {
                    return 1;
                }
                if (o2.getFirst() instanceof SOXBaseProfessionnal) {
                    return 1;
                }
                return StringUtils.compareAscii((String)((XBaseProfessionnal)o1.getFirst()).getName(), (String)((XBaseProfessionnal)o2.getFirst()).getName());
            }
        });
    }

    public static void sortBySiteAndProf(List<IPair<XBaseProfessionnal, XSite>> list) {
        Collections.sort(list, new Comparator<IPair<XBaseProfessionnal, XSite>>(){

            @Override
            public int compare(IPair<XBaseProfessionnal, XSite> o1, IPair<XBaseProfessionnal, XSite> o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getFirst() instanceof NullXBaseProfessionnal) {
                    return -1;
                }
                if (o1.getFirst() instanceof SOXBaseProfessionnal) {
                    return -1;
                }
                if (o2.getFirst() instanceof NullXBaseProfessionnal) {
                    return 1;
                }
                if (o2.getFirst() instanceof SOXBaseProfessionnal) {
                    return 1;
                }
                int i = o1.getSecond() == o2.getSecond() ? 0 : (o1.getSecond() == null ? -1 : (o2.getSecond() == null ? 1 : StringUtils.compareAscii((String)((XSite)o1.getSecond()).getNameCommon(), (String)((XSite)o2.getSecond()).getNameCommon())));
                if (i == 0) {
                    i = StringUtils.compareAscii((String)((XBaseProfessionnal)o1.getFirst()).getName(), (String)((XBaseProfessionnal)o2.getFirst()).getName());
                }
                return i;
            }
        });
    }

    public static List<IPair<XBaseProfessionnal, XSite>> toProfessionnalBySiteList(Collection<XBaseProfessionnal> professionals) {
        return ProfessionalBySiteCombo.toProfessionnalBySiteList(professionals.stream());
    }

    public static List<IPair<XBaseProfessionnal, XSite>> toProfessionnalBySiteList(Stream<XBaseProfessionnal> professionals) {
        HashSet<Pair> items = new HashSet<Pair>();
        Iterator iterator = professionals.iterator();
        while (iterator.hasNext()) {
            XBaseProfessionnal prof = (XBaseProfessionnal)iterator.next();
            if (prof.getSites() == null || prof.getSites().isEmpty()) {
                items.add(new Pair((Object)prof, null));
                continue;
            }
            for (XPersonSite ps : prof.getSites()) {
                if (ps == null) {
                    System.out.println("prof XPersonSite est null");
                    continue;
                }
                XSite site = SitePlugin.getDefault().getSite(ps.getIdSite());
                if (site == null) {
                    System.out.println(ps + " is bad - site is null");
                    continue;
                }
                if (!Boolean.TRUE.equals(site.isWorkSite)) continue;
                items.add(Pair.newPair((Object)prof, (Object)site));
            }
        }
        return new ArrayList<IPair<XBaseProfessionnal, XSite>>(items);
    }

    private IPair<XBaseProfessionnal, XSite> getSelectionItem() {
        IPair selection = (IPair)this.combo.getSelection();
        if (selection == null) {
            return null;
        }
        if (selection.getFirst() instanceof NullXBaseProfessionnal) {
            return null;
        }
        return selection;
    }

    public XBaseProfessionnal getSelection() {
        IPair<XBaseProfessionnal, XSite> selection = this.getSelectionItem();
        return selection == null ? null : (XBaseProfessionnal)selection.getFirst();
    }

    public XSite getSelectedSite() {
        IPair<XBaseProfessionnal, XSite> selection = this.getSelectionItem();
        return selection == null ? null : (XSite)selection.getSecond();
    }

    public void select(Integer profId) {
        if (profId == null) {
            this.select((IPair<XBaseProfessionnal, XSite>)null);
        } else {
            this.select(PersonUiPlugin.getDefault().getBaseProfessionnal(profId));
        }
    }

    public void select(XBaseProfessionnal prof) {
        if (prof == null) {
            this.select((IPair<XBaseProfessionnal, XSite>)null);
        } else {
            List sites = prof.getSites();
            if (sites == null || sites.isEmpty()) {
                this.select((IPair<XBaseProfessionnal, XSite>)new Pair((Object)prof, null));
            } else {
                XSite site = SitePlugin.getDefault().getSite(((XPersonSite)prof.getSites().get(0)).getIdSite());
                this.select((IPair<XBaseProfessionnal, XSite>)new Pair((Object)prof, (Object)site));
            }
        }
    }

    public void select(IPair<XBaseProfessionnal, XSite> item) {
        if (this.combo.contains(item)) {
            this.combo.select(item);
        } else {
            if (item != null) {
                String text = this.getLabelForItem(item);
                this.labels.put(item, text);
            }
            this.combo.add(item);
            this.combo.select(item);
        }
    }

    public MyCombo<IPair<XBaseProfessionnal, XSite>> getCombo() {
        return this.combo;
    }

    public Control getControl() {
        return this.combo.getControl();
    }

    public void addListener(int eventType, Listener listener) {
        this.combo.addListener(eventType, listener);
    }

    public void selectNoNotify(XBaseProfessionnal prof) {
        List sites = prof.getSites();
        if (sites == null || sites.isEmpty()) {
            this.combo.selectNoNotify((Object)new Pair((Object)prof, null));
        } else {
            XSite site = SitePlugin.getDefault().getSite(((XPersonSite)prof.getSites().get(0)).getIdSite());
            this.combo.selectNoNotify((Object)new Pair((Object)prof, (Object)site));
        }
    }

    public void setEnabled(boolean b) {
        this.getCombo().setEnabled(b);
    }

    public PredicateA<IPair<XBaseProfessionnal, XSite>> getDisplayPredicate() {
        return this.combo.getDisplayPredicate();
    }

    public void setDisplayPredicate(PredicateA<IPair<XBaseProfessionnal, XSite>> predicate) {
        this.combo.setDisplayPredicate(predicate);
    }

    public void refresh() {
        this.combo.refresh();
    }

    public void selectNone() {
        this.combo.selectNone();
    }

    public void setFocus() {
        this.combo.setFocus();
    }

    public void setLayoutData(FormData data) {
        this.combo.setLayoutData(data);
    }

    public void forceSelect(XBaseProfessionnal prof) {
        if (prof == null) {
            this.combo.forceSelect(null);
        } else {
            List sites = prof.getSites();
            if (sites == null || sites.isEmpty()) {
                this.combo.forceSelect((Object)new Pair((Object)prof, null));
            } else {
                XSite site = SitePlugin.getDefault().getSite(((XPersonSite)prof.getSites().get(0)).getIdSite());
                this.combo.forceSelect((Object)new Pair((Object)prof, (Object)site));
            }
        }
    }

    public IPair<XBaseProfessionnal, XSite> getMyComboSelection() {
        return (IPair)this.combo.getSelection();
    }

    public MyCombo<?> getMyCombo() {
        return this.combo;
    }

    public void setMyComboSelect(Object o) {
        if (o == null || "null".equals(o)) {
            this.select((IPair<XBaseProfessionnal, XSite>)null);
        } else if (o instanceof IPair) {
            IPair e = (IPair)o;
            this.select((IPair<XBaseProfessionnal, XSite>)e);
        } else if (o instanceof String) {
            XBaseProfessionnal x = PersonUiPlugin.getDefault().getBaseProfessionnal(Integer.parseInt((String)o));
            this.select(x);
        }
    }
}

