/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.export;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.WizardDialog3;
import ca.infodata.ofys.ui.person.patient.search.export.ExportWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExportWizardDialog2
extends WizardDialog3 {
    private static final Logger logger = Logger.getLogger(ExportWizardDialog2.class.getName());
    private static final int PREVIOUS_BUTTON_ID = 101;
    private static final int NEXT_BUTTON_ID = 102;
    private static final int EXPORT_BUTTON_ID = 103;
    private Button btnPrevious;
    private Button btnNext;
    private Button btnExport;
    private Button btnCancel;
    private ExportWizard wizard;

    public ExportWizardDialog2(Shell parentShell, ExportWizard newWizard) {
        super(parentShell, (IWizard)newWizard);
        this.setShellStyle(0xCF0 | ExportWizardDialog2.getDefaultOrientation());
        this.wizard = newWizard;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Exportation");
        newShell.setImage(ResourceGetter.getImage((String)"images/persons-icon32.png"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.btnPrevious = this.createButton(parent, 101, Messages.getString((String)"PRECEDENT", (String[])new String[0]), false);
        this.btnPrevious.setFont(ResourceGetter.getFontNormal());
        this.setButtonLayoutData(this.btnPrevious);
        this.btnNext = this.createButton(parent, 102, Messages.getString((String)"SUIVANT", (String[])new String[0]), false);
        this.btnNext.setFont(ResourceGetter.getFontNormal());
        this.setButtonLayoutData(this.btnNext);
        this.btnExport = this.createButton(parent, 103, Messages.getString((String)"EXPORTER", (String[])new String[0]), true);
        this.btnExport.setFont(ResourceGetter.getFontNormal());
        this.setButtonLayoutData(this.btnExport);
        this.btnCancel = this.createButton(parent, 1, Messages.getString((String)"FERMER", (String[])new String[0]), false);
        this.btnCancel.setFont(ResourceGetter.getFontNormal());
        this.setButtonLayoutData(this.btnCancel);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.close();
        } else if (buttonId == 103) {
            try {
                this.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ExportWizardDialog2.this.wizard.performExport(monitor);
                        ExportWizardDialog2.this.doNextPage(200);
                    }
                });
                this.btnExport.setEnabled(false);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error", e);
            }
        } else if (buttonId == 101) {
            this.wizard.performPreviousPage();
        } else if (buttonId == 102) {
            this.wizard.performNextPage();
        }
    }

    protected void doNextPage(final int delay) {
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            final Display display = shell.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    display.timerExec(delay, new Runnable(){

                        @Override
                        public void run() {
                            ExportWizardDialog2.this.wizard.performNextPage();
                        }
                    });
                }
            });
        }
    }

    public void updateButtons() {
        boolean hasActiveRunningOperations = false;
        this.btnNext.setEnabled(!hasActiveRunningOperations && this.wizard.canNextPage());
        this.btnPrevious.setEnabled(!hasActiveRunningOperations && this.wizard.canPreviousPage());
        this.btnExport.setEnabled(!hasActiveRunningOperations && this.wizard.canExport());
        this.btnCancel.setEnabled(true);
    }
}

