/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XDisabilityCode;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectListReader;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.Age;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.util.math.NumberUtils;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.ArrayList;

public class XPatientFormatter {
    public static String formatComplete(IPatient patient) {
        boolean showToAll = true;
        XConsentement consent = null;
        Integer idUser = Application.get().getGlobalInstances().getSession().getUser().getId();
        if (!patient.getConsentement().isEmpty()) {
            showToAll = false;
            IEditableDataObjectListReader consentements = patient.getConsentement();
            int i = 0;
            while (i < consentements.size()) {
                XConsentement consentement = (XConsentement)consentements.get(i);
                if (consentement.getIdUserAnchor().equals(idUser)) {
                    consent = consentement;
                    break;
                }
                ++i;
            }
        }
        boolean checkDroit = false;
        if (!showToAll && consent != null) {
            checkDroit = true;
        }
        boolean showPatient = showToAll || checkDroit && consent.hasRightPatient();
        boolean showPatientOther = showToAll || checkDroit && consent.hasRightPatientOther();
        boolean showAddress = showToAll || checkDroit && consent.hasRightAddres();
        boolean showComm = showToAll || checkDroit && consent.hasRightComm();
        StringBuilder sb = new StringBuilder(100);
        String age = "";
        String ddn = "";
        if (patient.getBirthDate() != null) {
            ddn = LocalDateFormat.format((LocalDate)patient.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString());
            LocalDate now = LocalDate.today();
            age = " - " + (patient.getAge().intValue() == 0 ? Age.formatMonthDay((LocalDate)patient.getBirthDate(), (LocalDate)now) : Age.formatYearMonth((LocalDate)patient.getBirthDate(), (LocalDate)now));
        }
        String sexe = "";
        if (patient.getGender() != null) {
            sexe = " (" + patient.getGender() + ")";
        }
        if (StringUtils.isNotEmpty((String)sexe) || StringUtils.isNotEmpty((String)ddn)) {
            sb.append(ddn).append(sexe).append(age).append("\n");
        }
        String expCam = "";
        if (StringUtils.isNotEmpty((String)patient.getExpirationCAM())) {
            expCam = " (" + patient.getFormatedExpirationCAM() + ")";
        }
        if (showPatient) {
            sb.append(patient.getPatientRecordNumber()).append(", ").append(patient.getFormatedHealthInsuranceNumber()).append(expCam).append("\n");
        }
        ArrayList<String> lstData = new ArrayList<String>();
        if (showAddress) {
            if (StringUtils.isNotEmpty((String)patient.getStreet())) {
                lstData.add(patient.getStreet());
            }
            if (patient.getCity() != null && StringUtils.isNotEmpty((String)patient.getCity().getName())) {
                lstData.add(patient.getCity().getName());
            }
            if (StringUtils.isNotEmpty((String)patient.getPostalCode())) {
                String p = patient.getPostalCode().length() == 6 ? String.valueOf(patient.getPostalCode().substring(0, 3)) + " " + patient.getPostalCode().substring(3) : patient.getPostalCode();
                lstData.add(p);
            }
            sb.append(new JoinList(", ", lstData).toString()).append(StringUtils.isNotEmpty((String)patient.getNoteAddress()) ? ": " + patient.getNoteAddress() : "").append("\n");
        }
        if (showComm) {
            String c;
            ArrayList<String> lstContacts = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)patient.getFirstContactInformationContact())) {
                c = patient.getFirstContactInformationContact().trim();
                if (c.length() == 10 && NumberUtils.isNumber((String)c)) {
                    c = "(" + c.substring(0, 3) + ")" + c.substring(3, 6) + "-" + c.substring(6, 10);
                }
                if (StringUtils.isNotEmpty((String)patient.getFirstContactInformationNote())) {
                    c = String.valueOf(c) + ": " + patient.getFirstContactInformationNote();
                }
                lstContacts.add(c);
            }
            if (StringUtils.isNotEmpty((String)patient.getSecondContactInformationContact())) {
                c = patient.getSecondContactInformationContact();
                if (c.length() == 10 && NumberUtils.isNumber((String)c)) {
                    c = "(" + c.substring(0, 3) + ")" + c.substring(3, 6) + "-" + c.substring(6, 10);
                }
                if (StringUtils.isNotEmpty((String)patient.getSecondContactInformationNote())) {
                    c = String.valueOf(c) + ": " + patient.getSecondContactInformationNote();
                }
                lstContacts.add(c);
            }
            sb.append(new JoinList(", ", lstContacts).toString());
        }
        if (showPatient) {
            String mdtx = "";
            XBaseProfessionnal prof = PersonUiPlugin.getDefault().getBaseProfessionnal(patient.getTreatingProfessionnal());
            if (prof != null) {
                mdtx = "\nMD: " + prof.getName();
            }
            if (showPatientOther) {
                sb.append(mdtx);
                String inscrit = "";
                if (XInscriptionStatus.INSCRIT_CONFIRME.equals((Object)patient.getB2bStatus())) {
                    String code1 = patient.getB2bDisabilityCode1() == null ? XDisabilityCode.C00.getCode2chifres() : patient.getB2bDisabilityCode1().getCode2chifres();
                    String code2 = patient.getB2bDisabilityCode2() == null ? XDisabilityCode.C00.getCode2chifres() : patient.getB2bDisabilityCode2().getCode2chifres();
                    String code3 = patient.getB2bDisabilityCode3() == null ? XDisabilityCode.C00.getCode2chifres() : patient.getB2bDisabilityCode3().getCode2chifres();
                    inscrit = "\n" + Messages.getString((String)"INSCRIT", (String[])new String[0]) + " (" + code1 + "-" + code2 + "-" + code3 + ")";
                }
                sb.append(inscrit);
            }
        }
        if (showPatientOther && StringUtils.isNotEmpty((String)patient.getNote())) {
            sb.append("\n----------------------------\n").append(patient.getNote());
        }
        return sb.toString();
    }

    public static String format(XPatient patient, boolean includeNam, boolean includeRecordNumber) {
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        String nam = patient.getFormatedHealthInsuranceNumber();
        String rec = patient.getFormatedPatientRecordNumber();
        String format = "%s %s";
        if (includeNam && nam != null) {
            format = String.valueOf(format) + " %s";
        }
        if (includeRecordNumber && rec != null) {
            format = String.valueOf(format) + " %s";
        }
        return String.format(format, patient.getFirstName(), patient.getLastName(), nam, rec);
    }

    public static String format(IPatient patient, boolean includeRecordNumber) {
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        String rec = patient.getPatientRecordNumber();
        String format = "%s %s";
        if (includeRecordNumber && rec != null) {
            format = String.valueOf(format) + " %s";
        }
        return String.format(format, patient.getFirstName(), patient.getLastName(), rec);
    }
}

