/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.identifiers;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XBaseIdentifierType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IdentifierTypeCombo
extends MyCombo<XBaseIdentifierType> {
    private static final List<IdentifierTypeCombo> instances = new CopyOnWriteArrayList<IdentifierTypeCombo>();
    private static final CompletionComboAccessorClient.CompletionComboListener listener = new CompletionComboAccessorClient.CompletionComboListener(){
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                ArrayList<IdentifierTypeCombo> toRemoveList = new ArrayList<IdentifierTypeCombo>();
                for (IdentifierTypeCombo combo : instances) {
                    if (combo == null || combo.getControl().isDisposed()) {
                        toRemoveList.add(combo);
                        continue;
                    }
                    combo.fill();
                }
                instances.removeAll(toRemoveList);
            }
        };

        public void shouldRefresh(ICompletionComboItem item) {
            Display.getDefault().asyncExec(this.refresh);
        }
    };
    private static final int STANDARD_TEXT_LIMIT = 100;

    static {
        CompletionComboAccessorClient.addListener((String)XBaseIdentifierType.type, (CompletionComboAccessorClient.CompletionComboListener)listener);
    }

    public IdentifierTypeCombo(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style, toolkit);
        this.setAutoComplete(true);
        this.setLabelProvider((ProviderAR)new ProviderAR<XBaseIdentifierType, String>(){

            public String get(XBaseIdentifierType country) {
                return country == null || country.getName() == null ? "" : country.getName();
            }
        });
        this.setDisplayPredicate((PredicateA)new PredicateA<XBaseIdentifierType>(){

            public boolean evaluate(XBaseIdentifierType c) {
                return c != null && c.isActive();
            }
        });
        this.setTextLimit(100);
        this.fill();
        instances.add(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                instances.remove((Object)IdentifierTypeCombo.this);
            }
        });
    }

    protected void fill() {
        block4: {
            final String text = this.getText();
            final XBaseIdentifierType selection = (XBaseIdentifierType)this.getSelection();
            JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                public void responseReceived(final ReturnObject response) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!IdentifierTypeCombo.this.getControl().isDisposed()) {
                                IdentifierTypeCombo.this.removeAllNoNotify();
                                IdentifierTypeCombo.this.setItems((List)response.getObj());
                                if (selection != null) {
                                    IdentifierTypeCombo.this.selectNoNotify(selection);
                                } else {
                                    IdentifierTypeCombo.this.setTextNoNotify(text);
                                }
                            }
                        }
                    });
                }
            };
            try {
                CompletionComboAccessorClient.getInstance().findAllAsync(Application.get().getGlobalInstances().getSession(), (ICallback)callback, XBaseIdentifierType.type);
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
                if (callback != null && !callback.killed()) {
                    callback.kill();
                }
            }
            catch (Exception e) {
                Log.severe((Throwable)e);
                if (callback == null || callback.killed()) break block4;
                callback.kill();
            }
        }
    }

    public void select(XBaseIdentifierType item) {
        if (this.contains(item)) {
            super.select((Object)item);
        } else {
            this.add(item);
            super.select((Object)item);
        }
    }
}

