/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.EmployeeAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.util.ObjectCache;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XEmployee;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmployeeCache
extends ObjectCache<XEmployee> {
    private static final Logger logger = Logger.getLogger(EmployeeCache.class.getName());
    private static final String EMP_PERSON = "emp-person";
    private static final String EMP = "emp";
    private IConsumerListenerImplementation listener = new IConsumerListenerImplementation();

    public EmployeeCache() {
        super(EMP);
        Application.get().getGlobalInstances().getNotificationSystem().addListener((IConsumerListener)this.listener);
    }

    protected void load(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAllAsync(session, callback, XEmployee.class.getName());
    }

    protected void add(Map<ObjectCache.Key, XEmployee> map, XEmployee e) {
        if (e != null && e.getId() != null) {
            map.put(new ObjectCache.Key(EMP, e.getId()), e);
            map.put(new ObjectCache.Key(EMP_PERSON, e.getIdPerson()), e);
        }
    }

    public XEmployee getById(Integer id, boolean logIfNotFound) {
        return this.getById(id, logIfNotFound, true);
    }

    public List<XEmployee> getAll() {
        return new ArrayList<XEmployee>(this.getMap().values());
    }

    public XEmployee getById(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XEmployee)this.get(new ObjectCache.Key(EMP, id), logIfNotFound, mustTryToFindServer);
    }

    public XEmployee getByIdPerson(Integer id, boolean logIfNotFound) {
        return this.getByIdPerson(id, logIfNotFound, true);
    }

    public XEmployee getByIdPerson(Integer id, boolean logIfNotFound, boolean mustTryToFindServer) {
        if (id == null) {
            return null;
        }
        return (XEmployee)this.get(new ObjectCache.Key(EMP_PERSON, id), logIfNotFound, mustTryToFindServer);
    }

    protected XEmployee loadSync(XSession session, ObjectCache.Key key) throws Exception {
        if (key == null) {
            return null;
        }
        if (EMP.equals(key.type)) {
            return (XEmployee)EmployeeAccessorClient.getInstance().getEmployeeSync(session, key.id.intValue(), false);
        }
        if (EMP_PERSON.equals(key.type)) {
            return (XEmployee)EmployeeAccessorClient.getInstance().getEmployeeByIdPersonSync(session, key.id.intValue(), false);
        }
        return null;
    }

    protected void loadSync(int uniqueKey, XSession session, ICallback callback) throws Exception {
        CompletionComboAccessorClient.getInstance().findAll(session, callback, XEmployee.class.getName());
    }

    private final class IConsumerListenerImplementation
    implements IConsumerListener {
        private IConsumerListenerImplementation() {
        }

        public void handle(DataObjectUpdatedNotification notification) {
            try {
                IDataObject object;
                if (notification != null && (object = notification.getObject()) instanceof XEmployee) {
                    EmployeeCache.this.add((Map<ObjectCache.Key, XEmployee>)EmployeeCache.this.getMap(), (XEmployee)object);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in IConsumerListenerImplementation.handle", e);
            }
        }

        public void handleOther(Notification notification) {
        }

        public void forceRefresh() {
            try {
                EmployeeCache.this.reload(true);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in EmployeeCache.forceRefresh", e);
            }
        }
    }
}

