/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nightlabs.util.CollectionUtil;
import org.nightlabs.util.ds.TrieNode;

public class PrefixTree<T> {
    private TrieNode<T> root = new TrieNode<Object>(null);

    public void insert(String[] path, T element) {
        this.insert(element, path, 0, this.root);
    }

    protected void insert(T element, String[] path, int index, TrieNode<T> node) {
        TrieNode<T> childNode = node.getChild(path[index]);
        if (childNode == null) {
            childNode = node.addChild(path[index]);
            if (index == path.length - 1) {
                childNode.setElement(element);
                return;
            }
        }
        this.insert(element, path, index + 1, childNode);
    }

    public TrieNode<T> getNode(String[] path) {
        TrieNode<T> currentNode = this.root;
        int i = 0;
        while (i < path.length) {
            if ((currentNode = currentNode.getChild(path[i])) == null) {
                return null;
            }
            ++i;
        }
        return currentNode;
    }

    public List<T> getSubtrieElements(String[] path) {
        TrieNode<T> node = this.getNode(path);
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        return this.traverseSubtrie(node, null);
    }

    public Map<String, T> getSubtrieElementsWithKeys(String[] path) {
        TrieNode<T> node = this.getNode(path);
        if (node == null) {
            return Collections.EMPTY_MAP;
        }
        return this.traverseSubtrieWithKeys(node, CollectionUtil.array2ArrayList(path), null);
    }

    private List<T> traverseSubtrie(TrieNode<T> rootNode, List<T> traversedElements) {
        if (traversedElements == null) {
            traversedElements = new LinkedList<T>();
        }
        if (rootNode.hasElement()) {
            traversedElements.add(rootNode.getElement());
        }
        for (String key : rootNode.getChildrenMap().keySet()) {
            this.traverseSubtrie(rootNode.getChild(key), traversedElements);
        }
        return traversedElements;
    }

    private Map<String, T> traverseSubtrieWithKeys(TrieNode<T> root, List<String> path, Map<String, T> elems) {
        if (elems == null) {
            elems = new HashMap<String, T>();
        }
        if (root.hasElement()) {
            elems.put(path.toString(), root.getElement());
        }
        for (String key : root.getChildrenMap().keySet()) {
            path.add(key);
            this.traverseSubtrieWithKeys(root.getChild(key), path, elems);
            path.remove(key);
        }
        return elems;
    }

    public String toString() {
        Map<String, T> elems = this.getSubtrieElementsWithKeys(new String[0]);
        String toReturn = "";
        for (String key : elems.keySet()) {
            toReturn = String.valueOf(toReturn) + key + "\n" + "\t-> " + elems.get(key) + "\n";
        }
        return toReturn;
    }
}

