/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io.pcx;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nightlabs.io.pcx.PCXReader;
import org.nightlabs.io.pcx.PCXWriter;

public class PCXUtil {
    public static void rotate90Degrees(InputStream in, OutputStream out) throws IOException {
        PCXReader reader = new PCXReader();
        BufferedImage image = reader.read(in);
        if (image.getType() != 12) {
            throw new UnsupportedOperationException("image.getType() != BufferedImage.TYPE_BYTE_BINARY");
        }
        WritableRaster srcRaster = image.getRaster();
        BufferedImage rimg = new BufferedImage(image.getHeight(), image.getWidth(), 12);
        WritableRaster destRaster = rimg.getRaster();
        int maxY = image.getMinY() + image.getHeight() - 1;
        int maxX = image.getMinX() + image.getWidth() - 1;
        int[] iArray = new int[1];
        int y = image.getMinY();
        while (y <= maxY) {
            int x = image.getMinX();
            while (x <= maxX) {
                srcRaster.getPixel(x, y, iArray);
                destRaster.setPixel(y, maxX - x, iArray);
                ++x;
            }
            ++y;
        }
        PCXWriter writer = new PCXWriter();
        writer.write(out, rimg);
    }

    public static void main(String[] args) {
        try {
            FileInputStream fin = new FileInputStream("/tmp/ipanema-bw.pcx");
            FileOutputStream fout = new FileOutputStream("/tmp/out.pcx");
            PCXUtil.rotate90Degrees(fin, fout);
            fin.close();
            fout.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

