/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.io.pcx;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import org.nightlabs.io.pcx.ImageOutputStream;
import org.nightlabs.io.pcx.PCXWriter;

public class PCXImageWriter
extends ImageWriter {
    private OutputStream outputStream = null;
    private PCXWriter pcxWriter = null;

    public PCXImageWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (image.getRenderedImage() instanceof BufferedImage && this.getOutputStream() != null) {
            BufferedImage bi = (BufferedImage)image.getRenderedImage();
            this.getPCXWriter().write(this.getOutputStream(), bi);
        }
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        this.outputStream = null;
    }

    protected OutputStream getOutputStream() {
        if (this.outputStream == null && this.output != null) {
            if (this.output instanceof javax.imageio.stream.ImageOutputStream) {
                javax.imageio.stream.ImageOutputStream imageOutputStream = (javax.imageio.stream.ImageOutputStream)this.output;
                this.outputStream = new ImageOutputStream(imageOutputStream);
            } else if (this.output instanceof OutputStream) {
                this.outputStream = (OutputStream)this.output;
            }
        }
        return this.outputStream;
    }

    protected PCXWriter getPCXWriter() {
        if (this.pcxWriter == null) {
            this.pcxWriter = new PCXWriter();
        }
        return this.pcxWriter;
    }
}

