/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.menu.treeelements;

import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.AbstractTreeElement;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class CallbackElement
extends AbstractTreeElement {
    protected static final int COUNT_CALL = 0;
    protected static final int LIST_CALL = 1;
    private List<ITreeElements> childs = new ArrayList<ITreeElements>();
    private boolean isChildrenLoading;
    private boolean isChildrenLoaded;

    public CallbackElement() {
    }

    public CallbackElement(ITreeElements parent, String text, String imageName, List<? extends AbstractTreeElement> listChilds) {
        super(parent, text, imageName, listChilds);
    }

    public CallbackElement(ITreeElements parent) {
        super(parent);
    }

    public abstract void initAsLoading();

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.isChildrenLoading = true;
            this.loadListAsync();
        }
        return this.children;
    }

    private boolean notLoaded() {
        return !this.isChildrenLoaded && !this.isChildrenLoading;
    }

    public abstract void loadListAsync();

    public abstract void loadCountAsync();

    public final void loadResponse(int key, Object response) {
        if (key == 0) {
            this.loadCountResponse(response);
        } else if (key == 1) {
            try {
                this.loadListResponse(response);
            }
            finally {
                this.isChildrenLoaded = true;
                this.isChildrenLoading = false;
            }
        }
        DossierPlugin.getDefault().refreshTreeInSwtThread((ITreeElements)this);
    }

    public abstract void loadCountResponse(Object var1);

    public abstract void loadListResponse(Object var1);

    public void removeLoadingElements(List<ITreeElements> list) {
        this.removeElementByClass(list, LoadingElement.class);
    }

    public void removeElementByClass(List<ITreeElements> list, Class<?> c) {
        if (list != null && list.size() > 0) {
            Iterator<ITreeElements> iterator = list.iterator();
            while (iterator.hasNext()) {
                ITreeElements e = iterator.next();
                if (!c.isAssignableFrom(e.getClass())) continue;
                iterator.remove();
            }
        }
    }

    public <T extends ITreeElements> T getByClass(List<ITreeElements> list, Class<T> c) {
        if (list != null && list.size() > 0) {
            for (ITreeElements e : list) {
                if (!c.isAssignableFrom(e.getClass())) continue;
                return (T)e;
            }
        }
        return null;
    }

    public List<ITreeElements> findByClass(List<ITreeElements> list, Class<?> ... classes) {
        if (list != null && list.size() > 0) {
            ArrayList<ITreeElements> list2 = new ArrayList<ITreeElements>(classes.length);
            for (ITreeElements e : list) {
                Class<?>[] classArray = classes;
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    if (c.isAssignableFrom(e.getClass())) {
                        list2.add(e);
                    }
                    ++n2;
                }
            }
            return list2;
        }
        return Collections.emptyList();
    }

    protected String getLoadingTextFlag() {
        return " (" + Messages.getString((String)"CHARGEMENT", (String[])new String[0]) + ")";
    }

    public void forwardResponseToChildren(int key, Object response) {
        for (ITreeElements e : this.childs) {
            if (!(e instanceof CallbackElement)) continue;
            ((CallbackElement)e).loadResponse(key, response);
        }
    }

    public ICallback getCallback(final int key) {
        return new Callback((IStatusHandler)new JustLogStatusHandler()){

            public void responseReceived(ReturnObject response) {
                if (response == null || response.getObj() == null) {
                    CallbackElement.this.loadResponse(key, null);
                } else {
                    CallbackElement.this.loadResponse(key, response.getObj());
                }
            }

            public void exception(Exception e) {
                CallbackElement.this.loadResponse(key, null);
            }
        };
    }

    protected void setChilds(List<ITreeElements> list) {
        this.childs = list;
        this.children = this.childs.toArray(new ITreeElements[this.childs.size()]);
    }

    protected List<ITreeElements> getChilds() {
        return this.childs;
    }

    public boolean isChildrenLoaded() {
        return this.isChildrenLoaded;
    }

    public void setChildrenLoaded(boolean isChildrenLoaded) {
        this.isChildrenLoaded = isChildrenLoaded;
    }
}

