/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.menu;

import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;

public class ImageDecorator
implements ILightweightLabelDecorator {
    private static final Logger logger = Logger.getLogger(ImageDecorator.class.getName());

    public void decorate(Object element, IDecoration decoration) {
        XImageDecorator decorators = ((ITreeElements)element).getDecorators();
        if (decorators == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("XImageDecorator is null for element " + String.valueOf(element));
            }
        } else {
            if (decorators.topRightImageName != null) {
                this.addDecoration(decoration, decorators.topRightImageName, 1);
            }
            if (decorators.topLeftImageName != null) {
                this.addDecoration(decoration, decorators.topLeftImageName, 0);
            }
            if (decorators.bottomRightImageName != null) {
                this.addDecoration(decoration, decorators.bottomRightImageName, 3);
            }
            if (decorators.bottomLeftImageName != null) {
                this.addDecoration(decoration, decorators.bottomLeftImageName, 2);
            }
        }
    }

    private void addDecoration(IDecoration decoration, String imageName, int position) {
        if (imageName.startsWith("images/")) {
            decoration.addOverlay(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)imageName)), position);
        } else {
            decoration.addOverlay(ImageDescriptor.createFromImage((Image)ResourceGetter.getImage((String)("images/" + imageName))), position);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

