/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.library.DelegateException;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.RunnableR;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.IPair;
import ca.infodata.util1.StringUtils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class UI {
    private static final Logger logger = Logger.getLogger(UI.class.getName());
    private static final String CHOIX_DES_COULEURS = Messages.getString((String)"CHOIX_DES_COULEURS", (String[])new String[0]);
    public static final boolean OS_COCOA = "cocoa".equals(SWT.getPlatform());
    public static final boolean OS_CARBON = "carbon".equals(SWT.getPlatform()) || OS_COCOA;
    public static final boolean OS_MAC = OS_CARBON || OS_COCOA;
    public static final boolean OS_GTK = "gtk".equals(SWT.getPlatform());
    public static final boolean OS_WINDOWS = "win32".equals(SWT.getPlatform());
    public static final boolean OS_WINDOWS64B = OS_WINDOWS && (System.getProperty("os.arch") == null || System.getProperty("os.arch").contains("64"));
    public static final boolean OS_WINDOWS32B = OS_WINDOWS && !OS_WINDOWS64B;
    public static final String DISABLED_BACKGROUND_COLOR = "DISABLED_BACKGROUND_COLOR";
    public static int STANDARD_BUTTON_WIDTH = OS_CARBON ? 130 : 100;
    public static int STANDARD_TEXT_WIDTH = OS_CARBON ? 130 : 100;
    public static final int CTRL_CMD = OS_MAC ? 0x400000 : 262144;
    private static Timer loopExecTimer = new Timer("loopExecTimer", true);

    private UI() {
        throw new UnsupportedOperationException();
    }

    public static Event toEvent(TouchEvent e) {
        Event ev = new Event();
        ev.x = e.x;
        ev.y = e.y;
        ev.widget = e.widget;
        return ev;
    }

    public static boolean containsStyle(int constant, int style) {
        return (style | constant) == style;
    }

    public static boolean SHIFT(KeyEvent e) {
        return (e.stateMask | 0x20000) == e.stateMask;
    }

    public static boolean SHIFT_TAB(KeyEvent e) {
        return UI.SHIFT(e) && (e.keyCode | 9) == e.keyCode;
    }

    public static boolean CTRL(KeyEvent e) {
        return e.keyCode == 262144 || (e.stateMask | CTRL_CMD) == e.stateMask;
    }

    public static boolean CTRL(KeyEvent e, char c) {
        return UI.CTRL(e) && (e.keyCode == c || e.keyCode == Character.toUpperCase(c));
    }

    public static boolean CTRL(MouseEvent e) {
        return (e.stateMask | CTRL_CMD) == e.stateMask;
    }

    public static boolean CTRL(Event e) {
        return (e.stateMask | CTRL_CMD) == e.stateMask;
    }

    public static boolean CR(KeyEvent e) {
        return e.keyCode == 13 || e.keyCode == 0x1000050;
    }

    public static boolean CR(Event e) {
        return e.keyCode == 13 || e.keyCode == 0x1000050;
    }

    public static boolean NUMBER(KeyEvent e) {
        return StringUtils.isNumeric((char)e.character);
    }

    public static boolean ESC(KeyEvent e) {
        return e.keyCode == 27;
    }

    public static boolean ESC(Event e) {
        return e.keyCode == 27;
    }

    public static boolean leftClick(MouseEvent e) {
        if (OS_CARBON) {
            return e.button == 1 && (e.stateMask & 0x400000) == e.stateMask;
        }
        return e.button == 1;
    }

    public static boolean rightClick(MouseEvent e) {
        if (OS_CARBON) {
            return e.button == 3 || e.button == 1 && e.stateMask == CTRL_CMD;
        }
        return e.button == 3;
    }

    public static boolean rightClick(Event e) {
        if (OS_CARBON) {
            return e.button == 3 || e.button == 1 && e.stateMask == CTRL_CMD;
        }
        return e.button == 3;
    }

    public static int getAjustedPosition() {
        return OS_CARBON ? -3 : 0;
    }

    public static int getAjustedPositionHorizontal() {
        return OS_CARBON ? -7 : 0;
    }

    public static boolean hasFocus(Control control) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (control.isFocusControl()) {
            return true;
        }
        if (control instanceof Composite) {
            boolean hasfocus = false;
            Control[] children = ((Composite)control).getChildren();
            int i = 0;
            while (i < children.length && !hasfocus) {
                hasfocus = UI.hasFocus(children[i]);
                ++i;
            }
            return hasfocus;
        }
        return false;
    }

    public static boolean hasFocus(IWorkbenchPart part) {
        IWorkbenchPart ap;
        IWorkbenchPage apg;
        IWorkbenchWindow aww;
        IWorkbench w;
        if (part != null && (w = LibPlugin.getDefault().getWorkbench()) != null && (aww = w.getActiveWorkbenchWindow()) != null && (apg = aww.getActivePage()) != null && (ap = apg.getActivePart()) != null) {
            return ap.equals(part);
        }
        return false;
    }

    public static boolean superForceFocus(Control control) {
        System.out.println("UI.superForceFocus()");
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (control.isFocusControl()) {
            System.out.println("control already has focus");
            return true;
        }
        boolean focused = control.setFocus();
        if (focused) {
            System.out.println("simple setFocus worked");
            return true;
        }
        focused = control.forceFocus();
        if (focused) {
            System.out.println("simple forceFocus worked");
            return true;
        }
        return false;
    }

    public static Control getFocusedControl(Composite parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (parent.isFocusControl()) {
            return parent;
        }
        Control focusedControl = null;
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length && focusedControl == null) {
            if (children[i].isFocusControl()) {
                focusedControl = children[i];
            } else if (children[i] instanceof Composite) {
                focusedControl = UI.getFocusedControl((Composite)children[i]);
            }
            ++i;
        }
        return focusedControl;
    }

    public static FormToolkit createToolKit(Widget parent) {
        FormColors colors = new FormColors(parent.getDisplay());
        colors.createColor(DISABLED_BACKGROUND_COLOR, 224, 224, 224);
        final FormToolkit t = new FormToolkit(colors);
        t.setBorderStyle(2048);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                t.dispose();
            }
        });
        return t;
    }

    public static void centerComposite(Composite target, Composite base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (base.isDisposed()) {
            throw new IllegalArgumentException("base composite is disposed");
        }
        if (target.isDisposed()) {
            throw new IllegalArgumentException("target composite is disposed");
        }
        if (target == base) {
            return;
        }
        Point location = base.getLocation();
        Point size = base.getSize();
        Point targetSize = target.getSize();
        int x = location.x + size.x / 2 - targetSize.x / 2;
        int y = location.y + size.y / 2 - targetSize.y / 2;
        target.setLocation(x, y);
    }

    public static void packAsParentDialog(Shell shell) {
        UI.packAsParentDialog(shell, shell == null ? null : shell.getParent());
    }

    public static void packAsParentDialog(Shell shell, Composite parent) {
        UI.packAsParentDialog(shell, parent, 0.9f);
    }

    public static void packAsParentDialog(Shell shell, Composite parent, float percentOfParentSize) {
        if (shell == null) {
            throw new NullPointerException("shell");
        }
        if (shell.isDisposed()) {
            throw new IllegalArgumentException("shell is disposed");
        }
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (parent.isDisposed()) {
            throw new IllegalArgumentException("parent is disposed");
        }
        shell.pack(true);
        Point size = shell.getSize();
        Point parentSize = parent.getSize();
        int w = (int)((float)Math.max(size.x, parentSize.x) * percentOfParentSize);
        int h = (int)((float)Math.max(size.y, parentSize.y) * percentOfParentSize);
        shell.setSize(w, h);
    }

    public static void linkObjectListenerWithWidgetLife(final IObjectListener<?> listener, Widget widget) {
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectListenerManager.removeListener((IObjectListener)listener);
            }
        });
    }

    public static void linkPropertyListenerWithWidgetLife(final IPropertyListener listener, Widget widget) {
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PropertyListenerManager.removeListener((IPropertyListener)listener);
            }
        });
    }

    public static Composite createScrolledComposite(final Composite parent, FormToolkit toolkit) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (toolkit == null) {
            throw new NullPointerException("toolkit");
        }
        final ScrolledForm form = toolkit.createScrolledForm(parent);
        form.getBody().setLayout((Layout)new FormLayout());
        form.setAlwaysShowScrollBars(false);
        form.getHorizontalBar().setVisible(false);
        final Composite compMain = new Composite(form.getBody(), 0);
        toolkit.adapt(compMain);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.top = new FormAttachment(0);
        data.width = parent.getSize().x - 18;
        data.bottom = new FormAttachment(100);
        compMain.setLayoutData((Object)data);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FormData data = new FormData();
                data.left = new FormAttachment(0);
                data.top = new FormAttachment(0);
                form.getVerticalBar().setVisible(true);
                data.width = parent.getSize().x - 18;
                data.bottom = new FormAttachment(100);
                compMain.setLayoutData((Object)data);
                compMain.layout(true);
            }
        });
        return compMain;
    }

    public static void printEventType(Event e) {
        switch (e.type) {
            case 13: {
                System.out.println("selection");
                break;
            }
            case 24: {
                System.out.println("modify");
                break;
            }
        }
    }

    public static void waitForWindowToClose(Shell shell) {
        if (shell == null) {
            throw new NullPointerException("shell");
        }
        if (shell.isDisposed()) {
            throw new IllegalArgumentException("shell is disposed");
        }
        Display display = shell.getDisplay();
        while (!shell.isDisposed() && shell.isVisible()) {
            if (display.isDisposed() || display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public static void disableForXMillisecond(final Control control, int timeInMillisecond) {
        control.setEnabled(false);
        int timeToWait = timeInMillisecond;
        control.getDisplay().timerExec(timeToWait, new Runnable(){

            @Override
            public void run() {
                if (!control.isDisposed()) {
                    control.setEnabled(true);
                }
            }
        });
    }

    public static void disableForXMillisecond(final IAction action, long timeInMillisecond) {
        action.setEnabled(false);
        if (timeInMillisecond > Integer.MAX_VALUE) {
            logger.warning("timeInMillisecond " + timeInMillisecond + "is greater than Integer.MAX_VALUE. it will be truncated");
        }
        int timeToWait = (int)timeInMillisecond;
        Display.getDefault().timerExec(timeToWait, new Runnable(){

            @Override
            public void run() {
                action.setEnabled(true);
            }
        });
    }

    public static void decorateTreeWithAutoAdjustColumnWidthToContent(final Tree tree) {
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                UI.autoAdjustColumnWidthToContent(tree);
            }

            public void treeCollapsed(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(false);
                UI.autoAdjustColumnWidthToContent(tree);
            }
        });
    }

    public static void autoAdjustColumnWidthToContent(Tree tree) {
        int linesCount = tree.getItemCount();
        if (linesCount > 0) {
            TreeColumn column;
            GC gc = new GC((Drawable)tree);
            int columnCount = tree.getColumnCount();
            int[] columnSizes = new int[columnCount];
            int i = 0;
            while (i < linesCount) {
                TreeItem item = tree.getItem(i);
                int j = 0;
                while (j < columnCount) {
                    columnSizes[j] = Math.max(UI.itemWidth(gc, item, j), columnSizes[j]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < columnCount) {
                column = tree.getColumn(i);
                Integer w = (Integer)column.getData("minWidth");
                if (w != null) {
                    columnSizes[i] = Math.max(w, columnSizes[i]);
                }
                ++i;
            }
            i = 0;
            while (i < columnCount) {
                column = tree.getColumn(i);
                Integer w = (Integer)column.getData("maxWidth");
                if (w != null) {
                    columnSizes[i] = Math.min(w, columnSizes[i]);
                }
                ++i;
            }
            gc.dispose();
            int compensation = UI.containsStyle(32, tree.getStyle()) ? 50 : 35;
            int i2 = 0;
            while (i2 < columnCount) {
                tree.getColumn(i2).setWidth(columnSizes[i2] + compensation);
                ++i2;
            }
        }
    }

    private static int itemWidth(GC gc, TreeItem item, int column) {
        int itemCount;
        gc.setFont(item.getFont());
        Point extent = gc.stringExtent(item.getText(column));
        Image image = item.getImage(column);
        int w = extent.x;
        if (image != null) {
            w += image.getBounds().width;
        }
        if (item.getExpanded() && (itemCount = item.getItemCount()) > 0) {
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                w = Math.max(w, UI.itemWidth(gc, items[i], column) + 10);
                ++i;
            }
        }
        return w;
    }

    public static Point stringExtent(Control c, String s) {
        if (s == null) {
            s = "";
        }
        GC gc = new GC((Drawable)c);
        gc.setFont(c.getFont());
        Point extent = gc.stringExtent(s);
        gc.dispose();
        return extent;
    }

    private static int itemWidth(GC gc, TableColumn column) {
        gc.setFont(column.getParent().getFont());
        Point extent = gc.stringExtent(column.getText());
        Image image = column.getImage();
        int w = extent.x;
        if (image != null) {
            w += image.getBounds().width;
        }
        return w + 15;
    }

    public static void autoAdjustColumnWidthToContent(Table table) {
        UI.autoAdjustColumnWidthToContent(table, false);
    }

    public static void autoAdjustColumnWidthToContent(Table table, boolean hideColumnWithEmptyContent) {
        int linesCount = table.getItemCount();
        if (linesCount > 0 || table.getHeaderVisible()) {
            TableColumn column;
            int i;
            GC gc = new GC((Drawable)table);
            int columnCount = table.getColumnCount();
            int[] columnSizes = new int[columnCount];
            if (table.getHeaderVisible()) {
                i = 0;
                while (i < columnCount) {
                    column = table.getColumn(i);
                    columnSizes[i] = UI.itemWidth(gc, column);
                    ++i;
                }
            }
            i = 0;
            while (i < linesCount) {
                TableItem item = table.getItem(i);
                int j = 0;
                while (j < columnCount) {
                    columnSizes[j] = Math.max(UI.itemWidth(gc, item, j), columnSizes[j]);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < columnCount) {
                column = table.getColumn(i);
                Integer w = (Integer)column.getData("minWidth");
                if (w != null) {
                    columnSizes[i] = Math.max(w, columnSizes[i]);
                }
                ++i;
            }
            i = 0;
            while (i < columnCount) {
                column = table.getColumn(i);
                Integer w = (Integer)column.getData("maxWidth");
                if (w != null) {
                    columnSizes[i] = Math.min(w, columnSizes[i]);
                }
                ++i;
            }
            if (hideColumnWithEmptyContent) {
                int column2 = 0;
                while (column2 < columnCount) {
                    TableColumn column22 = table.getColumn(column2);
                    Integer w = (Integer)column22.getData("minWidth");
                    if (w == null) {
                        boolean empty = true;
                        int line = 0;
                        while (line < linesCount && empty) {
                            TableItem item = table.getItem(line);
                            empty = item.getText(column2).isEmpty();
                            ++line;
                        }
                        if (empty) {
                            columnSizes[column2] = 0;
                        }
                    }
                    ++column2;
                }
            }
            gc.dispose();
            i = 0;
            while (i < columnCount) {
                table.getColumn(i).setWidth(columnSizes[i]);
                ++i;
            }
        }
    }

    private static int itemWidth(GC gc, TableItem item, int column) {
        gc.setFont(item.getFont());
        Point extent = gc.stringExtent(item.getText(column));
        Image image = item.getImage(column);
        int w = extent.x;
        if (image != null) {
            w += image.getBounds().width;
        }
        return w + 15;
    }

    public static boolean isCurrentThreadIsUIThread() {
        Display display = Display.getCurrent();
        if (display == null) {
            return false;
        }
        Thread thread = display.getThread();
        return thread == Thread.currentThread() || thread.getId() == Thread.currentThread().getId();
    }

    public static void runInSwtThread(final Runnable runnable) throws RuntimeException {
        if (UI.isCurrentThreadIsUIThread()) {
            runnable.run();
        } else {
            final DelegateException delegateException = new DelegateException();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.SEVERE, "Error executing runnable", e);
                        delegateException.runtimeException = e;
                    }
                }
            });
            delegateException.throwOnRuntimeException();
        }
    }

    public static <T> T runInSwtThread(final RunnableR<T> runnable) throws Exception {
        if (UI.isCurrentThreadIsUIThread()) {
            try {
                return runnable.run();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error executing runnable", e);
                throw e;
            }
        }
        final DelegateException delegateException = new DelegateException();
        final Object[] h = new Object[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    h[0] = runnable.run();
                }
                catch (Exception e2) {
                    logger.log(Level.SEVERE, "Error executing runnable", e2);
                    delegateException.exception = e2;
                }
            }
        });
        delegateException.throwOnException();
        return (T)h[0];
    }

    public static int openDialogInUIThread(final MessageDialog dialog) {
        if (UI.isCurrentThreadIsUIThread()) {
            return dialog.open();
        }
        final int[] r = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                r[0] = dialog.open();
            }
        });
        return r[0];
    }

    public static void loopExecForWidget(long delay, long period, final int iteration, final boolean async, final Widget widget, final Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        if (widget == null) {
            throw new NullPointerException("widget");
        }
        final TimerTask timerTask = new TimerTask(){
            int count = 0;

            @Override
            public void run() {
                ++this.count;
                try {
                    if (widget.isDisposed()) {
                        this.cancel();
                    } else if (async) {
                        widget.getDisplay().asyncExec(runnable);
                    } else {
                        widget.getDisplay().syncExec(runnable);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception in loopExec", e);
                }
                if (iteration != -1 && this.count >= iteration) {
                    this.cancel();
                }
            }
        };
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                timerTask.cancel();
            }
        });
        loopExecTimer.schedule(timerTask, delay, period);
    }

    public static Object genericExecuteCommandSafe(AbstractUIPlugin plugin, String commandId, Object defaultValue) {
        try {
            return UI.genericExecuteCommand(plugin, commandId);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static Object genericExecuteCommand(AbstractUIPlugin plugin, String commandId) throws Exception {
        if (commandId == null) {
            NullPointerException e = new NullPointerException("commandId");
            logger.log(Level.SEVERE, "Failed to execute " + commandId, e);
        }
        IHandlerService service = (IHandlerService)plugin.getWorkbench().getService(IHandlerService.class);
        try {
            return service.executeCommand(commandId, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to execute " + commandId, e);
            throw e;
        }
    }

    public static Object genericExecuteCommand(AbstractUIPlugin plugin, String commandId, IPair<String, String> ... parameters) throws Exception {
        Log.logOperation("IntroPlugin" + commandId, new Object[0]);
        if (commandId == null) {
            NullPointerException e = new NullPointerException("commandId");
            logger.log(Level.SEVERE, "Failed to execute " + commandId, e);
        }
        IHandlerService service = (IHandlerService)plugin.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)plugin.getWorkbench().getService(ICommandService.class);
        try {
            if (parameters != null) {
                Command command = commandService.getCommand(commandId);
                Parameterization[] params = new Parameterization[parameters.length];
                int j = 0;
                while (j < parameters.length) {
                    IParameter param = command.getParameter((String)parameters[j].getFirst());
                    params[j] = new Parameterization(param, (String)parameters[j].getSecond());
                    ++j;
                }
                ParameterizedCommand parmCommand = new ParameterizedCommand(command, params);
                return service.executeCommand(parmCommand, null);
            }
            return service.executeCommand(commandId, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to execute " + commandId, e);
            throw e;
        }
    }

    public static RGB openColorDialog(Shell shell, RGB defaultColor) {
        if (defaultColor == null) {
            throw new NullPointerException("defaultColor");
        }
        ColorDialog cd = new ColorDialog(shell);
        cd.setText(CHOIX_DES_COULEURS);
        cd.setRGB(defaultColor);
        return cd.open();
    }

    public static Shell getWorkbenchShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        Shell shell = null;
        if (activeWorkbenchWindow != null) {
            shell = activeWorkbenchWindow.getShell();
        } else if (workbench.getWorkbenchWindowCount() > 0) {
            shell = workbench.getWorkbenchWindows()[0].getShell();
        }
        if (shell == null) {
            logger.log(Level.SEVERE, "no workbench shell found \n" + Log.getPrintedStackTrace());
        }
        return shell;
    }

    public static FormData newFillFormData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        return data;
    }

    public static FormLayout newFormLayout(int margins, int spacing) {
        FormLayout layout = new FormLayout();
        layout.marginBottom = margins;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.spacing = spacing;
        return layout;
    }

    public static FormLayout newFormLayout(int vertical, int horizontal, int spacing) {
        FormLayout layout = new FormLayout();
        layout.marginBottom = vertical;
        layout.marginTop = vertical;
        layout.marginLeft = horizontal;
        layout.marginRight = horizontal;
        layout.spacing = spacing;
        return layout;
    }

    public static void adaptRecursive(Composite c, FormToolkit toolkit) {
        toolkit.adapt(c);
        Control[] controlArray = c.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                UI.adaptRecursive((Composite)control, toolkit);
            }
            ++n2;
        }
    }

    public static FormData newFormDataLabeledControlLayout(Control topControl, Control label, Control control) {
        FormData data = new FormData();
        data.top = new FormAttachment(control, 0, 0x1000000);
        data.left = new FormAttachment(0);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.top = topControl == null ? new FormAttachment(0) : new FormAttachment(topControl);
        data.left = new FormAttachment(label);
        data.right = new FormAttachment(100);
        control.setLayoutData((Object)data);
        return data;
    }

    public static Point computeMax(Control[] controls) {
        return UI.computeMax(controls, -1, -1);
    }

    public static Point computeMax(Control[] controls, int wHint, int hHint) {
        Point max = new Point(0, 0);
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Point size = c.computeSize(wHint, hHint);
            max.x = Math.max(max.x, size.x);
            max.y = Math.max(max.y, size.y);
            ++n2;
        }
        return max;
    }

    public static Event newKeyEvent(KeyEvent e) {
        Event event = new Event();
        event.character = e.character;
        event.data = e.data;
        event.display = e.display;
        event.doit = e.doit;
        event.keyCode = e.keyCode;
        event.stateMask = e.stateMask;
        event.time = e.time;
        event.widget = e.widget;
        return event;
    }

    public static Event newTraverseEvent(TraverseEvent e) {
        Event event = new Event();
        event.character = e.character;
        event.data = e.data;
        event.display = e.display;
        event.doit = e.doit;
        event.keyCode = e.keyCode;
        event.stateMask = e.stateMask;
        event.time = e.time;
        event.widget = e.widget;
        return event;
    }

    public static boolean isMouseOver(Control control) {
        if (control == null) {
            throw new NullPointerException("control");
        }
        if (!control.isVisible()) {
            return false;
        }
        Control cursorControl = control.getDisplay().getCursorControl();
        while (cursorControl != null) {
            if (cursorControl == control) {
                return true;
            }
            cursorControl = cursorControl.getParent();
        }
        return false;
    }

    public static boolean isTooBig(Shell shell) {
        shell.getDisplay();
        Rectangle bounds = shell.getMonitor().getClientArea();
        Point size = shell.getSize();
        return size.x > bounds.width || size.y > bounds.height;
    }
}

