/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.ApprovedRequest;
import ca.infodata.dsq.domain.IPrescriptionSummary;
import ca.infodata.dsq.domain.PrescriptionDeviceSummary;
import ca.infodata.dsq.domain.PrescriptionDrugSummary;
import ca.infodata.dsq.domain.ToBeApprovedRequest;
import ca.infodata.dsq.service.oe.OEC1701Svc.RetractRequestCriteria;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.EventLockCallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RetractPrescriptionAction
extends BaseDSQAction
implements IWorkbenchWindowActionDelegate {
    private static final String CANCELLATION_OF = Messages.getString((String)"CANCELLATION_OF", (String[])new String[0]);
    private static final String PREPARATION = Messages.getString((String)"PREPARATION", (String[])new String[0]);
    private static final String CANCELLING = Messages.getString((String)"CANCELLING", (String[])new String[0]);
    private static IAction action;
    private static boolean tempEnable;
    private Image disable;
    private boolean silent;

    static {
        tempEnable = true;
    }

    public void dispose() {
        if (this.disable != null && !this.disable.isDisposed()) {
            this.disable.dispose();
        }
    }

    public void run(IAction action) {
        throw new UnsupportedOperationException();
    }

    public boolean retract(IPatient patient, IPrescriptionSummary prescription, IProgressMonitor monitor) {
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        Data data = new Data();
        data.prescriptionFormat = this.format(prescription);
        data.prescriptionId = prescription.getId();
        data.prescriptionVersion = prescription.getVersion();
        return this.retract(patient, data, monitor);
    }

    public boolean retract(IPatient patient, String prescriptionFormat, String dsqPrescriptionId, String dsqPrescriptionVersion, IProgressMonitor monitor) {
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        if (dsqPrescriptionId == null) {
            throw new NullPointerException("dsqPrescriptionId");
        }
        if (dsqPrescriptionVersion == null) {
            throw new NullPointerException("dsqPrescriptionVersion");
        }
        Data data = new Data();
        data.prescriptionFormat = prescriptionFormat;
        data.prescriptionId = dsqPrescriptionId;
        data.prescriptionVersion = dsqPrescriptionVersion;
        return this.retract(patient, data, monitor);
    }

    private boolean retract(IPatient patient, Data data, IProgressMonitor monitor) {
        boolean retracted = false;
        monitor.beginTask(String.valueOf(CANCELLATION_OF) + data.prescriptionFormat, 4);
        try {
            boolean confirmed;
            XmlSignatureI signature = null;
            Alias alias = this.getAlias(monitor);
            if (!this.hasSignatures(patient.getId())) {
                if (!UI.OS_WINDOWS) {
                    throw new AbortException(Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                signature = this.getSignatureI(monitor, alias, null);
            }
            monitor.subTask(PREPARATION);
            try {
                this.retract1(patient, (Signature)signature, data);
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (Exception e) {
                data.status1 = new Status(IStatus.Severity.BUG, (Throwable)e);
            }
            monitor.worked(1);
            if (data.status1.isOK() && data.toBeApprovedRequest != null) {
                confirmed = this.isSilent() ? true : this.showConfirmation(data);
            } else {
                if (!this.isSilent()) {
                    MessageUtil.show((Shell)this.getShell(), (IStatus)data.status1);
                }
                confirmed = false;
            }
            monitor.worked(1);
            if (confirmed) {
                Signature signatureS = this.getSignatureS(monitor, alias, null, data.toBeApprovedRequest.hash);
                data.approvedRequest = data.toBeApprovedRequest.toApprovedRequest(signatureS);
                monitor.worked(1);
                monitor.subTask(CANCELLING);
                this.retract2(patient, (Signature)signature, data);
                if (data.status2.isOK()) {
                    retracted = true;
                    if (!this.isSilent()) {
                        MessageUtil.infoMsg((Shell)this.getShell(), (String)"Le retrait a r\u00e9ussi :)");
                    }
                } else {
                    retracted = false;
                    if (!this.isSilent()) {
                        MessageUtil.warningMsg((Shell)this.getShell(), (String)("Le retrait a \u00e9chou\u00e9 :( avec le message suivant : \n\n " + RetractPrescriptionAction.getReadTimeoutMessage(data.status2.getMessage())));
                    }
                }
                monitor.worked(1);
            } else {
                monitor.worked(2);
            }
        }
        catch (AbortException e) {
            MessageUtil.errorMsg((Shell)this.getShell(), (String)e.getMessage());
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CancelException cancelException) {
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return retracted;
    }

    private String format(IPrescriptionSummary prescription) {
        String prescriptionText;
        if (prescription instanceof PrescriptionDrugSummary) {
            prescriptionText = String.valueOf(((PrescriptionDrugSummary)prescription).medication.name) + ": " + ((PrescriptionDrugSummary)prescription).dosageText;
        } else if (prescription instanceof PrescriptionDeviceSummary) {
            prescriptionText = String.valueOf(((PrescriptionDeviceSummary)prescription).device.name) + ": " + ((PrescriptionDeviceSummary)prescription).usageInstructions;
        } else {
            throw new IllegalArgumentException("unsupported prescription class type " + prescription.getClass().getSimpleName());
        }
        return prescriptionText;
    }

    private boolean showConfirmation(Data data) {
        MyMessageDialogBuilder builder = new MyMessageDialogBuilder();
        builder.setParent(this.getShell());
        builder.setImageType(3);
        builder.setButtonLabels(new String[]{MessageUtil.CONFIRMER, MessageUtil.ANNULER});
        builder.setDefaultButton(0);
        builder.setTitle("Confirmer le retrait");
        String prescriptionText = data.prescriptionFormat;
        builder.setMessage("Veuillez confirmer le retrait de la prescription suivante du registre DSQ. \n\n " + prescriptionText);
        int r = builder.buildAndOpen();
        return r == 0;
    }

    private void retract1(IPatient patient, Signature signature, final Data data) throws InterruptedException {
        EventLockCallback callback = new EventLockCallback((IStatusHandler)JustLogStatusHandler.getInstance()){

            public void responseOverride(ReturnObject response) {
                if (response != null) {
                    if (response.getStatus().isOkToProceed() && (response.getObj() == null || response.getObj() instanceof ToBeApprovedRequest)) {
                        data.toBeApprovedRequest = (ToBeApprovedRequest)response.getObj();
                    }
                    data.status1 = response.getStatus();
                } else {
                    data.status1 = new Status(IStatus.Severity.BUG, "response is null");
                }
            }

            public void exceptionOverride(Exception e) {
                super.exceptionOverride(e);
                data.status1 = new Status(IStatus.Severity.BUG, "Failed to retract", (Throwable)e);
            }
        };
        XSession session = Application.get().getGlobalInstances().getSession();
        try {
            DSQAccessorClient.getInstance().retractPrescription1((ICallback)callback, session, patient.getId(), signature, data.prescriptionId, data.prescriptionVersion);
            callback.getLock().waitUntilEvent();
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            callback.kill();
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
        catch (InterruptedException ex) {
            callback.kill();
            throw ex;
        }
        catch (Exception e) {
            callback.kill();
            Log.log((Throwable)e);
        }
    }

    private void retract2(IPatient patient, Signature signature, final Data data) throws InterruptedException {
        EventLockCallback callback = new EventLockCallback((IStatusHandler)JustLogStatusHandler.getInstance()){

            public void responseOverride(ReturnObject response) {
                if (response != null) {
                    data.status2 = response.getStatus();
                }
            }
        };
        XSession session = Application.get().getGlobalInstances().getSession();
        try {
            DSQAccessorClient.getInstance().retractPrescription2((ICallback)callback, session, patient.getId(), signature, data.prescriptionId, data.prescriptionVersion, data.approvedRequest);
            callback.getLock().waitUntilEvent();
        }
        catch (InterruptedException ex) {
            callback.kill();
            throw ex;
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            callback.kill();
            MessageUtil.cannotConnectToServerExceptionMsg();
        }
        catch (Exception e) {
            callback.kill();
            Log.log((Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        RetractPrescriptionAction.action = action;
        action.setEnabled(tempEnable);
        Image icon = ResourceGetter.getImage((String)"images/enc-icon16.png");
        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)icon));
        this.disable = new Image((Device)Display.getDefault(), icon, 2);
        action.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)this.disable));
    }

    public static void setEnabled(boolean value) {
        if (action != null) {
            action.setEnabled(value);
        } else {
            tempEnable = value;
        }
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    private static class Data {
        String prescriptionFormat;
        String prescriptionId;
        String prescriptionVersion;
        ToBeApprovedRequest toBeApprovedRequest;
        ApprovedRequest<RetractRequestCriteria> approvedRequest;
        IStatus status1;
        IStatus status2;

        private Data() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.prescriptionId == null ? 0 : this.prescriptionId.hashCode());
            result = 31 * result + (this.prescriptionVersion == null ? 0 : this.prescriptionVersion.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Data other = (Data)obj;
            return this.hashCode() == other.hashCode();
        }
    }
}

