/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dsq;

import ca.infodata.dsq.domain.Address;
import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.CandidateRelation;
import ca.infodata.dsq.domain.CandidateRelationType;
import ca.infodata.dsq.domain.Gender;
import ca.infodata.dsq.domain.NAM;
import ca.infodata.dsq.service.ru.FindCandidateCriteria;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.dsq.AbortException;
import ca.infodata.ofys.client.modules.dsq.Alias;
import ca.infodata.ofys.client.modules.dsq.CancelException;
import ca.infodata.ofys.data.client.dataaccess.DSQAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XAddress;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformationOrigin;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.NAM_QC;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLog;
import ca.infodata.ofys.ui.controls.IRunnableWithProgressWithLog;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialogWithLog;
import ca.infodata.ofys.ui.dsq.BaseDSQAction;
import ca.infodata.ofys.ui.dsq.FindCandidateActionDialog;
import ca.infodata.ofys.ui.dsq.Messages;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.MutableBoolean;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FindCandidateAction
extends BaseDSQAction
implements IWorkbenchWindowActionDelegate {
    private static final String RESOLUTION_DU_PATIENT = Messages.getString("FindCandidateAction.RESOLUTION_DU_PATIENT");
    private static final Logger logger = Logger.getLogger(FindCandidateAction.class.getName());
    private static IAction action;
    private static boolean tempEnable;
    private Image disable;

    static {
        tempEnable = true;
    }

    public void dispose() {
        if (this.disable != null && !this.disable.isDisposed()) {
            this.disable.dispose();
        }
    }

    public void run(IAction action) {
        XPatient patient = PersonUiPlugin.getDefault().getCurrentPatient();
        if (patient != null) {
            IWorkbenchPage page = ControlsPlugin.getActivePage();
            if (page != null && page.getActiveEditor() instanceof PatientMultiEditor) {
                PatientMultiEditor activeEditor = (PatientMultiEditor)page.getActiveEditor();
                MyProgressMonitorDialog dialog2 = new MyProgressMonitorDialog(this.getShell());
                try {
                    dialog2.setInterruptOnCancel(true);
                    dialog2.run(true, true, new IRunnableWithProgress((IPatient)patient, activeEditor){
                        private final /* synthetic */ IPatient val$patient;
                        private final /* synthetic */ PatientMultiEditor val$activeEditor;
                        {
                            this.val$patient = iPatient;
                            this.val$activeEditor = patientMultiEditor;
                        }

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                final Candidate candidate = FindCandidateAction.this.find(this.val$patient, monitor);
                                if (candidate != null) {
                                    MessageUtil.infoMsg((Shell)FindCandidateAction.this.getShell(), (String)"La r\u00e9solution a r\u00e9ussi.");
                                    if (MessageUtil.askQuestion((Shell)FindCandidateAction.this.getShell(), (String)("Voulez-vous importer les donn\u00e9es DSQ du patient : \n" + FindCandidateAction.this.formatCandidate(candidate) + "\ndans le dossier local?"), (boolean)false)) {
                                        FindCandidateAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                FindCandidateAction.this.importDsqPatientToLocalPatient(val$activeEditor, candidate);
                                            }
                                        });
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error", e);
                                MessageUtil.show((Shell)FindCandidateAction.this.getShell(), (Exception)e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Error", ex);
                }
            } else {
                MyProgressMonitorDialogWithLog dialog2 = new MyProgressMonitorDialogWithLog(this.getShell());
                try {
                    dialog2.setInterruptOnCancel(true);
                    dialog2.runWithLog(true, true, new IRunnableWithProgressWithLog((IPatient)patient){
                        private final /* synthetic */ IPatient val$patient;
                        {
                            this.val$patient = iPatient;
                        }

                        public void run(IProgressMonitorWithLog monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                FindCandidateAction.this.getNiu(this.val$patient, true, true, monitor);
                            }
                            catch (AbortException e) {
                                monitor.log(Level.SEVERE, e.getMessage());
                            }
                            catch (CancelException e) {
                                monitor.log(Level.SEVERE, StringUtils.isNotBlank((String)e.getMessage()) ? e.getMessage() : "L'utilisateur a annul\u00e9");
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error", e);
                                monitor.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Error", ex);
                }
            }
        }
    }

    public String getNiu(IPatient patient, IProgressMonitorWithLog monitor) throws AbortException, CancelException, InterruptedException {
        return this.getNiu(patient, false, false, monitor);
    }

    public String getNiu(IPatient patient, boolean forceResolution, boolean forceResolutionDialog, IProgressMonitorWithLog monitor) throws AbortException, CancelException, InterruptedException {
        if (!forceResolution && StringUtils.isNotEmpty((String)patient.getNiu())) {
            return patient.getNiu();
        }
        Candidate candidate = this.getCandidate(patient, forceResolutionDialog, monitor);
        return candidate.getNiu().value();
    }

    public Candidate getCandidate(IPatient patient, IProgressMonitorWithLog monitor) throws AbortException, CancelException, InterruptedException {
        return this.getCandidate(patient, false, monitor);
    }

    public Candidate getCandidate(IPatient patient, boolean forceResolutionDialog, IProgressMonitorWithLog monitor) throws AbortException, CancelException, InterruptedException {
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        if (patient.getId() == null) {
            throw new NullPointerException("patient.getId()");
        }
        if (monitor != null) {
            monitor.beginTask(RESOLUTION_DU_PATIENT, 2);
        }
        try {
            Candidate candidate;
            XSession session = Application.get().getGlobalInstances().getSession();
            XmlSignatureI signature = null;
            if (!this.hasSignatures(null)) {
                if (!UI.OS_WINDOWS) {
                    throw new AbortException(ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.getAlias((IProgressMonitor)monitor);
                signature = this.getSignatureI((IProgressMonitor)monitor, alias, null);
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            if (monitor != null) {
                monitor.subTask(RESOLUTION_DU_PATIENT);
            }
            ReturnObject r = DSQAccessorClient.getInstance().findCandidateById(session, patient.getId(), true, (Signature)signature);
            if (monitor != null) {
                monitor.worked(1);
            }
            if (r == null) {
                throw new AbortException("Erreur lors de la r\u00e9solution du patient au registre");
            }
            if (r.getStatus().getChildByCode("DSQ_CANDIDATE_ID_ERROR") != null || !r.getStatus().isOkToProceed() && forceResolutionDialog) {
                if (monitor != null) {
                    monitor.log(Level.WARNING, "Erreur lors de la r\u00e9solution du patient au registre");
                }
                candidate = null;
                final FindCandidateActionDialog.FindCandidateActionDialogData dialogData = new FindCandidateActionDialog.FindCandidateActionDialogData();
                dialogData.nam = patient.getHealthInsuranceNumber();
                dialogData.firstName = patient.getFirstName();
                dialogData.lastName = patient.getLastName();
                dialogData.birthDate = patient.getBirthDate();
                dialogData.gender = patient.getGender();
                final MutableBoolean canceled = new MutableBoolean(false);
                do {
                    if (monitor != null) {
                        monitor.log(Level.INFO, "Modification des informations du patient");
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            FindCandidateActionDialog dialog = new FindCandidateActionDialog(FindCandidateAction.this.getShell(), dialogData);
                            int open = dialog.open();
                            canceled.setValue(open != 0);
                        }
                    });
                    if (canceled.booleanValue()) {
                        throw new CancelException();
                    }
                    this.showPatientNameLongerThanMaxInfo(dialogData.firstName, dialogData.lastName);
                    FindCandidateCriteria criteria = StringUtils.isNotBlank((String)dialogData.nam) ? new FindCandidateCriteria(new NAM(dialogData.nam)) : new FindCandidateCriteria(dialogData.firstName, dialogData.lastName, Long.valueOf(dialogData.birthDate.toTimeInMillisUTC()), Gender.from((String)dialogData.gender));
                    r = DSQAccessorClient.getInstance().findCandidateByCriteria(session, criteria, (Signature)signature);
                    if (r == null) {
                        throw new AbortException("Erreur lors de la r\u00e9solution du patient au registre");
                    }
                    candidate = (Candidate)r.getObj();
                    if (candidate != null) {
                        Address dsqAddress;
                        XPatient simplePatient = PatientUtil.getSimplePatient((Object)patient);
                        simplePatient.setFirstName(candidate.getFirstName());
                        simplePatient.setLastName(candidate.getLastName());
                        simplePatient.setBirthDate(LocalDate.fromTimeInMillisUTC((Long)candidate.getBirthDate()));
                        simplePatient.setGender(candidate.getGender().code);
                        simplePatient.setHealthInsuranceNumber(candidate.getNam() == null ? null : candidate.getNam().value());
                        if (candidate.getRelations() != null) {
                            CandidateRelation mother;
                            CandidateRelation father;
                            if (StringUtils.isBlank((CharSequence)simplePatient.getFatherName()) && (father = (CandidateRelation)candidate.getRelations().stream().filter(c -> c.type == CandidateRelationType.FATHER).findFirst().orElse(null)) != null) {
                                simplePatient.setFatherName(StringUtils.joinNonBlank((String)", ", (Object[])new Object[]{father.lastName, father.firstName}));
                            }
                            if (StringUtils.isBlank((CharSequence)simplePatient.getMotherName()) && (mother = (CandidateRelation)candidate.getRelations().stream().filter(c -> c.type == CandidateRelationType.MOTHER).findFirst().orElse(null)) != null) {
                                simplePatient.setMotherName(StringUtils.joinNonBlank((String)", ", (Object[])new Object[]{mother.lastName, mother.firstName}));
                            }
                        }
                        if ((dsqAddress = candidate.getAddress()) != null) {
                            String telecom;
                            EditableDataObjectList contacts;
                            boolean found;
                            EditableDataObjectList addresses = simplePatient.getLstAddress();
                            if (addresses.isEmpty()) {
                                String street = StringUtils.defaultString((String)dsqAddress.street);
                                int hubAddressHash = this.computeHash(street, dsqAddress.city, dsqAddress.postalCode);
                                found = false;
                                for (XAddress address : addresses) {
                                    int addressHash = this.computeHash(address.getStreet(), address.getCity() == null ? null : address.getCity().getName(), address.getPostalCode());
                                    if (hubAddressHash != addressHash) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    XAddress a = new XAddress();
                                    a.setStreet(street);
                                    a.setCity(new XCity(dsqAddress.city));
                                    a.setCountry(new XCountry(dsqAddress.country));
                                    a.setProvince(new XProvince(dsqAddress.state));
                                    a.setPostalCode(dsqAddress.postalCode);
                                    addresses.add((IMinimalEditableDataObject)a);
                                }
                            }
                            if ((contacts = simplePatient.getLstContactInformation()).isEmpty() && StringUtils.isNotBlank((String)dsqAddress.telecom) && (telecom = dsqAddress.telecom.replaceAll("[^0-9]", "")).length() >= 7) {
                                found = false;
                                for (XContactInformation contact : contacts) {
                                    if (!telecom.equals(contact.getContact())) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    XContactInformation newContact = new XContactInformation();
                                    newContact.setNew();
                                    newContact.setContact(telecom);
                                    newContact.setOrigin(XContactInformationOrigin.OFYS);
                                    newContact.setTypeContact(XContactInformation.CONTACT_TYPE_PHONE);
                                    contacts.add((IMinimalEditableDataObject)newContact);
                                }
                            }
                        }
                        simplePatient.setUpdated();
                        PatientAccessorClient.getInstance().saveSync(this.hashCode(), Application.get().getGlobalInstances().getSession(), (Serializable)simplePatient, false);
                        if (monitor == null) continue;
                        monitor.log(Level.INFO, "R\u00e9solution r\u00e9ussie");
                        continue;
                    }
                    if (monitor == null) continue;
                    monitor.log(Level.WARNING, "Erreur lors de la r\u00e9solution du patient au registre");
                } while (candidate == null && !canceled.booleanValue());
            } else if (!r.getStatus().isOkToProceed()) {
                throw new AbortException(FindCandidateAction.getReadTimeoutMessage(r.getStatus().getMessage()));
            }
            if ((candidate = (Candidate)r.getObj()) != null && monitor != null) {
                monitor.log(Level.INFO, "R\u00e9solution r\u00e9ussie");
            }
            Candidate candidate2 = candidate;
            return candidate2;
        }
        catch (CannotConnectToServerException e) {
            MessageUtil.cannotConnectToServerExceptionMsg();
            throw new AbortException((Throwable)e);
        }
        catch (AbortException e) {
            throw e;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get niu for patient " + patient.getId() + " " + StringUtils.safeToString((Logger)logger, (Object)patient), e);
            throw new AbortException((Throwable)e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private Candidate find(IPatient patient, IProgressMonitor monitor) {
        Candidate candidate = null;
        try {
            monitor.beginTask(RESOLUTION_DU_PATIENT, 3);
            this.checkIfActionWasCanceled(monitor);
            XmlSignatureI signature = null;
            if (!this.hasSignatures(null)) {
                if (!UI.OS_WINDOWS) {
                    throw new AbortException(ca.infodata.ofys.data.middle.dataobjects.Messages.getString((String)"ABSENCE_SIGN_DSQ", (String[])new String[0]));
                }
                Alias alias = this.getAlias(monitor);
                signature = this.getSignatureI(monitor, alias, null);
            }
            this.checkIfActionWasCanceled(monitor);
            monitor.worked(1);
            XSession session = Application.get().getGlobalInstances().getSession();
            try {
                ReturnObject r;
                monitor.subTask("Recherche");
                if (patient.getId() == null) {
                    String nam;
                    FindCandidateCriteria criteria = null;
                    if (criteria == null && NAM_QC.validateNAMLength((String)(nam = patient.getHealthInsuranceNumber()))) {
                        criteria = new FindCandidateCriteria(new NAM(nam));
                    }
                    if (criteria == null) {
                        if (StringUtils.isBlank((CharSequence)patient.getFirstName()) || StringUtils.isBlank((CharSequence)patient.getLastName()) || patient.getBirthDate() == null || FindCandidateAction.getDsqGender(patient.getGender()) == null) {
                            throw new AbortException("Veuillez sp\u00e9cifier le pr\u00e9nom, le nom de famille, la date de naissance et le sexe OU le nam");
                        }
                        this.showPatientNameLongerThanMaxInfo(patient.getFirstName(), patient.getLastName());
                        criteria = new FindCandidateCriteria(patient.getFirstName(), patient.getLastName(), Long.valueOf(patient.getBirthDate().toTimeInMillisUTC()), FindCandidateAction.getDsqGender(patient.getGender()));
                    }
                    this.checkIfActionWasCanceled(monitor);
                    r = DSQAccessorClient.getInstance().findCandidateByCriteria(session, criteria, (Signature)signature);
                } else {
                    this.checkIfActionWasCanceled(monitor);
                    r = DSQAccessorClient.getInstance().findCandidateById(session, patient.getId(), false, (Signature)signature);
                }
                if (r == null) {
                    throw new AbortException("Erreur lors de la resolution du patient au registre");
                }
                if (!r.getStatus().isOkToProceed()) {
                    throw new AbortException(FindCandidateAction.getReadTimeoutMessage(r.getStatus().getMessage()));
                }
                candidate = (Candidate)r.getObj();
            }
            catch (CannotConnectToServerException cannotConnectToServerException) {
                MessageUtil.cannotConnectToServerExceptionMsg();
            }
        }
        catch (CancelException cancelException) {
        }
        catch (AbortException e) {
            MessageUtil.errorMsg((Shell)this.getShell(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to find candidate with patient " + patient.getId() + " " + StringUtils.safeToString((Logger)logger, (Object)patient), e);
            MessageUtil.errorMsg((Shell)this.getShell(), (String)e.getMessage());
        }
        monitor.done();
        return candidate;
    }

    protected void showPatientNameLongerThanMaxInfo(String firstName, String lastName) {
        JoinList infos = new JoinList("\n\n");
        if (StringUtils.isNotBlank((String)firstName) && firstName.length() > 25) {
            infos.add((CharSequence)"Le pr\u00e9nom est trop long pour la recherche et sera tronqu\u00e9 \u00e0 25 caract\u00e8res.");
        }
        if (StringUtils.isNotBlank((String)lastName) && lastName.length() > 40) {
            infos.add((CharSequence)"Le nom est trop long pour la recherche et sera tronqu\u00e9 \u00e0 40 caract\u00e8res.");
        }
        if (!infos.isEmpty()) {
            MessageUtil.warningMsg((Shell)this.getShell(), (String)infos.toString());
        }
    }

    protected String formatCandidate(Candidate candidate) {
        String firstName = candidate.getFirstName();
        String lastName = candidate.getLastName();
        String sex = FindCandidateAction.getInfodataGender((Gender)candidate.getGender()).id;
        String birthDate = candidate.getBirthDate() == null ? null : LocalDate.fromTimeInMillisUTC((Long)candidate.getBirthDate()).formatHyphen();
        String nam = candidate.getNam() == null ? null : candidate.getNam().value();
        String address = null;
        String telecom = null;
        Address dsqAddress = candidate.getAddress();
        if (dsqAddress != null) {
            address = new JoinList(", ").setTrim(true).add((CharSequence)dsqAddress.street).add((CharSequence)dsqAddress.city).add((CharSequence)dsqAddress.state).add((CharSequence)dsqAddress.postalCode).add((CharSequence)dsqAddress.country).toString();
            telecom = dsqAddress.telecom;
        }
        JoinList list = new JoinList(", ");
        list.add((CharSequence)firstName);
        list.add((CharSequence)lastName);
        list.add((CharSequence)sex);
        list.add((CharSequence)birthDate);
        list.add((CharSequence)nam);
        list.add("\n", address);
        list.add("\n", telecom);
        return list.toString();
    }

    protected void importDsqPatientToLocalPatient(PatientMultiEditor editor, Candidate candidate) {
        Address dsqAddress;
        XPatient patient = editor.getPatient();
        patient.setFirstName(candidate.getFirstName());
        patient.setLastName(candidate.getLastName());
        patient.setBirthDate(LocalDate.fromTimeInMillisUTC((Long)candidate.getBirthDate()));
        XPerson.Gender sex = FindCandidateAction.getInfodataGender(candidate.getGender());
        patient.setGender(sex == null ? null : sex.id);
        patient.setHealthInsuranceNumber(candidate.getNam() == null ? null : candidate.getNam().value());
        if (candidate.getRelations() != null) {
            CandidateRelation mother;
            CandidateRelation father;
            if (StringUtils.isBlank((CharSequence)patient.getFatherName()) && (father = (CandidateRelation)candidate.getRelations().stream().filter(c -> c.type == CandidateRelationType.FATHER).findFirst().orElse(null)) != null) {
                patient.setFatherName(StringUtils.joinNonBlank((String)", ", (Object[])new Object[]{father.lastName, father.firstName}));
            }
            if (StringUtils.isBlank((CharSequence)patient.getMotherName()) && (mother = (CandidateRelation)candidate.getRelations().stream().filter(c -> c.type == CandidateRelationType.MOTHER).findFirst().orElse(null)) != null) {
                patient.setMotherName(StringUtils.joinNonBlank((String)", ", (Object[])new Object[]{mother.lastName, mother.firstName}));
            }
        }
        if ((dsqAddress = candidate.getAddress()) != null) {
            String telecom;
            EditableDataObjectList contacts = patient.getLstContactInformation();
            EditableDataObjectList addresses = patient.getLstAddress();
            String street = StringUtils.defaultString((String)dsqAddress.street);
            int hubAddressHash = this.computeHash(street, dsqAddress.city, dsqAddress.postalCode);
            boolean found = false;
            for (XAddress address : addresses) {
                int addressHash = this.computeHash(address.getStreet(), address.getCity() == null ? null : address.getCity().getName(), address.getPostalCode());
                if (hubAddressHash != addressHash) continue;
                found = true;
                break;
            }
            if (!found) {
                XAddress a = new XAddress();
                a.setStreet(street);
                a.setCity(new XCity(dsqAddress.city));
                a.setCountry(new XCountry(dsqAddress.country));
                a.setProvince(new XProvince(dsqAddress.state));
                a.setPostalCode(dsqAddress.postalCode);
                addresses.add((IMinimalEditableDataObject)a);
                patient.setUpdated();
            }
            found = false;
            if (StringUtils.isNotBlank((String)dsqAddress.telecom) && (telecom = dsqAddress.telecom.replaceAll("[^0-9]", "")).length() >= 7) {
                for (XContactInformation contact : contacts) {
                    if (!telecom.equals(contact.getContact())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    XContactInformation newContact = new XContactInformation();
                    newContact.setNew();
                    newContact.setContact(telecom);
                    newContact.setOrigin(XContactInformationOrigin.OFYS);
                    newContact.setTypeContact(XContactInformation.CONTACT_TYPE_PHONE);
                    contacts.add((IMinimalEditableDataObject)newContact);
                    patient.setUpdated();
                }
            }
        }
        editor.showAllDataObject();
    }

    private int computeHash(String street, String city, String postalCode) {
        String street2 = street == null ? "" : street.toLowerCase().replaceAll("[^a-z0-9]", "");
        String city2 = city == null ? "" : city.toLowerCase().replaceAll("[^a-z0-9]", "");
        String postalCode2 = postalCode == null ? "" : postalCode.toLowerCase().replaceAll("[^a-z0-9]", "");
        return new JoinList(";", new Object[]{street2, city2, postalCode2}).toString().hashCode();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        FindCandidateAction.action = action;
        action.setEnabled(tempEnable);
        Image icon = ResourceGetter.getImage((String)"images/enc-icon16.png");
        action.setImageDescriptor(ImageDescriptor.createFromImage((Image)icon));
        this.disable = new Image((Device)Display.getDefault(), icon, 2);
        action.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)this.disable));
    }

    public static void setEnabled(boolean value) {
        if (action != null) {
            action.setEnabled(value);
        } else {
            tempEnable = value;
        }
    }
}

