/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.cache;

import ca.infodata.ofys.client.cache.IPatientDsqControllerCache;
import ca.infodata.ofys.client.modules.dsq.PatientDsqControllers;
import ca.infodata.ofys.client.modules.dsq.PatientDsqControllersKey;
import ca.infodata.ofys.client.util.SupplierE;
import ca.infodata.util1.StringUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatientDsqControllerCacheImpl
implements IPatientDsqControllerCache {
    private static final Logger logger = Logger.getLogger(PatientDsqControllerCacheImpl.class.getName());
    private Cache<PatientDsqControllersKey, PatientDsqControllers> cache = Caffeine.newBuilder().maximumSize(30L).expireAfterAccess(1L, TimeUnit.HOURS).build();

    private PatientDsqControllers get(PatientDsqControllersKey key) {
        return (PatientDsqControllers)this.cache.getIfPresent((Object)key);
    }

    private void put(PatientDsqControllersKey key, PatientDsqControllers value) {
        this.cache.put((Object)key, (Object)value);
    }

    public PatientDsqControllers get(PatientDsqControllersKey key, SupplierE<PatientDsqControllers> ifAbsent) {
        PatientDsqControllers value = this.get(key);
        if (value == null) {
            try {
                value = (PatientDsqControllers)ifAbsent.get();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting value from ifAbsent supplier" + StringUtils.safeToString((Logger)logger, ifAbsent) + " and key " + StringUtils.safeToString((Logger)logger, (Object)key), e);
            }
            if (value != null) {
                this.put(key, value);
            }
        }
        return value;
    }

    public void dispose() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }
}

