/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;

public final class AppendingDeltaPackedLongBuffer
extends AbstractAppendingLongBuffer {
    long[] minValues;

    public AppendingDeltaPackedLongBuffer(int initialPageCount, int pageSize, float acceptableOverheadRatio) {
        super(initialPageCount, pageSize, acceptableOverheadRatio);
        this.minValues = new long[this.values.length];
    }

    public AppendingDeltaPackedLongBuffer() {
        this(16, 1024, 0.2f);
    }

    public AppendingDeltaPackedLongBuffer(float acceptableOverheadRatio) {
        this(16, 1024, acceptableOverheadRatio);
    }

    @Override
    long get(int block, int element) {
        if (block == this.valuesOff) {
            return this.pending[element];
        }
        if (this.values[block] == null) {
            return this.minValues[block];
        }
        return this.minValues[block] + this.values[block].get(element);
    }

    @Override
    int get(int block, int element, long[] arr, int off, int len) {
        if (block == this.valuesOff) {
            int sysCopyToRead = Math.min(len, this.pendingOff - element);
            System.arraycopy(this.pending, element, arr, off, sysCopyToRead);
            return sysCopyToRead;
        }
        int read = this.values[block].get(element, arr, off, len);
        long d = this.minValues[block];
        int r = 0;
        while (r < read) {
            int n = off++;
            arr[n] = arr[n] + d;
            ++r;
        }
        return read;
    }

    @Override
    void packPendingValues() {
        long minValue = this.pending[0];
        long maxValue = this.pending[0];
        int i = 1;
        while (i < this.pendingOff) {
            minValue = Math.min(minValue, this.pending[i]);
            maxValue = Math.max(maxValue, this.pending[i]);
            ++i;
        }
        long delta = maxValue - minValue;
        this.minValues[this.valuesOff] = minValue;
        if (delta == 0L) {
            this.values[this.valuesOff] = new PackedInts.NullReader(this.pendingOff);
        } else {
            int bitsRequired = delta < 0L ? 64 : PackedInts.bitsRequired(delta);
            int i2 = 0;
            while (i2 < this.pendingOff) {
                int n = i2++;
                this.pending[n] = this.pending[n] - minValue;
            }
            PackedInts.Mutable mutable = PackedInts.getMutable(this.pendingOff, bitsRequired, this.acceptableOverheadRatio);
            int i3 = 0;
            while (i3 < this.pendingOff) {
                i3 += mutable.set(i3, this.pending, i3, this.pendingOff - i3);
            }
            this.values[this.valuesOff] = mutable;
        }
    }

    @Override
    void grow(int newBlockCount) {
        super.grow(newBlockCount);
        this.minValues = Arrays.copyOf(this.minValues, newBlockCount);
    }

    @Override
    long baseRamBytesUsed() {
        return super.baseRamBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }

    @Override
    public long ramBytesUsed() {
        return super.ramBytesUsed() + RamUsageEstimator.sizeOf(this.minValues);
    }
}

