/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.externalsorting;

import com.google.code.externalsorting.BinaryFileBuffer;
import com.google.code.externalsorting.StringSizeEstimator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ExternalSort {
    public static Comparator<String> defaultcomparator = new Comparator<String>(){

        @Override
        public int compare(String r1, String r2) {
            return r1.compareTo(r2);
        }
    };
    public static final int DEFAULTMAXTEMPFILES = 1024;

    public static void displayUsage() {
        System.out.println("java com.google.externalsorting.ExternalSort inputfile outputfile");
        System.out.println("Flags are:");
        System.out.println("-v or --verbose: verbose output");
        System.out.println("-d or --distinct: prune duplicate lines");
        System.out.println("-t or --maxtmpfiles (followed by an integer): specify an upper bound on the number of temporary files");
        System.out.println("-c or --charset (followed by a charset code): specify the character set to use (for sorting)");
        System.out.println("-z or --gzip: use compression for the temporary files");
        System.out.println("-H or --header (followed by an integer): ignore the first few lines");
        System.out.println("-s or --store (following by a path): where to store the temporary files");
        System.out.println("-h or --help: display this message");
    }

    public static long estimateAvailableMemory() {
        System.gc();
        return Runtime.getRuntime().freeMemory();
    }

    public static long estimateBestSizeOfBlocks(long sizeoffile, int maxtmpfiles, long maxMemory) {
        long blocksize = sizeoffile / (long)maxtmpfiles + (long)(sizeoffile % (long)maxtmpfiles == 0L ? 0 : 1);
        if (blocksize < maxMemory / 2L) {
            blocksize = maxMemory / 2L;
        }
        return blocksize;
    }

    public static void main(String[] args) throws IOException {
        boolean verbose = false;
        boolean distinct = false;
        int maxtmpfiles = 1024;
        Charset cs = Charset.defaultCharset();
        String inputfile = null;
        String outputfile = null;
        File tempFileStore = null;
        boolean usegzip = false;
        int headersize = 0;
        int param = 0;
        while (param < args.length) {
            if (args[param].equals("-v") || args[param].equals("--verbose")) {
                verbose = true;
            } else {
                if (args[param].equals("-h") || args[param].equals("--help")) {
                    ExternalSort.displayUsage();
                    return;
                }
                if (args[param].equals("-d") || args[param].equals("--distinct")) {
                    distinct = true;
                } else if ((args[param].equals("-t") || args[param].equals("--maxtmpfiles")) && args.length > param + 1) {
                    maxtmpfiles = Integer.parseInt(args[++param]);
                    if (headersize < 0) {
                        System.err.println("maxtmpfiles should be positive");
                    }
                } else if ((args[param].equals("-c") || args[param].equals("--charset")) && args.length > param + 1) {
                    cs = Charset.forName(args[++param]);
                } else if (args[param].equals("-z") || args[param].equals("--gzip")) {
                    usegzip = true;
                } else if ((args[param].equals("-H") || args[param].equals("--header")) && args.length > param + 1) {
                    if ((headersize = Integer.parseInt(args[++param])) < 0) {
                        System.err.println("headersize should be positive");
                    }
                } else if ((args[param].equals("-s") || args[param].equals("--store")) && args.length > param + 1) {
                    tempFileStore = new File(args[++param]);
                } else if (inputfile == null) {
                    inputfile = args[param];
                } else if (outputfile == null) {
                    outputfile = args[param];
                } else {
                    System.out.println("Unparsed: " + args[param]);
                }
            }
            ++param;
        }
        if (outputfile == null) {
            System.out.println("please provide input and output file names");
            ExternalSort.displayUsage();
            return;
        }
        Comparator<String> comparator = defaultcomparator;
        List<File> l = ExternalSort.sortInBatch(new File(inputfile), comparator, maxtmpfiles, cs, tempFileStore, distinct, headersize, usegzip);
        if (verbose) {
            System.out.println("created " + l.size() + " tmp files");
        }
        ExternalSort.mergeSortedFiles(l, new File(outputfile), comparator, cs, distinct, false, usegzip);
    }

    /*
     * Unable to fully structure code
     */
    public static int mergeSortedFiles(BufferedWriter fbw, final Comparator<String> cmp, boolean distinct, List<BinaryFileBuffer> buffers) throws IOException {
        pq = new PriorityQueue<BinaryFileBuffer>(11, new Comparator<BinaryFileBuffer>(){

            @Override
            public int compare(BinaryFileBuffer i, BinaryFileBuffer j) {
                return cmp.compare(i.peek(), j.peek());
            }
        });
        for (BinaryFileBuffer bfb : buffers) {
            if (bfb.empty()) continue;
            pq.add(bfb);
        }
        rowcounter = 0;
        try {
            if (!distinct) {
                while (pq.size() > 0) {
                    bfb = pq.poll();
                    r = bfb.pop();
                    fbw.write(r);
                    fbw.newLine();
                    ++rowcounter;
                    if (bfb.empty()) {
                        bfb.fbr.close();
                        continue;
                    }
                    pq.add(bfb);
                }
            }
            lastLine = null;
            if (pq.size() > 0) {
                bfb = pq.poll();
                lastLine = bfb.pop();
                fbw.write(lastLine);
                fbw.newLine();
                ++rowcounter;
                if (bfb.empty()) {
                    bfb.fbr.close();
                } else {
                    pq.add(bfb);
                }
            }
            while (pq.size() > 0) {
                bfb = pq.poll();
                r = bfb.pop();
                if (cmp.compare(r, lastLine) != 0) {
                    fbw.write(r);
                    fbw.newLine();
                    lastLine = r;
                }
                ++rowcounter;
                if (bfb.empty()) {
                    bfb.fbr.close();
                    continue;
                }
                pq.add(bfb);
            }
        }
        finally {
            fbw.close();
            ** for (bfb : pq)
        }
lbl-1000:
        // 1 sources

        {
            bfb.close();
            continue;
        }
lbl55:
        // 1 sources

        return rowcounter;
    }

    public static int mergeSortedFiles(List<File> files, File outputfile) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, defaultcomparator, Charset.defaultCharset());
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, Charset.defaultCharset());
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, boolean distinct) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, Charset.defaultCharset(), distinct);
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, Charset cs) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, cs, false);
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, Charset cs, boolean distinct) throws IOException {
        return ExternalSort.mergeSortedFiles(files, outputfile, cmp, cs, distinct, false, false);
    }

    public static int mergeSortedFiles(List<File> files, File outputfile, Comparator<String> cmp, Charset cs, boolean distinct, boolean append, boolean usegzip) throws IOException {
        ArrayList<BinaryFileBuffer> bfbs = new ArrayList<BinaryFileBuffer>();
        for (File f : files) {
            FileInputStream in = new FileInputStream(f);
            BufferedReader br = usegzip ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream((InputStream)in, 2048), cs)) : new BufferedReader(new InputStreamReader((InputStream)in, cs));
            BinaryFileBuffer bfb = new BinaryFileBuffer(br);
            bfbs.add(bfb);
        }
        BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile, append), cs));
        int rowcounter = ExternalSort.mergeSortedFiles(fbw, cmp, distinct, bfbs);
        for (File f : files) {
            f.delete();
        }
        return rowcounter;
    }

    public static void sort(File input, File output) throws IOException {
        ExternalSort.mergeSortedFiles(ExternalSort.sortInBatch(input), output);
    }

    public static File sortAndSave(List<String> tmplist, Comparator<String> cmp, Charset cs, File tmpdirectory) throws IOException {
        return ExternalSort.sortAndSave(tmplist, cmp, cs, tmpdirectory, false, false);
    }

    public static File sortAndSave(List<String> tmplist, Comparator<String> cmp, Charset cs, File tmpdirectory, boolean distinct, boolean usegzip) throws IOException {
        Collections.sort(tmplist, cmp);
        File newtmpfile = File.createTempFile("sortInBatch", "flatfile", tmpdirectory);
        newtmpfile.deleteOnExit();
        OutputStream out = new FileOutputStream(newtmpfile);
        int ZIPBUFFERSIZE = 2048;
        if (usegzip) {
            out = new GZIPOutputStream(out, ZIPBUFFERSIZE){
                {
                    this.def.setLevel(1);
                }
            };
        }
        try (BufferedWriter fbw = new BufferedWriter(new OutputStreamWriter(out, cs));){
            if (!distinct) {
                for (String r : tmplist) {
                    fbw.write(r);
                    fbw.newLine();
                }
            } else {
                String lastLine = null;
                Iterator<String> i = tmplist.iterator();
                if (i.hasNext()) {
                    lastLine = i.next();
                    fbw.write(lastLine);
                    fbw.newLine();
                }
                while (i.hasNext()) {
                    String r = i.next();
                    if (cmp.compare(r, lastLine) == 0) continue;
                    fbw.write(r);
                    fbw.newLine();
                    lastLine = r;
                }
            }
        }
        return newtmpfile;
    }

    public static List<File> sortInBatch(BufferedReader fbr, long datalength) throws IOException {
        return ExternalSort.sortInBatch(fbr, datalength, defaultcomparator, 1024, ExternalSort.estimateAvailableMemory(), Charset.defaultCharset(), null, false, 0, false);
    }

    public static List<File> sortInBatch(BufferedReader fbr, long datalength, Comparator<String> cmp, boolean distinct) throws IOException {
        return ExternalSort.sortInBatch(fbr, datalength, cmp, 1024, ExternalSort.estimateAvailableMemory(), Charset.defaultCharset(), null, distinct, 0, false);
    }

    public static List<File> sortInBatch(BufferedReader fbr, long datalength, Comparator<String> cmp, int maxtmpfiles, long maxMemory, Charset cs, File tmpdirectory, boolean distinct, int numHeader, boolean usegzip) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        long blocksize = ExternalSort.estimateBestSizeOfBlocks(datalength, maxtmpfiles, maxMemory);
        try {
            ArrayList<String> tmplist = new ArrayList<String>();
            String line = "";
            try {
                int counter = 0;
                while (line != null) {
                    long currentblocksize = 0L;
                    while (currentblocksize < blocksize && (line = fbr.readLine()) != null) {
                        if (counter < numHeader) {
                            ++counter;
                            continue;
                        }
                        tmplist.add(line);
                        currentblocksize += StringSizeEstimator.estimatedSizeOf(line);
                    }
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs, tmpdirectory, distinct, usegzip));
                    tmplist.clear();
                }
            }
            catch (EOFException eOFException) {
                if (tmplist.size() > 0) {
                    files.add(ExternalSort.sortAndSave(tmplist, cmp, cs, tmpdirectory, distinct, usegzip));
                    tmplist.clear();
                }
            }
        }
        finally {
            fbr.close();
        }
        return files;
    }

    public static List<File> sortInBatch(File file) throws IOException {
        return ExternalSort.sortInBatch(file, defaultcomparator, 1024, Charset.defaultCharset(), null, false);
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp) throws IOException {
        return ExternalSort.sortInBatch(file, cmp, 1024, Charset.defaultCharset(), null, false);
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp, boolean distinct) throws IOException {
        return ExternalSort.sortInBatch(file, cmp, 1024, Charset.defaultCharset(), null, distinct);
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp, int maxtmpfiles, Charset cs, File tmpdirectory, boolean distinct) throws IOException {
        return ExternalSort.sortInBatch(file, cmp, maxtmpfiles, cs, tmpdirectory, distinct, 0, false);
    }

    public static List<File> sortInBatch(File file, Comparator<String> cmp, int maxtmpfiles, Charset cs, File tmpdirectory, boolean distinct, int numHeader, boolean usegzip) throws IOException {
        BufferedReader fbr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));
        return ExternalSort.sortInBatch(fbr, file.length(), cmp, maxtmpfiles, ExternalSort.estimateAvailableMemory(), cs, tmpdirectory, distinct, numHeader, usegzip);
    }
}

