/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.webbrowser;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.library.UI;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AdvancedBrowser {
    private static final String ANNULER = Messages.getString((String)"ANNULER", (String[])new String[0]);
    private static final String OK = Messages.getString((String)"OK", (String[])new String[0]);
    private final Shell dialog;
    private boolean okPressed = false;
    private String text = null;
    private String html = null;
    private String url = null;
    private boolean keepIt = false;
    Browser browser = null;

    public AdvancedBrowser(Shell parent, String htmls, boolean keepIt) {
        this(parent, htmls);
        this.keepIt = keepIt;
    }

    public AdvancedBrowser(Shell parent, String htmls) {
        this.dialog = new Shell(parent, 32792);
        this.dialog.setText("Canevas posologiques");
        this.dialog.setLocation((parent.getDisplay().getBounds().width - 400) / 2, (parent.getDisplay().getBounds().height - 300) / 2);
        this.text = htmls;
    }

    public boolean isDisposed() {
        return this.dialog.isDisposed() && this.browser.isDisposed();
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    public void show() {
        this.browser.update();
        this.dialog.setVisible(true);
    }

    public void open() {
        try {
            this.createDialog((Composite)this.dialog);
            this.dialog.setSize(900, 800);
            UI.centerComposite((Composite)this.dialog, (Composite)this.dialog.getParent());
            this.dialog.open();
            if (!this.keepIt) {
                UI.waitForWindowToClose((Shell)this.dialog);
            }
        }
        catch (RuntimeException runtimeException) {}
    }

    private void createDialog(Composite parent) {
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        this.browser = new Browser(parent, 2048);
        if (!this.keepIt) {
            this.browser.addLocationListener((LocationListener)new AdvancedLocationListener());
        }
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                System.out.println("browser in AdvancedBrowser is disposed");
            }
        });
        this.browser.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27 || e.keyCode == 13) {
                    AdvancedBrowser.this.onCancel();
                }
            }
        });
        MyButton btnOk = new MyButton(parent, OK, 8, toolkit);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedBrowser.this.onOk();
            }
        });
        MyButton btnCancel = new MyButton(parent, ANNULER, 8, toolkit);
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedBrowser.this.onCancel();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        data.width = this.keepIt ? 0 : MyButton.getStandardButtonWidth();
        btnCancel.setLayoutData(data);
        btnCancel.setVisible(!this.keepIt);
        data = new FormData();
        data.right = new FormAttachment(btnCancel.getControl(), this.keepIt ? 0 : -5);
        data.bottom = new FormAttachment(100);
        data.width = MyButton.getStandardButtonWidth();
        btnOk.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(btnCancel.getControl());
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.browser.setLayoutData((Object)data);
        this.setText(this.text);
    }

    void onOk() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.okPressed = true;
        try {
            if (this.keepIt) {
                this.dialog.setVisible(false);
            } else {
                this.dialog.dispose();
            }
        }
        catch (Exception exception) {}
    }

    public void dispose() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.dispose();
        }
        if (this.dialog != null && !this.dialog.isDisposed()) {
            this.dialog.dispose();
        }
    }

    void onCancel() {
        this.okPressed = false;
        try {
            if (this.keepIt) {
                this.dialog.setVisible(false);
            } else {
                this.dialog.dispose();
            }
        }
        catch (Exception exception) {}
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public final String getHtml() {
        return this.html;
    }

    public final void setText(String html) {
        if (html != null) {
            if (html.toLowerCase().startsWith("http")) {
                this.url = html;
                this.html = null;
                this.browser.setUrl(this.url);
                this.browser.setText("");
            } else {
                this.html = html;
                this.url = null;
                this.browser.setUrl("");
                this.browser.setText(this.html);
            }
        }
    }

    public final void setHtml(String html) {
        this.html = html;
    }

    class AdvancedCloseWindowListener
    implements CloseWindowListener {
        AdvancedCloseWindowListener() {
        }

        public void close(WindowEvent event) {
            ((Browser)event.widget).getShell().close();
        }
    }

    private class AdvancedLocationListener
    implements LocationListener {
        public void changing(LocationEvent event) {
            AdvancedBrowser.this.html = event.location.replace("%20", " ").replaceAll("file:///", "");
            if (!AdvancedBrowser.this.html.equals("about:blank")) {
                AdvancedBrowser.this.onOk();
            }
        }

        public void changed(LocationEvent event) {
        }
    }
}

