/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DText;
import ca.infodata.ofys.client.modules.template.TypeDeDonnee;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.SimpleNumberText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.util1.StringUtils;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DTextDialog
extends MyMessageDialogBuilder {
    private static String REQUIRED_DATA = Messages.getString((String)"REQUIRED_DATA", (String[])new String[0]);
    private DText field;
    private MyMaskedText txtText;
    private SimpleNumberText txtMax;
    private SimpleNumberText txtWidth;
    private SimpleNumberText txtHeight;
    private MyCombo<TypeDeDonnee> cmbTypeDeDonnee = null;
    private MyButton chkWrap;
    private MyButton chkRequired;
    private final XCompletionProposalType type;

    public DTextDialog(Shell shell, DText field, XCompletionProposalType xType) {
        this.field = field;
        this.type = xType;
        this.setButtonLabels(Messages.getString((String)"OK", (String[])new String[0]), Messages.getString((String)"CANCEL", (String[])new String[0]));
        this.setDefaultButton(-1);
        this.setParent(shell);
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        parent = new Composite(parent, 0);
        RowLayout layout = new RowLayout(512);
        layout.fill = true;
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        new MyLabel(parent, "Nom : ", 16384);
        this.txtText = new MyMaskedText(parent, Pattern.compile(DField.regExpForName));
        this.txtText.setValidStyle(6);
        new MyLabel(parent, "Longueur maximum (optionnel) ", 16384);
        this.txtMax = new SimpleNumberText(parent, 2048);
        this.txtMax.getMask().setAllowNegative(false);
        new MyLabel(parent, "Largeur du contr\u00f4le (optionnel) ", 16384);
        this.txtWidth = new SimpleNumberText(parent, 2048);
        this.txtWidth.getMask().setAllowNegative(false);
        new MyLabel(parent, "Hauteur du contr\u00f4le (optionnel) ", 16384);
        this.txtHeight = new SimpleNumberText(parent, 2048);
        this.txtHeight.getMask().setAllowNegative(false);
        if (XCompletionProposalType.ENCOUNTER_NOTE.equals((Object)this.type)) {
            new MyLabel(parent, "Type de donn\u00e9es :", 16384);
            this.cmbTypeDeDonnee = new MyCombo(parent, 8);
            this.cmbTypeDeDonnee.setItems((TypeDeDonnee[])TypeDeDonnee.values());
        }
        this.chkWrap = new MyButton(parent, "Permettre le saut de lignes", 32, null);
        this.chkRequired = new MyButton(parent, REQUIRED_DATA, 32, null);
        this.setTitle("Texte");
        this.txtText.setText(StringUtils.defaultString((String)this.field.name));
        this.txtMax.setNumber(this.field.maxLen);
        this.txtWidth.setNumber(this.field.width);
        this.txtHeight.setNumber(this.field.height);
        if (this.cmbTypeDeDonnee != null) {
            if (this.field.typeDeDonnee != null) {
                this.cmbTypeDeDonnee.select(this.field.typeDeDonnee);
            } else {
                this.cmbTypeDeDonnee.select(TypeDeDonnee.S_O);
            }
        }
        this.chkWrap.setSelection(this.field.wrap == null ? false : this.field.wrap);
        this.chkRequired.setSelection(this.field.required);
        return parent;
    }

    @Override
    protected boolean customShouldTakeFocus() {
        return true;
    }

    @Override
    protected boolean buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.txtText.getText().trim();
            if (StringUtils.isBlank((CharSequence)name)) {
                return false;
            }
            this.field.name = name;
            this.field.maxLen = this.txtMax.getNumber();
            this.field.height = this.txtHeight.getNumber();
            this.field.width = this.txtWidth.getNumber();
            this.field.typeDeDonnee = this.cmbTypeDeDonnee == null ? TypeDeDonnee.S_O : this.cmbTypeDeDonnee.getSelection();
            this.field.wrap = new Boolean(this.chkWrap.getSelection());
            this.field.required = new Boolean(this.chkRequired.getSelection());
        }
        return true;
    }
}

