/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.grid;

import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.CellRenderer;
import java.util.HashMap;
import java.util.Map;

public class CellRendererFactory {
    private Map<String, CellRenderer<?, ?>> renderers = new HashMap();
    private boolean isDisposed;

    public CellRenderer<?, ?> getCellRenderer(Cell cell) {
        this.checkIfNotDisposed();
        return this.renderers.get(cell.getType());
    }

    public CellRenderer<?, ?> getCellRenderer(String type) {
        this.checkIfNotDisposed();
        return this.renderers.get(type);
    }

    public void registerCellRenderer(String cellType, CellRenderer<?, ?> renderer) {
        this.checkIfNotDisposed();
        assert (cellType != null && renderer != null);
        if (this.renderers.containsKey(cellType)) {
            throw new IllegalArgumentException("cellType " + cellType + " is already registered");
        }
        this.renderers.put(cellType, renderer);
    }

    public void unregisterCellRenderer(String cellType) {
        this.checkIfNotDisposed();
        this.renderers.remove(cellType);
    }

    public void dispose() {
        this.checkIfNotDisposed();
        this.renderers.clear();
        this.renderers = null;
        this.isDisposed = true;
    }

    private void checkIfNotDisposed() {
        if (this.isDisposed) {
            throw new IllegalStateException("factory is disposed");
        }
    }
}

