/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo;

import ca.infodata.ofys.ui.controls.FontAwareCombo;
import ca.infodata.ofys.ui.controls.ICombo;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MyCombo<E>
implements IControl,
ICombo<E> {
    private static final Logger logger = Logger.getLogger(MyCombo.class.getName());
    public static final int CREAD_ONLY = 4096;
    public static final int CSO = 8192;
    public static final int CNULL = 65536;
    private final Listener lastModifyListener = new Listener(){

        public void handleEvent(Event e) {
            MyCombo.this.isEventFromKey = false;
            MyCombo.this.externModifyTextDoit = true;
            MyCombo.this.internModifyTextDoit = true;
        }
    };
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MyCombo.this.doAutoComplete(e);
        }
    };
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            MyCombo.this.caretPosition = ++MyCombo.this.myCombo.getSelection().x;
            if (e.character == '\b') {
                MyCombo myCombo = MyCombo.this;
                myCombo.caretPosition = myCombo.caretPosition - 1;
            }
            MyCombo.this.carac = e.character;
        }
    };
    protected final FontAwareCombo myCombo;
    private final ArrayList<E> myItems;
    private ProviderAR<E, String> labelProvider;
    private PredicateA<E> displayPredicate;
    private final Map<Integer, Integer> itemIndexMapDisplayIndex;
    private int selectionIndex;
    private E defaultSelection;
    private boolean autoComplete;
    private String[] searchItems;
    private int caretPosition;
    private char carac;
    private boolean externModifyTextDoit = true;
    private boolean internModifyTextDoit = true;
    private final List<ListenerProxy> listeners = new ArrayList<ListenerProxy>();
    private final boolean isCReadOnly;
    private final boolean isReadOnly;
    private boolean ignoreVerify;
    private boolean selectionByMouse;
    private boolean selectionByKeyboard;
    private boolean selectionBySetText;
    private final FormToolkit toolkit;
    private boolean isEventFromKey;
    private PredicateA<E> wrappedSearhPredicate;
    private PredicateA<E> search_oldDisplayPredicate;
    private SearchPredicate<E> searchPredicate;
    private boolean search_fromSelection;
    private boolean search_modifyFromMe;
    private boolean search_featureInitialized;
    private Listener search_mouseListener;
    private Listener search_keyListener;
    private Listener search_modifyListener;
    private int search_oldVisibleItemCount;
    private Cursor mouseCursor;

    public MyCombo(Composite parent, int style) {
        this(parent, style, null);
    }

    public MyCombo(Composite parent, int style, FormToolkit formToolkit) {
        this.isCReadOnly = (style | 0x1000) == style;
        this.isReadOnly = (style | 8 | 0xFFFFFFFF) == style;
        this.myItems = new ArrayList();
        this.searchItems = new String[0];
        this.defaultSelection = null;
        this.selectionIndex = -1;
        this.myCombo = new FontAwareCombo(parent, style);
        this.autoComplete = false;
        this.itemIndexMapDisplayIndex = new HashMap<Integer, Integer>();
        this.myCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MyCombo.this.dispose();
            }
        });
        this.myCombo.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (MyCombo.this.ignoreVerify) {
                    MyCombo.this.ignoreVerify = false;
                    return;
                }
                MyCombo.this.verifyEvent(e);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 11: {
                        MyCombo.this.ignoreVerify = true;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 37: {
                        MyCombo.this.selectionByMouse = true;
                        MyCombo.this.selectionBySetText = false;
                        MyCombo.this.selectionByKeyboard = false;
                        break;
                    }
                    case 1: {
                        MyCombo.this.isEventFromKey = true;
                        MyCombo.this.selectionByMouse = false;
                        MyCombo.this.selectionBySetText = false;
                        MyCombo.this.selectionByKeyboard = true;
                    }
                }
            }
        };
        this.myCombo.addListener(11, listener);
        this.myCombo.addListener(5, listener);
        this.myCombo.addListener(3, listener);
        this.myCombo.addListener(37, listener);
        this.myCombo.addListener(1, listener);
        this.toolkit = formToolkit;
        if (this.toolkit != null) {
            this.toolkit.adapt((Composite)this.myCombo);
        }
        this.setVisibleItemCount(10);
    }

    private void verifyEvent(VerifyEvent e) {
        if (this.internModifyTextDoit) {
            this.selectionIndex = -1;
            if (this.selectionBySetText) {
                e.doit = true;
            } else if (this.selectionByKeyboard) {
                if (this.isCReadOnly) {
                    int index;
                    this.internModifyTextDoit = false;
                    this.externModifyTextDoit = false;
                    this.selectionIndex = index = this.partialIndexOf(String.valueOf(e.character), this.selectionIndex + 1);
                    if (this.selectionIndex != -1) {
                        this.myCombo.select(index);
                    }
                    this.internModifyTextDoit = false;
                    this.externModifyTextDoit = true;
                    this.notifyListeners(13, null);
                    this.internModifyTextDoit = false;
                    this.externModifyTextDoit = true;
                    this.notifyListeners(24, null);
                    this.internModifyTextDoit = true;
                    this.externModifyTextDoit = true;
                    e.doit = false;
                } else if (this.autoComplete) {
                    this.externModifyTextDoit = false;
                    e.doit = true;
                }
            } else {
                e.doit = this.selectionByMouse ? true : true;
            }
        }
    }

    private void doAutoComplete(ModifyEvent e) {
        if (this.autoComplete && this.internModifyTextDoit) {
            if (this.carac != '\u0000' && this.carac != '\u007f' && this.carac != '\b') {
                int index;
                this.selectionIndex = index = this.partialIndexOf(this.myCombo.getText(), 0);
                if (this.selectionIndex != -1) {
                    this.isEventFromKey = false;
                    this.internModifyTextDoit = false;
                    this.externModifyTextDoit = false;
                    this.myCombo.select(index);
                    this.myCombo.setSelection(new Point(this.caretPosition, this.myCombo.getText().length()));
                }
            } else {
                this.selectionIndex = -1;
            }
            this.internModifyTextDoit = false;
            this.externModifyTextDoit = true;
            this.notifyListeners(24, null);
            this.internModifyTextDoit = false;
            this.externModifyTextDoit = true;
            this.notifyListeners(13, null);
            this.internModifyTextDoit = false;
            this.externModifyTextDoit = false;
        }
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean enable) {
        if (enable && this.isReadOnly) {
            logger.log(Level.WARNING, "AutoComplete is incompatible with system readonly mode, use CREADONLY instead");
        }
        if (enable && this.searchPredicate != null) {
            logger.log(Level.WARNING, "AutoComplete is incompatible with Search Predicate");
        }
        if (!this.isReadOnly && this.autoComplete != enable) {
            this.autoComplete = enable;
            if (this.autoComplete) {
                this.myCombo.addModifyListener(this.modifyListener);
                this.myCombo.addKeyListener((KeyListener)this.keyAdapter);
            } else {
                this.myCombo.removeModifyListener(this.modifyListener);
                this.myCombo.removeKeyListener((KeyListener)this.keyAdapter);
            }
            this.myCombo.removeListener(24, this.lastModifyListener);
            this.myCombo.addListener(24, this.lastModifyListener);
        }
    }

    public void setSearchPredicate(SearchPredicate<E> predicate) {
        if (predicate != null && this.isReadOnly) {
            logger.log(Level.WARNING, "Search Predicate is incompatible with system readonly mode, use CREADONLY instead");
        }
        if (predicate != null && this.autoComplete) {
            logger.log(Level.WARNING, "Search Predicate is incompatible with AutoComplete");
        }
        if (!this.isReadOnly && this.searchPredicate != predicate) {
            if (predicate == null) {
                this.removeListener(5, this.search_mouseListener);
                this.removeListener(1, this.search_keyListener);
                this.removeListener(24, this.search_modifyListener);
            } else if (this.searchPredicate == null) {
                this.initializeSearchFeature();
                this.addListener(5, this.search_mouseListener);
                this.addListener(1, this.search_keyListener);
                this.addListener(24, this.search_modifyListener);
            }
            this.searchPredicate = predicate;
        }
    }

    public SearchPredicate<E> getSearchPredicate() {
        return this.searchPredicate;
    }

    private void initializeSearchFeature() {
        if (!this.search_featureInitialized) {
            this.wrappedSearhPredicate = new SearchPredicateWrapper();
            this.search_oldVisibleItemCount = this.myCombo.getVisibleItemCount();
            this.search_keyListener = new Listener(){

                public void handleEvent(Event e) {
                    MyCombo.this.search_modifyFromMe = false;
                    switch (e.keyCode) {
                        case 27: {
                            MyCombo.this.cancelSearch();
                            break;
                        }
                        case 13: {
                            MyCombo.this.finalizeSearch();
                            break;
                        }
                        case 0x1000001: 
                        case 0x1000002: {
                            MyCombo.this.search_fromSelection = true;
                            break;
                        }
                        default: {
                            MyCombo.this.search_fromSelection = false;
                        }
                    }
                }
            };
            this.search_mouseListener = new Listener(){

                public void handleEvent(Event e) {
                    MyCombo.this.search_modifyFromMe = false;
                    if (e.type == 5) {
                        MyCombo.this.mouseCursor = MyCombo.this.myCombo.getCursor();
                        MyCombo.this.search_fromSelection = true;
                    }
                }
            };
            this.search_modifyListener = new Listener(){

                public void handleEvent(Event e) {
                    boolean doit;
                    boolean bl = doit = e.type == 24 && !MyCombo.this.search_modifyFromMe && !MyCombo.this.search_fromSelection && MyCombo.this.internModifyTextDoit && MyCombo.this.externModifyTextDoit;
                    if (doit) {
                        MyCombo.this.search();
                    }
                }
            };
            this.search_featureInitialized = true;
        }
    }

    public final void finalizeSearch() {
        this.isEventFromKey = false;
        this.search_fromSelection = true;
        this.search_modifyFromMe = true;
        this.internModifyTextDoit = false;
        if (this.myCombo.getListVisible()) {
            this.selectionIndex = this.fullIndexOf(this.myCombo.getText());
            this.myCombo.select(this.selectionIndex);
            this.notifyListeners(13, null);
            this.myCombo.setListVisible(false);
            this.unfilter();
            this.myCombo.select(this.fullIndexOf(this.myCombo.getText()));
        }
        this.internModifyTextDoit = true;
    }

    public final void cancelSearch() {
        this.search_modifyFromMe = true;
        this.internModifyTextDoit = false;
        this.myCombo.setListVisible(false);
        this.myCombo.deselectAll();
        this.unfilter();
        this.internModifyTextDoit = true;
    }

    public final void search() {
        this.search_modifyFromMe = true;
        if (this.filter()) {
            if (this.getDisplayItemCount() == 0) {
                this.unfilter();
                this.myCombo.setVisibleItemCount(this.search_oldVisibleItemCount);
                this.myCombo.setListVisible(false);
            } else {
                this.externModifyTextDoit = false;
                this.internModifyTextDoit = false;
                String text = this.myCombo.getText();
                Point selection = this.myCombo.getSelection();
                this.myCombo.setVisibleItemCount(this.search_oldVisibleItemCount);
                this.myCombo.setListVisible(true);
                this.myCombo.setCursor(this.mouseCursor);
                this.internal_setText(text);
                this.myCombo.setSelection(selection);
                this.internModifyTextDoit = true;
                this.externModifyTextDoit = true;
            }
        } else {
            this.unfilter();
            this.myCombo.setVisibleItemCount(this.search_oldVisibleItemCount);
        }
    }

    private boolean filter() {
        if (this.searchPredicate != null && this.searchPredicate.doit(this.getText())) {
            if (this.getDisplayPredicate() != this.wrappedSearhPredicate) {
                this.search_oldDisplayPredicate = this.getDisplayPredicate();
                this.setDisplayPredicate(this.wrappedSearhPredicate);
            }
            this.refresh();
            return true;
        }
        return false;
    }

    private void unfilter() {
        if (this.getSearchPredicate() != null && this.searchPredicate.doit(this.getText())) {
            this.setDisplayPredicate(this.search_oldDisplayPredicate);
            this.refresh();
        }
    }

    private int partialIndexOf(String text, int offset) {
        offset = offset < 0 ? 0 : offset;
        text = text.toUpperCase();
        int i = offset;
        while (i < this.searchItems.length) {
            if (this.searchItems[i].startsWith(text)) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (i < this.searchItems.length) {
            if (this.searchItems[i].startsWith(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int fullIndexOf(String text) {
        text = text.toUpperCase();
        int i = 0;
        while (i < this.searchItems.length) {
            if (this.searchItems[i].equals(text)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public PredicateA<E> getDisplayPredicate() {
        return this.displayPredicate;
    }

    public void setDisplayPredicate(PredicateA<E> displayPredicate) {
        if (this.isReadOnly) {
            logger.log(Level.WARNING, "DisplayPredicate is incompatible with system readonly mode, use CREADONLY instead");
        }
        this.displayPredicate = displayPredicate;
    }

    private boolean displayable(E e) {
        return this.displayPredicate == null || this.displayPredicate.evaluate(e);
    }

    public void setDefaultSelection(E defaultSelection) throws IllegalArgumentException {
        if (!this.identityContains(defaultSelection)) {
            throw new IllegalArgumentException("items must identity contains defaultSelection. arg=" + defaultSelection + ". " + this.toString());
        }
        this.defaultSelection = defaultSelection;
        if (this.getSelection() == null) {
            this.select(defaultSelection);
        }
    }

    private boolean identityContains(E e) {
        boolean identityContains = false;
        for (E item : this.myItems) {
            if (item != e) continue;
            identityContains = true;
            break;
        }
        return identityContains;
    }

    public E getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setLabelProvider(ProviderAR<E, String> labelProvider) {
        if (this.labelProvider != labelProvider) {
            this.labelProvider = labelProvider;
        }
    }

    public String getStringForItem(E item) {
        if (this.labelProvider != null) {
            return (String)this.labelProvider.get(item);
        }
        return item == null ? "" : String.valueOf(item);
    }

    public void addListener(int eventType, Listener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ListenerProxy proxy = new ListenerProxy(listener);
        this.listeners.add(proxy);
        this.myCombo.addListener(eventType, proxy);
        if (this.autoComplete) {
            this.myCombo.removeListener(24, this.lastModifyListener);
            this.myCombo.addListener(24, this.lastModifyListener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Iterator<ListenerProxy> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListenerProxy proxy = iterator.next();
            if (!proxy.listener.equals(listener)) continue;
            this.myCombo.removeListener(eventType, proxy);
            iterator.remove();
        }
    }

    public Object getData() {
        return this.myCombo.getData();
    }

    public Object getData(String key) {
        return this.myCombo.getData(key);
    }

    public int getItemCount() {
        return this.myItems.size();
    }

    protected List<E> internal_getItems() {
        return this.myItems;
    }

    public Collection<E> getItems() {
        return this.myItems == null ? null : CollectionUtils.unmodifiableCollection(this.myItems);
    }

    public int getDisplayItemCount() {
        return this.myCombo.getItemCount();
    }

    public String getText() {
        return this.myCombo.getText();
    }

    public boolean getVisible() {
        return this.myCombo.getVisible();
    }

    public void notifyListeners(int eventType, Event event) {
        this.myCombo.notifyListeners(eventType, event);
    }

    public void selectNone() {
        this.internModifyTextDoit = false;
        this.myCombo.deselectAll();
        this.selectionIndex = -1;
        this.internModifyTextDoit = true;
        this.notifyListeners(13, null);
    }

    public void clearTextSelection() {
        this.myCombo.clearSelection();
    }

    public final void setTextNoNotify(String text) {
        if (text == null) {
            text = "";
        }
        this.isEventFromKey = false;
        this.internModifyTextDoit = false;
        this.externModifyTextDoit = false;
        int fullIndexOf = this.fullIndexOf(text);
        if (fullIndexOf != -1) {
            this.myCombo.select(fullIndexOf);
        } else {
            this.internal_setText(text);
        }
        this.internModifyTextDoit = true;
        this.externModifyTextDoit = true;
    }

    public final void selectNoNotify(E item) {
        this.isEventFromKey = false;
        this.internModifyTextDoit = false;
        this.externModifyTextDoit = false;
        this.selectionIndex = this.myItems.indexOf(item);
        if (this.selectionIndex == -1) {
            if (this.defaultSelection != null) {
                this.select(this.defaultSelection);
            } else {
                this.myCombo.deselectAll();
            }
        } else {
            Integer displayIndex = this.itemIndexMapDisplayIndex.get(this.selectionIndex);
            displayIndex = displayIndex == null ? -1 : displayIndex;
            if (displayIndex == -1) {
                int selectionIndex2 = this.selectionIndex;
                this.myCombo.deselectAll();
                this.isEventFromKey = false;
                this.internModifyTextDoit = false;
                this.externModifyTextDoit = false;
                this.internal_setText(this.getStringForItem(item));
                this.selectionIndex = selectionIndex2;
            } else {
                this.myCombo.select(displayIndex);
            }
        }
        this.internModifyTextDoit = true;
        this.externModifyTextDoit = true;
    }

    public void trySelect(E item) {
        if (this.contains(item)) {
            this.select(item);
        }
    }

    public void forceSelect(E item) {
        if (this.contains(item)) {
            this.select(item);
        } else {
            this.add(item);
            this.select(item);
        }
    }

    public void forceSelect(E item, boolean keepSelection) {
        Point selection = this.myCombo.getSelection();
        if (this.contains(item)) {
            this.select(item);
        } else {
            this.add(item);
            this.select(item);
        }
        if (keepSelection) {
            this.myCombo.setSelection(selection);
        }
    }

    public void forceSelectNoNotify(E item, boolean keepSelection) {
        Point selection = this.myCombo.getSelection();
        if (this.contains(item)) {
            this.selectNoNotify(item);
        } else {
            this.add(item);
            this.selectNoNotify(item);
        }
        if (keepSelection) {
            this.myCombo.setSelection(selection);
        }
    }

    public void selectOrSetText(E item) {
        if (this.contains(item)) {
            this.select(item);
        } else {
            this.setText(this.getStringForItem(item));
        }
    }

    public void update(E e) {
        if (this.contains(e) && this.displayable(e)) {
            String text = this.getStringForItem(e);
            Integer displayIndex = this.itemIndexMapDisplayIndex.get(this.myItems.indexOf(e));
            if (displayIndex != null && displayIndex != -1) {
                this.searchItems[displayIndex.intValue()] = text.toUpperCase();
                this.myCombo.setItem(displayIndex, text);
            }
        }
    }

    public void select(E item) {
        this.isEventFromKey = false;
        this.internModifyTextDoit = false;
        this.selectionIndex = this.myItems.indexOf(item);
        if (this.selectionIndex == -1) {
            if (item != null && logger.isLoggable(Level.INFO)) {
                String logMyItems;
                String logItem;
                try {
                    logItem = item.toString();
                }
                catch (Exception exception) {
                    logItem = "failed_to_print_item";
                }
                try {
                    logMyItems = this.myItems.toString();
                }
                catch (Exception exception) {
                    logMyItems = "failed_to_print_myItems";
                }
                logger.info(String.valueOf(this.getClass().getName()) + ".select() item not in list. item=" + logItem + "\n\nmyItems=" + logMyItems + "\n\n" + Log.getPrintedStackTrace());
            }
            if (this.defaultSelection != null) {
                this.select(this.defaultSelection);
            } else {
                this.myCombo.deselectAll();
            }
        } else {
            Integer displayIndex = this.itemIndexMapDisplayIndex.get(this.selectionIndex);
            displayIndex = displayIndex == null ? -1 : displayIndex;
            if (displayIndex == -1) {
                String oldText = this.myCombo.getText();
                String newtext = this.getStringForItem(item);
                int selectionIndex2 = this.selectionIndex;
                this.externModifyTextDoit = false;
                this.myCombo.deselectAll();
                if (oldText.equals(newtext)) {
                    this.internal_setText(newtext);
                    this.selectionIndex = selectionIndex2;
                    this.externModifyTextDoit = true;
                } else {
                    this.internal_setText(newtext);
                    this.selectionIndex = selectionIndex2;
                    this.externModifyTextDoit = true;
                }
            } else {
                this.externModifyTextDoit = false;
                this.myCombo.select(displayIndex);
                this.externModifyTextDoit = true;
            }
        }
        this.internModifyTextDoit = false;
        this.notifyListeners(24, null);
        this.internModifyTextDoit = true;
        this.notifyListeners(13, null);
    }

    public E getSelection() {
        int displayIndex = this.myCombo.getSelectionIndex();
        if (displayIndex == -1) {
            displayIndex = this.fullIndexOf(this.myCombo.getText());
        }
        if (displayIndex != -1) {
            for (Map.Entry<Integer, Integer> entry : this.itemIndexMapDisplayIndex.entrySet()) {
                if (entry.getValue() != displayIndex) continue;
                this.selectionIndex = entry.getKey();
                return this.myItems.get(this.selectionIndex);
            }
        }
        if (this.selectionIndex == -1) {
            return null;
        }
        return this.myItems.get(this.selectionIndex);
    }

    public void setData(Object obj) {
        this.myCombo.setData(obj);
    }

    public void setData(String key, Object obj) {
        this.myCombo.setData(key, obj);
    }

    public boolean setFocus() {
        return this.myCombo.setFocus();
    }

    public void setItemsWithNull(Collection<E> items) {
        if (items == null) {
            this.setItems((Collection<E>)null);
        } else {
            ArrayList<E> list = new ArrayList<E>(items.size());
            list.add(null);
            for (E e : items) {
                list.add(e);
            }
            this.setItems(list);
        }
    }

    public void setItemsWithNull(E[] items) {
        if (items == null) {
            this.setItems((Collection<E>)null);
        } else {
            ArrayList<E> list = new ArrayList<E>(items.length);
            list.add(null);
            int i = 0;
            while (i < items.length) {
                list.add(items[i]);
                ++i;
            }
            this.setItems(list);
        }
    }

    public void setItems(E[] items) {
        if (items == null) {
            this.setItems((Collection<E>)null);
        } else {
            ArrayList<E> list = new ArrayList<E>(items.length);
            int i = 0;
            while (i < items.length) {
                list.add(items[i]);
                ++i;
            }
            this.setItems(list);
        }
    }

    public void refresh() {
        this.internal_setItems(this.myItems, true, false);
    }

    public void setItems(Collection<E> col) {
        this.internal_setItems(col, false, false);
    }

    private void internal_setItems(Collection<E> col, boolean keepTextAndSelection, boolean force) {
        if (col == null) {
            col = Collections.emptyList();
        }
        this.internModifyTextDoit = false;
        this.externModifyTextDoit = false;
        this.itemIndexMapDisplayIndex.clear();
        if (force || col != this.myItems) {
            this.myItems.clear();
            this.myItems.addAll(col);
            if (!this.myItems.contains(this.defaultSelection)) {
                this.defaultSelection = null;
            }
        }
        String text = this.myCombo.getText();
        Point selection = this.myCombo.getSelection();
        this.myCombo.removeAll();
        if (keepTextAndSelection) {
            this.internal_setText(text);
            this.myCombo.setSelection(selection);
        }
        this.internModifyTextDoit = false;
        this.externModifyTextDoit = false;
        ArrayList<String> searchList = new ArrayList<String>(this.myItems.size());
        ArrayList<String> comboList = new ArrayList<String>(this.myItems.size());
        int i = 0;
        while (i < this.myItems.size()) {
            E e = this.myItems.get(i);
            if (this.displayable(e)) {
                this.itemIndexMapDisplayIndex.put(i, comboList.size());
                String name = this.getStringForItem(e);
                comboList.add(name);
                searchList.add(name.toUpperCase());
            } else {
                this.itemIndexMapDisplayIndex.put(i, -1);
            }
            ++i;
        }
        this.searchItems = new String[searchList.size()];
        searchList.toArray(this.searchItems);
        String[] comboItems = new String[comboList.size()];
        comboList.toArray(comboItems);
        this.myCombo.setItems(comboItems);
        if (keepTextAndSelection) {
            this.internal_setText(text);
            this.myCombo.setSelection(selection);
        }
        this.internModifyTextDoit = true;
        this.externModifyTextDoit = true;
    }

    public void add(E e) {
        int index = this.myItems.size();
        this.myItems.add(e);
        if (this.displayable(e)) {
            this.itemIndexMapDisplayIndex.put(index, this.myCombo.getItemCount());
            String name = this.getStringForItem(e);
            this.myCombo.add(name);
            if (this.searchItems == null) {
                this.searchItems = new String[1];
                this.searchItems[0] = name.toUpperCase();
            } else {
                String[] newSearchItems = new String[this.searchItems.length + 1];
                System.arraycopy(this.searchItems, 0, newSearchItems, 0, this.searchItems.length);
                this.searchItems = newSearchItems;
                this.searchItems[this.searchItems.length - 1] = name.toUpperCase();
            }
        } else {
            this.itemIndexMapDisplayIndex.put(index, -1);
        }
    }

    public void remove(E e) {
        if (this.defaultSelection != null && this.defaultSelection.equals(e)) {
            this.defaultSelection = null;
        }
        int index = this.myItems.indexOf(e);
        this.myItems.remove(index);
        Integer displayIndex = this.itemIndexMapDisplayIndex.get(index);
        this.itemIndexMapDisplayIndex.remove(index);
        if (displayIndex != null && displayIndex != -1) {
            this.myCombo.remove(displayIndex);
        }
    }

    protected final void removeAllNoNotify() {
        this.internModifyTextDoit = false;
        this.externModifyTextDoit = false;
        this.removeAll();
        this.internModifyTextDoit = true;
        this.externModifyTextDoit = true;
    }

    public void removeAll() {
        this.myItems.clear();
        this.defaultSelection = null;
        this.selectionIndex = -1;
        this.itemIndexMapDisplayIndex.clear();
        this.myCombo.removeAll();
    }

    public void setText(String text) {
        int fullIndexOf;
        this.isEventFromKey = false;
        if (text == null) {
            text = "";
        }
        if ((fullIndexOf = this.fullIndexOf(text)) != -1) {
            this.myCombo.select(fullIndexOf);
        } else {
            this.internal_setText(text);
            this.internModifyTextDoit = true;
            this.externModifyTextDoit = true;
            this.notifyListeners(24, null);
        }
    }

    private void internal_setText(String text) {
        this.isEventFromKey = false;
        this.selectionBySetText = true;
        this.myCombo.setText(text);
        this.selectionBySetText = false;
    }

    public void setVisible(boolean visible) {
        this.myCombo.setVisible(visible);
    }

    public Combo getControl() {
        return this.myCombo;
    }

    public void setTextLimit(int limit) {
        this.myCombo.setTextLimit(limit);
    }

    public void setVisibleItemCount(int count) {
        this.search_oldVisibleItemCount = count;
        this.myCombo.setVisibleItemCount(count);
    }

    public boolean getEnabled() {
        return this.myCombo.getEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.toolkit != null) {
            if (enabled) {
                this.myCombo.setBackground(this.toolkit.getColors().getBackground());
            } else {
                this.myCombo.setBackground(this.toolkit.getColors().getColor("DISABLED_BACKGROUND_COLOR"));
            }
        }
        this.myCombo.setEnabled(enabled);
    }

    private void dispose() {
        this.myItems.clear();
        this.listeners.clear();
        this.searchItems = null;
        this.defaultSelection = null;
        this.labelProvider = null;
    }

    public boolean contains(E e) {
        return this.myItems.contains(e);
    }

    public boolean isFirstItem(E e) {
        return this.myItems.indexOf(e) == 0;
    }

    public boolean maybeVisible(E e) {
        return this.contains(e) && this.displayable(e);
    }

    public boolean isEventFromKey() {
        return this.isEventFromKey;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.myCombo.addDisposeListener(listener);
    }

    public String toString() {
        return String.format("MyCombo [myItems=%s, itemIndexMapDisplayIndex=%s, selectionIndex=%s, defaultSelection=%s, externModifyTextDoit=%s, internModifyTextDoit=%s, isCReadOnly=%s, isReadOnly=%s]", this.myItems, this.itemIndexMapDisplayIndex, this.selectionIndex, this.defaultSelection, this.externModifyTextDoit, this.internModifyTextDoit, this.isCReadOnly, this.isReadOnly);
    }

    public void setLayoutData(FormData data) {
        this.myCombo.setLayoutData(data);
    }

    @Override
    public MyCombo<?> getMyCombo() {
        return this;
    }

    @Override
    public E getMyComboSelection() {
        return this.getSelection();
    }

    @Override
    public void setMyComboSelect(Object e) {
        if (e instanceof String) {
            this.setText((String)e);
        } else {
            this.select(e);
        }
    }

    private class ListenerProxy
    implements Listener {
        private Listener listener;

        private ListenerProxy(Listener listener) {
            this.listener = listener;
        }

        public void handleEvent(Event e) {
            if (MyCombo.this.externModifyTextDoit) {
                this.listener.handleEvent(e);
            }
        }
    }

    public static interface SearchPredicate<T> {
        public boolean doit(String var1);

        public boolean evaluate(String var1, T var2);
    }

    private class SearchPredicateWrapper
    implements PredicateA<E> {
        private SearchPredicateWrapper() {
        }

        public boolean evaluate(E object) {
            return MyCombo.this.searchPredicate.evaluate(MyCombo.this.myCombo.getText(), object);
        }
    }
}

