/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.form.FirstItemISearchTextListenerFilter;
import ca.infodata.ofys.ui.controls.form.IReferenceControl;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.ISearchTextListenerFilter;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.plugins.searchview.SearchItem;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MySearchText
extends Composite
implements IReferenceControl,
IControl {
    public static final int CHIDE_TEXTCONTROL = 4096;
    public static final int CHIDE_LABELCONTROL = 8192;
    public static final int CBELOW_LABELCONTROL = 16384;
    public static final int NO_DEFAULT_CR_LISTENER = 32768;
    public static final int CSHOW_OPENUTTON = 65536;
    public static final int SKIP_BUTTONS_ON_TAB = 131072;
    public static final int SPECIAL_CASE_RETURN_ALL = 1;
    private static final Logger logger = Logger.getLogger(MySearchText.class.getName());
    private final MyLabel myLabel;
    private final MyMaskedText myText;
    private final MyButton btnSearch;
    private final MyButton btnRemove;
    private final MyButton btnOpen;
    private int group;
    private ArrayList<ISearchTextListener> lstSearchListener = new ArrayList();
    private ISearchTextListenerFilter searchListenerFilter = new FirstItemISearchTextListenerFilter();
    private ProviderAR<IDataObject, String> labelProvider;
    private ProviderAR<IDataObject, String> textProvider;
    private ISearchTextAccessor searchTextAccessor;
    private int specialCase = -1;
    private boolean doSearch = true;
    protected boolean isDoSearching;
    private String oldText;
    private IDataObject dataObject;
    private FocusAdapter searchOnFocusLostListener;
    private boolean searchOnFocusLost;
    private boolean searchOnTab;
    private boolean hideText;
    private boolean hideLabel;
    private boolean belowLabel;
    private boolean showOpenButton;
    private boolean noDefaultCrListener;
    private boolean skipButtonsOnTab;
    private IReferenceControl referenceControl;
    private String labelEmptyString = "                                             ";
    private boolean forwardNullToLabelAndTextProvider;
    private boolean deleteCallback;

    public MySearchText(Composite parent, int style, FormToolkit toolkit) {
        this(parent, style, toolkit, null);
    }

    public MySearchText(Composite parent, int style, FormToolkit toolkit, String message) {
        super(parent, style);
        this.hideText = (style | 0x1000) == style;
        this.hideLabel = (style | 0x2000) == style;
        this.belowLabel = (style | 0x4000) == style;
        this.showOpenButton = (style | 0x10000) == style;
        this.noDefaultCrListener = UI.containsStyle((int)32768, (int)style);
        this.skipButtonsOnTab = UI.containsStyle((int)131072, (int)style);
        this.group = System.identityHashCode(this);
        this.myText = new MyMaskedText(this, 18436, toolkit);
        if (UI.OS_CARBON) {
            this.btnSearch = new MyButton(this, 0x800008);
            this.btnRemove = new MyButton(this, 0x800008);
            this.btnOpen = new MyButton(this, 0x800008);
        } else {
            this.btnSearch = new MyButton(this, 8);
            this.btnRemove = new MyButton(this, 8);
            this.btnOpen = new MyButton(this, 8);
        }
        this.btnOpen.setVisible(this.showOpenButton);
        this.btnOpen.setToolTipText(Messages.getString((String)"OUVRIR", (String[])new String[0]));
        if (message != null) {
            this.myText.setMessage(message);
        }
        Image search = ResourceGetter.getImage((String)"images/rechercher.gif");
        ResourceGetter.linkResourceWithWidgetLife((Object)search, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)search, (Widget)parent);
        this.btnSearch.setImage(search);
        Image remove = ResourceGetter.getImage((String)"images/delete_edit.gif");
        ResourceGetter.linkResourceWithWidgetLife((Object)remove, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)remove, (Widget)parent);
        this.btnRemove.setImage(remove);
        Image open = ResourceGetter.getImage((String)"images/info.gif");
        ResourceGetter.linkResourceWithWidgetLife((Object)open, (Widget)parent);
        ResourceGetter.linkResourceWithWidgetLife((Object)open, (Widget)parent);
        this.btnOpen.setImage(open);
        int labelStyle = 0;
        if (this.belowLabel) {
            labelStyle = 64;
        }
        this.myLabel = new MyLabel(this, this.labelEmptyString, labelStyle, toolkit);
        this.referenceControl = this;
        if (toolkit != null) {
            toolkit.adapt((Composite)this);
        }
        this.initialize(this.hideText, this.hideLabel);
    }

    private void initialize(boolean hideText, boolean hideLabel) {
        this.myText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    try {
                        MySearchText.this.deleteCallback = true;
                        MySearchText.this.callback(null);
                    }
                    finally {
                        MySearchText.this.deleteCallback = false;
                    }
                }
            }
        });
        this.myText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                    if (MySearchText.this.searchOnTab && MySearchText.this.doSearch) {
                        MySearchText.this.doSearch();
                    }
                }
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MySearchText.this.deleteCallback = true;
                    MySearchText.this.callback(null);
                }
                finally {
                    MySearchText.this.deleteCallback = false;
                }
            }
        });
        this.myText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MySearchText.this.myText.getRawText().equals(MySearchText.this.oldText)) {
                    MySearchText.this.oldText = MySearchText.this.myText.getRawText();
                    MySearchText.this.doSearch = true;
                }
            }
        });
        if (!this.noDefaultCrListener) {
            this.myText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (UI.CR((KeyEvent)e)) {
                        MySearchText.this.getBtnSearch().notifyListeners(13, new Event());
                    }
                }
            });
        }
        this.searchOnFocusLost = true;
        this.searchOnFocusLostListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (MySearchText.this.doSearch) {
                    MySearchText.this.doSearch();
                }
            }
        };
        this.myText.addFocusListener((FocusListener)this.searchOnFocusLostListener);
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MySearchText.this.myText.setFocus();
            }
        });
        this.layout2(hideText, hideLabel);
        if (hideText) {
            this.setTabList(new Control[]{this.btnSearch.getControl(), this.btnRemove.getControl()});
        } else if (this.skipButtonsOnTab) {
            this.setTabList(new Control[]{this.myText.getControl()});
        } else {
            this.setTabList(new Control[]{this.myText.getControl(), this.btnSearch.getControl(), this.btnRemove.getControl()});
        }
    }

    private void layout2(boolean hideText, boolean hideLabel) {
        Point btnRemoveSize = this.btnRemove.computeSize(-1, -1);
        Point btnSearchSize = this.btnSearch.computeSize(-1, -1);
        Point btnOpenSize = this.btnOpen.getVisible() ? this.btnOpen.computeSize(-1, -1) : new Point(0, 0);
        this.setLayout((Layout)new FormLayout());
        if (hideText) {
            this.myText.setVisible(false);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment(0, 0);
            this.btnSearch.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment(this.btnSearch.getControl(), 0);
            data.top = new FormAttachment(0, 0);
            this.btnRemove.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment(this.btnRemove.getControl(), 0);
            data.top = new FormAttachment(0, 0);
            if (!this.btnOpen.getVisible()) {
                data.width = 0;
            }
            this.btnOpen.setLayoutData(data);
            if (hideLabel) {
                this.myLabel.setVisible(false);
                data = new FormData();
                data.top = new FormAttachment(0);
                data.height = 0;
                data.width = 0;
                this.myLabel.setLayoutData(data);
            } else {
                data = new FormData();
                if (this.belowLabel) {
                    data.left = new FormAttachment(0);
                    data.top = new FormAttachment(this.btnSearch.getControl());
                } else {
                    data.left = new FormAttachment(this.btnRemove.getControl(), UI.OS_CARBON ? 0 : 5);
                    data.top = new FormAttachment(this.btnRemove.getControl(), 0, 0x1000000);
                }
                data.bottom = new FormAttachment(100);
                data.right = new FormAttachment(100);
                this.myLabel.setLayoutData(data);
            }
        } else {
            FormData data = new FormData();
            data.left = new FormAttachment(0);
            data.top = new FormAttachment(0);
            int buttonsWidth = -btnSearchSize.x - btnRemoveSize.x - btnOpenSize.x;
            data.right = hideLabel || this.belowLabel ? new FormAttachment(100, buttonsWidth) : new FormAttachment(40, buttonsWidth);
            this.myText.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment(this.myText.getControl(), 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(this.myText.getControl(), 0, 1024);
            this.btnSearch.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment(this.btnSearch.getControl(), 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(this.myText.getControl(), 0, 1024);
            this.btnRemove.setLayoutData(data);
            data = new FormData();
            data.left = new FormAttachment(this.btnRemove.getControl(), 0);
            data.top = new FormAttachment(0, 0);
            data.bottom = new FormAttachment(this.myText.getControl(), 0, 1024);
            if (!this.btnOpen.getVisible()) {
                data.width = 0;
            }
            this.btnOpen.setLayoutData(data);
            if (hideLabel) {
                this.myLabel.setVisible(false);
                data = new FormData();
                data.top = new FormAttachment(0);
                data.height = 0;
                data.width = 0;
                this.myLabel.setLayoutData(data);
            } else {
                data = new FormData();
                if (this.belowLabel) {
                    data.left = new FormAttachment(0);
                    data.top = new FormAttachment(this.btnSearch.getControl());
                } else {
                    data.left = new FormAttachment(this.btnRemove.getControl(), UI.OS_CARBON ? 0 : 5);
                    data.top = new FormAttachment(this.btnRemove.getControl(), 0, 0x1000000);
                }
                data.bottom = new FormAttachment(100);
                data.right = new FormAttachment(100);
                this.myLabel.setLayoutData(data);
            }
        }
    }

    public void removeSearchTextListener(ISearchTextListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.lstSearchListener.remove(listener);
    }

    public void addSearchTextListener(ISearchTextListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.lstSearchListener.add(listener);
    }

    public ISearchTextListenerFilter getSearchListenerFilter() {
        return this.searchListenerFilter;
    }

    public void setSearchListenerFilter(ISearchTextListenerFilter searchListenerFilter) {
        this.searchListenerFilter = searchListenerFilter;
    }

    public void setDataObjectKeepSelection(IDataObject dataObject) {
        this.dataObject = dataObject;
        String label = this.getLabelForDataObject(dataObject);
        this.myLabel.setText((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)label, (CharSequence)this.labelEmptyString));
        this.myLabel.setToolTipText(label);
        this.getParent().layout(new Control[]{this});
        this.myText.setRawTextKeepSelection(this.getTextForDataObject(dataObject));
        this.oldText = this.getLabelForDataObject(dataObject);
        this.doSearch = false;
    }

    public void setDataObjectId(Integer id) {
        if (id == null) {
            this.setDataObject(null);
            return;
        }
        if (this.searchTextAccessor == null) {
            throw new NullPointerException("searchTextAccessor");
        }
        JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

            public void responseReceived(final ReturnObject response) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MySearchText.this.referenceControl.callback(response.getObj());
                    }
                });
            }
        };
        this.searchTextAccessor.findFromId(this.group, Application.get().getGlobalInstances().getSession(), (ICallback)callback, id.intValue());
    }

    public void setDataObject(IDataObject dataObject) {
        this.dataObject = dataObject;
        String label = this.getLabelForDataObject(dataObject);
        this.myLabel.setText((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)label, (CharSequence)this.labelEmptyString));
        this.myLabel.setToolTipText(label);
        this.getParent().layout(new Control[]{this});
        this.myText.setRawText(this.getTextForDataObject(dataObject));
        this.oldText = this.getLabelForDataObject(dataObject);
        this.doSearch = false;
    }

    public IDataObject getDataObject() {
        return this.dataObject;
    }

    public Integer getDataObjectId() {
        return this.dataObject == null ? null : this.dataObject.getId();
    }

    private String getLabelForDataObject(IDataObject dataObject) {
        if (this.getLabelProvider() == null) {
            return dataObject == null ? "" : dataObject.toString();
        }
        if (dataObject == null && !this.forwardNullToLabelAndTextProvider) {
            return "";
        }
        return (String)this.getLabelProvider().get((Object)dataObject);
    }

    private String getTextForDataObject(IDataObject dataObject) {
        if (this.getTextProvider() == null) {
            return dataObject == null ? "" : dataObject.toString();
        }
        if (dataObject == null && !this.forwardNullToLabelAndTextProvider) {
            return "";
        }
        return (String)this.getTextProvider().get((Object)dataObject);
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.btnSearch.setEnabled(value);
        this.btnRemove.setEnabled(value);
        this.btnOpen.setEnabled(this.dataObject != null);
        this.myText.setEnabled(value);
    }

    public boolean setFocus() {
        if (this.myText.getVisible()) {
            return this.myText.setFocus();
        }
        if (this.btnSearch.getVisible()) {
            return this.btnSearch.setFocus();
        }
        return false;
    }

    public void setSpecialSearchCase(int specialCase) {
        this.specialCase = specialCase;
    }

    public int getSpecialSearchCase() {
        return this.specialCase;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(Object group) {
        this.group = System.identityHashCode(group);
    }

    public ProviderAR<IDataObject, String> getLabelProvider() {
        return this.labelProvider;
    }

    public void setLabelProvider(ProviderAR<IDataObject, String> labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ProviderAR<IDataObject, String> getTextProvider() {
        return this.textProvider;
    }

    public void setTextProvider(ProviderAR<IDataObject, String> textProvider) {
        this.textProvider = textProvider;
    }

    public ISearchTextAccessor getSearchTextAccessor() {
        return this.searchTextAccessor;
    }

    public void setSearchTextAccessor(ISearchTextAccessor searchTextAccessor) {
        this.searchTextAccessor = searchTextAccessor;
    }

    public MyLabel getMyLabel() {
        return this.myLabel;
    }

    public MyMaskedText getMyText() {
        return this.myText;
    }

    public MyButton getBtnSearch() {
        return this.btnSearch;
    }

    public MyButton getBtnRemove() {
        return this.btnRemove;
    }

    public MyButton getBtnOpen() {
        return this.btnOpen;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        return size;
    }

    @Override
    public void callback(Object o) {
        if (!this.isDisposed()) {
            if (o instanceof SearchItem) {
                o = ((SearchItem)o).getData();
            }
            IDataObject dataObject = null;
            if (o instanceof IDataObject[]) {
                List<IDataObject> c = Arrays.asList((IDataObject[])o);
                dataObject = this.searchListenerFilter.filter(c);
            } else if (o instanceof Collection) {
                dataObject = this.searchListenerFilter.filter((Collection)o);
            } else if (o instanceof IDataObject) {
                dataObject = (IDataObject)o;
            }
            this.setDataObject(dataObject);
            for (ISearchTextListener listener : this.lstSearchListener) {
                listener.objectReceived(dataObject);
            }
        }
    }

    public void setSearchOnFocusLost(boolean b) {
        if (b && !this.searchOnFocusLost) {
            this.myText.addFocusListener((FocusListener)this.searchOnFocusLostListener);
        } else if (!b || !this.searchOnFocusLost) {
            if (!b && this.searchOnFocusLost) {
                this.myText.removeFocusListener((FocusListener)this.searchOnFocusLostListener);
            } else if (!b) {
                // empty if block
            }
        }
        this.searchOnFocusLost = b;
    }

    public boolean doSearch() {
        if (this.searchTextAccessor == null) {
            logger.fine("search failed because searchTextAccessor is null");
            this.doSearch = false;
            return false;
        }
        String text = this.myText.getText();
        if (StringUtils.isNotBlank((String)text)) {
            this.isDoSearching = true;
            try {
                JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0])){

                    public void responseReceived(final ReturnObject response) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    MySearchText.this.referenceControl.callback(response.getObj());
                                }
                                finally {
                                    (this).MySearchText.this.isDoSearching = false;
                                }
                            }
                        });
                    }
                };
                this.searchTextAccessor.findFromSearchText(this.getGroup(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, this.specialCase, text);
            }
            catch (RuntimeException e) {
                this.isDoSearching = false;
                throw e;
            }
        }
        try {
            this.isDoSearching = true;
            this.deleteCallback = true;
            this.referenceControl.callback(null);
        }
        finally {
            this.isDoSearching = false;
            this.deleteCallback = false;
        }
        this.doSearch = false;
        return false;
        this.doSearch = false;
        return true;
    }

    @Override
    public Control getControl() {
        return this;
    }

    public void setText(String s) {
        this.getMyText().setText(s);
    }

    public IReferenceControl getReferenceControl() {
        return this.referenceControl;
    }

    public void setReferenceControl(IReferenceControl referenceControl) {
        this.referenceControl = referenceControl == null ? this : referenceControl;
    }

    public boolean isDeleteCallback() {
        return this.deleteCallback;
    }

    public boolean isSearchOnTab() {
        return this.searchOnTab;
    }

    public void setSearchOnTab(boolean searchOnTab) {
        this.searchOnTab = searchOnTab;
    }

    public boolean isDoSearching() {
        return this.isDoSearching;
    }

    public boolean isForwardNullToLabelAndTextProvider() {
        return this.forwardNullToLabelAndTextProvider;
    }

    public void setForwardNullToLabelAndTextProvider(boolean forwardNullToLabelProvider) {
        this.forwardNullToLabelAndTextProvider = forwardNullToLabelProvider;
    }
}

