/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;

public class NumberMask
extends MyMask {
    private boolean allowNegative;
    private int max;
    private int min;
    private Integer defaultValue;

    public NumberMask(int min, int max) {
        super("");
        this.min = min;
        this.max = max;
    }

    public NumberMask() {
        super("");
        this.max = Integer.MAX_VALUE;
        this.min = Integer.MIN_VALUE;
    }

    public NumberMask setMaximum(int max) {
        this.max = max;
        return this;
    }

    public int getMaximum() {
        return this.max;
    }

    public NumberMask setMinimum(int min) {
        this.min = min;
        return this;
    }

    public int getMinimum() {
        return this.min;
    }

    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public NumberMask setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
        return this;
    }

    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Integer defaultValue) {
        if (defaultValue != null && (defaultValue < this.min || defaultValue > this.max || defaultValue < 0 && !this.allowNegative)) {
            throw new IllegalArgumentException(defaultValue.toString());
        }
        this.defaultValue = defaultValue;
    }

    @Override
    public String apply(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        String text2 = text.trim();
        int length = text2.length();
        StringBuilder b = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char ch = text2.charAt(i);
            if (NumberMask.isCharValid(i, ch)) {
                b.append(ch);
            }
            ++i;
        }
        return this.checkAgainstDefault(b.toString());
    }

    @Override
    public String feed(String base, char c) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        StringBuilder b = new StringBuilder();
        b.append(base);
        b.append(c);
        if (this.valid(b)) {
            return b.toString();
        }
        return base;
    }

    @Override
    public String feed(String base, int offset, char c) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        StringBuilder b = new StringBuilder();
        b.append(base.substring(0, offset));
        b.append(c);
        b.append(base.substring(offset));
        if (this.valid(b)) {
            return b.toString();
        }
        return base;
    }

    @Override
    public String unapply(String text) {
        return text;
    }

    @Override
    public boolean valid(CharSequence text) {
        int value;
        if (text == null) {
            return true;
        }
        int length = text.length();
        if (length == 0) {
            return true;
        }
        int i = 0;
        while (i < length) {
            if (!NumberMask.isCharValid(i, text.charAt(i))) {
                return false;
            }
            ++i;
        }
        if (length == 1 && text.charAt(0) == '-') {
            return this.allowNegative;
        }
        try {
            value = Integer.parseInt(text.toString());
        }
        catch (Exception exception) {
            return false;
        }
        if (!this.allowNegative && value < 0) {
            return false;
        }
        if (value > this.max) {
            return false;
        }
        return value >= this.min;
    }

    private static boolean isCharValid(int index, int ch) {
        return index == 0 && ch == 45 || Character.isDigit(ch);
    }

    @Override
    public String starve(String base, int count) {
        return this.checkAgainstDefault(super.starve(base, count));
    }

    @Override
    public String starve(String base, int endOffset, int count) {
        return this.checkAgainstDefault(super.starve(base, endOffset, count));
    }

    @Override
    public String starve2(String base, int from, int to) {
        return this.checkAgainstDefault(super.starve2(base, from, to));
    }

    private String checkAgainstDefault(String s) {
        if (this.defaultValue != null && StringUtils.isBlank((CharSequence)s)) {
            return this.defaultValue.toString();
        }
        return s;
    }

    public static void main(String[] args) {
        NumberMask mask = new NumberMask();
        mask.setDefaultValue(0);
        NumberMask.assertEquals("11", mask.feed("1", '1'));
        NumberMask.assertEquals("0", mask.apply(""));
        NumberMask.assertEquals("0", mask.apply("a"));
        NumberMask.assertEquals("111", mask.feed("11", 1, '1'));
        NumberMask.assertEquals("0", mask.starve("1", 1));
        NumberMask.assertEquals("0", mask.starve("11", 2));
        NumberMask.assertEquals("0", mask.starve("1", 1, 1));
        NumberMask.assertEquals("0", mask.starve2("1111", 0, 4));
    }

    private static void assertEquals(String expected, String real) {
        if (!MiscUtil.areObjectsEquals((Object)expected, (Object)real)) {
            throw new RuntimeException("expected=" + expected + ", was=" + real);
        }
    }
}

