/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FontAwareExpandBar
extends ExpandBar
implements IRefreshFont {
    private int fontSizeIncrement = 0;
    private int fontStyle = 0;

    public FontAwareExpandBar(Composite parent, int style) {
        super(parent, style);
        this.setFont(this.fontSizeIncrement, this.fontStyle);
    }

    public void setFont(int fontSizeIncrement, int fontStyle) {
        this.fontSizeIncrement = fontSizeIncrement;
        this.fontStyle = fontStyle;
        Font font = ResourceGetter.getFont((int)fontSizeIncrement, (int)fontStyle);
        this.setFont(font);
        try {
            ExpandItem[] expandItemArray = this.getItems();
            int n = expandItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExpandItem i = expandItemArray[n2];
                if (i.getControl() instanceof Tree) {
                    Tree tree = (Tree)i.getControl();
                    TreeItem[] treeItemArray = tree.getItems();
                    int n3 = treeItemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem ti = treeItemArray[n4];
                        ti.setFont(0, font);
                        if (ti.getItemCount() > 0) {
                            TreeItem[] treeItemArray2 = ti.getItems();
                            int n5 = treeItemArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                TreeItem ti1 = treeItemArray2[n6];
                                ti1.setFont(0, font);
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public void addPaintListener() {
        if (UI.OS_WINDOWS) {
            try {
                ExpandItem[] expandItemArray = this.getItems();
                int n = expandItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ExpandItem ei = expandItemArray[n2];
                    if (ei.getControl() instanceof Tree) {
                        final Tree tree = (Tree)ei.getControl();
                        tree.addListener(42, new Listener(){

                            public void handleEvent(Event event) {
                                if (tree.getItemCount() > 0 && tree.getColumnCount() > 1) {
                                    Point fontSize = event.gc.textExtent("M");
                                    int fontH = fontSize.y;
                                    int itemH = tree.getItemHeight();
                                    if (fontH - itemH > 5) {
                                        tree.getItem(0).setImage(0, ResourceGetter.getImage((int)fontH));
                                        tree.redraw();
                                    } else if (tree.getItem(0).getImage(0) != null) {
                                        tree.getItem(0).setImage(0, null);
                                        tree.redraw();
                                    }
                                }
                            }
                        });
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void refreshFont() {
        this.setFont(this.fontSizeIncrement, this.fontStyle);
    }

    protected void checkSubclass() {
    }
}

