/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.ui.controls.DateChangedEvent;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.DateTimeText;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ReceiveEvent;
import ca.infodata.ofys.ui.controls.SWTEvents;
import ca.infodata.ofys.ui.controls.form.FormMaskedText;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.Calendar;
import org.eclipse.nebula.widgets.calendarcombo.ICalendarListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public abstract class EditorModifyListener
implements Listener,
SelectionListener,
ModifyListener,
FocusListener,
MouseListener,
ICalendarListener,
DateText.IDateListener,
ISearchTextListener,
DateTimeText.IDateTimeListener {
    public static final int ResponseReceived = 4096;
    public static final int DateChanged = 16384;
    public static final int PartialDateChanged = 65536;
    public static final int DatetimeChanged = 262144;
    private IBaseEditor2 editor;
    private final int types;

    public EditorModifyListener(IBaseEditor2 editor) {
        this(editor, 4127);
    }

    public EditorModifyListener(IBaseEditor2 editor, int types) {
        this.editor = editor;
        this.types = types;
    }

    public void focusGained(FocusEvent e) {
        if (this.isListeningOnType(15)) {
            this.eventSent(SWTEvents.convert(e, 15));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isListeningOnType(13)) {
            this.eventSent(SWTEvents.convert(e, 13));
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.isListeningOnType(24)) {
            Control widget = (Control)e.widget;
            if (widget.getParent() instanceof FormMaskedText) {
                if (!((FormMaskedText)widget.getParent()).getFromMe()) {
                    this.eventSent(SWTEvents.convert(e, 24));
                }
            } else {
                this.eventSent(SWTEvents.convert(e, 24));
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.isListeningOnType(8)) {
            if (e.widget instanceof Table) {
                if (((Table)e.widget).getSelectionCount() > 0) {
                    this.eventSent(SWTEvents.convert(e, 8));
                }
            } else {
                this.eventSent(SWTEvents.convert(e, 8));
            }
        }
    }

    @Override
    public void objectReceived(IDataObject dataObject) {
        if (this.isListeningOnType(4096) && this.editor.mustEditDataObject()) {
            this.edited(new ReceiveEvent(dataObject));
            if (!this.editor.getLastKnowDirtyStatus()) {
                this.editor.checkDirty();
            }
        }
    }

    private void eventSent(Event e) {
        if (this.editor.mustEditDataObject()) {
            this.edited(e);
            if (!this.editor.getLastKnowDirtyStatus()) {
                this.editor.checkDirty();
            }
        }
    }

    private boolean isListeningOnType(int eventType) {
        return this.types == -1 || (this.types | eventType) == this.types;
    }

    public abstract void edited(Event var1);

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.isListeningOnType(14)) {
            this.eventSent(SWTEvents.convert(e, 14));
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.isListeningOnType(16)) {
            this.eventSent(SWTEvents.convert(e, 16));
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this.isListeningOnType(3)) {
            this.eventSent(SWTEvents.convert(e, 3));
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.isListeningOnType(4)) {
            this.eventSent(SWTEvents.convert(e, 4));
        }
    }

    @Override
    public void dateChanged(LocalDate date) {
        if (this.isListeningOnType(16384)) {
            this.eventSent(new DateChangedEvent((IPartialDate)date));
        }
    }

    @Override
    public void partialChanged(IPartialDate date) {
        if (this.isListeningOnType(65536)) {
            this.eventSent(new DateChangedEvent(date));
        }
    }

    public void dateChanged(Calendar date) {
        if (this.isListeningOnType(16384)) {
            this.eventSent(new DateChangedEvent(date));
        }
    }

    @Override
    public void datetimeChanged() {
        if (this.isListeningOnType(262144)) {
            this.eventSent(new Event());
        }
    }

    public void dateRangeChanged(Calendar start, Calendar end) {
    }

    public void popupClosed() {
    }

    public void handleEvent(Event e) {
        if (this.isListeningOnType(e.type)) {
            this.eventSent(e);
        }
    }
}

