/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;

public class ConsoleStyledText
extends StyledText {
    private Color red;

    public ConsoleStyledText(Composite parent, int style) {
        super(parent, style);
        this.setEditable(false);
        this.red = ResourceGetter.getColor((int)255, (int)0, (int)0);
    }

    public void log(Level level, String message, Throwable t) {
        String text = this.format(level, message, t);
        int start = this.getCharCount();
        int length = text.length();
        if (text.length() > 0) {
            text = String.valueOf(text) + "\r\n";
            this.append(text);
            StyleRange range = level.intValue() >= Level.WARNING.intValue() ? new StyleRange(new TextStyle(ResourceGetter.getFont((int)0, (int)0), this.red, null)) : new StyleRange(new TextStyle(ResourceGetter.getFont((int)0, (int)0), null, null));
            range.start = start;
            range.length = length;
            this.setStyleRange(range);
            this.setTopIndex(this.getLineCount() - 1);
        }
    }

    private String format(Level level, String message, Throwable t) {
        JoinList list = new JoinList("\r\n");
        list.setNoDuplicate(true);
        list.add((CharSequence)message);
        if (t != null) {
            if (StringUtils.isNotBlank((String)t.getMessage())) {
                list.add((CharSequence)t.getMessage());
            } else {
                list.add((CharSequence)t.getClass().getSimpleName());
            }
        }
        return list.toString();
    }
}

