/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.ITreeElementsContextMenuContribution;
import ca.infodata.ofys.ui.controls.ITreeElementsFactory;
import ca.infodata.ofys.ui.library.ResourceGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;

public class AbstractTreeElement
implements ITreeElements,
IFontProvider {
    public static final String CONTEXT_MENU_ID = "ca.infodata.ofys.ui.menu.contextmenu";
    public static final String MENU_ID = "ca.infodata.ofys.ui.menu.menuelements";
    private static final Logger logger = Logger.getLogger(AbstractTreeElement.class.getName());
    private ITreeElements parent;
    private String text;
    private String imageName;
    protected ITreeElements[] children;
    protected int childrenNumber = -1;

    public AbstractTreeElement() {
    }

    public AbstractTreeElement(ITreeElements parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
    }

    public AbstractTreeElement(ITreeElements parent, String text, String imageName, List<? extends AbstractTreeElement> listChilds) {
        this(parent);
        this.text = text;
        this.imageName = imageName;
        this.children = listChilds == null ? null : listChilds.toArray(new ITreeElements[listChilds.size()]);
        for (AbstractTreeElement abstractTreeElement : listChilds) {
            abstractTreeElement.setParent(this);
        }
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public void setParent(ITreeElements parent) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.parent = parent;
    }

    protected List<ITreeElements> getChildrenByExtension() {
        ArrayList<ITreeElements> lstChilds = new ArrayList<ITreeElements>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(MENU_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String parentId = e.getAttribute("parentId");
                if (AbstractTreeElement.parentIdEquals(this.getClass(), parentId)) {
                    Object factory = e.createExecutableExtension("factoryClass");
                    if (factory instanceof ITreeElementsFactory) {
                        List<? extends ITreeElements> elements = ((ITreeElementsFactory)factory).newITreeElements(this, e);
                        if (elements != null && elements.size() > 0) {
                            lstChilds.addAll(elements);
                        }
                    } else {
                        throw new RuntimeException("ca.infodata.ofys.ui.menu.menuelements menu class must be instanceof ITreeElementsFactory " + factory);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log(Level.WARNING, "Failed to load children extensions for " + this.getClass().getName(), ex);
        }
        return lstChilds;
    }

    public int hashCode() {
        return new String(String.valueOf(this.parent.hashCode()) + " " + this.getClass().getName()).hashCode();
    }

    public boolean equals(Object o) {
        return o != null && o.hashCode() == this.hashCode();
    }

    private static boolean parentIdEquals(Class<?> c, String parentId) {
        Class<?>[] interfaces;
        if (parentId == null) {
            return false;
        }
        Class<?> c2 = c;
        while (c2 != null) {
            if (c2.getName().equals(parentId)) {
                return true;
            }
            c2 = c2.getSuperclass();
        }
        Class<?>[] classArray = interfaces = c.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            if (i.getName().equals(parentId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void extendsContextMenuWithContributions(Control control) {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTEXT_MENU_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String targetId = e.getAttribute("targetId");
                if (this.getClass().getName().equals(targetId)) {
                    Object instance = e.createExecutableExtension("class");
                    if (instance instanceof ITreeElementsContextMenuContribution) {
                        ((ITreeElementsContextMenuContribution)instance).contributeContextMenuTo(this, control);
                    } else {
                        throw new RuntimeException("ca.infodata.ofys.ui.menu.contextmenu class attribute must be instanceof ITreeElementsContextMenuContribution " + instance);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            logger.log(Level.WARNING, "Failed to extendsContextMenuWithContributions for " + this.getClass().getName(), ex);
        }
    }

    @Override
    public Object[] getChildren() {
        return this.children == null ? null : this.children;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    @Override
    public Image getImage() {
        return this.imageName == null ? null : ResourceGetter.getImage((String)this.imageName);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getTooltipText() {
        return this.getText();
    }

    @Override
    public String getEditorClass() {
        return null;
    }

    @Override
    public IEditorInput getEditorInput() {
        return null;
    }

    @Override
    public XImageDecorator getDecorators() {
        return null;
    }

    @Override
    public void doKeyListener(Control control, KeyEvent ke) {
    }

    @Override
    public void showContextMenu(Control control) {
    }

    @Override
    public int getChildrenNumberForPastille() {
        return this.childrenNumber;
    }

    public Font getFont(Object element) {
        return ResourceGetter.getFontNormal();
    }
}

