/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.b2b.simple;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XDisabilityCode;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionCategory;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionEndReason;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XInscriptionStatus;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientRepresentativeType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.b2b.simple.IPatientB2bReader;
import ca.infodata.ofys.ui.b2b.simple.IPatientB2bWriter;
import ca.infodata.ofys.ui.b2b.simple.NullPatientB2bReader;
import ca.infodata.ofys.ui.b2b.simple.NullPatientB2bWriter;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.IPatientSearchTextListener;
import ca.infodata.ofys.ui.person.patient.NotFoundPatient;
import ca.infodata.ofys.ui.person.patient.NullPatient;
import ca.infodata.ofys.ui.person.patient.PatientMultiEditor;
import ca.infodata.ofys.ui.person.patient.PatientSearchText;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.professionnal.ProfessionnalMultiEditor;
import ca.infodata.ofys.ui.person.professionnal.ProfessionnalSearchText;
import ca.infodata.ofys.ui.site.SiteCombo;
import ca.infodata.ofys.ui.site.WorkSiteCombo;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PatientB2BControl
extends Composite {
    private static final String EFFACER_LES_INFORMATIONS = Messages.getString((String)"B2B.DIALOG.EFFACER_LES_INFORMATIONS", (String[])new String[0]);
    private static final String SUPPRIMER_L_INSCRIPTION = Messages.getString((String)"B2B.DIALOG.SUPPRIMER_LINSCRIPTION", (String[])new String[0]);
    private static final String CESSER_L_INSCRIPTION = Messages.getString((String)"B2B.DIALOG.CESSER_LINSCRIPTION", (String[])new String[0]);
    private static final String INSCRIRE = Messages.getString((String)"B2B.DIALOG.INSCRIRE", (String[])new String[0]);
    private static final String RENEW = Messages.getString((String)"B2B.DIALOG.RENEW", (String[])new String[0]);
    private static final String RENEW_CODE10_TTT = Messages.getString((String)"B2B.DIALOG.RENEW_CODE10_TTT", (String[])new String[0]);
    private static final String PR\u00c9_INSCRIRE = Messages.getString((String)"B2B.DIALOG.PRE-INSCRIRE", (String[])new String[0]);
    private static final String ACTIONS_RAPIDES = Messages.getString((String)"B2B.DIALOG.ACTION_RAPIDES", (String[])new String[0]);
    private static final String STATUT = Messages.getString((String)"B2B.DIALOG.STATUT", (String[])new String[0]);
    private static final String PROFESSIONNEL_TRAITANT = Messages.getString((String)"B2B.DIALOG.PROFESSIONNEL_TRAITANT", (String[])new String[0]);
    private static final String CLIENT = Messages.getString((String)"B2B.DIALOG.CLIENT", (String[])new String[0]);
    private static final String VERIFIER_L_INSCRIPTION = Messages.getString((String)"B2B.DIALOG.VERIFIER_L_INSCRIPTION", (String[])new String[0]);
    private static final String REPRESENTANT_SI_MOINS_DE_14_ANS_OU_INAPTE = Messages.getString((String)"B2B.DIALOG.REPRESENTANT_SI_MOINS_DE_14_ANS_OU_INAPTE", (String[])new String[0]);
    private static final String STATUT_INSCRIPTION = Messages.getString((String)"B2B.DIALOG.STATUT_INSCRIPTION", (String[])new String[0]);
    private static final String LIEU_DU_SUIVI = Messages.getString((String)"B2B.DIALOG.LIEU_DU_SUIVI", (String[])new String[0]);
    private static final String DATE_DEBUT_DE_SUIVI = Messages.getString((String)"B2B.DIALOG.DATE_DEBUT_DE_SUIVI", (String[])new String[0]);
    private static final String RESIDENT = Messages.getString((String)"B2B.DIALOG.RESIDENT", (String[])new String[0]);
    private static final String DATE_INSCRIPTION = Messages.getString((String)"B2B.DIALOG.DATE_INSCRIPTION", (String[])new String[0]);
    private static final String DATE_FIN_INSCR = Messages.getString((String)"B2B.DIALOG.DATE_FIN_INSCR", (String[])new String[0]);
    private static final String RAISON_FIN = Messages.getString((String)"B2B.DIALOG.RAISON_FIN", (String[])new String[0]);
    private static final String MSG_CHANG_VULN = Messages.getString((String)"B2B.DIALOG.MSG_CHANG_VULN", (String[])new String[0]);
    private static final String CODE_VULNERABILITE = Messages.getString((String)"B2B.DIALOG.CODE_VULNERABILITE", (String[])new String[0]);
    private static final String DATE_DE_DEBUT = Messages.getString((String)"B2B.DIALOG.DATE_DE_DEBUT", (String[])new String[0]);
    private static final String DATE_DE_FIN = Messages.getString((String)"B2B.DIALOG.DATE_DE_FIN", (String[])new String[0]);
    private static final String CATEGORIE = Messages.getString((String)"B2B.DIALOG.CATEGORIE", (String[])new String[0]);
    private MyLabel lblFollowUpLocationLieu;
    private MyLabel lblFollowUpLocationDate;
    private MyCalendarText txtFollowUpLocationDate;
    private SiteCombo cmbDepartment;
    private PatientSearchText txtRepresentant;
    private ProfessionnalSearchText txtResident;
    private MyCombo<XPatientRepresentativeType> cboType;
    private MyLabel lblDateInscription;
    private MyCalendarText txtDateInscription;
    private MyLabel lblDateFinInscription;
    private MyCalendarText txtDateFinInscription;
    private MyLabel lblRaisonArret;
    private MyCombo<XInscriptionEndReason> cboRaisonArret;
    private MyLabel lblCategory;
    private MyCombo<XInscriptionCategory> cmbCategory;
    private MyButton btnCheckInscription;
    private MyLabel lblStatusInscription;
    private MyCombo<XInscriptionStatus> cmbStatusInscription;
    private FormToolkit toolkit;
    private IPatient patient;
    private IPatientB2bReader patientB2bReader;
    private IPatientB2bWriter patientB2bWriter;
    private MyCombo<XDisabilityCode> cmbCode1;
    private MyCalendarText txtDate1;
    private MyCalendarText txtDateEnd1;
    private MyCombo<XDisabilityCode> cmbCode2;
    private MyCalendarText txtDate2;
    private MyCalendarText txtDateEnd2;
    private MyCombo<XDisabilityCode> cmbCode3;
    private MyCalendarText txtDate3;
    private MyCalendarText txtDateEnd3;
    private MyLabel lblCode;
    private MyLabel lblDate;
    private MyLabel lblDateEnd;
    private MyLabel lblPatient;
    private MyLabel lblTreatingProfessionnal;
    private FontAwareSection sectionPatient;
    private FontAwareSection sectionTreatingProf;
    private FontAwareSection sectionStatus;
    private FontAwareSection sectionSuivi;
    private FontAwareSection sectionVuln;
    private FontAwareSection sectionRepr;
    private FontAwareSection sectionResident;
    private FontAwareSection sectionShortcutActions;
    private boolean isRefreshing;
    private MyButton btnQuickPreInscrire;
    private MyButton btnQuickInscrire;
    private MyButton btnQuickRenew;
    private MyButton btnQuickSupprimer;
    private MyButton btnQuickCesser;
    private MyButton btnQuickEffacer;

    public PatientB2BControl(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.toolkit = toolkit;
        this.createMyControl();
        this.setModel(null, null, null);
    }

    public void createMyControl() {
        PatientB2BControl parent = this;
        Composite leftPart = this.toolkit.createComposite((Composite)parent, 0);
        Label separator = this.toolkit.createSeparator((Composite)parent, 512);
        Composite rightPart = this.toolkit.createComposite((Composite)parent, 0);
        int marginHeight = ResourceGetter.getFontSizeIncrement() > 4 ? 0 : 4;
        this.sectionPatient = new FontAwareSection(leftPart, 64, this.toolkit);
        this.sectionPatient.setText(CLIENT);
        this.toolkit.createCompositeSeparator((Composite)this.sectionPatient);
        this.sectionPatient.setLayout((Layout)new FormLayout());
        Composite sectionPatientComp = this.toolkit.createComposite((Composite)this.sectionPatient);
        sectionPatientComp.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionPatient.setClient((Control)sectionPatientComp);
        this.lblPatient = new MyLabel(sectionPatientComp, "", 64, this.toolkit);
        this.lblPatient.setFont(0, 1);
        this.sectionTreatingProf = new FontAwareSection(leftPart, 64, this.toolkit);
        this.sectionTreatingProf.setText(PROFESSIONNEL_TRAITANT);
        this.toolkit.createCompositeSeparator((Composite)this.sectionTreatingProf);
        this.sectionTreatingProf.setLayout((Layout)new FormLayout());
        Composite sectionTreatingProfComp = this.toolkit.createComposite((Composite)this.sectionTreatingProf);
        sectionTreatingProfComp.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionTreatingProf.setClient((Control)sectionTreatingProfComp);
        this.lblTreatingProfessionnal = new MyLabel(sectionTreatingProfComp, "", 64, this.toolkit);
        this.lblTreatingProfessionnal.setFont(0, 1);
        this.sectionStatus = new FontAwareSection(leftPart, 64, this.toolkit);
        this.sectionStatus.setText(STATUT);
        this.toolkit.createCompositeSeparator((Composite)this.sectionStatus);
        this.sectionStatus.setLayout((Layout)new FormLayout());
        Composite sectionSt = this.toolkit.createComposite((Composite)this.sectionStatus);
        sectionSt.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionStatus.setClient((Control)sectionSt);
        this.lblStatusInscription = new MyLabel(sectionSt, STATUT_INSCRIPTION, 0, this.toolkit);
        this.cmbStatusInscription = new MyCombo(sectionSt, 8, this.toolkit);
        this.cmbStatusInscription.setItems((Object[])XInscriptionStatus.values());
        this.cmbStatusInscription.setLayoutData(UI.newFillFormData());
        this.lblCategory = new MyLabel(sectionSt, CATEGORIE, 0, this.toolkit);
        this.cmbCategory = new MyCombo(sectionSt, 8, this.toolkit);
        this.cmbCategory.setItems((Object[])XInscriptionCategory.values());
        this.lblDateInscription = new MyLabel(sectionSt, DATE_INSCRIPTION, 0, this.toolkit);
        this.txtDateInscription = new MyCalendarText(sectionSt, this.toolkit);
        this.lblDateFinInscription = new MyLabel(sectionSt, DATE_FIN_INSCR, 0, this.toolkit);
        this.txtDateFinInscription = new MyCalendarText(sectionSt, this.toolkit);
        this.lblRaisonArret = new MyLabel(sectionSt, RAISON_FIN, 0, this.toolkit);
        this.cboRaisonArret = new MyCombo(sectionSt, 8, this.toolkit);
        this.cboRaisonArret.setItems((Object[])XInscriptionEndReason.values());
        this.cboRaisonArret.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XInscriptionEndReason item = (XInscriptionEndReason)PatientB2BControl.this.cboRaisonArret.getSelection();
                PatientB2BControl.this.cboRaisonArret.getControl().setToolTipText(item == null ? "" : item.toString());
            }
        });
        this.sectionSuivi = new FontAwareSection(leftPart, 64, this.toolkit);
        this.sectionSuivi.setText(LIEU_DU_SUIVI);
        this.toolkit.createCompositeSeparator((Composite)this.sectionSuivi);
        this.sectionSuivi.setLayout((Layout)new FormLayout());
        Composite sectionSv = this.toolkit.createComposite((Composite)this.sectionSuivi);
        sectionSv.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionSuivi.setClient((Control)sectionSv);
        this.lblFollowUpLocationLieu = new MyLabel(sectionSv, LIEU_DU_SUIVI, 0, this.toolkit);
        this.cmbDepartment = new WorkSiteCombo(sectionSv, 65544, this.toolkit);
        this.lblFollowUpLocationDate = new MyLabel(sectionSv, DATE_DEBUT_DE_SUIVI, 0, this.toolkit);
        this.txtFollowUpLocationDate = new MyCalendarText(sectionSv, this.toolkit);
        this.sectionVuln = new FontAwareSection(leftPart, 64, this.toolkit);
        this.sectionVuln.setText(MSG_CHANG_VULN);
        this.toolkit.createCompositeSeparator((Composite)this.sectionVuln);
        this.sectionVuln.setLayout((Layout)new FormLayout());
        Composite sectionVn = this.toolkit.createComposite((Composite)this.sectionVuln);
        sectionVn.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionVuln.setClient((Control)sectionVn);
        this.lblCode = new MyLabel(sectionVn, CODE_VULNERABILITE, 16384, this.toolkit);
        this.lblDate = new MyLabel(sectionVn, DATE_DE_DEBUT, 16384, this.toolkit);
        this.lblDateEnd = new MyLabel(sectionVn, DATE_DE_FIN, 16384, this.toolkit);
        ProviderAR<XDisabilityCode, String> disabilityCodeLabelProvider = new ProviderAR<XDisabilityCode, String>(){

            public String get(XDisabilityCode n) {
                return String.valueOf(n.getCode().length() == 1 ? String.valueOf(n.getCode()) + " " : n.getCode()) + ": " + n.getDescription();
            }
        };
        this.cmbCode1 = new MyCombo(sectionVn, 8);
        this.cmbCode1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XDisabilityCode item = (XDisabilityCode)PatientB2BControl.this.cmbCode1.getSelection();
                PatientB2BControl.this.cmbCode1.getControl().setToolTipText(item == null ? "" : item.getDescription());
            }
        });
        this.cmbCode1.setLabelProvider((ProviderAR)disabilityCodeLabelProvider);
        this.cmbCode1.setItems((Object[])XDisabilityCode.values());
        this.cmbCode1.setDefaultSelection((Object)XDisabilityCode.C00);
        this.txtDate1 = new MyCalendarText(sectionVn, this.toolkit);
        this.txtDateEnd1 = new MyCalendarText(sectionVn, this.toolkit);
        this.txtDateEnd1.setEnabled(false);
        this.cmbCode2 = new MyCombo(sectionVn, 8);
        this.cmbCode2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XDisabilityCode item = (XDisabilityCode)PatientB2BControl.this.cmbCode2.getSelection();
                PatientB2BControl.this.cmbCode2.getControl().setToolTipText(item == null ? "" : item.getDescription());
            }
        });
        this.cmbCode2.setLabelProvider((ProviderAR)disabilityCodeLabelProvider);
        this.cmbCode2.setItems((Object[])XDisabilityCode.values());
        this.cmbCode2.setDefaultSelection((Object)XDisabilityCode.C00);
        this.txtDate2 = new MyCalendarText(sectionVn, this.toolkit);
        this.txtDateEnd2 = new MyCalendarText(sectionVn, this.toolkit);
        this.txtDateEnd2.setEnabled(false);
        this.cmbCode3 = new MyCombo(sectionVn, 8);
        this.cmbCode3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XDisabilityCode item = (XDisabilityCode)PatientB2BControl.this.cmbCode3.getSelection();
                PatientB2BControl.this.cmbCode3.getControl().setToolTipText(item == null ? "" : item.getDescription());
            }
        });
        this.cmbCode3.setLabelProvider((ProviderAR)disabilityCodeLabelProvider);
        this.cmbCode3.setItems((Object[])XDisabilityCode.values());
        this.cmbCode3.setDefaultSelection((Object)XDisabilityCode.C00);
        this.txtDate3 = new MyCalendarText(sectionVn, this.toolkit);
        this.txtDateEnd3 = new MyCalendarText(sectionVn, this.toolkit);
        this.txtDateEnd3.setEnabled(false);
        this.sectionRepr = new FontAwareSection(leftPart, 64, this.toolkit);
        this.sectionRepr.setText(REPRESENTANT_SI_MOINS_DE_14_ANS_OU_INAPTE);
        this.toolkit.createCompositeSeparator((Composite)this.sectionRepr);
        this.sectionRepr.setLayout((Layout)new FormLayout());
        Composite sectionRp = this.toolkit.createComposite((Composite)this.sectionRepr);
        sectionRp.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionRepr.setClient((Control)sectionRp);
        this.txtRepresentant = new PatientSearchText(sectionRp, 4096, this.toolkit);
        this.txtRepresentant.setUseSearchDialog(true);
        this.cboType = new MyCombo(sectionRp, 8, this.toolkit);
        this.cboType.setItems((Object[])XPatientRepresentativeType.values());
        this.cboType.setDefaultSelection((Object)XPatientRepresentativeType.SO);
        this.sectionResident = new FontAwareSection(leftPart, 64, this.toolkit);
        this.sectionResident.setText(RESIDENT);
        this.toolkit.createCompositeSeparator((Composite)this.sectionResident);
        this.sectionResident.setLayout((Layout)new FormLayout());
        Composite sectionRs = this.toolkit.createComposite((Composite)this.sectionResident);
        sectionRs.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionResident.setClient((Control)sectionRs);
        this.txtResident = new ProfessionnalSearchText(sectionRs, 4096, this.toolkit);
        this.txtResident.setUseSearchDialog(true);
        this.sectionShortcutActions = new FontAwareSection(rightPart, 64, this.toolkit);
        this.sectionShortcutActions.setText(ACTIONS_RAPIDES);
        this.toolkit.createCompositeSeparator((Composite)this.sectionShortcutActions);
        this.sectionShortcutActions.setLayout((Layout)new FormLayout());
        Composite sectionSa = this.toolkit.createComposite((Composite)this.sectionShortcutActions);
        sectionSa.setLayout((Layout)UI.newFormLayout((int)marginHeight, (int)5, (int)5));
        this.sectionShortcutActions.setClient((Control)sectionSa);
        this.btnCheckInscription = new MyButton(sectionSa, VERIFIER_L_INSCRIPTION, 8, this.toolkit);
        this.btnCheckInscription.setVisible(false);
        this.btnQuickPreInscrire = new MyButton(sectionSa, PR\u00c9_INSCRIRE, 8, this.toolkit);
        this.btnQuickInscrire = new MyButton(sectionSa, INSCRIRE, 8, this.toolkit);
        this.btnQuickCesser = new MyButton(sectionSa, CESSER_L_INSCRIPTION, 8, this.toolkit);
        this.btnQuickSupprimer = new MyButton(sectionSa, SUPPRIMER_L_INSCRIPTION, 8, this.toolkit);
        this.btnQuickEffacer = new MyButton(sectionSa, EFFACER_LES_INFORMATIONS, 8, this.toolkit);
        this.btnQuickRenew = new MyButton(sectionSa, RENEW, 8, this.toolkit);
        this.btnQuickRenew.setToolTipText(RENEW_CODE10_TTT);
        this.btnQuickRenew.setVisible(false);
        this.btnQuickPreInscrire.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientB2BControl.this.patientB2bWriter.quickActionPreInscrire();
            }
        });
        this.btnQuickInscrire.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientB2BControl.this.patientB2bWriter.quickActionInscrire();
            }
        });
        this.btnQuickSupprimer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientB2BControl.this.patientB2bWriter.quickActionSupprimer();
            }
        });
        this.btnQuickCesser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientB2BControl.this.patientB2bWriter.quickActionCesser();
            }
        });
        this.btnQuickEffacer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientB2BControl.this.patientB2bWriter.quickActionEffacer();
            }
        });
        this.btnQuickRenew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientB2BControl.this.patientB2bWriter.quickActionRenew();
            }
        });
        this.cmbDepartment.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setSiteFollow(PatientB2BControl.this.cmbDepartment.getSelection());
                }
            }
        });
        this.txtRepresentant.setPatientSearchTextListener(new IPatientSearchTextListener(){

            public void objectReceived(IPatient representative) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setPatientRepresentative(PatientUtil.getXPatient((Object)representative));
                    if (representative == null) {
                        PatientB2BControl.this.cboType.select((Object)XPatientRepresentativeType.SO);
                    } else if (PatientB2BControl.this.cboType.getSelection() == null) {
                        PatientB2BControl.this.cboType.select((Object)XPatientRepresentativeType.TITULAIRE_DE_LAUTORITE_PARENTALE);
                    }
                }
            }
        });
        this.cboType.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setPatientRepresentativeType((XPatientRepresentativeType)PatientB2BControl.this.cboType.getSelection());
                }
            }
        });
        this.txtResident.addSearchTextListener(new ISearchTextListener(){

            public void objectReceived(IDataObject dataObject) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setResident((XBaseProfessionnal)dataObject);
                }
            }
        });
        this.txtDateInscription.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setStartDate(date);
                }
            }
        });
        this.txtDateFinInscription.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setEndDate(date);
                }
            }
        });
        this.cboRaisonArret.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setEndReason((XInscriptionEndReason)PatientB2BControl.this.cboRaisonArret.getSelection());
                }
            }
        });
        this.txtFollowUpLocationDate.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setSiteFollowStartDate(date);
                }
            }
        });
        this.cmbStatusInscription.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setStatus((XInscriptionStatus)PatientB2BControl.this.cmbStatusInscription.getSelection());
                }
            }
        });
        this.cmbCategory.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setCategory((XInscriptionCategory)PatientB2BControl.this.cmbCategory.getSelection());
                }
            }
        });
        this.cmbCode1.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setVulnerability1Code((XDisabilityCode)PatientB2BControl.this.cmbCode1.getSelection());
                }
            }
        });
        this.cmbCode2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setVulnerability2Code((XDisabilityCode)PatientB2BControl.this.cmbCode2.getSelection());
                }
            }
        });
        this.cmbCode3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setVulnerability3Code((XDisabilityCode)PatientB2BControl.this.cmbCode3.getSelection());
                }
            }
        });
        this.txtDate1.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setVulnerability1Date(date);
                }
            }
        });
        this.txtDate2.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setVulnerability2Date(date);
                }
            }
        });
        this.txtDate3.addDateListener((DateText.IDateListener)new DateText.DateAdapter(){

            public void dateChanged(LocalDate date) {
                if (PatientB2BControl.this.shouldModify()) {
                    PatientB2BControl.this.patientB2bWriter.setVulnerability3Date(date);
                }
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = marginHeight;
        layout.marginWidth = 4;
        layout.spacing = 4;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        leftPart.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)leftPart);
        data.bottom = new FormAttachment(100);
        separator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)separator);
        data.bottom = new FormAttachment(100);
        rightPart.setLayoutData((Object)data);
        FormLayout layout2 = new FormLayout();
        layout2.marginHeight = marginHeight;
        layout2.marginWidth = 4;
        layout2.spacing = 4;
        leftPart.setLayout((Layout)layout2);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        this.sectionPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionPatient.getClient()).setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.sectionPatient);
        data.right = new FormAttachment(100);
        this.sectionTreatingProf.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionTreatingProf.getClient()).setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionPatient);
        data.left = new FormAttachment(0);
        this.sectionStatus.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionStatus.getClient()).setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionStatus);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.sectionSuivi.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionSuivi.getClient()).setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionSuivi);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.sectionVuln.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionVuln.getClient()).setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionVuln);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.sectionRepr.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionRepr.getClient()).setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.sectionRepr);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.sectionResident.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionResident.getClient()).setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblStatusInscription.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblStatusInscription.getControl());
        data.left = new FormAttachment(0);
        this.cmbStatusInscription.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.cmbStatusInscription.getControl());
        this.lblCategory.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCategory.getControl());
        data.left = new FormAttachment((Control)this.cmbStatusInscription.getControl());
        this.cmbCategory.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.cmbCategory.getControl());
        this.lblDateInscription.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDateInscription.getControl());
        data.left = new FormAttachment((Control)this.cmbCategory.getControl());
        this.txtDateInscription.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbStatusInscription.getControl());
        data.left = new FormAttachment(0);
        this.lblRaisonArret.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblRaisonArret.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment((Control)this.cmbCategory.getControl(), 0, 131072);
        this.cboRaisonArret.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbStatusInscription.getControl());
        data.left = new FormAttachment(this.lblDateInscription.getControl(), 0, 16384);
        this.lblDateFinInscription.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblDateFinInscription.getControl());
        data.left = new FormAttachment(this.txtDateInscription.getControl(), 0, 16384);
        this.txtDateFinInscription.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.lblFollowUpLocationLieu.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblFollowUpLocationLieu.getControl());
        data.left = new FormAttachment(0);
        this.cmbDepartment.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtFollowUpLocationDate.getControl(), 0, 16384);
        this.lblFollowUpLocationDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblFollowUpLocationDate.getControl());
        data.left = new FormAttachment((Control)this.cmbDepartment.getControl());
        this.txtFollowUpLocationDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.cmbCode1.getControl(), 0, 16384);
        data.right = new FormAttachment((Control)this.cmbCode1.getControl(), 0, 131072);
        this.lblCode.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtDate1.getControl(), 0, 16384);
        data.right = new FormAttachment(this.txtDate1.getControl(), 0, 131072);
        this.lblDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.txtDateEnd1.getControl(), 0, 16384);
        data.right = new FormAttachment(this.txtDateEnd1.getControl(), 0, 131072);
        this.lblDateEnd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCode.getControl());
        data.left = new FormAttachment(0);
        data.width = 250;
        this.cmbCode1.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCode.getControl());
        data.left = new FormAttachment((Control)this.cmbCode1.getControl());
        this.txtDate1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblCode.getControl());
        data.left = new FormAttachment(this.txtDate1.getControl());
        this.txtDateEnd1.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbCode1.getControl());
        data.left = new FormAttachment(0);
        data.width = 250;
        this.cmbCode2.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbCode1.getControl());
        data.left = new FormAttachment((Control)this.cmbCode2.getControl());
        this.txtDate2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbCode1.getControl());
        data.left = new FormAttachment(this.txtDate2.getControl());
        this.txtDateEnd2.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbCode2.getControl());
        data.left = new FormAttachment(0);
        data.width = 250;
        this.cmbCode3.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbCode2.getControl());
        data.left = new FormAttachment((Control)this.cmbCode3.getControl());
        this.txtDate3.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbCode2.getControl());
        data.left = new FormAttachment(this.txtDate3.getControl());
        this.txtDateEnd3.setLayoutData((Object)data);
        if (ResourceGetter.getFontSizeIncrement() > 4) {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            data.width = 200;
            this.cboType.getControl().setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment((Control)this.cboType.getControl());
            data.right = new FormAttachment(100);
            this.txtRepresentant.setLayoutData((Object)data);
        } else {
            data = new FormData();
            data.top = new FormAttachment(0);
            data.left = new FormAttachment(0);
            this.cboType.getControl().setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.cboType.getControl());
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.txtRepresentant.setLayoutData((Object)data);
        }
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.txtResident.setLayoutData((Object)data);
        FormLayout layout3 = new FormLayout();
        layout3.marginHeight = marginHeight;
        layout3.marginWidth = 4;
        layout3.spacing = 4;
        rightPart.setLayout((Layout)layout3);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.sectionShortcutActions.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ((Composite)this.sectionShortcutActions.getClient()).setLayoutData((Object)data);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.justify = true;
        ((Composite)this.sectionShortcutActions.getClient()).setLayout((Layout)rowLayout);
        this.toolkit.adapt((Composite)this);
    }

    public void setModel(IPatient patient, IPatientB2bReader reader, IPatientB2bWriter writer) {
        this.patient = patient == null ? new NullPatient() : patient;
        this.patientB2bReader = reader == null ? new NullPatientB2bReader() : reader;
        this.patientB2bWriter = writer == null ? new NullPatientB2bWriter() : writer;
        this.refresh();
    }

    public void refresh() {
        try {
            this.isRefreshing = true;
            StringBuilder s = new StringBuilder();
            s.append(StringUtils.defaultString((String)this.patient.getNameBirthdateSex()));
            if (StringUtils.isNotBlank((String)this.patient.getFormatedHealthInsuranceNumber())) {
                s.append("\n");
                s.append(this.patient.getFormatedHealthInsuranceNumber());
                if (StringUtils.isNotBlank((String)this.patient.getFormatedExpirationCAM())) {
                    s.append(" (Exp. " + this.patient.getFormatedExpirationCAM() + ")");
                }
            }
            this.lblPatient.setText(s.toString());
            s.setLength(0);
            if (this.patient.getTreatingProfessionnal() != null) {
                XBaseProfessionnal treatingProf = PersonUiPlugin.getDefault().getBaseProfessionnal(this.patient.getTreatingProfessionnal());
                s.append(treatingProf.getName());
                s.append("\n");
                s.append(treatingProf.getCode());
                this.lblTreatingProfessionnal.setText(s.toString());
                this.lblTreatingProfessionnal.setForeground(null);
            } else {
                this.lblTreatingProfessionnal.setText("Aucun");
                this.lblTreatingProfessionnal.setForeground(ResourceGetter.getRedWarningColor());
            }
            IPatient rep = this.patientB2bReader.getPatientRepresentative();
            this.txtRepresentant.setDataObject((IDataObject)rep);
            this.cboType.select((Object)this.patientB2bReader.getPatientRepresentativeType());
            XBaseProfessionnal res = this.patientB2bReader.getProfessionnalResident();
            this.txtResident.setDataObject((IDataObject)res);
            XSite site = this.patientB2bReader.getSiteFollow();
            if (site == null) {
                this.cmbDepartment.selectNone();
            } else {
                this.cmbDepartment.select(site);
            }
            this.txtFollowUpLocationDate.setDate((IPartialDate)this.patientB2bReader.getSiteFollowStartDate());
            this.cmbStatusInscription.select((Object)this.patientB2bReader.getStatus());
            this.cmbCategory.select((Object)this.patientB2bReader.getCategory());
            this.txtDateInscription.setDate((IPartialDate)this.patientB2bReader.getStartDate());
            this.txtDateFinInscription.setDate((IPartialDate)this.patientB2bReader.getEndDate());
            this.cboRaisonArret.select((Object)this.patientB2bReader.getEndReason());
            this.cmbCode1.select((Object)this.patientB2bReader.getVulnerability1Code());
            this.cmbCode2.select((Object)this.patientB2bReader.getVulnerability2Code());
            this.cmbCode3.select((Object)this.patientB2bReader.getVulnerability3Code());
            this.txtDate1.setDate((IPartialDate)this.patientB2bReader.getVulnerability1Date());
            this.txtDate2.setDate((IPartialDate)this.patientB2bReader.getVulnerability2Date());
            this.txtDate3.setDate((IPartialDate)this.patientB2bReader.getVulnerability3Date());
            this.txtDateEnd1.setDate((IPartialDate)this.patientB2bReader.getVulnerability1DateEnd());
            this.txtDateEnd2.setDate((IPartialDate)this.patientB2bReader.getVulnerability2DateEnd());
            this.txtDateEnd3.setDate((IPartialDate)this.patientB2bReader.getVulnerability3DateEnd());
        }
        finally {
            this.isRefreshing = false;
        }
    }

    protected void openRepresentant() {
        IPatient representative = this.patientB2bReader.getPatientRepresentative();
        if (representative != null && !(representative instanceof NotFoundPatient) && !(representative instanceof NullPatient)) {
            BaseEditor.openEditorSafePlain((IEditorInput)new EditorInput((IDataObject)representative), (String)PatientMultiEditor.class.getName());
        }
    }

    protected void openResident() {
        XBaseProfessionnal resident = this.patientB2bReader.getProfessionnalResident();
        if (resident != null) {
            BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)resident), (String)ProfessionnalMultiEditor.class.getName());
        }
    }

    protected boolean shouldModify() {
        return !this.isRefreshing;
    }
}

