/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodResult;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.Interceptor;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ListWithInterceptor;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.SetWithInterceptor;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.appointment.search.ISearchController;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.DayOfWeek;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ComplexSearchController
implements ISearchController {
    static final int PROP_GROUP = 0;
    static final int PROP_PROF = 1;
    static final int PROP_SITE = 2;
    static final int PROP_HOUR = 3;
    static final int PROP_DATE = 4;
    static final int PROP_PERIOD_TYPE = 5;
    static final int PROP_DAY_OF_WEEK = 6;
    static final int PROP_ALL = 11;
    static final int PROP_FAMILLY_SEARCH = 12;
    static final int DAYS = 7;
    static final int MONTHS = 8;
    static final int WEEKS = 9;
    private List<Integer> professionnalGroups;
    private List<XBaseProfessionnal> professionnals;
    private List<XSite> sites;
    private List<XAppointmentPeriodType> periodTypes;
    private Set<DayOfWeek> dayOfWeeks;
    private Integer beforeHour;
    private Integer afterHour;
    private LocalDate fromDate;
    private Integer fromDateAfterHour;
    private LocalDate toDate;
    private Integer inXDays;
    private Integer inXMonths;
    private Integer inXWeeks;
    private Integer moreOrLessXDays;
    private Integer moreOrLessXMonths;
    private Integer moreOrLessXWeeks;
    private Boolean famillySearch;
    private Integer famillyReferencePatientId;
    private CopyOnWriteArrayList<XSearchPeriodResult> results = new CopyOnWriteArrayList();

    public ComplexSearchController() {
        this.professionnalGroups = new ArrayList<Integer>();
        this.professionnals = new ArrayList<XBaseProfessionnal>(4);
        this.sites = new ArrayList<XSite>(3);
        this.periodTypes = new ArrayList<XAppointmentPeriodType>(2);
        this.dayOfWeeks = new HashSet<DayOfWeek>(7);
        this.professionnalGroups = ListWithInterceptor.decorate(this.professionnalGroups, (Interceptor)new Interceptor(){

            public void modified() {
                PropertyListenerManager.firePropertyChanged((Object)ComplexSearchController.this, (int)0);
            }
        });
        this.professionnals = ListWithInterceptor.decorate(this.professionnals, (Interceptor)new Interceptor(){

            public void modified() {
                PropertyListenerManager.firePropertyChanged((Object)ComplexSearchController.this, (int)1);
            }
        });
        this.sites = ListWithInterceptor.decorate(this.sites, (Interceptor)new Interceptor(){

            public void modified() {
                PropertyListenerManager.firePropertyChanged((Object)ComplexSearchController.this, (int)2);
            }
        });
        this.periodTypes = ListWithInterceptor.decorate(this.periodTypes, (Interceptor)new Interceptor(){

            public void modified() {
                PropertyListenerManager.firePropertyChanged((Object)ComplexSearchController.this, (int)5);
            }
        });
        this.dayOfWeeks = SetWithInterceptor.decorate(this.dayOfWeeks, (Interceptor)new Interceptor(){

            public void modified() {
                PropertyListenerManager.firePropertyChanged((Object)ComplexSearchController.this, (int)6);
            }
        });
        this.fromDate = LocalDate.today();
        this.fromDateAfterHour = DateUtil.getMinutesFromMidnight();
    }

    public void reset() {
        this.professionnalGroups.clear();
        this.professionnals.clear();
        this.sites.clear();
        this.beforeHour = null;
        this.afterHour = null;
        this.periodTypes.clear();
        this.dayOfWeeks.clear();
        this.inXDays = null;
        this.inXMonths = null;
        this.inXWeeks = null;
        this.moreOrLessXDays = null;
        this.moreOrLessXMonths = null;
        this.moreOrLessXWeeks = null;
        this.fromDate = LocalDate.today();
        this.fromDateAfterHour = DateUtil.getMinutesFromMidnight();
        this.toDate = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)11);
        this.results.clear();
        PropertyListenerManager.firePropertyChanged((Object)this, (int)10);
    }

    public List<Integer> getProfessionnalGroups() {
        return this.professionnalGroups;
    }

    public List<XBaseProfessionnal> getProfessionnals() {
        return this.professionnals;
    }

    public List<XSite> getSites() {
        return this.sites;
    }

    public List<XAppointmentPeriodType> getPeriodTypes() {
        return this.periodTypes;
    }

    public Set<DayOfWeek> getDayOfWeeks() {
        return this.dayOfWeeks;
    }

    public Integer getBeforeHour() {
        return this.beforeHour;
    }

    public void setBeforeHour(Integer beforeHour) {
        this.beforeHour = beforeHour;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)3);
    }

    public Integer getAfterHour() {
        return this.afterHour;
    }

    public void setAfterHour(Integer afterHour) {
        this.afterHour = afterHour;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)3);
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
        this.inXDays = null;
        this.inXMonths = null;
        this.inXWeeks = null;
        this.moreOrLessXDays = null;
        this.moreOrLessXMonths = null;
        this.moreOrLessXWeeks = null;
        if (fromDate == null) {
            this.fromDateAfterHour = null;
        }
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
        this.inXDays = null;
        this.inXMonths = null;
        this.inXWeeks = null;
        this.moreOrLessXDays = null;
        this.moreOrLessXMonths = null;
        this.moreOrLessXWeeks = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    @Override
    public void searchAsync() {
        XSearchPeriodCriteria c = new XSearchPeriodCriteria();
        c.professionnalGroups = new ArrayList<Integer>(this.professionnalGroups);
        c.professionnals = new ArrayList(this.professionnals.size());
        for (XBaseProfessionnal xBaseProfessionnal : this.professionnals) {
            c.professionnals.add(xBaseProfessionnal.getId());
        }
        c.sites = new ArrayList(this.sites.size());
        for (XSite xSite : this.sites) {
            c.sites.add(xSite.getId());
        }
        c.periodTypes = new ArrayList(this.periodTypes.size());
        for (XAppointmentPeriodType xAppointmentPeriodType : this.periodTypes) {
            c.periodTypes.add(xAppointmentPeriodType.getId());
        }
        c.dayOfWeeks = new HashSet(this.dayOfWeeks.size());
        for (DayOfWeek dayOfWeek : this.dayOfWeeks) {
            c.dayOfWeeks.add(dayOfWeek.id);
        }
        c.beforeHour = this.beforeHour;
        c.afterHour = this.afterHour;
        if (this.moreOrLessXDays != null) {
            c.datePrecision = this.moreOrLessXDays;
        } else if (this.moreOrLessXWeeks != null) {
            c.datePrecision = this.moreOrLessXWeeks * 7;
        } else if (this.moreOrLessXMonths != null) {
            c.datePrecision = this.moreOrLessXMonths * 30;
        }
        if (this.fromDate != null) {
            c.fromDate = this.fromDate;
            c.fromDateAfterHour = this.fromDateAfterHour;
        } else if (this.inXDays != null) {
            c.fromDate = LocalDate.today().plusDay(this.inXDays.intValue());
        } else if (this.inXWeeks != null) {
            c.fromDate = LocalDate.today().plusDay(this.inXWeeks * 7);
        } else if (this.inXMonths != null) {
            c.fromDate = LocalDate.today().plusMonth(this.inXMonths.intValue());
        } else {
            c.fromDate = LocalDate.today();
            c.fromDateAfterHour = DateUtil.getMinutesFromMidnight();
        }
        c.toDate = this.toDate;
        c.famillySearch = this.famillySearch;
        c.famillyReferencePatientId = this.famillyReferencePatientId;
        JobCallback jobCallback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                List list = null;
                if (response != null) {
                    list = (List)response.getObj();
                }
                ComplexSearchController.this.results.clear();
                if (list != null) {
                    ComplexSearchController.this.results.addAll(list);
                }
                PropertyListenerManager.firePropertyChanged((Object)ComplexSearchController.this, (int)10);
            }

            public void exception(Exception e) {
                super.exception(e);
                ComplexSearchController.this.results.clear();
                PropertyListenerManager.firePropertyChanged((Object)ComplexSearchController.this, (int)10);
            }
        };
        try {
            AppointmentAccessorClient.getInstance().findAvailableAppointmentSpaces(c, this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)jobCallback);
        }
        catch (Exception exception) {
            jobCallback.kill();
        }
    }

    @Override
    public List<XSearchPeriodResult> getResult() {
        return new ArrayList<XSearchPeriodResult>(this.results);
    }

    public Integer getInXDays() {
        return this.inXDays;
    }

    public void setInXDays(Integer inXDays) {
        this.inXDays = inXDays;
        this.inXMonths = null;
        this.inXWeeks = null;
        this.fromDate = null;
        this.toDate = null;
        this.fromDateAfterHour = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public Integer getInXMonths() {
        return this.inXMonths;
    }

    public void setInXMonths(Integer inXMonths) {
        this.inXMonths = inXMonths;
        this.inXDays = null;
        this.inXWeeks = null;
        this.fromDate = null;
        this.toDate = null;
        this.fromDateAfterHour = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public Integer getInXWeeks() {
        return this.inXWeeks;
    }

    public void setInXWeeks(Integer inXWeeks) {
        this.inXWeeks = inXWeeks;
        this.inXDays = null;
        this.inXMonths = null;
        this.fromDate = null;
        this.toDate = null;
        this.fromDateAfterHour = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public Integer getMoreOrLessXDays() {
        return this.moreOrLessXDays;
    }

    public void setMoreOrLessXDays(Integer moreOrLessXDays) {
        this.moreOrLessXDays = moreOrLessXDays;
        this.moreOrLessXWeeks = null;
        this.moreOrLessXMonths = null;
        if (this.inXDays == null && this.inXWeeks == null && this.inXMonths == null) {
            this.inXDays = 0;
        }
        this.fromDate = null;
        this.toDate = null;
        this.fromDateAfterHour = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public Integer getMoreOrLessXMonths() {
        return this.moreOrLessXMonths;
    }

    public void setMoreOrLessXMonths(Integer moreOrLessXMonths) {
        this.moreOrLessXMonths = moreOrLessXMonths;
        this.moreOrLessXDays = null;
        this.moreOrLessXWeeks = null;
        this.fromDate = null;
        this.toDate = null;
        this.fromDateAfterHour = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public Integer getMoreOrLessXWeeks() {
        return this.moreOrLessXWeeks;
    }

    public void setMoreOrLessXWeeks(Integer moreOrLessXWeeks) {
        this.moreOrLessXWeeks = moreOrLessXWeeks;
        this.moreOrLessXDays = null;
        this.moreOrLessXMonths = null;
        this.fromDate = null;
        this.toDate = null;
        this.fromDateAfterHour = null;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public void setDayOfWeeks(Set<DayOfWeek> dayOfWeeks) {
        this.dayOfWeeks = dayOfWeeks;
    }

    public Integer getFromDateAfterHour() {
        return this.fromDateAfterHour;
    }

    public void setFromDateAfterHour(Integer fromDateAfterHour) {
        this.fromDateAfterHour = fromDateAfterHour;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)4);
    }

    public Boolean getFamillySearch() {
        return this.famillySearch;
    }

    public void setFamillySearch(Boolean famillySearch) {
        this.famillySearch = famillySearch;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)12);
    }

    public void setFamillyReferencePatientId(Integer idPatient) {
        this.famillyReferencePatientId = idPatient;
    }
}

