/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.preferences;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentTypeStatus;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.appointment.editor.preferences.ColorRow;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.MyMask;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.SimpleNumberText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.professionnal.ProfessionalBySiteCombo;
import ca.infodata.ofys.util.EnumWithValues;
import ca.infodata.util1.IPair;
import ca.infodata.util1.PredicateA;
import net.miginfocom.swt.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class AppointmentTypeListForm
extends ColorRow {
    private static final String CODE = Messages.getString((String)"CODE", (String[])new String[0]);
    private static final String FRANCAIS = Messages.getString((String)"FRANCAIS", (String[])new String[0]);
    private static final String ENGLISH = Messages.getString((String)"ENGLISH", (String[])new String[0]);
    private static final String ACTIF = Messages.getString((String)"ACTIF", (String[])new String[0]);
    private static final String COULEUR = Messages.getString((String)"COULEUR", (String[])new String[0]);
    private static final String DUREE_RDVS = Messages.getString((String)"DUREE", (String[])new String[0]);
    private static final String METTRE_0 = Messages.getString((String)"METTRE_0", (String[])new String[0]);
    private static final String PROFESSIONNEL = Messages.getString((String)"PROFESSIONNEL", (String[])new String[0]);
    private static final String BTN_ANNULER = Messages.getString((String)"APPOINTEMENT.BTN_ANNULER", (String[])new String[0]);
    private static final String SAUVEGARDER = Messages.getString((String)"SAUVEGARDER", (String[])new String[0]);
    private static final String ON_SITE = Messages.getString((String)"ON_SITE", (String[])new String[0]);
    private static final String TELMED = Messages.getString((String)"TELMED", (String[])new String[0]);
    private static final String BY_PHONE = Messages.getString((String)"BY_PHONE", (String[])new String[0]);
    private static final String NO_AUTO_COMM = Messages.getString((String)"NO_AUTO_COMM", (String[])new String[0]);
    private static final String NO_COMM = Messages.getString((String)"NO_COMM", (String[])new String[0]);
    private static final String IS_TODO = Messages.getString((String)"IS_TODO", (String[])new String[0]);
    private final MyMaskedText txtCode;
    private final SimpleNumberText txtDuree;
    private final MyText txtFrench;
    private final MyText txtEnglish;
    private final MyButton chkOnSite;
    private final MyButton chkTelmed;
    private final MyButton chkByPhone;
    private final MyButton chkNoAutoComm;
    private final MyButton chkNoComm;
    private final MyButton chkIsToDo;
    private final MyButton chkIsNotDeleted;
    private final MyButton btnSave;
    private final MyButton btnUndo;
    private final ProfessionalBySiteCombo cmbProfessional;
    private final MyText txtMessage;
    private final MyMaskedText txtSurvey1Q;
    private XAppointmentType type;
    private boolean modified;
    private final IBaseEditor editor;

    public AppointmentTypeListForm(IBaseEditor editor, Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (toolkit == null) {
            throw new NullPointerException("toolkit");
        }
        this.editor = editor;
        new MyLabel((Composite)this, COULEUR, 0, toolkit);
        this.cvsColor = this.createLabel(this, 2048, "");
        MyLabel lblCode = new MyLabel((Composite)this, CODE, 0, toolkit);
        this.txtCode = new MyMaskedText((Composite)this, 4, toolkit);
        this.txtCode.setMask(new MyMask("####", 16));
        MyLabel lblDuree = new MyLabel((Composite)this, DUREE_RDVS, 0, toolkit);
        this.txtDuree = new SimpleNumberText((Composite)this, 4, toolkit);
        this.txtDuree.getMask().setAllowNegative(false);
        this.txtDuree.getMask().setMaximum(600);
        ControlDecorator.decorateWithHelp((Control)this.txtDuree.getControl(), (String)METTRE_0);
        MyLabel lblFrench = new MyLabel((Composite)this, FRANCAIS, 0, toolkit);
        this.txtFrench = new MyText((Composite)this, null, 4, toolkit);
        this.txtFrench.setTextLimit(MyMasks.STANDARD_TEXT_LIMIT);
        new MyLabel((Composite)this, ENGLISH, 0, toolkit);
        this.txtEnglish = new MyText((Composite)this, null, 4, toolkit);
        this.txtEnglish.setTextLimit(MyMasks.STANDARD_TEXT_LIMIT);
        MyLabel lblMessage = new MyLabel((Composite)this, Messages.getString((String)"MESSAGE", (String[])new String[0]), 0, toolkit);
        this.txtMessage = new MyText((Composite)this, null, 66, toolkit);
        MyLabel lblSurvey1Q = new MyLabel((Composite)this, Messages.getString((String)"QUESTION_ID", (String[])new String[0]), 0, toolkit);
        this.txtSurvey1Q = new MyMaskedText((Composite)this, 0, toolkit);
        this.txtSurvey1Q.setMask(MyMasks.patientFacilityNumber);
        this.txtSurvey1Q.setToolTipText(Messages.getString((String)"QUESTIONNAIRE_ID_APT", (String[])new String[0]));
        MyLabel lblProfessional = new MyLabel((Composite)this, PROFESSIONNEL, 0, toolkit);
        this.cmbProfessional = new ProfessionalBySiteCombo((Composite)this, 65544, toolkit);
        final PredicateA displayPredicate = this.cmbProfessional.getDisplayPredicate();
        this.cmbProfessional.setDisplayPredicate((PredicateA)new PredicateA<IPair<XBaseProfessionnal, XSite>>(){

            public boolean evaluate(IPair<XBaseProfessionnal, XSite> e) {
                return e != null && displayPredicate.evaluate(e) && (e.getFirst() == null || ((XBaseProfessionnal)e.getFirst()).useAppointment);
            }
        });
        this.cmbProfessional.fill();
        this.chkOnSite = new MyButton((Composite)this, ON_SITE, 32, toolkit);
        this.chkTelmed = new MyButton((Composite)this, TELMED, 32, toolkit);
        this.chkByPhone = new MyButton((Composite)this, BY_PHONE, 32, toolkit);
        this.chkNoAutoComm = new MyButton((Composite)this, NO_AUTO_COMM, 32, toolkit);
        this.chkNoComm = new MyButton((Composite)this, NO_COMM, 32, toolkit);
        this.chkIsToDo = new MyButton((Composite)this, IS_TODO, 32, toolkit);
        this.chkIsNotDeleted = new MyButton((Composite)this, ACTIF, 32, toolkit);
        this.btnSave = new MyButton((Composite)this, SAUVEGARDER, 8, toolkit);
        this.btnSave.setImage(ResourceGetter.getImage((String)"images/save_edit16.gif"));
        this.btnUndo = new MyButton((Composite)this, BTN_ANNULER, 8, toolkit);
        this.btnUndo.setImage(ResourceGetter.getImage((String)"images/undo_edit16.gif"));
        EditorModifyListener modifiedListener = new EditorModifyListener((IBaseEditor2)editor){

            public void edited(Event e) {
                AppointmentTypeListForm.this.modified = true;
            }
        };
        EditorModifyListener modifiedTypeListener = new EditorModifyListener((IBaseEditor2)editor){

            public void edited(Event e) {
                AppointmentTypeListForm.this.modified = true;
                if (((MyButton)e.widget).getSelection()) {
                    if (e.widget.equals(AppointmentTypeListForm.this.chkTelmed)) {
                        AppointmentTypeListForm.this.chkOnSite.setSelection(false);
                        AppointmentTypeListForm.this.chkByPhone.setSelection(false);
                    } else if (e.widget.equals(AppointmentTypeListForm.this.chkByPhone)) {
                        AppointmentTypeListForm.this.chkOnSite.setSelection(false);
                        AppointmentTypeListForm.this.chkTelmed.setSelection(false);
                    } else if (e.widget.equals(AppointmentTypeListForm.this.chkOnSite)) {
                        AppointmentTypeListForm.this.chkByPhone.setSelection(false);
                        AppointmentTypeListForm.this.chkTelmed.setSelection(false);
                    } else if (e.widget.equals(AppointmentTypeListForm.this.chkIsToDo)) {
                        AppointmentTypeListForm.this.chkOnSite.setSelection(false);
                        AppointmentTypeListForm.this.chkByPhone.setSelection(false);
                        AppointmentTypeListForm.this.chkTelmed.setSelection(false);
                        AppointmentTypeListForm.this.chkNoAutoComm.setSelection(false);
                        AppointmentTypeListForm.this.chkNoComm.setSelection(false);
                    } else if (e.widget.equals(AppointmentTypeListForm.this.chkNoComm)) {
                        AppointmentTypeListForm.this.chkNoAutoComm.setSelection(false);
                    } else if (e.widget.equals(AppointmentTypeListForm.this.chkNoAutoComm)) {
                        AppointmentTypeListForm.this.chkNoComm.setSelection(false);
                    }
                }
            }

            private void checkOnSitePrn() {
                if (!(AppointmentTypeListForm.this.chkOnSite.getSelection() || AppointmentTypeListForm.this.chkTelmed.getSelection() || AppointmentTypeListForm.this.chkByPhone.getSelection() || AppointmentTypeListForm.this.chkIsToDo.getSelection())) {
                    AppointmentTypeListForm.this.chkOnSite.setSelection(true);
                }
            }
        };
        this.txtCode.addModifyListener((ModifyListener)modifiedListener);
        this.txtDuree.addModifyListener((ModifyListener)modifiedListener);
        this.txtEnglish.addModifyListener((ModifyListener)modifiedListener);
        this.txtFrench.addModifyListener((ModifyListener)modifiedListener);
        this.txtMessage.addModifyListener((ModifyListener)modifiedListener);
        this.txtSurvey1Q.addModifyListener((ModifyListener)modifiedListener);
        this.chkOnSite.addSelectionListener((SelectionListener)modifiedTypeListener);
        this.chkTelmed.addSelectionListener((SelectionListener)modifiedTypeListener);
        this.chkByPhone.addSelectionListener((SelectionListener)modifiedTypeListener);
        this.chkNoAutoComm.addSelectionListener((SelectionListener)modifiedTypeListener);
        this.chkNoComm.addSelectionListener((SelectionListener)modifiedTypeListener);
        this.chkIsToDo.addSelectionListener((SelectionListener)modifiedTypeListener);
        this.chkIsNotDeleted.addSelectionListener((SelectionListener)modifiedListener);
        this.cmbProfessional.addListener(24, (Listener)modifiedListener);
        this.cvsColor.addMouseListener((MouseListener)new EditorModifyListener((IBaseEditor2)editor, 3){

            public void edited(Event e) {
                AppointmentTypeListForm.this.changeColor();
                if (AppointmentTypeListForm.this.type != null && AppointmentTypeListForm.this.cvsColor.getData("rgb") != null) {
                    RGB rgb = (RGB)AppointmentTypeListForm.this.cvsColor.getData("rgb");
                    AppointmentTypeListForm.this.type.setColor(new int[]{rgb.red, rgb.green, rgb.blue});
                    AppointmentTypeListForm.this.modified = true;
                }
                AppointmentTypeListForm.this.cvsColor.removePaintListener(AppointmentTypeListForm.this.drawSelectedRect);
                AppointmentTypeListForm.this.cvsColor.addPaintListener(AppointmentTypeListForm.this.drawRect);
                AppointmentTypeListForm.this.cvsColor.redraw();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)AppointmentTypeListForm.this.color);
                AppointmentTypeListForm.this.cursor.dispose();
            }
        });
        this.txtDuree.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AppointmentTypeListForm.this.txtDuree.selectAll();
            }
        });
        this.setLayout((Layout)new MigLayout("", "[r]10[l][][]"));
        this.cvsColor.setLayoutData((Object)"w 15!, h 15!");
        lblCode.setLayoutData((Object)"newline");
        this.txtCode.setLayoutData((Object)"growx");
        lblDuree.setLayoutData((Object)"newline");
        this.txtDuree.setLayoutData((Object)"growx, spanx 2");
        lblFrench.setLayoutData((Object)"newline");
        this.txtFrench.setLayoutData((Object)"growx, spanx 2, split 5");
        this.txtEnglish.setLayoutData((Object)"growx");
        lblMessage.setLayoutData((Object)"newline");
        this.txtMessage.setLayoutData((Object)"growx, growy, spanx 2, h 50!");
        lblSurvey1Q.setLayoutData((Object)"newline");
        this.txtSurvey1Q.setLayoutData((Object)"growx, spanx 2");
        lblProfessional.setLayoutData((Object)"newline");
        this.cmbProfessional.getControl().setLayoutData((Object)"growx");
        this.chkOnSite.setLayoutData((Object)"newline, skip");
        this.chkTelmed.setLayoutData((Object)"newline, skip");
        this.chkByPhone.setLayoutData((Object)"newline, skip");
        this.chkNoAutoComm.setLayoutData((Object)"newline, skip");
        this.chkNoComm.setLayoutData((Object)"newline, skip");
        this.chkIsToDo.setLayoutData((Object)"newline, skip");
        this.chkIsNotDeleted.setLayoutData((Object)"newline, skip");
        int dim = LibPlugin.ON_MAC ? 24 : 24;
        this.btnSave.setLayoutData((Object)("id save_edit, pos 1al 0al, w " + dim + "!, h " + dim + "!"));
        this.btnUndo.setLayoutData((Object)("id undo_edit, pos 1al save_edit.y2+5, w " + dim + "!, h " + dim + "!"));
    }

    public void undo() {
        this.showDataObject();
        this.modified = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void save() {
        if (this.type != null && this.modified) {
            RGB rgb = this.cvsColor.getBackground().getRGB();
            this.type.setColor(new int[]{rgb.red, rgb.green, rgb.blue});
            this.type.setCode(this.txtCode.getText());
            this.type.setFrench(this.txtFrench.getText());
            this.type.setEnglish(this.txtEnglish.getText());
            this.type.setProfessionnal(this.cmbProfessional.getSelection() == null ? null : this.cmbProfessional.getSelection().getId());
            int typeStatus = (this.chkOnSite.getSelection() ? XAppointmentTypeStatus.ON_SITE.value : 0) | (this.chkTelmed.getSelection() ? XAppointmentTypeStatus.TELMED.value : 0) | (this.chkByPhone.getSelection() ? XAppointmentTypeStatus.BY_PHONE.value : 0) | (this.chkNoAutoComm.getSelection() ? XAppointmentTypeStatus.NO_AUTO_COMM.value : 0) | (this.chkNoComm.getSelection() ? XAppointmentTypeStatus.NO_COMM.value : 0) | (this.chkIsToDo.getSelection() ? XAppointmentTypeStatus.IS_TODO.value : 0);
            this.type.setStatus(EnumWithValues.fromSet(XAppointmentTypeStatus.class, (Integer)typeStatus));
            this.type.setIsDeleted(Boolean.valueOf(!this.chkIsNotDeleted.getSelection()));
            this.type.setDuree(Short.valueOf(this.txtDuree.getNumber().shortValue()));
            this.type.setEspanol(this.txtFrench.getText());
            this.type.setMessage(this.txtMessage.getText().trim());
            try {
                this.type.setSurvey1Q(StringUtils.isBlank((String)this.txtSurvey1Q.getText()) ? null : Integer.valueOf(Integer.parseInt(this.txtSurvey1Q.getText().trim())));
            }
            catch (NumberFormatException numberFormatException) {
                this.type.setSurvey1Q(null);
            }
        }
    }

    public XAppointmentType getType() {
        return this.type;
    }

    public void setType(XAppointmentType type) {
        this.type = type;
        this.showDataObject();
        this.modified = false;
    }

    public void showDataObject() {
        RGB typeColor = this.getTypeColor();
        if (this.color == null) {
            this.color = ResourceGetter.getColor((RGB)typeColor);
        } else if (!typeColor.equals((Object)this.color.getRGB())) {
            ResourceGetter.dispose((Object)this.color);
            this.color = ResourceGetter.getColor((RGB)typeColor);
        }
        this.cvsColor.setBackground(this.color);
        this.cvsColor.redraw();
        if (this.type != null) {
            this.txtCode.setRawText(this.type.getCode());
            this.txtDuree.setRawText(this.type.getDuree().toString());
            this.txtDuree.setEnabled(!Boolean.TRUE.equals(this.type.getIsDefault()));
            this.txtFrench.setText(this.type.getFrench());
            this.txtEnglish.setText(this.type.getEnglish());
            this.cmbProfessional.select(PersonUiPlugin.getDefault().getBaseProfessionnal(this.type.getProfessionnal()));
            this.cmbProfessional.setEnabled(!Boolean.TRUE.equals(this.type.getIsDefault()));
            this.chkOnSite.setSelection(this.type.getStatus().contains(XAppointmentTypeStatus.ON_SITE));
            this.chkTelmed.setSelection(this.type.getStatus().contains(XAppointmentTypeStatus.TELMED));
            this.chkByPhone.setSelection(this.type.getStatus().contains(XAppointmentTypeStatus.BY_PHONE));
            this.chkNoAutoComm.setSelection(this.type.getStatus().contains(XAppointmentTypeStatus.NO_AUTO_COMM));
            this.chkNoComm.setSelection(this.type.getStatus().contains(XAppointmentTypeStatus.NO_COMM));
            this.chkIsToDo.setSelection(this.type.getStatus().contains(XAppointmentTypeStatus.IS_TODO));
            this.chkIsNotDeleted.setSelection(this.type.getIsDeleted() == false);
            this.chkIsNotDeleted.setEnabled(!Boolean.TRUE.equals(this.type.getIsDefault()));
            this.txtMessage.setText(this.type.getMessage());
            this.txtSurvey1Q.setText(this.type.getSurvey1Q() == null ? "" : this.type.getSurvey1Q().toString());
        }
    }

    private RGB getTypeColor() {
        boolean isTColorInvalid;
        int[] tcolor = this.type == null ? null : this.type.getColor();
        boolean bl = isTColorInvalid = tcolor == null || tcolor.length != 3;
        if (isTColorInvalid) {
            return new RGB(255, 255, 255);
        }
        return new RGB(tcolor[0], tcolor[1], tcolor[2]);
    }

    public Label getCvsColor() {
        return this.cvsColor;
    }

    public MyButton getBtnSave() {
        return this.btnSave;
    }

    public MyButton getBtnUndo() {
        return this.btnUndo;
    }
}

