/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.preferences;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.ui.appointment.editor.preferences.ColorRow;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.MyMasks;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class AppointmentPeriodTypeControl
extends ColorRow {
    private MyButton btnCanHaveAppointment;
    private MyText code;
    private MyText french;
    private MyText english;
    private MyButton chkActive;
    private MyButton btnDelete;
    private XAppointmentPeriodType type;
    protected boolean ignore;
    private final IBaseEditor editor;

    public AppointmentPeriodTypeControl(IBaseEditor editor, Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.editor = editor;
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (toolkit == null) {
            throw new NullPointerException("toolkit");
        }
        this.cvsColor = this.createLabel(parent, 2048, "");
        this.btnCanHaveAppointment = new MyButton(parent, null, 32, toolkit);
        this.code = new MyText(parent, null, 0, toolkit);
        this.code.setTextLimit(MyMasks.SMALL_TEXT_LIMIT);
        this.french = new MyText(parent, null, 0, toolkit);
        this.french.setTextLimit(MyMasks.STANDARD_TEXT_LIMIT);
        this.english = new MyText(parent, null, 0, toolkit);
        this.english.setTextLimit(MyMasks.STANDARD_TEXT_LIMIT);
        this.chkActive = new MyButton(parent, null, 32, toolkit);
        this.btnDelete = new MyButton(parent, null, 8, toolkit);
        this.btnDelete.setImage(ResourceGetter.getImage((String)"images/delete_edit.gif"));
        this.btnDelete.setToolTipText(Messages.getString((String)"SUPPRIMER", (String[])new String[0]));
        this.cvsColor.addMouseListener((MouseListener)new EditorModifyListener((IBaseEditor2)editor, 3){

            public void edited(Event e) {
                if (AppointmentPeriodTypeControl.this.type != null && !AppointmentPeriodTypeControl.this.ignore) {
                    AppointmentPeriodTypeControl.this.changeColor();
                    if (AppointmentPeriodTypeControl.this.type != null && AppointmentPeriodTypeControl.this.cvsColor.getData("rgb") != null) {
                        RGB rgb = (RGB)AppointmentPeriodTypeControl.this.cvsColor.getData("rgb");
                        AppointmentPeriodTypeControl.this.type.setColor(new int[]{rgb.red, rgb.green, rgb.blue});
                    }
                    AppointmentPeriodTypeControl.this.cvsColor.removePaintListener(AppointmentPeriodTypeControl.this.drawSelectedRect);
                    AppointmentPeriodTypeControl.this.cvsColor.addPaintListener(AppointmentPeriodTypeControl.this.drawRect);
                    AppointmentPeriodTypeControl.this.cvsColor.redraw();
                }
            }
        });
        this.code.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)editor, 24){

            public void edited(Event e) {
                if (AppointmentPeriodTypeControl.this.type != null && !AppointmentPeriodTypeControl.this.ignore) {
                    AppointmentPeriodTypeControl.this.type.setCode(AppointmentPeriodTypeControl.this.code.getText());
                }
            }
        });
        this.french.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)editor, 24){

            public void edited(Event e) {
                if (AppointmentPeriodTypeControl.this.type != null && !AppointmentPeriodTypeControl.this.ignore) {
                    AppointmentPeriodTypeControl.this.type.setFrench(AppointmentPeriodTypeControl.this.french.getText());
                    AppointmentPeriodTypeControl.this.type.setSpanish(AppointmentPeriodTypeControl.this.french.getText());
                }
            }
        });
        this.english.addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)editor, 24){

            public void edited(Event e) {
                if (AppointmentPeriodTypeControl.this.type != null && !AppointmentPeriodTypeControl.this.ignore) {
                    AppointmentPeriodTypeControl.this.type.setEnglish(AppointmentPeriodTypeControl.this.english.getText());
                }
            }
        });
        this.btnCanHaveAppointment.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)editor, 13){

            public void edited(Event e) {
                if (AppointmentPeriodTypeControl.this.type != null && !AppointmentPeriodTypeControl.this.ignore) {
                    AppointmentPeriodTypeControl.this.type.setCanHaveAppointment(Boolean.valueOf(AppointmentPeriodTypeControl.this.btnCanHaveAppointment.getSelection()));
                }
            }
        });
        this.chkActive.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)editor, 13){

            public void edited(Event e) {
                if (AppointmentPeriodTypeControl.this.type != null && !AppointmentPeriodTypeControl.this.ignore) {
                    AppointmentPeriodTypeControl.this.type.setIsDeleted(Boolean.valueOf(!AppointmentPeriodTypeControl.this.chkActive.getSelection()));
                    AppointmentPeriodTypeControl.this.showDataObject();
                }
            }
        });
        this.btnDelete.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)editor, 13){

            public void edited(Event e) {
                if (AppointmentPeriodTypeControl.this.type != null && !AppointmentPeriodTypeControl.this.ignore) {
                    AppointmentPeriodTypeControl.this.type.setIsDeleted(Boolean.valueOf(true));
                    AppointmentPeriodTypeControl.this.showDataObject();
                }
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ResourceGetter.dispose((Object)AppointmentPeriodTypeControl.this.color);
                AppointmentPeriodTypeControl.this.cursor.dispose();
            }
        });
    }

    public XAppointmentPeriodType getType() {
        return this.type;
    }

    public void setType(XAppointmentPeriodType type) {
        this.type = type;
        this.showDataObject();
    }

    public void showDataObject() {
        this.ignore = true;
        boolean enabled = this.type != null;
        RGB typeColor = this.getTypeColor();
        if (this.color == null) {
            this.color = ResourceGetter.getColor((RGB)typeColor);
        } else if (!typeColor.equals((Object)this.color.getRGB())) {
            ResourceGetter.dispose((Object)this.color);
            this.color = ResourceGetter.getColor((RGB)typeColor);
        }
        this.cvsColor.setBackground(this.color);
        this.cvsColor.setEnabled(enabled);
        if (this.type != null) {
            this.btnCanHaveAppointment.setSelection(this.type.getCanHaveAppointment().booleanValue());
            this.code.setText(this.type.getCode());
            this.french.setText(this.type.getFrench());
            this.english.setText(this.type.getEnglish());
            this.chkActive.setSelection(Boolean.FALSE.equals(this.type.getIsDeleted()));
            this.btnDelete.setVisible(this.type.isNewOrNewUpdated());
            this.chkActive.setEnabled(Boolean.FALSE.equals(this.type.getIsDefault()));
        } else {
            this.btnCanHaveAppointment.setSelection(false);
            this.code.setText(null);
            this.french.setText(null);
            this.english.setText(null);
            this.chkActive.setSelection(false);
            this.btnDelete.setVisible(false);
            this.chkActive.setEnabled(false);
        }
        this.btnCanHaveAppointment.setEnabled(enabled);
        this.code.setEnabled(enabled);
        this.french.setEnabled(enabled);
        this.english.setEnabled(enabled);
        this.btnDelete.setEnabled(enabled);
        this.ignore = false;
    }

    private RGB getTypeColor() {
        return this.getTypeColor(this.type == null ? null : this.type.getColor());
    }

    public Label getCvsColor() {
        return this.cvsColor;
    }

    public MyButton getBtnCanHaveAppointment() {
        return this.btnCanHaveAppointment;
    }

    public MyText getFrench() {
        return this.french;
    }

    public MyText getEnglish() {
        return this.english;
    }

    public MyText getCode() {
        return this.code;
    }

    public MyButton getBtnDelete() {
        return this.btnDelete;
    }

    public MyButton getChkActive() {
        return this.chkActive;
    }

    public void dispose() {
        if (!this.cvsColor.isDisposed()) {
            this.cvsColor.dispose();
        }
        if (!this.btnCanHaveAppointment.isDisposed()) {
            this.btnCanHaveAppointment.dispose();
        }
        if (!this.code.isDisposed()) {
            this.code.dispose();
        }
        if (!this.french.isDisposed()) {
            this.french.dispose();
        }
        if (!this.english.isDisposed()) {
            this.english.dispose();
        }
        if (!this.btnDelete.isDisposed()) {
            this.btnDelete.dispose();
        }
        if (!this.chkActive.isDisposed()) {
            this.chkActive.dispose();
        }
    }
}

