/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.multiprof;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.appointment.control.AppointmentFormatField;
import ca.infodata.ofys.ui.appointment.control.AppointmentFormatterSettingsBased;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AppointmentMultiProfPreferencesDialog {
    private static final String PREFERENCES = Messages.getString((String)"PREFERENCES", (String[])new String[0]);
    private static final String AFFICHER_LES_RENDEZ_VOUS_SUPPRIMES = Messages.getString((String)"AFFICHER_LES_RENDEZ_VOUS_SUPPRIMES", (String[])new String[0]);
    private static final String AFFICHER_LES_RENDEZ_VOUS_ANNULES = Messages.getString((String)"AFFICHER_LES_RENDEZ_VOUS_ANNULES", (String[])new String[0]);

    public AppointmentMultiProfPreferencesDialog(Shell parent) {
        final Shell dialog = new Shell(parent, 65600);
        dialog.setText(PREFERENCES);
        dialog.setLayout((Layout)new FillLayout());
        Composite cStats = new Composite((Composite)dialog, 0);
        Label hseparator = new Label(cStats, 258);
        final Button btnShowDeleted = new Button(cStats, 32);
        btnShowDeleted.setText(AFFICHER_LES_RENDEZ_VOUS_SUPPRIMES);
        btnShowDeleted.setSelection(PreferencesSettings.getInstance().getBoolean("appointment/show_deleted_appointment"));
        btnShowDeleted.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesSettings.getInstance().put("appointment/show_deleted_appointment", btnShowDeleted.getSelection());
            }
        });
        final Button btnShowCanceled = new Button(cStats, 32);
        btnShowCanceled.setText(AFFICHER_LES_RENDEZ_VOUS_ANNULES);
        btnShowCanceled.setSelection(PreferencesSettings.getInstance().getBoolean("appointment/show_canceled_appointment"));
        btnShowCanceled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesSettings.getInstance().put("appointment/show_canceled_appointment", btnShowCanceled.getSelection());
            }
        });
        MyLabel lblAppointmentFormat = new MyLabel(cStats, "Format du texte du rendez-vous", 64);
        MyLabel lblAppointmentFormatWarning = new MyLabel(cStats, "de la vue multi-professionnels seulement", 64);
        lblAppointmentFormatWarning.setForeground(ResourceGetter.getColor((int)255, (int)0, (int)0));
        Table tblAppointmentFormat = this.createAppointmentFormatControl(cStats);
        Button btnOk = new Button(cStats, 8);
        btnOk.setText("Fermer");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                dialog.close();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        cStats.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        lblAppointmentFormat.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblAppointmentFormat.getControl());
        data.left = new FormAttachment(0);
        lblAppointmentFormatWarning.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblAppointmentFormatWarning.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, -120);
        tblAppointmentFormat.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)tblAppointmentFormat, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100);
        hseparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)hseparator, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100);
        btnShowDeleted.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)btnShowDeleted, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100);
        btnShowCanceled.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100);
        data.right = new FormAttachment(100);
        data.width = UI.STANDARD_BUTTON_WIDTH;
        btnOk.setLayoutData((Object)data);
        dialog.setSize(500, 600);
        UI.centerComposite((Composite)dialog, (Composite)parent);
        dialog.open();
    }

    private Table createAppointmentFormatControl(Composite cStats) {
        final Table table = new Table(cStats, 2592);
        EnumSet<AppointmentFormatField> list = AppointmentFormatterSettingsBased.getFormatFromSettings("appointment/multi_prof_appointment_format_pref");
        ArrayList<AppointmentFormatField> fields = new ArrayList<AppointmentFormatField>();
        fields.add(AppointmentFormatField.TIME);
        fields.add(AppointmentFormatField.DURATION);
        fields.add(AppointmentFormatField.NOTE);
        fields.add(AppointmentFormatField.STATUS);
        fields.add(AppointmentFormatField.PATIENT_STATUS);
        fields.add(AppointmentFormatField.PATIENT_NAME);
        fields.add(AppointmentFormatField.PATIENT_NAME_BIRTHDATE_SEX);
        fields.add(AppointmentFormatField.PATIENT_NAM);
        fields.add(AppointmentFormatField.PATIENT_NAM_EXP);
        fields.add(AppointmentFormatField.PATIENT_NO);
        fields.add(AppointmentFormatField.PATIENT_PHONE1);
        fields.add(AppointmentFormatField.PATIENT_PHONE2);
        fields.add(AppointmentFormatField.PATIENT_STATUS_B2B);
        fields.add(AppointmentFormatField.PATIENT_TREATING_PROF);
        for (AppointmentFormatField field : fields) {
            TableItem item = new TableItem(table, 0);
            item.setData((Object)field);
            item.setChecked(list.contains((Object)field));
            item.setText(field.toString());
        }
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    ArrayList<AppointmentFormatField> list2 = new ArrayList<AppointmentFormatField>();
                    TableItem[] tableItemArray = table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked()) {
                            list2.add((AppointmentFormatField)((Object)item.getData()));
                        }
                        ++n2;
                    }
                    AppointmentFormatterSettingsBased.setFormatToSettings("appointment/multi_prof_appointment_format_pref", list2);
                }
            }
        });
        return table;
    }
}

