/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.control.AppointmentFormatField;
import ca.infodata.ofys.ui.appointment.control.AppointmentFormatterSettingsBased;
import ca.infodata.ofys.ui.appointment.control.StatisticCellRenderer;
import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.controls.FontAwareLabel;
import ca.infodata.ofys.ui.controls.FontAwareShell;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.library.UI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AppointmentPreferencesDialog {
    private static final String PREFERENCES = Messages.getString((String)"PREFERENCES", (String[])new String[0]);
    private static final String TYPES_DE_PERIODES_A_INCLURE = Messages.getString((String)"TYPE_DE_PERIODES_A_INCLURE", (String[])new String[0]);
    private static final String INCLURE_DES_LES_RENDEZ_VOUS_HORS_PERIODE = Messages.getString((String)"INCLURE_DES_LES_RENDEZ_VOUS_HORS_PERIODE", (String[])new String[0]);
    private static final String INCLURE_LES_RENDEZ_VOUS_EN_OVERBOOKING = Messages.getString((String)"INCLURE_LES_RENDEZ_VOUS_EN_OVERBOOKING", (String[])new String[0]);
    private static final String AFFICHER_LES_RENDEZ_VOUS_SUPPRIMES = Messages.getString((String)"AFFICHER_LES_RENDEZ_VOUS_SUPPRIMES", (String[])new String[0]);
    private static final String AFFICHER_LES_RENDEZ_VOUS_ANNULES = Messages.getString((String)"AFFICHER_LES_RENDEZ_VOUS_ANNULES", (String[])new String[0]);
    private static final String CALCUL_STAT_CAL = Messages.getString((String)"CALCUL_STAT_CAL", (String[])new String[0]);
    private static final String FORMAT_TEXT_RDV = Messages.getString((String)"FORMAT_TEXT_RDV", (String[])new String[0]);
    private static final String FERMER = Messages.getString((String)"FERMER", (String[])new String[0]);

    public AppointmentPreferencesDialog(Shell parent) {
        FontAwareShell dialog = new FontAwareShell(parent, 65616);
        dialog.setText(PREFERENCES);
        dialog.setLayout((Layout)new FillLayout());
        Composite cStats = new Composite((Composite)dialog, 0);
        FontAwareLabel lblCalendarStats = new FontAwareLabel(cStats, 64);
        lblCalendarStats.setText(CALCUL_STAT_CAL);
        lblCalendarStats.setFont(0, 1);
        FontAwareLabel label = new FontAwareLabel(cStats, 64);
        label.setText(TYPES_DE_PERIODES_A_INCLURE);
        int[] excludedPeriodTypesPref = StatisticCellRenderer.getExcludedPeriodTypesPref();
        FontAwareTable tblPeriodType = new FontAwareTable(cStats, 2592);
        final List<XAppointmentPeriodType> types = AppointmentPlugin.getDefault().getPeriodTypes();
        for (XAppointmentPeriodType type : types) {
            TableItem item = new TableItem((Table)tblPeriodType, 0);
            item.setData((Object)type);
            item.setChecked(Arrays.binarySearch(excludedPeriodTypesPref, type.getId()) < 0);
            item.setText(String.valueOf(type.isActive() ? "" : "*") + type.getText());
        }
        tblPeriodType.addListener(13, new Listener((Table)tblPeriodType){
            private final /* synthetic */ Table val$tblPeriodType;
            {
                this.val$tblPeriodType = table;
            }

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    IntArrayList list = new IntArrayList(types.size());
                    TableItem[] tableItemArray = this.val$tblPeriodType.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (!item.getChecked()) {
                            list.add(((XAppointmentPeriodType)item.getData()).getId().intValue());
                        }
                        ++n2;
                    }
                    StatisticCellRenderer.setExcludedPeriodTypesPref(list);
                }
            }
        });
        FontAwareButton btnIncludeAppointmentOutsidePeriods = new FontAwareButton(cStats, 96);
        btnIncludeAppointmentOutsidePeriods.setText(INCLURE_DES_LES_RENDEZ_VOUS_HORS_PERIODE);
        btnIncludeAppointmentOutsidePeriods.setSelection(StatisticCellRenderer.getIncludeAppointmentOutsidePeriod());
        btnIncludeAppointmentOutsidePeriods.addSelectionListener((SelectionListener)new SelectionAdapter((Button)btnIncludeAppointmentOutsidePeriods){
            private final /* synthetic */ Button val$btnIncludeAppointmentOutsidePeriods;
            {
                this.val$btnIncludeAppointmentOutsidePeriods = button;
            }

            public void widgetSelected(SelectionEvent e) {
                StatisticCellRenderer.setIncludeAppointmentOutsidePeriod(this.val$btnIncludeAppointmentOutsidePeriods.getSelection());
            }
        });
        FontAwareButton btnIncludeOverbooking = new FontAwareButton(cStats, 96);
        btnIncludeOverbooking.setText(INCLURE_LES_RENDEZ_VOUS_EN_OVERBOOKING);
        btnIncludeOverbooking.setSelection(StatisticCellRenderer.getIncludeOverbooking());
        btnIncludeOverbooking.addSelectionListener((SelectionListener)new SelectionAdapter((Button)btnIncludeOverbooking){
            private final /* synthetic */ Button val$btnIncludeOverbooking;
            {
                this.val$btnIncludeOverbooking = button;
            }

            public void widgetSelected(SelectionEvent e) {
                StatisticCellRenderer.setIncludeOverbooking(this.val$btnIncludeOverbooking.getSelection());
            }
        });
        Label vseparator = new Label(cStats, 514);
        Label hseparator = new Label(cStats, 258);
        FontAwareButton btnShowDeleted = new FontAwareButton(cStats, 32);
        btnShowDeleted.setText(AFFICHER_LES_RENDEZ_VOUS_SUPPRIMES);
        btnShowDeleted.setSelection(PreferencesSettings.getInstance().getBoolean("appointment/show_deleted_appointment"));
        btnShowDeleted.addSelectionListener((SelectionListener)new SelectionAdapter((Button)btnShowDeleted){
            private final /* synthetic */ Button val$btnShowDeleted;
            {
                this.val$btnShowDeleted = button;
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesSettings.getInstance().put("appointment/show_deleted_appointment", this.val$btnShowDeleted.getSelection());
            }
        });
        FontAwareButton btnShowCanceled = new FontAwareButton(cStats, 32);
        btnShowCanceled.setText(AFFICHER_LES_RENDEZ_VOUS_ANNULES);
        btnShowCanceled.setSelection(PreferencesSettings.getInstance().getBoolean("appointment/show_canceled_appointment"));
        btnShowCanceled.addSelectionListener((SelectionListener)new SelectionAdapter((Button)btnShowCanceled){
            private final /* synthetic */ Button val$btnShowCanceled;
            {
                this.val$btnShowCanceled = button;
            }

            public void widgetSelected(SelectionEvent e) {
                PreferencesSettings.getInstance().put("appointment/show_canceled_appointment", this.val$btnShowCanceled.getSelection());
            }
        });
        MyLabel lblAppointmentFormat = new MyLabel(cStats, FORMAT_TEXT_RDV, 64);
        lblAppointmentFormat.setFont(0, 1);
        Table tblAppointmentFormat = this.createAppointmentFormatControl(cStats);
        FontAwareButton btnOk = new FontAwareButton(cStats, 8);
        btnOk.setText(FERMER);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter((Shell)dialog){
            private final /* synthetic */ Shell val$dialog;
            {
                this.val$dialog = shell;
            }

            public void widgetSelected(SelectionEvent e) {
                this.val$dialog.close();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        cStats.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        lblCalendarStats.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)lblCalendarStats, 10);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)label);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        data.bottom = new FormAttachment((Control)btnIncludeAppointmentOutsidePeriods);
        tblPeriodType.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50);
        data.bottom = new FormAttachment((Control)btnIncludeOverbooking);
        btnIncludeAppointmentOutsidePeriods.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.bottom = new FormAttachment(100, -120);
        btnIncludeOverbooking.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)vseparator);
        lblAppointmentFormat.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(50, 5);
        data.bottom = new FormAttachment((Control)btnIncludeOverbooking, 0, 1024);
        vseparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)tblPeriodType, 0, 128);
        data.left = new FormAttachment((Control)vseparator, 5);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, -120);
        tblAppointmentFormat.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)vseparator, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100);
        hseparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)hseparator, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100);
        btnShowDeleted.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)btnShowDeleted, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100);
        btnShowCanceled.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        data.width = UI.STANDARD_BUTTON_WIDTH;
        btnOk.setLayoutData((Object)data);
        dialog.setSize(700, 540);
        UI.centerComposite((Composite)dialog, (Composite)parent);
        dialog.open();
    }

    private Table createAppointmentFormatControl(Composite cStats) {
        FontAwareTable table = new FontAwareTable(cStats, 2592);
        EnumSet<AppointmentFormatField> list = AppointmentFormatterSettingsBased.getFormatFromSettings("appointment/appointment_format_pref");
        ArrayList<AppointmentFormatField> fields = new ArrayList<AppointmentFormatField>();
        fields.add(AppointmentFormatField.TIME);
        fields.add(AppointmentFormatField.DURATION);
        fields.add(AppointmentFormatField.NOTE);
        fields.add(AppointmentFormatField.STATUS);
        fields.add(AppointmentFormatField.PATIENT_STATUS);
        fields.add(AppointmentFormatField.PATIENT_NAME);
        fields.add(AppointmentFormatField.PATIENT_NAME_BIRTHDATE_SEX);
        fields.add(AppointmentFormatField.PATIENT_NAM);
        fields.add(AppointmentFormatField.PATIENT_NAM_EXP);
        fields.add(AppointmentFormatField.PATIENT_NO);
        fields.add(AppointmentFormatField.PATIENT_PHONE1);
        fields.add(AppointmentFormatField.PATIENT_PHONE2);
        fields.add(AppointmentFormatField.PATIENT_STATUS_B2B);
        fields.add(AppointmentFormatField.PATIENT_TREATING_PROF);
        for (AppointmentFormatField field : fields) {
            TableItem item = new TableItem((Table)table, 0);
            item.setData((Object)field);
            item.setChecked(list.contains((Object)field));
            item.setText(field.toString());
        }
        table.addListener(13, new Listener((Table)table){
            private final /* synthetic */ Table val$table;
            {
                this.val$table = table;
            }

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    ArrayList<AppointmentFormatField> list2 = new ArrayList<AppointmentFormatField>();
                    TableItem[] tableItemArray = this.val$table.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked()) {
                            list2.add((AppointmentFormatField)((Object)item.getData()));
                        }
                        ++n2;
                    }
                    AppointmentFormatterSettingsBased.setFormatToSettings("appointment/appointment_format_pref", list2);
                }
            }
        });
        return table;
    }
}

