/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.control.AppointmentThermometerControl;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.control.SmallAppointmentDateControl;
import ca.infodata.ofys.ui.appointment.editor.AppointmentMainEditorInput;
import ca.infodata.ofys.ui.appointment.editor.AppointmentSelection;
import ca.infodata.ofys.ui.appointment.editor.BaseAppointmentMainEditor;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerListener;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.appointment.editor.model2.Model;
import ca.infodata.ofys.ui.controls.IUserInteractionHelper;
import ca.infodata.ofys.ui.controls.UserInteractionHelper;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.patient.AdHocPatient;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.swt.layout.MyFormAttachment;
import ca.infodata.swt.layout.MyFormData;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.mb.listeners.GenListenerManager;

public final class AppointmentMainEditor
extends BaseAppointmentMainEditor
implements IPatientRelated,
ISelectionProvider {
    private static final Logger logger = Logger.getLogger(AppointmentMainEditor.class.getName());
    private IPropertyListener searchControl2ContextSiteListener = new IPropertyListener(){

        public void propertyChanged(int propertyId) {
            if (propertyId == 1 && !AppointmentMainEditor.this.isDisposed() && AppointmentMainEditor.this.searchControl2 != null) {
                AppointmentMainEditor.this.searchControl2.getSimpleController().setSite(SitePlugin.getDefault().getContextSite());
            }
        }
    };
    private AppointmentControllerAdapter searchControl2CurrentProfessionnalListener = new AppointmentControllerAdapter(){

        @Override
        public void currentProfessionalChanged() {
            if (!AppointmentMainEditor.this.isDisposed() && !AppointmentMainEditor.this.ignore && AppointmentMainEditor.this.searchControl2 != null) {
                AppointmentMainEditor.this.searchControl2.getSimpleController().setProfessionnal(AppointmentMainEditor.this.getController().getCurrentProfessional());
            }
        }
    };
    private AppointmentMainController controller;
    protected AppointmentControllerListener controllerListener;
    protected boolean initializing;
    private GenListenerManager<ISelectionChangedListener> managers = new GenListenerManager(ISelectionChangedListener.class);

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.initializing = true;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    @Override
    public void setInput(IEditorInput input) {
        if (input == null || !(input instanceof AppointmentMainEditorInput)) {
            throw new IllegalArgumentException();
        }
        AppointmentMainEditorInput newInput = (AppointmentMainEditorInput)input;
        this.mode = newInput.getMode();
        this.setController(newInput.buildController((IUserInteractionHelper)new UserInteractionHelper(this.getSite().getShell())));
        this.getController().setCurrentProfessional(newInput.getProfessional());
        super.setInputWithNotify(input);
        if (!this.initializing) {
            this.initGui();
        }
    }

    private void setController(AppointmentMainController newController) {
        if (newController == null) {
            throw new IllegalArgumentException();
        }
        if (newController == this.controller) {
            return;
        }
        if (this.controller != null) {
            this.controller.removeListener(this.controllerListener);
            this.controller.removeListener(this.searchControl2CurrentProfessionnalListener);
            PropertyListenerManager.removeListener((IPropertyListener)this.searchControl2ContextSiteListener);
            this.controller.dispose();
        }
        this.controller = newController;
        if (this.controllerListener == null) {
            this.controllerListener = new AppointmentControllerListenerImplementation();
        }
        this.controller.addListener(this.controllerListener);
        this.controller.addListener(this.searchControl2CurrentProfessionnalListener);
        PropertyListenerManager.addListener((Object)SitePlugin.getDefault(), (IPropertyListener)this.searchControl2ContextSiteListener);
        if (!this.initializing) {
            Object[] objectArray = this.appointmentVisualStructures;
            int n = this.appointmentVisualStructures.length;
            int n2 = 0;
            while (n2 < n) {
                AppointmentVisualStructure visualStructure = objectArray[n2];
                visualStructure.refresh();
                ++n2;
            }
            this.appointmentDateControl.refresh();
            objectArray = this.appointmentWeekControls;
            n = this.appointmentWeekControls.length;
            n2 = 0;
            while (n2 < n) {
                AppointmentVisualStructure control = objectArray[n2];
                ((SmallAppointmentDateControl)((Object)control)).setController(this.controller);
                ++n2;
            }
        }
    }

    public void initGui() {
        this.ignore = true;
        if (this.getController().isUsable()) {
            if (!this.leftPart.isDisposed()) {
                int allUsesAppt;
                this.globalHorizontalSash1.setEnabled(true);
                Collection<XBaseProfessionnal> lstProfessional = this.getController().getLstProfessional();
                Collection<XPersonGroup> lstGroup = this.getController().getLstPersonGroup();
                ArrayList<XBaseProfessionnal> lstProfessionalFromGroup = new ArrayList<XBaseProfessionnal>(lstGroup.size());
                for (XPersonGroup xg : lstGroup) {
                    allUsesAppt = 1;
                    for (Integer ii : xg.getPersons()) {
                        XBaseProfessionnal byIdPerson = PersonUiPlugin.getDefault().getBaseProfessionnalByIdPerson(ii, false, false);
                        if (byIdPerson != null && byIdPerson.useAppointment) continue;
                        allUsesAppt = 0;
                        break;
                    }
                    if (allUsesAppt == 0) continue;
                    XBaseProfessionnal x = new XBaseProfessionnal();
                    x.setId(Integer.valueOf(-xg.getId().intValue()));
                    x.setLastName("\u4e00GRP");
                    x.setFirstName(xg.getName());
                    x.useAppointment = true;
                    x.str = "Groupe de prof.";
                    lstProfessionalFromGroup.add(x);
                }
                ArrayList<XBaseProfessionnal> lsProfsAndGroups = new ArrayList<XBaseProfessionnal>(lstProfessional.size() + lstGroup.size());
                lsProfsAndGroups.addAll(lstProfessional);
                lsProfsAndGroups.addAll(lstProfessionalFromGroup);
                this.cmbProfessionnals.setItems(lsProfsAndGroups);
                this.cmbProfessionnals.select(this.getController().getCurrentProfessional());
                this.refreshComboPeriodTypes();
                this.refreshGroupPeriod();
                this.scheduleControl.refresh();
                this.calendar.setMode(this.mode);
                this.setLayoutForMode(this.mode);
                AppointmentVisualStructure[] appointmentVisualStructureArray = this.appointmentVisualStructures;
                int x = this.appointmentVisualStructures.length;
                allUsesAppt = 0;
                while (allUsesAppt < x) {
                    AppointmentVisualStructure visualStructure = appointmentVisualStructureArray[allUsesAppt];
                    visualStructure.setMode(this.mode);
                    visualStructure.refresh();
                    ++allUsesAppt;
                }
                LocalDate currentCalendarDate = this.getController().getCurrentCalendarDate();
                AppointmentThermometerControl[] appointmentThermometerControlArray = this.thermometerControls;
                int n = this.thermometerControls.length;
                x = 0;
                while (x < n) {
                    AppointmentThermometerControl th = appointmentThermometerControlArray[x];
                    if (th.getVisualStructure().getDate() == currentCalendarDate) {
                        th.select();
                    }
                    ++x;
                }
                this.calendar.getSelection().clearAddAndFinalize((Object)currentCalendarDate);
                AppointmentVisualStructure vs = this.appointmentDateControl.getVisualStructure();
                IAppointment appointment = this.getController().getCurrentAppointment();
                if (vs != null && appointment != null) {
                    vs.setSelection((IVisualAppointment)appointment);
                    this.appointmentDateControl.reveal(appointment, true);
                }
                this.searchControl2.getSimpleController().setProfessionnal(this.getController().getCurrentProfessional());
                this.searchControl2.getSimpleController().setSite(SitePlugin.getDefault().getContextSite());
                this.refreshPartName();
            }
        } else if (!this.globalHorizontalSash1.isDisposed()) {
            this.globalHorizontalSash1.setEnabled(false);
        }
        this.ignore = false;
    }

    private void refreshComboPeriodTypes() {
        if (this.getController().isUsable()) {
            XAppointmentPeriodType selection = (XAppointmentPeriodType)this.cmbTypePeriod.getSelection();
            Collection<XAppointmentPeriodType> types = this.getController().getLstAppointmentPeriodType();
            this.cmbTypePeriod.setItems(types);
            XAppointmentPeriodType default_appointment_period_type = this.getController().getDEFAULT_APPOINTMENT_PERIOD_TYPE();
            if (default_appointment_period_type != null) {
                this.cmbTypePeriod.setDefaultSelection((Object)default_appointment_period_type);
            }
            this.cmbTypePeriod.setMyComboSelect((Object)selection);
        } else {
            this.cmbTypePeriod.removeAll();
        }
    }

    public void refresh() {
        AppointmentMainController controller2;
        Log.log((Logger)logger, (String)"AppointmentEditor.refresh", (String[])new String[0], (Object[])new Object[0]);
        this.ignore = true;
        if (this.getMode() == IAppointmentMode.Mode.APPOINTMENT && this.editorState != BaseAppointmentMainEditor.EditorState.DATE) {
            this.setEditorStateTo_DATE();
        }
        boolean enabled = (controller2 = this.getController()) != null && controller2.isUsable();
        this.calendar.redraw();
        this.calendar.getCanvas().setEnabled(enabled);
        this.appointmentDateControl.refresh();
        this.appointmentDateControl.setEnabled(enabled);
        this.scheduleControl.refresh();
        this.scheduleControl.setEnabled(enabled);
        LocalDate date = this.controller.getCurrentCalendarDate();
        this.lblCurrentDate.setText(this.getLblCurrentDateText(date));
        Composite[] compositeArray = this.thermometerControls;
        int n = this.thermometerControls.length;
        int n2 = 0;
        while (n2 < n) {
            AppointmentThermometerControl thermometerControl = compositeArray[n2];
            thermometerControl.refresh();
            thermometerControl.setEnabled(enabled);
            ++n2;
        }
        compositeArray = this.appointmentWeekControls;
        n = this.appointmentWeekControls.length;
        n2 = 0;
        while (n2 < n) {
            Composite appointmentWeekControl = compositeArray[n2];
            appointmentWeekControl.refresh();
            appointmentWeekControl.setEnabled(enabled);
            ++n2;
        }
        this.refreshPartName();
        this.ignore = false;
    }

    private void refreshPartName() {
        StringBuilder builder = new StringBuilder(30);
        if (this.getController().isUsable()) {
            builder.append(this.controller.getCurrentProfessional());
        } else {
            builder.append(Messages.getString((String)"AUCUN_PROFESSIONNEL_COURRANT", (String[])new String[0]));
        }
        this.setPartName(builder.toString().trim());
    }

    private void refreshCurrentWeekText() {
        List<LocalDate> dates;
        String text = "";
        if (this.getMode() == IAppointmentMode.Mode.APPOINTMENT && (dates = this.getController().getCurrentCalendarDates()).size() > 0) {
            LocalDate dateInTheWeek = dates.get(0);
            LocalDate first = LocalDate.getFirstDayOfWeek((LocalDate)dateInTheWeek);
            LocalDate last = LocalDate.getLastDayOfWeek((LocalDate)dateInTheWeek);
            text = String.format(Messages.getString((String)"SEMAINE_DU_A_AU_B", (String[])new String[0]), LocalDateFormat.format((LocalDate)first, (String)FormatDateProvider.getFormatDate().toString()), LocalDateFormat.format((LocalDate)last, (String)FormatDateProvider.getFormatDate().toString()));
        }
        this.lblCurrentWeek.setText(text);
    }

    @Override
    public void setMode(IAppointmentMode.Mode mode) {
        if (mode == null) {
            mode = IAppointmentMode.Mode.APPOINTMENT;
        }
        Log.log((Logger)logger, (String)"AppointmentEditor.setMode", (String[])new String[]{"mode"}, (Object[])new Object[]{mode});
        this.mode = mode;
        Object[] objectArray = this.appointmentVisualStructures;
        int n = this.appointmentVisualStructures.length;
        int n2 = 0;
        while (n2 < n) {
            AppointmentVisualStructure visualStructure = objectArray[n2];
            visualStructure.setMode(mode);
            ++n2;
        }
        if (!this.leftPart.isDisposed()) {
            if (this.getController().getCurrentProfessional() == null) {
                this.setEditorStateTo_NOTHING();
            } else if (mode == IAppointmentMode.Mode.SCHEDULE) {
                this.refreshGroupPeriod();
                this.refreshGroupDateTemplate();
            } else if (mode == IAppointmentMode.Mode.APPOINTMENT) {
                this.setEditorStateTo_DATE();
            }
            this.refreshPartName();
            objectArray = this.thermometerControls;
            n = this.thermometerControls.length;
            n2 = 0;
            while (n2 < n) {
                AppointmentVisualStructure thermometerControl = objectArray[n2];
                ((AppointmentThermometerControl)((Object)thermometerControl)).refresh();
                ++n2;
            }
            this.calendar.setMode(mode);
            this.setLayoutForMode(mode);
        }
    }

    void refreshGroupWeekTemplate() {
        XAppointmentWeekTemplate template = this.getController().getCurrentWeekTemplate();
        this.ignore = true;
        if (template == null) {
            this.grpDateTemplateProperties.setEnabled(false);
            this.txtWeekTemplateName.clear();
            this.txtWeekTemplateName.setEnabled(false);
            this.chkWeekTemplateIsForCurrentUser.setSelection(false);
            this.chkWeekTemplateIsForCurrentUser.setEnabled(false);
        } else {
            this.grpWeekTemplateProperties.setEnabled(true);
            this.txtWeekTemplateName.setEnabled(true);
            this.txtWeekTemplateName.setTextKeepSelection(template.getNote());
            this.chkWeekTemplateIsForCurrentUser.setEnabled(true);
            this.chkWeekTemplateIsForCurrentUser.setSelection(template.getProfessionnal() != null);
        }
        this.ignore = false;
    }

    void refreshGroupDateTemplate() {
        XAppointmentDateTemplate template = this.getController().getCurrentDateTemplate();
        this.ignore = true;
        if (template == null) {
            this.grpDateTemplateProperties.setEnabled(false);
            this.txtDateTemplateName.clear();
            this.txtDateTemplateScale.clear();
            this.txtDateTemplateStartHour.clear();
            this.txtDateTemplateEndHour.clear();
            this.chkDateTemplateIsForCurrentUser.setSelection(false);
        } else {
            this.grpDateTemplateProperties.setEnabled(true);
            this.txtDateTemplateName.setTextKeepSelection(template.getNote());
            this.txtDateTemplateScale.setNumberKeepSelection(Integer.valueOf(template.getScale().intValue()));
            this.txtDateTemplateStartHour.setNumberKeepSelection(Integer.valueOf(template.getStartHour().intValue()));
            this.txtDateTemplateEndHour.setNumberKeepSelection(Integer.valueOf(template.getEndHour().intValue()));
            this.chkDateTemplateIsForCurrentUser.setSelection(template.getProfessionnal() != null);
        }
        this.ignore = false;
    }

    void refreshGroupPeriod() {
        XAppointmentPeriod currentPeriod = this.getController().getCurrentPeriod();
        this.ignore = true;
        if (currentPeriod != null) {
            this.grpPeriodProperties.setEnabled(true);
            this.txtHourStartPeriod.setEnabled(true);
            this.txtHourEndPeriod.setEnabled(true);
            this.txtNamePeriod.setEnabled(true);
            this.txtLengthPeriod.setEnabled(true);
            this.cmbTypePeriod.setEnabled(true);
            this.cmbSitePeriod.setEnabled(true);
            this.chkIsClosedPeriod.setEnabled(true);
            this.chkIsSofyEnabled.setEnabled(true);
            this.chkIsSofyTreatingRestricted.setEnabled(true);
            this.txtNamePeriod.setTextKeepSelection(currentPeriod.getNomPeriod());
            this.txtNamePeriod.setToolTipText(StringUtils.defaultString((String)currentPeriod.getNomPeriod()));
            this.txtLengthPeriod.setNumberKeepSelection(currentPeriod.getDefaultLength());
            this.txtHourStartPeriod.setTime(currentPeriod.getStartTime());
            this.txtHourEndPeriod.setTime(currentPeriod.getEndTime());
            this.cmbTypePeriod.select((Object)AppointmentPlugin.getDefault().getPeriodType(currentPeriod.getAppointmentPeriodType()));
            if (currentPeriod.getIdSite() == null) {
                this.cmbSitePeriod.selectNone();
            } else {
                XSite site = SitePlugin.getDefault().getSite(currentPeriod.getIdSite());
                this.cmbSitePeriod.select(site);
            }
            this.chkIsClosedPeriod.setSelection(currentPeriod.isClosed());
            this.chkIsSofyEnabled.setSelection(currentPeriod.isSofyEnabled());
            this.chkIsSofyTreatingRestricted.setSelection(currentPeriod.isSofyTreatingRestricted());
            this.txtVisibleNbMinBefore.setEnabled(true);
            this.txtVisibleNbMinBefore.setNumber(currentPeriod.getVisibleNbMinBefore());
        } else {
            this.grpPeriodProperties.setEnabled(false);
            this.txtHourStartPeriod.setEnabled(false);
            this.txtHourEndPeriod.setEnabled(false);
            this.txtNamePeriod.setEnabled(false);
            this.txtLengthPeriod.setEnabled(false);
            this.cmbTypePeriod.setEnabled(false);
            this.cmbSitePeriod.setEnabled(false);
            this.chkIsClosedPeriod.setEnabled(false);
            this.chkIsSofyEnabled.setEnabled(false);
            this.chkIsSofyTreatingRestricted.setEnabled(false);
            this.txtVisibleNbMinBefore.setEnabled(false);
            this.txtNamePeriod.setText(null);
            this.txtHourStartPeriod.setRawText(null);
            this.txtHourEndPeriod.setRawText(null);
            this.txtLengthPeriod.setRawText(null);
            this.cmbTypePeriod.selectNone();
            this.cmbSitePeriod.selectNone();
            this.chkIsClosedPeriod.setSelection(false);
            this.chkIsSofyEnabled.setSelection(false);
            this.chkIsSofyTreatingRestricted.setSelection(false);
            this.txtVisibleNbMinBefore.setNumber(null);
        }
        this.ignore = false;
    }

    @Override
    public IAppointmentMode.Mode getMode() {
        return this.mode;
    }

    @Override
    public void switchMode() {
        IStatus status = Status.OK_STATUS;
        if (this.getController().isUsable()) {
            status = this.getController().saveAll();
        }
        if (status.isOkToProceed()) {
            if (this.getMode() == IAppointmentMode.Mode.SCHEDULE) {
                logger.fine("settings mode appointment");
                this.setMode(IAppointmentMode.Mode.APPOINTMENT);
            } else {
                logger.fine("settings mode schedule");
                this.setMode(IAppointmentMode.Mode.SCHEDULE);
            }
        } else {
            MessageUtil.show((IStatus)status);
        }
    }

    public void setEditorStateTo_DATE() {
        if (!this.getController().isUsable()) {
            this.setEditorStateTo_NOTHING();
        } else {
            LocalDate date = this.getController().getCurrentCalendarDate();
            if (date != null) {
                this.setEditorStateTo_DATE(date);
            } else {
                List<LocalDate> dates = this.getController().getCurrentCalendarDates();
                if (dates.size() == 0) {
                    this.setEditorStateTo_DATE(LocalDate.today());
                } else {
                    this.setEditorStateTo_DATE(dates.get(0));
                }
            }
        }
    }

    public void setEditorStateTo_DATE(LocalDate newCurrentDate) {
        this.setEditorStateTo_DATE(newCurrentDate, false);
    }

    public void setEditorStateTo_DATE(LocalDate newCurrentDate, boolean fromCalendar) {
        block7: {
            block6: {
                if (this.getController().isUsable()) break block6;
                this.setEditorStateTo_NOTHING();
                break block7;
            }
            Log.logOperation((String)"AppointmentEditor.setEditorStateTo_DATE", (Object[])new Object[]{"newCurrentDate", newCurrentDate});
            Log.log((Logger)logger, (String)"AppointmentEditor.setEditorStateTo_DATE", (String[])new String[]{"newCurrentDate"}, (Object[])new Object[]{newCurrentDate});
            this.editorState = BaseAppointmentMainEditor.EditorState.DATE;
            if (this.initializing) break block7;
            this.getController().setCurrents(null, null, null);
            LocalDate oldDate = this.getController().getCurrentCalendarDate();
            this.getController().setCurrentCalendarDates(newCurrentDate);
            if (!oldDate.equals((Object)newCurrentDate)) {
                this.getController().setCurrentStartTime(null);
                this.getController().setCurrentEndTime(null);
                this.getController().setCurrentAppointment(null);
                if (newCurrentDate != null && newCurrentDate.weekOfYear == oldDate.weekOfYear) {
                    int dayOfWeek = newCurrentDate.dayOfWeek - 1;
                    int i = 0;
                    while (i < this.appointmentVisualStructures.length) {
                        if (fromCalendar || i != dayOfWeek) {
                            this.appointmentVisualStructures[i].setSelection(AppointmentVisualStructure.NULL_SELECTION);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.appointmentVisualStructures.length) {
                        this.appointmentVisualStructures[i].setSelection(AppointmentVisualStructure.NULL_SELECTION);
                        ++i;
                    }
                }
            }
        }
    }

    public void setEditorStateTo_DATE(IAppointment pAppointment) {
        if (!this.getController().isUsable()) {
            this.setEditorStateTo_NOTHING();
        } else {
            Log.log((Logger)logger, (String)"AppointmentMainEditor.setEditorStateTo_DATE", (String[])new String[]{"pAppointment"}, (Object[])new Object[]{pAppointment});
            LocalDate date = pAppointment.getDate();
            IAppointment appointment = this.getController().getAppointment(this.getController().getAppointmentDate(date), pAppointment.getStartTime().shortValue(), pAppointment.getEndTime().shortValue());
            if (appointment != null) {
                this.editorState = BaseAppointmentMainEditor.EditorState.DATE;
                this.getController().setCurrents(null, null, null);
                this.getController().setCurrentCalendarDates(date);
                this.getController().setCurrentAppointment(appointment);
                this.appointmentDateControl.reveal(appointment, true);
            }
        }
    }

    public void setEditorStateTo_DATE(XBaseProfessionnal professionnal, LocalDate date, Integer time) {
        if (!this.getController().isUsable()) {
            this.setEditorStateTo_NOTHING();
        } else {
            Log.log((Logger)logger, (String)"AppointmentMainEditor.setEditorStateTo_DATE", (String[])new String[]{"professionnal", "date", "time"}, (Object[])new Object[]{professionnal, date, time});
            this.setEditorStateTo_DATE(date);
            this.getController().setCurrentProfessional(professionnal);
            this.appointmentDateControl.reveal(time, true);
            this.appointmentDateControl.select(time);
        }
    }

    public void setEditorStateTo_WEEK_TEMPLATE(XAppointmentWeekTemplate newCurrentWeekTemplate, XAppointmentDateTemplate newCurrentDateTemplate, XAppointmentPeriod newCurrentPeriod) {
        if (!this.getController().isUsable()) {
            this.setEditorStateTo_NOTHING();
        } else {
            Log.log((Logger)logger, (String)"AppointmentEditor.setEditorStateTo_WEEK_TEMPLATE", (String[])new String[]{"newCurrentWeekTemplate", "newCurrentDateTemplate", "newCurrentPeriod"}, (Object[])new Object[]{newCurrentWeekTemplate, newCurrentDateTemplate, newCurrentPeriod});
            this.editorState = BaseAppointmentMainEditor.EditorState.WEEK_TEMPLATE;
            this.getController().setCurrentCalendarDates(Collections.EMPTY_LIST);
            this.getController().setCurrents(newCurrentWeekTemplate, newCurrentDateTemplate, newCurrentPeriod);
            this.txtWeekTemplateName.setFocus();
        }
    }

    public void setEditorStateTo_DATE_TEMPLATE(XAppointmentDateTemplate newCurrentDatetTemplate, XAppointmentPeriod newCurrentPeriod) {
        if (!this.getController().isUsable()) {
            this.setEditorStateTo_NOTHING();
        } else {
            Log.log((Logger)logger, (String)"AppointmentEditor.setEditorStateTo_DATE_TEMPLATE", (String[])new String[]{"newCurrentDatetTemplate", "newCurrentPeriod"}, (Object[])new Object[]{newCurrentDatetTemplate, newCurrentPeriod});
            this.editorState = BaseAppointmentMainEditor.EditorState.DATE_TEMPLATE;
            this.getController().setCurrentCalendarDates(Collections.EMPTY_LIST);
            this.getController().setCurrents(null, newCurrentDatetTemplate, newCurrentPeriod);
            this.txtDateTemplateName.setFocus();
        }
    }

    public void setEditorStateTo_NOTHING() {
        Log.log((Logger)logger, (String)"AppointmentEditor.setEditorStateTo_NOTHING", (String[])new String[0], (Object[])new Object[0]);
        this.editorState = BaseAppointmentMainEditor.EditorState.NOTHING;
        this.calendar.getSelection().clear();
        this.calendar.getSelection().finalizeSelection();
        this.scheduleControl.clearSelections();
        if (this.getController().isUsable()) {
            this.getController().clearCurrents();
        }
    }

    private void setLayoutForMode(IAppointmentMode.Mode mode) {
        Log.log((Logger)logger, (String)"AppointmentEditor.setLayoutForMode", (String[])new String[]{"mode"}, (Object[])new Object[]{mode});
        if (mode == IAppointmentMode.Mode.SCHEDULE) {
            this.cmbProfessionnals.setEnabled(false);
            this.btnHideWeekTemplateControl.setVisible(false);
            this.btnRefresh.setVisible(false);
            this.btnPreferences.setVisible(false);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginHeight = 5;
            fillLayout.marginWidth = 5;
            this.getParent().setLayout((Layout)fillLayout);
            this.getParent().setBackground(ResourceGetter.getColor((int)255, (int)150, (int)150));
            this.grpPeriodProperties.setVisible(false);
            this.setLayoutForTemplates(null, null);
            this.grpPeriodProperties.setVisible(true);
            this.lblScheduleModeWarning.setVisible(true);
            this.centerPartRdv4.setVisible(false);
            this.horaireContainer.setVisible(true);
            this.rightPartBottomStackLayout.topControl = this.scheduleSection;
            this.rightPartBottom.layout();
            this.btnMode.setText(EDIT_RDV);
            this.leftHorizontalSash3.SASH_WIDTH = this.sashWidth;
            this.leftHorizontalSash3.setWeights(this.scheduleLHSWeight);
            this.rightPartVerticalSash.setWeights(this.scheduleRVSWeight);
        } else {
            this.cmbProfessionnals.setEnabled(true);
            this.btnHideWeekTemplateControl.setVisible(true);
            this.lblDateTimeVisibility.setVisible(true);
            this.lblMinutes.setVisible(true);
            this.txtVisibleNbMinBefore.setVisible(true);
            this.btnRefresh.setVisible(true);
            this.btnPreferences.setVisible(true);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginHeight = 5;
            fillLayout.marginWidth = 5;
            this.getParent().setLayout((Layout)fillLayout);
            this.getParent().setBackground(ResourceGetter.getColor((int)100, (int)100, (int)100));
            this.lblScheduleModeWarning.setVisible(false);
            this.grpPeriodProperties.setVisible(false);
            this.centerPartRdv4.setVisible(true);
            this.horaireContainer.setVisible(false);
            this.rightPartBottomStackLayout.topControl = this.searchControl2;
            this.rightPartBottom.layout();
            this.btnMode.setText(EDIT_HORAIRE);
            int[] nArray = new int[2];
            nArray[0] = 1000;
            this.leftHorizontalSash3.SASH_WIDTH = Arrays.equals(this.appointmentLHSWeight, nArray) ? 0 : this.sashWidth;
            this.leftHorizontalSash3.setWeights(this.appointmentLHSWeight);
            this.rightPartVerticalSash.setWeights(this.appointmentRVSWeight);
        }
        this.leftHorizontalSash3.layout();
    }

    @Override
    protected void setLayoutForTemplates(XAppointmentDateTemplate template, XAppointmentWeekTemplate week) {
        Log.log((Logger)logger, (String)"setLayoutForTemplates", (String[])new String[]{"template", "week"}, (Object[])new Object[]{template, week});
        if (this.mode == IAppointmentMode.Mode.APPOINTMENT) {
            new Exception("setLayoutForTemplates call in appointment mode").printStackTrace();
        }
        MyFormData data = new MyFormData();
        data.top = new MyFormAttachment(0, 5);
        data.left = new MyFormAttachment(0, 5);
        data.right = new MyFormAttachment(100);
        this.lblScheduleModeWarning.setLayoutData((Object)data);
        if (this.mode == IAppointmentMode.Mode.SCHEDULE) {
            if (this.editorState == BaseAppointmentMainEditor.EditorState.WEEK_TEMPLATE) {
                data = new MyFormData();
                data.top = new MyFormAttachment(this.lblScheduleModeWarning.getControl(), 5);
                data.left = new MyFormAttachment(0, 5);
                data.right = new MyFormAttachment(100, -5);
                this.grpPeriodProperties.setLayoutData((Object)data);
                this.hideTxtDateTemplateName();
                data = new MyFormData();
                data.top = new MyFormAttachment((Control)this.grpPeriodProperties, 5);
                data.left = new MyFormAttachment(0, 5);
                data.right = new MyFormAttachment(100, -5);
                this.grpDateTemplateProperties.setLayoutData((Object)data);
                data = new MyFormData();
                data.top = new MyFormAttachment((Control)this.grpDateTemplateProperties, 5);
                data.left = new MyFormAttachment(0, 5);
                data.right = new MyFormAttachment(100, -5);
                this.grpWeekTemplateProperties.setLayoutData((Object)data);
                this.grpPeriodProperties.setVisible(true);
                this.grpDateTemplateProperties.setVisible(true);
                this.grpWeekTemplateProperties.setVisible(true);
                this.horaireContainer.layout(true, true);
            } else if (this.editorState == BaseAppointmentMainEditor.EditorState.DATE_TEMPLATE) {
                this.showTxtDateTemplateName();
                data = new MyFormData();
                data.top = new MyFormAttachment(this.lblScheduleModeWarning.getControl(), 5);
                data.left = new MyFormAttachment(0, 5);
                data.right = new MyFormAttachment(100, -5);
                this.grpPeriodProperties.setLayoutData((Object)data);
                data = new MyFormData();
                data.top = new MyFormAttachment((Control)this.grpPeriodProperties, 5);
                data.left = new MyFormAttachment(0, 5);
                data.right = new MyFormAttachment(100, -5);
                this.grpDateTemplateProperties.setLayoutData((Object)data);
                this.grpPeriodProperties.setVisible(true);
                this.grpDateTemplateProperties.setVisible(true);
                this.grpWeekTemplateProperties.setVisible(false);
                this.horaireContainer.layout(true, true);
            } else {
                this.hideTxtDateTemplateName();
                data = new MyFormData();
                data.top = new MyFormAttachment(this.lblScheduleModeWarning.getControl(), 5);
                data.left = new MyFormAttachment(0, 5);
                data.right = new MyFormAttachment(100, -5);
                this.grpPeriodProperties.setLayoutData((Object)data);
                data = new MyFormData();
                data.top = new MyFormAttachment((Control)this.grpPeriodProperties, 5);
                data.left = new MyFormAttachment(0, 5);
                data.right = new MyFormAttachment(100, -5);
                this.grpDateTemplateProperties.setLayoutData((Object)data);
                this.grpPeriodProperties.setVisible(true);
                this.grpDateTemplateProperties.setVisible(true);
                this.grpWeekTemplateProperties.setVisible(false);
                this.horaireContainer.layout(true, true);
            }
            this.horaireContainer.getParent().layout();
        }
    }

    private void hideTxtDateTemplateName() {
        this.lblDateTemplateName.setVisible(false);
        this.txtDateTemplateName.setVisible(false);
        this.chkDateTemplateIsForCurrentUser.setVisible(false);
        FormData data = (FormData)this.lblDateTemplateScale.getLayoutData();
        data.top = new FormAttachment(0, 5);
        this.grpDateTemplateProperties.layout(true);
    }

    private void showTxtDateTemplateName() {
        FormData data = (FormData)this.lblDateTemplateScale.getLayoutData();
        data.top = new FormAttachment(this.chkDateTemplateIsForCurrentUser.getControl(), 5);
        this.lblDateTemplateName.setVisible(true);
        this.txtDateTemplateName.setVisible(true);
        this.chkDateTemplateIsForCurrentUser.setVisible(true);
        this.grpDateTemplateProperties.layout(true);
    }

    @Override
    public void assignDay(XAppointmentDateTemplate dateTemplate, LocalDate date) {
        if (!this.getController().getAppointmentDate(date).getDateTemplate().getPeriods().isEmpty()) {
            if (MessageUtil.askQuestion((Shell)this.getSite().getShell(), (String)Messages.getString((String)"ETES_VOUS_CERTAINS_DE_VOULOIR_ECRASER_CETTE_DATE", (String[])new String[0]))) {
                this.getController().assignDay(dateTemplate, date);
                IStatus status = this.getController().saveAll();
                if (!status.isOkToProceed()) {
                    this.getController().cancelAll();
                }
            }
        } else {
            this.getController().assignDay(dateTemplate, date);
            IStatus status = this.getController().saveAll();
            if (!status.isOkToProceed()) {
                this.getController().cancelAll();
            }
        }
    }

    @Override
    public void assignWeek(XAppointmentWeekTemplate weekTemplate, LocalDate dateInTheWeek) {
        Log.log((Logger)logger, (String)"assignWeek", (String[])new String[]{"weekTemplate", "dates"}, (Object[])new Object[]{weekTemplate, dateInTheWeek});
        LocalDate date = LocalDate.getFirstDayOfWeek((LocalDate)dateInTheWeek);
        boolean exist = false;
        int i = 0;
        while (i < 7) {
            if (!this.getController().getAppointmentDate(date.plusDay(i)).getDateTemplate().getPeriods().isEmpty()) {
                exist = true;
                break;
            }
            ++i;
        }
        if (exist) {
            if (MessageUtil.askQuestion((Shell)this.getSite().getShell(), (String)Messages.getString((String)"ETES_VOUS_CERTAINS_DE_VOULOIR_ECRASER_CES_DATES", (String[])new String[0]))) {
                this.getController().assignWeek(weekTemplate, dateInTheWeek);
                IStatus status = this.getController().saveAll();
                if (!status.isOkToProceed()) {
                    this.getController().cancelAll();
                }
            }
        } else {
            this.getController().assignWeek(weekTemplate, dateInTheWeek);
            IStatus status = this.getController().saveAll();
            if (!status.isOkToProceed()) {
                this.getController().cancelAll();
            }
        }
    }

    @Override
    public AppointmentMainController getController() {
        return this.controller;
    }

    @Override
    public void createNewAppointmentDate(LocalDate date, XBaseProfessionnal professional) {
        Log.log((Logger)logger, (String)"AppointmentEditor.createNewAppointmentDate", (String[])new String[]{"date", "professional"}, (Object[])new Object[]{date, professional});
        XAppointmentDateTemplate template = new XAppointmentDateTemplate();
        template.setNew();
        template.setProfessionnal(professional == null ? null : professional.getId());
        template.setIsReusable(false);
        this.assignDay(template, date);
        this.setEditorStateTo_DATE(date);
    }

    @Override
    public void deleteAppointmentDate(final List<LocalDate> dates) {
        if (dates != null && dates.size() >= 7) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getSite().getShell());
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        AppointmentMainEditor.this.deleteAppointmentDate(monitor, dates);
                    }
                });
            }
            catch (Exception e) {
                MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
            }
        } else {
            this.deleteAppointmentDate(null, dates);
        }
    }

    public void deleteAppointmentDate(IProgressMonitor monitor, List<LocalDate> dates) {
        if (monitor != null) {
            monitor.beginTask("Effacement des journ\u00e9es", -1);
        }
        if (monitor != null) {
            monitor.subTask("Chargement");
        }
        this.getController().moveAppointmentDateCursor(dates);
        if (monitor != null) {
            monitor.subTask("Effacement");
        }
        this.getController().deleteAppointmentDate(dates);
        if (monitor != null) {
            monitor.done();
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.calendar.redraw();
        } else {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AppointmentMainEditor.this.calendar.redraw();
                }
            });
        }
    }

    public void closeAppointmentDate(final List<LocalDate> dates) {
        if (dates != null && dates.size() >= 7) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getSite().getShell());
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        AppointmentMainEditor.this.closeAppointmentDate(monitor, dates);
                    }
                });
            }
            catch (Exception e) {
                MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
            }
        } else {
            this.closeAppointmentDate(null, dates);
        }
    }

    public void closeAppointmentDate(IProgressMonitor monitor, List<LocalDate> dates) {
        if (monitor != null) {
            monitor.beginTask(Messages.getString((String)"FERMER_TOUTES_LES_PERIODES_ET_MARQUEE_LES_RENDEZ_VOUS_COMME_A_DEPLACER", (String[])new String[0]), -1);
        }
        if (monitor != null) {
            monitor.subTask(Messages.getString((String)"CHARGEMENT", (String[])new String[0]));
        }
        this.getController().moveAppointmentDateCursor(dates);
        if (monitor != null) {
            monitor.subTask(Messages.getString((String)"FERMETURE", (String[])new String[0]));
        }
        this.getController().closeAppointmentDate(dates);
        if (monitor != null) {
            monitor.done();
        }
        if (UI.isCurrentThreadIsUIThread()) {
            this.calendar.redraw();
        } else {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AppointmentMainEditor.this.calendar.redraw();
                }
            });
        }
    }

    @Override
    public void dispose() {
        logger.entering(this.getClass().getName(), "dispose");
        this.controller.removeListener(this.controllerListener);
        this.controller.removeListener(this.searchControl2CurrentProfessionnalListener);
        PropertyListenerManager.removeListener((IPropertyListener)this.searchControl2ContextSiteListener);
        this.controller.dispose();
        this.controller = null;
        super.dispose();
    }

    public void doRefresh() {
        IStatus status = this.getController().saveAll();
        if (!status.isOkToProceed()) {
            this.getController().cancelAll();
        }
    }

    public void doSave(IProgressMonitor arg0) {
        IStatus status = this.getController().saveAll();
        if (!status.isOkToProceed()) {
            this.getController().cancelAll();
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.getController().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.appointmentDateControl.setFocus();
    }

    protected void finalize() throws Throwable {
        System.err.println(this + "was finalized by gc");
        super.finalize();
    }

    public IPatient getPatient() {
        IAppointment currentAppointment;
        AppointmentMainController controller2 = this.getController();
        if (controller2 != null && controller2.isUsable() && (currentAppointment = controller2.getCurrentAppointment()) != null) {
            IPatient patient = currentAppointment.getPatient();
            if (patient != null) {
                return patient.clone();
            }
            XPatient adhocPatient = currentAppointment.getAdhocPatient((IJsonReader)Application.get().getGsonProcessor());
            if (adhocPatient != null) {
                return new AdHocPatient(adhocPatient);
            }
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.managers.addListener((Object)listener);
    }

    public AppointmentSelection getSelection() {
        IAppointment currentAppointment;
        AppointmentMainController controller = this.getController();
        AppointmentSelection selection = controller == null || !controller.isUsable() ? new AppointmentSelection() : (controller.canSeeAndModifyAppointment(currentAppointment = controller.getCurrentAppointment()) ? new AppointmentSelection(currentAppointment) : new AppointmentSelection());
        return selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.managers.removeListener((Object)listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public MessageLink getMessageLink() {
        return null;
    }

    @Override
    protected void loadNewModel() {
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getSite().getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString((String)"RAFRAICHIR", (String[])new String[0]), -1);
                    Model.getInstance().reset();
                }
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
        }
    }

    private final class AppointmentControllerListenerImplementation
    extends AppointmentControllerAdapter {
        private XAppointmentPeriod currentPeriod;

        private AppointmentControllerListenerImplementation() {
        }

        @Override
        public void currentDateTemplateChanged() {
            logger.fine("AppointmentMainEditor.currentDateTemplateChanged()");
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AppointmentMainEditor.this.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        if (AppointmentMainEditor.this.getMode() == IAppointmentMode.Mode.SCHEDULE) {
                            XAppointmentDateTemplate day = AppointmentMainEditor.this.getController().getCurrentDateTemplate();
                            XAppointmentWeekTemplate week = AppointmentMainEditor.this.getController().getCurrentWeekTemplate();
                            AppointmentMainEditor.this.setLayoutForTemplates(day, week);
                            if (((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.editorState != BaseAppointmentMainEditor.EditorState.DATE) {
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.getSelection().clear();
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.getSelection().finalizeSelection();
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.redraw();
                            }
                            AppointmentMainEditor.this.refreshGroupDateTemplate();
                            if (((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.editorState != BaseAppointmentMainEditor.EditorState.DATE) {
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentVisualStructures[0].refresh();
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.thermometerControls[0].select();
                            }
                        }
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void currentWeekTemplateChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".currentWeekTemplateChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        if (AppointmentMainEditor.this.getMode() == IAppointmentMode.Mode.SCHEDULE) {
                            XAppointmentDateTemplate day = AppointmentMainEditor.this.getController().getCurrentDateTemplate();
                            XAppointmentWeekTemplate week = AppointmentMainEditor.this.getController().getCurrentWeekTemplate();
                            AppointmentMainEditor.this.setLayoutForTemplates(day, week);
                            if (((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.editorState != BaseAppointmentMainEditor.EditorState.DATE) {
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.getSelection().clear();
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.getSelection().finalizeSelection();
                                ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.redraw();
                            }
                            if (((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.editorState == BaseAppointmentMainEditor.EditorState.WEEK_TEMPLATE) {
                                AppointmentMainEditor.this.refreshGroupDateTemplate();
                                AppointmentMainEditor.this.refreshGroupWeekTemplate();
                                int i = 0;
                                while (i < ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentWeekControls.length) {
                                    ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentWeekControls[i].setWeekTemplate(week);
                                    ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentWeekControls[i].refresh();
                                    ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentWeekControls[i].setEnabled(week != null);
                                    ++i;
                                }
                            }
                        }
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void currentAppointmentChanged(IAppointment appt) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".currentAppointmentChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        AppointmentVisualStructure vs = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentDateControl.getVisualStructure();
                        IAppointment appointment = AppointmentMainEditor.this.getController().getCurrentAppointment();
                        if (vs != null && appointment != null) {
                            vs.setSelection((IVisualAppointment)appointment);
                        }
                        AppointmentMainEditor.this.getParent().layout(true, true);
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                        ((ISelectionChangedListener)AppointmentMainEditor.this.managers.getProxy()).selectionChanged(new SelectionChangedEvent((ISelectionProvider)AppointmentMainEditor.this, (ISelection)AppointmentMainEditor.this.getSelection()));
                    }
                }
            });
        }

        @Override
        public void baseAppointmentDatesChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentDatesChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.redraw();
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void appointmentDatesChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentDatesChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.redraw();
                        AppointmentMainEditor.this.refreshPartName();
                        AppointmentVisualStructure[] appointmentVisualStructureArray = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentVisualStructures;
                        int n = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentVisualStructures.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AppointmentVisualStructure vs = appointmentVisualStructureArray[n2];
                            vs.refresh();
                            ++n2;
                        }
                    }
                }
            });
        }

        @Override
        public void appointmentsChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentsChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.redraw();
                        AppointmentVisualStructure[] appointmentVisualStructureArray = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentVisualStructures;
                        int n = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentVisualStructures.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AppointmentVisualStructure vs = appointmentVisualStructureArray[n2];
                            vs.refresh();
                            ++n2;
                        }
                    }
                }
            });
        }

        @Override
        public void appointmentPeriodTypesChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentPeriodTypesChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        AppointmentMainEditor.this.refreshComboPeriodTypes();
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void appointmentTypesChanged() {
            logger.fine(".appointmentTypesChanged()");
        }

        @Override
        public void appointmentWeekTemplatesChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentWeekTemplatesChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        AppointmentMainEditor.this.refresh();
                    }
                }
            });
        }

        @Override
        public void appointmentDateTemplatesChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".appointmentDateTemplatesChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        AppointmentMainEditor.this.refresh();
                    }
                }
            });
        }

        @Override
        public void objectModified(Object object) {
            if (!AppointmentMainEditor.this.leftPart.isDisposed()) {
                AppointmentMainEditor.this.scheduleControl.objectModified(object);
            }
        }

        @Override
        public void professionalsChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".professionalsChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        Collection<XBaseProfessionnal> lstProfessional = AppointmentMainEditor.this.getController().getLstProfessional();
                        Collection<XPersonGroup> lstGroup = AppointmentMainEditor.this.getController().getLstPersonGroup();
                        ArrayList<XBaseProfessionnal> lstProfessionalFromGroup = new ArrayList<XBaseProfessionnal>(lstGroup.size());
                        for (XPersonGroup xg : lstGroup) {
                            boolean allUsesAppt = true;
                            for (Integer ii : xg.getPersons()) {
                                XBaseProfessionnal byIdPerson = PersonUiPlugin.getDefault().getBaseProfessionnalByIdPerson(ii, false, false);
                                if (byIdPerson != null && byIdPerson.useAppointment) continue;
                                allUsesAppt = false;
                                break;
                            }
                            if (!allUsesAppt) continue;
                            XBaseProfessionnal x = new XBaseProfessionnal();
                            x.setId(Integer.valueOf(-xg.getId().intValue()));
                            x.setLastName("\u4e00GRP");
                            x.setFirstName(xg.getName());
                            x.useAppointment = true;
                            x.str = "Groupe de prof.";
                            lstProfessionalFromGroup.add(x);
                        }
                        ArrayList<XBaseProfessionnal> lsProfsAndGroups = new ArrayList<XBaseProfessionnal>(lstProfessional.size() + lstProfessionalFromGroup.size());
                        lsProfsAndGroups.addAll(lstProfessional);
                        lsProfsAndGroups.addAll(lstProfessionalFromGroup);
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.cmbProfessionnals.setItems(lsProfsAndGroups);
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.cmbProfessionnals.selectNoNotify(AppointmentMainEditor.this.getController().getCurrentProfessional());
                        if (lsProfsAndGroups.size() > 0) {
                            if (AppointmentMainEditor.this.getController().getCurrentProfessional() == null) {
                                AppointmentMainEditor.this.getController().setCurrentProfessional((XBaseProfessionnal)lsProfsAndGroups.iterator().next());
                            }
                        } else {
                            AppointmentMainEditor.this.getController().setCurrentProfessional((Integer)null);
                        }
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void currentCalendarDateChanged() {
            if (AppointmentMainEditor.this.ignore) {
                return;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".currentCalendarDateChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.centerPartRdv4.isDisposed()) {
                        List<LocalDate> dates;
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        LocalDate date = AppointmentMainEditor.this.controller.getCurrentCalendarDate();
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.lblCurrentDate.setText(AppointmentMainEditor.this.getLblCurrentDateText(date));
                        if (date != null) {
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.getSelection().clearAddAndFinalize((Object)date);
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.reveal(date);
                        } else {
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.getSelection().clear();
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.calendar.getSelection().finalizeSelection();
                        }
                        AppointmentThermometerControl[] appointmentThermometerControlArray = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.thermometerControls;
                        int n = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.thermometerControls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AppointmentThermometerControl c = appointmentThermometerControlArray[n2];
                            c.showTime(false);
                            c.showSelection(false);
                            ++n2;
                        }
                        if (date != null) {
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.thermometerControls[date.dayOfWeek - 1].select();
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.thermometerControls[date.dayOfWeek - 1].showTime(true);
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.thermometerControls[date.dayOfWeek - 1].showSelection(true);
                        }
                        AppointmentMainEditor.this.refreshPartName();
                        if (AppointmentMainEditor.this.getMode() == IAppointmentMode.Mode.SCHEDULE && !(dates = AppointmentMainEditor.this.getController().getCurrentCalendarDates()).isEmpty()) {
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.scheduleControl.clearSelections();
                        }
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void currentCalendarDatesChanged() {
            if (AppointmentMainEditor.this.ignore) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".currentCalendarDatesChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.centerPartRdv4.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        AppointmentVisualStructure[] appointmentVisualStructureArray = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentVisualStructures;
                        int n = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentVisualStructures.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AppointmentVisualStructure vs = appointmentVisualStructureArray[n2];
                            vs.refresh();
                            ++n2;
                        }
                        AppointmentMainEditor.this.refreshPartName();
                        AppointmentMainEditor.this.refreshCurrentWeekText();
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void currentPeriodChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AppointmentMainController controller2 = AppointmentMainEditor.this.getController();
                    if (controller2 != null && controller2.isUsable()) {
                        XAppointmentPeriod old = AppointmentControllerListenerImplementation.this.currentPeriod;
                        AppointmentControllerListenerImplementation.this.currentPeriod = controller2.getCurrentPeriod();
                        ObjectListenerManager.removeListener((Object)old, (IObjectListener)((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.currentPeriodListener);
                        ObjectListenerManager.addListener((Object)AppointmentControllerListenerImplementation.this.currentPeriod, (IObjectListener)((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.currentPeriodListener);
                        if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                            AppointmentMainEditor.this.refreshGroupPeriod();
                            ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                        }
                    }
                }
            });
        }

        @Override
        public void currentProfessionalChanged() {
            if (AppointmentMainEditor.this.ignore) {
                return;
            }
            AppointmentMainEditorInput.setInMemoryLastUsedProfessionnal(AppointmentMainEditor.this.getController().getCurrentProfessional());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    logger.fine(".currentProfessionalsChanged()");
                    if (!((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.leftPart.isDisposed()) {
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = true;
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.cmbProfessionnals.select(AppointmentMainEditor.this.getController().getCurrentProfessional());
                        AppointmentVisualStructure vs = ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.appointmentDateControl.getVisualStructure();
                        if (vs != null) {
                            vs.setSelection(AppointmentVisualStructure.NULL_SELECTION);
                        }
                        AppointmentMainEditor.this.setMode(((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.mode);
                        AppointmentMainEditor.this.refresh();
                        ((AppointmentControllerListenerImplementation)AppointmentControllerListenerImplementation.this).AppointmentMainEditor.this.ignore = false;
                    }
                }
            });
        }

        @Override
        public void usableStateChanged(boolean isUsable) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AppointmentMainEditor.this.refresh();
                }
            });
        }
    }
}

