/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.util1.PredicateA;
import ca.infodata.util1.ProviderAR;
import java.util.ArrayList;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchControl
extends Composite {
    private AppointmentMainController controller;
    private AppointmentControllerAdapterExtension controllerListener = new AppointmentControllerAdapterExtension();
    private MyCombo<XAppointmentPeriodType> cmbPeriodTypes;
    private MyLabel lblPeriodType;

    public SearchControl(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        this.createMyControl(this, toolkit);
    }

    private void createMyControl(Composite parent, FormToolkit toolkit) {
        toolkit.adapt((Composite)this);
        this.lblPeriodType = new MyLabel(parent, Messages.getString((String)"TYPE_DE_PERIODES", (String[])new String[0]), 0, toolkit);
        this.cmbPeriodTypes = new MyCombo(parent, 8, toolkit);
        this.cmbPeriodTypes.setLabelProvider((ProviderAR)new ProviderAR<XAppointmentPeriodType, String>(){

            public String get(XAppointmentPeriodType type) {
                if (type == null) {
                    return "SO";
                }
                if (Boolean.TRUE.equals(type.getIsDeleted())) {
                    return "*" + type.getFrench();
                }
                return type.getFrench();
            }
        });
        this.cmbPeriodTypes.setDisplayPredicate((PredicateA)new PredicateA<XAppointmentPeriodType>(){

            public boolean evaluate(XAppointmentPeriodType type) {
                return true;
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.lblPeriodType.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.lblPeriodType.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.cmbPeriodTypes.getControl().setLayoutData((Object)data);
    }

    public void refresh() {
        ArrayList<XAppointmentPeriodType> types = new ArrayList<XAppointmentPeriodType>(this.getController().getLstAppointmentPeriodType());
        XAppointmentPeriodType selection = (XAppointmentPeriodType)this.cmbPeriodTypes.getSelection();
        this.cmbPeriodTypes.setItems(types);
        int indexOf = types.indexOf(selection);
        if (indexOf != -1) {
            this.cmbPeriodTypes.select((Object)types.get(indexOf));
        } else if (types.size() > 0) {
            this.cmbPeriodTypes.select((Object)types.get(0));
        }
    }

    public void setController(AppointmentMainController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.removeListener(this.controllerListener);
            }
            if (controller != null) {
                controller.addListener(this.controllerListener);
            }
            this.controller = controller;
            this.refresh();
        }
    }

    public AppointmentMainController getController() {
        return this.controller;
    }

    public MyCombo<XAppointmentPeriodType> getCmbPeriodTypes() {
        return this.cmbPeriodTypes;
    }

    private final class AppointmentControllerAdapterExtension
    extends AppointmentControllerAdapter {
        private AppointmentControllerAdapterExtension() {
        }

        @Override
        public void usableStateChanged(boolean isUsable) {
            if (!SearchControl.this.isDisposed()) {
                SearchControl.this.cmbPeriodTypes.setEnabled(isUsable);
            }
        }

        @Override
        public void appointmentPeriodTypesChanged() {
            if (!SearchControl.this.isDisposed() && SearchControl.this.getController() != null && SearchControl.this.getController().isUsable()) {
                SearchControl.this.refresh();
            }
        }
    }
}

