/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class DrawingUtil {
    private Map<RGB, Color> colors = new HashMap<RGB, Color>();

    public Color getColor(int red, int green, int blue) {
        return this.getColor(new RGB(red, green, blue));
    }

    public Color getColor(int[] colors) {
        return this.getColor(new RGB(colors[0], colors[1], colors[2]));
    }

    public Color getColor(RGB rgb) {
        Color color = this.colors.get(rgb);
        if (color == null) {
            color = ResourceGetter.getColor((RGB)rgb);
            this.colors.put(rgb, color);
        }
        return color;
    }

    public final void drawFade(GC gc, Color colorStart, Color colorEnd, int startX, int endX, int startY, int endY, int maxX) {
        if (colorStart.equals((Object)colorEnd)) {
            Color background = gc.getBackground();
            gc.setBackground(colorStart);
            gc.fillRectangle(startX, startY, Math.min(endX, maxX) - startX, endY - startY);
            gc.setBackground(background);
        } else {
            double redToAdd = (double)(colorEnd.getRed() - colorStart.getRed()) / ((double)endX - (double)startX);
            double greenToAdd = (double)(colorEnd.getGreen() - colorStart.getGreen()) / ((double)endX - (double)startX);
            double blueToAdd = (double)(colorEnd.getBlue() - colorStart.getBlue()) / ((double)endX - (double)startX);
            double red = colorStart.getRed();
            double green = colorStart.getGreen();
            double blue = colorStart.getBlue();
            Color foreground = gc.getForeground();
            int i = startX;
            while (i < endX && i < maxX) {
                Color tempColor = this.getColor((int)(red += redToAdd), (int)(green += greenToAdd), (int)(blue += blueToAdd));
                gc.setForeground(tempColor);
                gc.drawLine(i, startY, i, endY);
                ++i;
            }
            gc.setForeground(foreground);
        }
    }

    public final void drawFade2(GC gc, Color colorStart, Color colorEnd, int startX, int endX, int startY, int endY, int maxX) {
        Color background = gc.getBackground();
        Color foreground = gc.getForeground();
        int alpha = gc.getAlpha();
        int realEndx = Math.min(endX, maxX);
        int width = realEndx - startX;
        int height = endY - startY;
        gc.setBackground(colorStart);
        gc.fillRectangle(startX, startY, width, height);
        if (!colorEnd.equals((Object)colorStart)) {
            gc.setForeground(colorEnd);
            int x = 0;
            while (x < width) {
                gc.setAlpha(x * 100 / width * 255 / 100);
                gc.drawLine(x + startX, startY, x + startX, endY);
                ++x;
            }
        }
        gc.setAlpha(alpha);
        gc.setBackground(background);
        gc.setForeground(foreground);
    }

    public Color darkenColor(RGB colorToFade) {
        return this.getColor((int)((double)colorToFade.red * 0.75), (int)((double)colorToFade.green * 0.75), (int)((double)colorToFade.blue * 0.75));
    }

    public void dispose() {
        for (Color color : this.colors.values()) {
            ResourceGetter.dispose((Object)color);
        }
    }

    public static void main(String[] args) {
        final DrawingUtil drawingUtil = new DrawingUtil();
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(1, false));
        final Color blue = drawingUtil.getColor(0, 0, 255);
        drawingUtil.getColor(255, 255, 255);
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle r = e.gc.getClipping();
                Log.startTimeLogger();
                drawingUtil.drawFade(e.gc, blue, blue, r.x, r.x + r.width / 2, r.y, r.y + r.height, r.width / 2);
                Log.printTimeLogger((String)"drawFade");
                Log.startTimeLogger();
                drawingUtil.drawFade2(e.gc, blue, blue, r.x + r.width / 2, r.x + r.width, r.y, r.y + r.height, r.width);
                Log.printTimeLogger((String)"drawFade2");
            }
        });
        shell.setSize(200, 200);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        drawingUtil.dispose();
        display.dispose();
    }
}

