/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util.json;

import ca.infodata.ofys.data.middle.dataobjects.XAddress;
import ca.infodata.ofys.data.middle.dataobjects.XCitizenship;
import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformationOrigin;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPersonType;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.util.EnumWithValueFactory;
import ca.infodata.ofys.util.json.JsonFunctionE;
import ca.infodata.util1.date.LocalDate;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XTypeJsonReadAptater {
    private static final Logger logger = Logger.getLogger(XTypeJsonReadAptater.class.getName());

    public static XPatient readXPatient(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        in.beginObject();
        XPatient c = new XPatient();
        block98: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "tag": {
                    c.setTag(XTypeJsonReadAptater.rinteger(in));
                    continue block98;
                }
                case "version": {
                    c.setVersion(XTypeJsonReadAptater.rinteger(in));
                    continue block98;
                }
                case "versionDateTime": {
                    c.setVersionDateTime(XTypeJsonReadAptater.rlong(in));
                    continue block98;
                }
                case "personType": {
                    c.personType = XTypeJsonReadAptater.readEnum(in, XPersonType.class);
                    continue block98;
                }
                case "lastName": {
                    c.lastName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "searchLastName": {
                    c.searchLastName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "firstName": {
                    c.firstName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "searchFirstName": {
                    c.searchFirstName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "gender": {
                    c.gender = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "race": {
                    c.race = XTypeJsonReadAptater.rshort(in);
                    continue block98;
                }
                case "midInitial": {
                    c.midInitial = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "languageCode": {
                    c.languageCode = XTypeJsonReadAptater.rshort(in);
                    continue block98;
                }
                case "maritalStatus": {
                    c.maritalStatus = XTypeJsonReadAptater.rshort(in);
                    continue block98;
                }
                case "birthDate": {
                    c.birthDate = XTypeJsonReadAptater.readLocalDate(in);
                    continue block98;
                }
                case "note": {
                    c.note = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "title": {
                    c.title = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "isDeleted": {
                    c.isDeleted = XTypeJsonReadAptater.rboolean(in);
                    continue block98;
                }
                case "idPerson": {
                    c.idPerson = XTypeJsonReadAptater.rinteger(in);
                    continue block98;
                }
                case "age": {
                    c.age = XTypeJsonReadAptater.rshort(in);
                    continue block98;
                }
                case "citizenship": {
                    c.citizenship = XTypeJsonReadAptater.readCitizenship(in);
                    continue block98;
                }
                case "contacts": {
                    c.setLstContactInformation(XTypeJsonReadAptater.readEditableDataObjectList(in, XContactInformation.class, XTypeJsonReadAptater::readXContactInformation));
                    continue block98;
                }
                case "addresses": {
                    c.setLstAddress(XTypeJsonReadAptater.readEditableDataObjectList(in, XAddress.class, XTypeJsonReadAptater::readXAddress));
                    continue block98;
                }
                case "sites": {
                    c.setLstSites(XTypeJsonReadAptater.readEditableDataObjectList(in, XPersonSite.class, XTypeJsonReadAptater::readXPersonSite));
                    continue block98;
                }
                case "externalId": {
                    c.externalId = XTypeJsonReadAptater.rinteger(in);
                    continue block98;
                }
                case "id": {
                    c.id = XTypeJsonReadAptater.rinteger(in);
                    continue block98;
                }
                case "niu": {
                    c.niu = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "allIds": {
                    c.allIds = XTypeJsonReadAptater.readIntAVLTreeSet(in);
                    continue block98;
                }
                case "healthInsuranceNumber": {
                    c.healthInsuranceNumber = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "patientRecordNumber": {
                    c.patientRecordNumber = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "bloodType": {
                    c.bloodType = XTypeJsonReadAptater.rshort(in);
                    continue block98;
                }
                case "messageAppointment": {
                    c.messageAppointment = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "lastVerificationDate": {
                    c.lastVerificationDate = XTypeJsonReadAptater.readLocalDate(in);
                    continue block98;
                }
                case "lastActivityDate": {
                    c.lastActivityDate = XTypeJsonReadAptater.readLocalDate(in);
                    continue block98;
                }
                case "expirationCAM": {
                    c.expirationCAM = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "fatherName": {
                    c.fatherName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "spouseName": {
                    c.spouseName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "motherName": {
                    c.motherName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "fatherHin": {
                    c.fatherHin = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "motherHin": {
                    c.motherHin = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "tutorName": {
                    c.tutorName = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "lastProfileVersion": {
                    c.lastProfileVersion = XTypeJsonReadAptater.rinteger(in);
                    continue block98;
                }
                case "treatingProfessionnal": {
                    c.treatingProfessionnal = XTypeJsonReadAptater.rinteger(in);
                    continue block98;
                }
                case "isSensible": {
                    c.isSensible = XTypeJsonReadAptater.rboolean(in);
                    continue block98;
                }
                case "isScanned": {
                    c.isScanned = XTypeJsonReadAptater.rboolean(in);
                    continue block98;
                }
                case "custodyTerms": {
                    c.custodyTerms = XTypeJsonReadAptater.rstring(in);
                    continue block98;
                }
                case "sofyGuardianAccess": {
                    c.sofyGuardianAccess = XTypeJsonReadAptater.rshort(in);
                    continue block98;
                }
                case "str": {
                    in.skipValue();
                    continue block98;
                }
            }
            logger.log(Level.SEVERE, "invalid XPatient json field name " + name);
        }
        in.endObject();
        return c;
    }

    private static IntAVLTreeSet readIntAVLTreeSet(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        IntAVLTreeSet list = new IntAVLTreeSet();
        in.beginArray();
        while (in.hasNext()) {
            list.add(in.nextInt());
        }
        in.endArray();
        return list;
    }

    private static XAddress readXAddress(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        XAddress c = new XAddress();
        in.beginObject();
        block28: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "tag": {
                    c.setTag(XTypeJsonReadAptater.rinteger(in));
                    continue block28;
                }
                case "version": {
                    c.setVersion(XTypeJsonReadAptater.rinteger(in));
                    continue block28;
                }
                case "versionDateTime": {
                    c.setVersionDateTime(XTypeJsonReadAptater.rlong(in));
                    continue block28;
                }
                case "id": {
                    c.id = XTypeJsonReadAptater.rinteger(in);
                    continue block28;
                }
                case "street": {
                    c.street = XTypeJsonReadAptater.rstring(in);
                    continue block28;
                }
                case "postalCode": {
                    c.postalCode = XTypeJsonReadAptater.rstring(in);
                    continue block28;
                }
                case "note": {
                    c.note = XTypeJsonReadAptater.rstring(in);
                    continue block28;
                }
                case "importance": {
                    c.importance = XTypeJsonReadAptater.rshort(in);
                    continue block28;
                }
                case "country": {
                    c.country = XTypeJsonReadAptater.readXCountry(in);
                    continue block28;
                }
                case "city": {
                    c.city = XTypeJsonReadAptater.readXCity(in);
                    continue block28;
                }
                case "province": {
                    c.province = XTypeJsonReadAptater.readXProvince(in);
                    continue block28;
                }
                case "origin": {
                    c.origin = XTypeJsonReadAptater.readEnum(in, XContactInformationOrigin.class);
                    continue block28;
                }
            }
            logger.log(Level.SEVERE, "invalid XAddress json field name " + name);
        }
        in.endObject();
        return c;
    }

    private static XPersonSite readXPersonSite(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        XPersonSite c = new XPersonSite();
        in.beginObject();
        block16: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "tag": {
                    c.setTag(XTypeJsonReadAptater.rinteger(in));
                    continue block16;
                }
                case "version": {
                    c.setVersion(XTypeJsonReadAptater.rinteger(in));
                    continue block16;
                }
                case "versionDateTime": {
                    c.setVersionDateTime(XTypeJsonReadAptater.rlong(in));
                    continue block16;
                }
                case "id": {
                    c.id = XTypeJsonReadAptater.rinteger(in);
                    continue block16;
                }
                case "isSite": {
                    c.idSite = XTypeJsonReadAptater.rinteger(in);
                    continue block16;
                }
                case "addedAs": {
                    c.addedAs = XTypeJsonReadAptater.readEnum(in, SiteAddedAs.class);
                    continue block16;
                }
            }
            logger.log(Level.SEVERE, "invalid XPersonSite json field name " + name);
        }
        in.endObject();
        return c;
    }

    private static XCountry readXCountry(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        XCountry c = new XCountry();
        in.beginObject();
        block10: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "id": {
                    c.id = XTypeJsonReadAptater.rinteger(in);
                    continue block10;
                }
                case "name": {
                    c.name = XTypeJsonReadAptater.rstring(in);
                    continue block10;
                }
                case "isDeleted": {
                    c.isDeleted = XTypeJsonReadAptater.rinteger(in);
                    continue block10;
                }
            }
            logger.log(Level.SEVERE, "invalid XCountry json field name " + name);
        }
        in.endObject();
        return c;
    }

    private static XCity readXCity(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        XCity c = new XCity();
        in.beginObject();
        block10: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "id": {
                    c.id = XTypeJsonReadAptater.rinteger(in);
                    continue block10;
                }
                case "name": {
                    c.name = XTypeJsonReadAptater.rstring(in);
                    continue block10;
                }
                case "isDeleted": {
                    c.isDeleted = XTypeJsonReadAptater.rinteger(in);
                    continue block10;
                }
            }
            logger.log(Level.SEVERE, "invalid XCity json field name " + name);
        }
        in.endObject();
        return c;
    }

    private static XProvince readXProvince(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        XProvince c = new XProvince();
        in.beginObject();
        block10: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "id": {
                    c.id = XTypeJsonReadAptater.rinteger(in);
                    continue block10;
                }
                case "name": {
                    c.name = XTypeJsonReadAptater.rstring(in);
                    continue block10;
                }
                case "isDeleted": {
                    c.isDeleted = XTypeJsonReadAptater.rinteger(in);
                    continue block10;
                }
            }
            logger.log(Level.SEVERE, "invalid XProvince json field name " + name);
        }
        in.endObject();
        return c;
    }

    private static XContactInformation readXContactInformation(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        XContactInformation c = new XContactInformation();
        in.beginObject();
        block22: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "tag": {
                    c.setTag(XTypeJsonReadAptater.rinteger(in));
                    continue block22;
                }
                case "version": {
                    c.setVersion(XTypeJsonReadAptater.rinteger(in));
                    continue block22;
                }
                case "versionDateTime": {
                    c.setVersionDateTime(XTypeJsonReadAptater.rlong(in));
                    continue block22;
                }
                case "id": {
                    c.id = XTypeJsonReadAptater.rinteger(in);
                    continue block22;
                }
                case "typeContact": {
                    c.typeContact = XTypeJsonReadAptater.rinteger(in);
                    continue block22;
                }
                case "contact": {
                    c.contact = XTypeJsonReadAptater.rstring(in);
                    continue block22;
                }
                case "note": {
                    c.note = XTypeJsonReadAptater.rstring(in);
                    continue block22;
                }
                case "importance": {
                    c.importance = XTypeJsonReadAptater.rshort(in);
                    continue block22;
                }
                case "origin": {
                    c.origin = XTypeJsonReadAptater.readEnum(in, XContactInformationOrigin.class);
                    continue block22;
                }
            }
            logger.log(Level.SEVERE, "invalid XContactInformation json field name " + name);
        }
        in.endObject();
        return c;
    }

    private static <E extends Enum<E>> E readEnum(JsonReader in, Class<E> c) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        E e = null;
        in.beginObject();
        block6: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "id": {
                    e = EnumWithValueFactory.fromInt(c, XTypeJsonReadAptater.rinteger(in));
                    continue block6;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return e;
    }

    private static <E extends IMinimalEditableDataObject> EditableDataObjectList<E> readEditableDataObjectList(JsonReader in, Class<E> c, JsonFunctionE<JsonReader, E> itemReader) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return new EditableDataObjectList(0);
        }
        EditableDataObjectList<IMinimalEditableDataObject> list = new EditableDataObjectList<IMinimalEditableDataObject>();
        in.beginArray();
        while (in.hasNext()) {
            IMinimalEditableDataObject e = (IMinimalEditableDataObject)itemReader.apply(in);
            if (e == null) continue;
            list.add(e);
        }
        in.endArray();
        return list;
    }

    private static XCitizenship readCitizenship(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        Integer id = null;
        String french = null;
        String english = null;
        in.beginObject();
        block10: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "id": {
                    id = XTypeJsonReadAptater.rinteger(in);
                    continue block10;
                }
                case "french": {
                    french = XTypeJsonReadAptater.rstring(in);
                    continue block10;
                }
                case "english": {
                    english = XTypeJsonReadAptater.rstring(in);
                    continue block10;
                }
            }
            logger.log(Level.SEVERE, "invalid XCitizenship json field name " + name);
        }
        in.endObject();
        return new XCitizenship(id, english, french);
    }

    private static Boolean rboolean(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        return in.nextBoolean();
    }

    private static LocalDate readLocalDate(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        return LocalDate.fromDayFrom1970((int)in.nextInt());
    }

    private static Short rshort(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        return (short)in.nextInt();
    }

    private static String rstring(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        return in.nextString();
    }

    private static Integer rinteger(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        return in.nextInt();
    }

    private static Long rlong(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            return null;
        }
        return in.nextLong();
    }
}

