/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class Comparators {
    public static Comparator<String> compareAscNullFirst() {
        return (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 0;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo((String)o2);
        };
    }

    public static <T extends Comparable<T>> int compareAscNullsFirst(T o1, T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static <T extends Comparable<T>> int compareAscNullsLast(T o1, T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    public static <E> Collection<E> sort(Collection<E> c, Comparator<E> comparator) {
        if (c == null) {
            throw new NullPointerException("c");
        }
        if (c.isEmpty()) {
            return c;
        }
        if (c.size() == 1) {
            return c;
        }
        if (c instanceof List) {
            ((List)c).sort(comparator);
            return c;
        }
        ArrayList<E> list = new ArrayList<E>(c);
        list.sort(comparator);
        return list;
    }

    public static <E> Collection<E> sort(Collection<E> c, Comparator<E> comparator, Comparator<E> comparator2) {
        if (c == null) {
            throw new NullPointerException("c");
        }
        if (c.isEmpty()) {
            return c;
        }
        if (c.size() == 1) {
            return c;
        }
        if (c instanceof List) {
            ((List)c).sort((a, b) -> {
                int i = comparator.compare(a, b);
                if (i == 0) {
                    i = comparator2.compare(a, b);
                }
                return i;
            });
            return c;
        }
        ArrayList<E> list = new ArrayList<E>(c);
        list.sort((a, b) -> {
            int i = comparator.compare(a, b);
            if (i == 0) {
                i = comparator2.compare(a, b);
            }
            return i;
        });
        return list;
    }

    public static <E> Collection<E> sort(Collection<E> c, Comparator<E> comparator, Comparator<E> comparator2, Comparator<E> comparator3) {
        if (c == null) {
            throw new NullPointerException("c");
        }
        if (c.isEmpty()) {
            return c;
        }
        if (c.size() == 1) {
            return c;
        }
        if (c instanceof List) {
            ((List)c).sort((a, b) -> {
                int i = comparator.compare(a, b);
                if (i == 0) {
                    i = comparator2.compare(a, b);
                }
                return i;
            });
            return c;
        }
        ArrayList<E> list = new ArrayList<E>(c);
        list.sort((a, b) -> {
            int i = comparator.compare(a, b);
            if (i == 0) {
                i = comparator2.compare(a, b);
            }
            return i;
        });
        return list;
    }
}

