/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.service;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.service.IEditableDataObjectDeleted;
import ca.infodata.ofys.data.middle.dataobjects.service.XTaxeDefData;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import ca.infodata.util1.date.LocaleProvider;
import java.math.BigDecimal;

public final class XTaxeDef
extends EditableDataObject
implements ICompletionComboItem,
IEditableDataObjectDeleted {
    public static String type = "taxedef";
    private static final long serialVersionUID = 1L;
    public Integer id;
    public String code;
    public String debut;
    public String fin;
    public Boolean isDeleted;
    public Long createdDatetime;
    public IEditableDataObjectList<XTaxeDefData> lstTaxeDefData = new EditableDataObjectList<XTaxeDefData>();

    public XTaxeDef() {
    }

    public XTaxeDef(Integer id) {
        this.setId(id);
    }

    @Override
    public void initialize() {
        this.setNew();
        this.code = "";
        this.debut = LocalDateFormat.format((LocalDate)LocalDate.today(), (String)"yyyyMMdd");
        this.fin = "99999999";
        this.isDeleted = Boolean.FALSE;
        this.createdDatetime = DateUtil.now();
        this.lstTaxeDefData = new EditableDataObjectList<XTaxeDefData>();
    }

    @Override
    public XTaxeDef clone() {
        XTaxeDef c = (XTaxeDef)super.clone();
        c.id = this.id;
        c.code = this.code;
        c.debut = this.debut;
        c.fin = this.fin;
        c.isDeleted = this.isDeleted;
        c.createdDatetime = this.createdDatetime;
        if (this.lstTaxeDefData != null) {
            c.lstTaxeDefData = this.lstTaxeDefData.deepClone();
        }
        return c;
    }

    @Override
    public XTaxeDef cloneSetIdNull() {
        XTaxeDef c = this.clone();
        c.id = null;
        c.setNew();
        for (XTaxeDefData rDef : c.lstTaxeDefData) {
            rDef.id = null;
            rDef.setNew();
            rDef.taxeDef = c;
        }
        return c;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public final String getCode() {
        return this.code;
    }

    public final void setCode(String code) {
        this.code = code;
        this.setUpdated();
    }

    public final String getNameFr() {
        StringBuilder name = new StringBuilder();
        if (this.lstTaxeDefData != null) {
            for (XTaxeDefData x : this.getLstTaxeDefData()) {
                name.append(x.getNameFr()).append(", ");
            }
            if (name.length() > 2) {
                name.append(name.substring(0, name.lastIndexOf(", ")));
            }
        }
        return name.toString();
    }

    public final String getNameEn() {
        StringBuilder name = new StringBuilder();
        if (this.lstTaxeDefData != null) {
            for (XTaxeDefData x : this.getLstTaxeDefData()) {
                name.append(x.getNameEn()).append(", ");
            }
            if (name.length() > 2) {
                name.append(name.substring(0, name.lastIndexOf(", ")));
            }
        }
        return name.toString();
    }

    public final String getDebut() {
        return this.debut;
    }

    public final void setDebut(String debut) {
        this.debut = debut;
        this.setUpdated();
    }

    public final String getFin() {
        return this.fin;
    }

    public final void setFin(String fin) {
        this.fin = fin;
        this.setUpdated();
    }

    @Override
    public final Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @Override
    public final void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    public final Long getCreatedDatetime() {
        return this.createdDatetime;
    }

    public final void setCreatedDatetime(Long createdDatetime) {
        this.createdDatetime = createdDatetime;
        this.setUpdated();
    }

    public final IEditableDataObjectList<XTaxeDefData> getLstTaxeDefData() {
        return this.lstTaxeDefData;
    }

    public final void setLstTaxeDefData(IEditableDataObjectList<XTaxeDefData> lstTaxeDef) {
        this.lstTaxeDefData = lstTaxeDef;
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.lstTaxeDefData.isDirty();
        return dirty;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XTaxeDef" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    public BigDecimal getCalculatedTaux() {
        BigDecimal bd = new BigDecimal(0);
        if (this.lstTaxeDefData != null && !this.lstTaxeDefData.isEmpty()) {
            bd = new BigDecimal(1);
            for (XTaxeDefData x : this.getLstTaxeDefData()) {
                if (x.isDeleted.booleanValue()) continue;
                bd = bd.multiply(x.getTaux().setScale(4, 0).add(new BigDecimal(1)));
            }
            bd = bd.add(new BigDecimal(-1));
        }
        return bd.setScale(6, 0);
    }

    @Override
    public String toString() {
        String del = this.getIsDeleted() != false ? "* " : "";
        return del + this.getCode();
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public String getText() {
        if (LocaleProvider.isFrench()) {
            return this.getNameFr();
        }
        return this.getNameEn();
    }

    @Override
    public boolean isActive() {
        return !Boolean.TRUE.equals(this.getIsDeleted());
    }

    @Override
    public void setNew() {
        super.setNew();
        this.id = null;
        this.setModificationStatus(ModificationStatus.STATUS_NEW);
        if (this.lstTaxeDefData != null) {
            for (XTaxeDefData x : this.lstTaxeDefData) {
                x.id = null;
                x.setNew();
            }
        }
    }
}

