/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.medication;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.encounter.IEncounterRelated;
import ca.infodata.ofys.data.middle.dataobjects.encounter.IHaveAnAnchor;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergyProbability;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XAllergySeverity;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBaseEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.RxUtil;
import ca.infodata.ofys.data.middle.dataobjects.medication.XChangeDose;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDevice;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.Closure;
import org.apache.commons.lang3.StringUtils;

public final class XPrescription
extends EditableDataObject
implements IEncounterRelated,
IHaveAnAnchor {
    private static final long serialVersionUID = 1L;
    public static final int GENERIC_NAME_FORMAT = 0;
    public static final int COMMERCIAL_NAME_FORMAT = 1;
    public static final int GENERIC_COMMERCIAL_NAME_FORMAT = 2;
    public static final int COMMERCIAL_GENERIC_NAME_FORMAT = 3;
    public static final Map<String, Integer> mapFormRQ = new HashMap<String, Integer>();
    public static final Map<String, Integer> mapFormSC;
    public static final String[] ROUTE_TEXT;
    public static final String[] FORMAT_TEXT;
    public Integer idAnchor;
    public Integer din;
    public XImageDecorator decorators;
    public Boolean expired;
    public Long represcribedDatetime;
    public Integer represcribedEncounterId;
    public Integer prevPrescriptionId;
    public Integer dsqTransactionId;
    public Integer dsqPrevTransactionId;
    public String dsqPrevPrescriptionId;
    public String dsqPrevPrescriptionVersion;
    public String dsqPrescriptionId;
    public String dsqPrescriptionVersion;
    public String dsqDMPrescriptionId;
    public String dsqDMPrescriptionVersion;
    public String dsqPrescriptionDispenseId;
    public Integer quantity;
    public Integer treatmentDuration;
    public XMyRouteOfAdministration route;
    public XMyOrderableDrugForm format;
    public XMyHumanSubstanceAdministrationSite site;
    public Integer rx;
    public String posology;
    public Boolean noSubstitution;
    public XDevice device;
    public XDrugStrength strength;
    public String frequency;
    public Boolean toReprescribe;
    public Boolean fromProfExterne;
    public Long entryDate;
    private transient StrengthClosure strengthClosure;
    public Integer id;
    public Integer idNextModificationEntry;
    public String note;
    public LocalDate startDate;
    public LocalDate stopDate;
    public LocalDate endDate;
    public String stopReason;
    public XAllergyProbability allergy;
    public XAllergySeverity severity;
    public Boolean isDeleted;
    public XBaseEncounter encounter;
    public XBaseEncounter stopEncounter;
    public XChangeDose dosageChange;
    public String dsqIt1;
    public String dsqIt2;
    public String dsqIt3;
    public String dsqIt4;
    public String dsqIt5;
    public String noteDsq;
    public String completeNameForFavorites = null;
    public transient List<RxData> lstRxData = new ArrayList<RxData>();
    public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
    private transient String intentionTx = null;

    public EnumSet<XEncounterLabel> getEncLabel() {
        return this.encLabel;
    }

    public void setEncLabel(EnumSet<XEncounterLabel> status) {
        this.encLabel = status;
        this.setUpdated();
    }

    public void removeXEncounterLabel(XEncounterLabel x) {
        this.encLabel.remove(x);
        this.setUpdated();
    }

    public void addXEncounterLabel(XEncounterLabel x) {
        this.encLabel.add(x);
        this.setUpdated();
    }

    public XPrescription() {
        this.strengthClosure = new StrengthClosure();
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.strength != null && this.strength.isDirty() || this.device != null && this.device.isDirty() || this.encounter != null && this.encounter.isDirty() || this.stopEncounter != null && this.stopEncounter.isDirty();
        return dirty;
    }

    public String getName() {
        return this.getEncounter().getPatient().getName() + Messages.getString("_ORDONNANCE", new String[0]);
    }

    public String getGenericDrugNameStrengthPosol() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.getStrength() != null) {
            lst.add(this.getStrength().getGenericName());
        }
        lst.add(this.getPosology());
        return new JoinList(" ", lst).toString();
    }

    public final String getCompleteNameForFavorites() {
        if (this.completeNameForFavorites == null) {
            this.completeNameForFavorites = this.getGenericDrugNameStrengthPosol() + this.getFormat().value() + this.getFrequency() + this.getRx().toString();
        }
        return this.completeNameForFavorites;
    }

    public String getCommercialDrugNameStrengthPosol() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.getStrength() != null) {
            lst.add(this.getStrength().getCommercialName());
        }
        lst.add(this.getPosology());
        return new JoinList(" ", lst).toString();
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
        this.setUpdated();
    }

    public Integer getTreatmentDuration() {
        return this.treatmentDuration;
    }

    public void setTreatmentDuration(Integer treatmentDuration) {
        this.treatmentDuration = treatmentDuration;
        this.setUpdated();
    }

    public XMyRouteOfAdministration getRoute() {
        return this.route;
    }

    public void setRoute(XMyRouteOfAdministration route) {
        this.route = route;
        this.setUpdated();
    }

    public XMyOrderableDrugForm getFormat() {
        return this.format;
    }

    public void setFormat(XMyOrderableDrugForm format) {
        this.format = format;
        this.setUpdated();
    }

    public Integer getRx() {
        return this.rx;
    }

    public void setRx(Integer rx) {
        this.rx = rx;
        this.setUpdated();
    }

    public String getPosology() {
        return this.posology;
    }

    public void setPosology(String posology) {
        this.posology = posology;
        this.setUpdated();
    }

    public Boolean getNoSubstitution() {
        return this.noSubstitution;
    }

    public void setNoSubstitution(Boolean noSubstitution) {
        this.noSubstitution = noSubstitution;
        this.setUpdated();
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    public XDevice getDevice() {
        return this.device;
    }

    public void setDevice(XDevice d) {
        this.device = d;
        this.setUpdated();
    }

    public XDrugStrength getStrength() {
        return this.strength;
    }

    public void setStrength(XDrugStrength strength) {
        this.strength = strength;
        this.strengthClosure.execute(strength);
        this.setUpdated();
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
        this.setUpdated();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public Integer getIdNextModificationEntry() {
        return this.idNextModificationEntry;
    }

    public void setIdNextModificationEntry(Integer id_next_modification_entry) {
        this.idNextModificationEntry = id_next_modification_entry;
    }

    @Override
    public XBaseEncounter getEncounter() {
        return this.encounter;
    }

    @Override
    public void setEncounter(XBaseEncounter encounter) {
        this.encounter = encounter;
        this.setUpdated();
    }

    public XImageDecorator getDecorators() {
        return this.decorators;
    }

    public void setDecorators(XImageDecorator decorators) {
        this.decorators = decorators;
    }

    public void useInformationFrom(XPrescription prescription) {
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        ObjectListenerManager.disable(this);
        this.setQuantity(prescription.getQuantity());
        this.setTreatmentDuration(prescription.getTreatmentDuration());
        this.setRoute(prescription.getRoute());
        this.setFormat(prescription.getFormat());
        this.setRx(prescription.getRx());
        this.setPosology(prescription.getPosology());
        this.setNoSubstitution(prescription.getNoSubstitution());
        this.setIsDeleted(prescription.getIsDeleted());
        this.setDevice(prescription.getDevice());
        this.setStrength(prescription.getStrength());
        this.setFrequency(prescription.getFrequency());
        this.setToReprescribe(prescription.getToReprescribe());
        this.setFromProfExterne(prescription.getFromProfExterne());
        this.setNote(prescription.getNote());
        this.setDsqIt1(prescription.getDsqIt1());
        this.setDsqIt2(prescription.getDsqIt2());
        this.setDsqIt3(prescription.getDsqIt3());
        this.setDsqIt4(prescription.getDsqIt4());
        this.setDsqIt5(prescription.getDsqIt5());
        ObjectListenerManager.enable(this, true);
    }

    @Override
    public XPrescription clone() {
        XPrescription c = (XPrescription)super.clone();
        c.id = this.id;
        c.idAnchor = this.idAnchor;
        c.decorators = this.decorators;
        c.endDate = this.endDate;
        c.stopDate = this.stopDate;
        c.din = this.din;
        c.represcribedDatetime = this.represcribedDatetime;
        c.represcribedEncounterId = this.represcribedEncounterId;
        c.prevPrescriptionId = this.prevPrescriptionId;
        c.dsqPrescriptionId = this.dsqPrescriptionId;
        c.dsqPrescriptionVersion = this.dsqPrescriptionVersion;
        c.dsqDMPrescriptionId = this.dsqDMPrescriptionId;
        c.dsqDMPrescriptionVersion = this.dsqDMPrescriptionVersion;
        c.dsqPrevPrescriptionId = this.dsqPrevPrescriptionId;
        c.dsqPrevPrescriptionVersion = this.dsqPrevPrescriptionVersion;
        c.dsqTransactionId = this.dsqTransactionId;
        c.dsqPrevTransactionId = this.dsqPrevTransactionId;
        c.dsqPrescriptionDispenseId = this.dsqPrescriptionDispenseId;
        c.quantity = this.quantity;
        c.treatmentDuration = this.treatmentDuration;
        c.route = this.route;
        c.site = this.site;
        c.format = this.format;
        c.rx = this.rx;
        c.posology = this.posology;
        c.noSubstitution = this.noSubstitution;
        c.isDeleted = this.isDeleted;
        c.toReprescribe = this.toReprescribe;
        c.device = this.device == null ? null : this.device.clone();
        c.strength = this.strength == null ? null : this.strength.clone();
        c.frequency = this.frequency;
        c.strengthClosure = c.new StrengthClosure();
        c.note = this.note;
        c.startDate = this.startDate;
        c.stopReason = this.stopReason;
        c.allergy = this.allergy;
        c.severity = this.severity;
        c.dsqIt1 = this.dsqIt1;
        c.dsqIt2 = this.dsqIt2;
        c.dsqIt3 = this.dsqIt3;
        c.dsqIt4 = this.dsqIt4;
        c.dsqIt5 = this.dsqIt5;
        if (this.encounter != null) {
            c.encounter = this.encounter.clone();
        }
        if (this.stopEncounter != null) {
            c.stopEncounter = this.stopEncounter.clone();
        }
        c.encLabel = this.encLabel.clone();
        return c;
    }

    public Boolean getToReprescribe() {
        return this.toReprescribe;
    }

    public void setToReprescribe(Boolean toReprescribe) {
        this.toReprescribe = toReprescribe;
    }

    public Boolean getFromProfExterne() {
        return this.fromProfExterne;
    }

    public void setFromProfExterne(Boolean b) {
        this.fromProfExterne = b;
    }

    public Long getEntryDate() {
        return this.entryDate;
    }

    public void setEntryDate(Long entryDate) {
        this.entryDate = entryDate;
    }

    public XMyHumanSubstanceAdministrationSite getSite() {
        return this.site;
    }

    public void setSite(XMyHumanSubstanceAdministrationSite site) {
        this.site = site;
    }

    @Override
    public String toString() {
        return String.format("XPrescription [idAnchor=%s, id=%s, encounter=%s, quantity=%s, treatmentDuration=%s, route=%s, format=%s, site=%s, rx=%s, posology=%s, noSubstitution=%s, isDeleted=%s, strength=%s, frequency=%s, toReprescribe=%s, entryDate=%s]", new Object[]{this.getIdAnchor(), this.getId(), this.getEncounter(), this.quantity, this.treatmentDuration, this.route, this.format, this.site, this.rx, this.posology, this.noSubstitution, this.isDeleted, this.strength, this.frequency, this.toReprescribe, this.entryDate});
    }

    @Override
    protected void childModified(Object object) {
        if (this.getStrength() != null && this.getStrength().getDrugType() == XDrugType.FOURNITURE) {
            ObjectListenerManager.disable(this);
            this.setStrength(null);
            this.setFormat(null);
            this.setSite(null);
            this.setFrequency(null);
            this.setRoute(null);
            ObjectListenerManager.enable(this, false);
        }
        super.childModified(object);
    }

    public LocalDate getPresumedDateToRenvew() {
        LocalDate ld = null;
        LocalDate start = null;
        LocalDate stop = null;
        LocalDate end = null;
        LocalDate realEnd = null;
        Integer nbJr = null;
        int nbRx = 1;
        int qte = 0;
        if (this.getStartDate() != null) {
            start = this.getStartDate();
        }
        if (start != null) {
            if (this.getStopDate() != null) {
                stop = this.getStopDate();
            }
            if (this.getEndDate() != null) {
                end = this.getEndDate();
            }
            realEnd = stop == null ? end : (end == null ? stop : (end.before((IPartialDate)stop) ? end : stop));
            if (this.getTreatmentDuration() != null && this.getTreatmentDuration() > 0) {
                nbJr = this.getTreatmentDuration();
            }
            if (this.getRx() != null && this.getRx() > 0) {
                nbRx = this.getRx() + 1;
            }
            if (this.getQuantity() != null && this.getQuantity() > 0) {
                qte = this.getQuantity() * nbRx;
            }
            if (nbJr != null) {
                ld = start.plusDay(nbJr * nbRx);
            } else if (qte > 0 && this.getFrequency() != null && this.getFrequency() != null) {
                Double nbPerDay = RxUtil.findNPerDay(this.getFrequency(), false);
                if (nbPerDay.equals(0.0)) {
                    ld = start.plusYear(2);
                } else {
                    int duree = (int)((double)qte / nbPerDay);
                    ld = start.plusDay(duree);
                }
            } else {
                LocalDate localDate = ld = realEnd == null ? start.plusYear(2) : realEnd;
            }
            if (ld != null && realEnd != null && realEnd.before((IPartialDate)ld)) {
                ld = realEnd;
            }
            if (ld != null && ld.after((IPartialDate)LocalDate.today().plusYear(2))) {
                ld = start.plusYear(2);
            }
        }
        return ld;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XPrescription) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XPrescription" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    public Long getReprescribedDatetime() {
        return this.represcribedDatetime;
    }

    public void setReprescribedDatetime(Long resprescribedDatetime) {
        this.represcribedDatetime = resprescribedDatetime;
        this.setUpdated();
    }

    public Integer getPrevPrescriptionId() {
        return this.prevPrescriptionId;
    }

    public void setPrevPrescriptionId(Integer prevPrescriptionId) {
        this.prevPrescriptionId = prevPrescriptionId;
    }

    public Integer getDsqTransactionId() {
        return this.dsqTransactionId;
    }

    public void setDsqTransactionId(Integer dsqTransactionId) {
        this.dsqTransactionId = dsqTransactionId;
    }

    public Integer getDsqPrevTransactionId() {
        return this.dsqPrevTransactionId;
    }

    public void setDsqPrevTransactionId(Integer dsqTransactionId) {
        this.dsqPrevTransactionId = dsqTransactionId;
    }

    public String getDsqPrevPrescriptionId() {
        return this.dsqPrevPrescriptionId;
    }

    public void setDsqPrevPrescriptionId(String dsqPrevPrescriptionId) {
        this.dsqPrevPrescriptionId = dsqPrevPrescriptionId;
    }

    public String getDsqPrevPrescriptionVersion() {
        return this.dsqPrevPrescriptionVersion;
    }

    public void setDsqPrevPrescriptionVersion(String dsqPrevPrescriptionVersion) {
        this.dsqPrevPrescriptionVersion = dsqPrevPrescriptionVersion;
    }

    public boolean isStillInSendingToDsqState() {
        return this.dsqPrescriptionId != null && this.dsqPrescriptionId.contains("sending");
    }

    public String getDsqPrescriptionId() {
        return this.dsqPrescriptionId;
    }

    public void setDsqPrescriptionId(String dsqPrescriptionId) {
        this.dsqPrescriptionId = dsqPrescriptionId;
    }

    public String getDsqPrescriptionVersion() {
        return this.dsqPrescriptionVersion;
    }

    public void setDsqPrescriptionVersion(String dsqPrescriptionVersion) {
        this.dsqPrescriptionVersion = dsqPrescriptionVersion;
    }

    public String getDsqDMPrescriptionId() {
        return this.dsqDMPrescriptionId;
    }

    public void setDsqDMPrescriptionId(String dsqDMPrescriptionId) {
        this.dsqDMPrescriptionId = dsqDMPrescriptionId;
    }

    public String getDsqDMPrescriptionVersion() {
        return this.dsqDMPrescriptionVersion;
    }

    public void setDsqDMPrescriptionVersion(String dsqDMPrescriptionVersion) {
        this.dsqDMPrescriptionVersion = dsqDMPrescriptionVersion;
    }

    public String getDsqPrescriptionDispenseId() {
        return this.dsqPrescriptionDispenseId;
    }

    public void setDsqPrescriptionDispenseId(String dsqPrescriptionDispenseId) {
        this.dsqPrescriptionDispenseId = dsqPrescriptionDispenseId;
    }

    @Override
    public Integer getIdAnchor() {
        return this.idAnchor;
    }

    public void setIdAnchor(Integer idAnchor) {
        this.idAnchor = idAnchor;
    }

    public Integer getDin() {
        return this.din;
    }

    public void setDin(Integer din) {
        this.din = din;
        this.setUpdated();
    }

    public void setReprescribedEncounterId(Integer represcribedEncounterId) {
        this.represcribedEncounterId = represcribedEncounterId;
        this.setUpdated();
    }

    public Integer getReprescribedEncounterId() {
        return this.represcribedEncounterId;
    }

    public boolean isActiveNow() {
        long referenceTime = DateUtil.now();
        LocalDate referenceDate = LocalDate.fromTimeInMillisLOCAL((Long)referenceTime);
        if (this.getStopDate() != null && this.getStopDate().beforeOrEquals(referenceDate) || this.getEndDate() != null && this.getEndDate().before((IPartialDate)referenceDate) || Boolean.TRUE.equals(this.getIsDeleted()) || this.getIdNextModificationEntry() != null) {
            return false;
        }
        return this.getReprescribedDatetime() == null || this.getReprescribedDatetime() + 10000L > referenceTime;
    }

    public boolean isReprescription() {
        return this.getPrevPrescriptionId() != null && this.getStopDate() == null;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.setUpdated();
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        this.setUpdated();
    }

    public LocalDate getStopDate() {
        return this.stopDate;
    }

    public void setStopDate(LocalDate stopDate) {
        this.stopDate = stopDate;
        this.setUpdated();
    }

    public String getStopReason() {
        return this.stopReason;
    }

    public void setStopReason(String stopReason) {
        this.stopReason = stopReason;
        this.setUpdated();
    }

    public XAllergyProbability getAllergy() {
        return this.allergy;
    }

    public void setAllergy(XAllergyProbability allergy) {
        this.allergy = allergy;
        this.setUpdated();
    }

    public XAllergySeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(XAllergySeverity severity) {
        this.severity = severity;
        this.setUpdated();
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        this.setUpdated();
    }

    public XBaseEncounter getStopEncounter() {
        return this.stopEncounter;
    }

    public void setStopEncounter(XBaseEncounter xBaseEncounter) {
        this.stopEncounter = xBaseEncounter;
        this.setUpdated();
    }

    public String getDsqIt1() {
        return this.dsqIt1;
    }

    public void setDsqIt1(String dsqIt1) {
        this.dsqIt1 = dsqIt1;
        this.setUpdated();
    }

    public String getDsqIt2() {
        return this.dsqIt2;
    }

    public void setDsqIt2(String dsqIt2) {
        this.dsqIt2 = dsqIt2;
        this.setUpdated();
    }

    public String getDsqIt3() {
        return this.dsqIt3;
    }

    public void setDsqIt3(String dsqIt3) {
        this.dsqIt3 = dsqIt3;
        this.setUpdated();
    }

    public String getDsqIt4() {
        return this.dsqIt4;
    }

    public void setDsqIt4(String dsqIt4) {
        this.dsqIt4 = dsqIt4;
        this.setUpdated();
    }

    public String getDsqIt5() {
        return this.dsqIt5;
    }

    public void setDsqIt5(String dsqIt5) {
        this.dsqIt5 = dsqIt5;
        this.setUpdated();
    }

    public XChangeDose getDosageChange() {
        return this.dosageChange;
    }

    public void setDosageChange(XChangeDose dosageChange) {
        this.dosageChange = dosageChange;
        this.setUpdated();
    }

    public String formatName(XPrescriptionDrugNameFormat format) {
        StringBuilder ret = new StringBuilder(30);
        if (this.getStrength() == null) {
            if (this.getDevice() != null) {
                return this.getDevice().getName();
            }
            return "Rx ?";
        }
        String gn = this.getStrength().getGenericName();
        String cn = this.getStrength().getCommercialName();
        switch (format) {
            case GENERIC_AND_COMMERCIAL: {
                ret.append(gn);
                ret.append(" (");
                ret.append(cn);
                ret.append(")");
                break;
            }
            case COMMERCIAL_AND_GENERIC: {
                ret.append(cn);
                ret.append(" (");
                ret.append(gn);
                ret.append(")");
                break;
            }
            case COMMERCIAL: {
                ret.append(cn);
                break;
            }
            case GENERIC: {
                ret.append(gn);
            }
        }
        return ret.toString();
    }

    public String getIt() {
        if (this.intentionTx == null) {
            String ss;
            ArrayList<String> lst = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)this.getDsqIt1())) {
                lst.add("P1 : " + this.getDsqIt1().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDsqIt2())) {
                lst.add("P2 : " + this.getDsqIt2().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDsqIt3())) {
                lst.add("P3 : " + this.getDsqIt3().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDsqIt4())) {
                lst.add("P4 : " + this.getDsqIt4().trim());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getDsqIt5())) {
                lst.add("P5 : " + this.getDsqIt5().trim());
            }
            this.intentionTx = ss = lst.size() == 0 ? "" : new JoinList(", ", lst).toString();
        }
        return this.intentionTx;
    }

    static {
        mapFormRQ.put("AERO. ORAL", new Integer(101));
        mapFormRQ.put("SUSP. RECT.", new Integer(231));
        mapFormRQ.put("PD. INJ. I.V.", new Integer(207));
        mapFormRQ.put("DISP. INTRA-UTER.", new Integer(227));
        mapFormRQ.put("MOUSSE RECT.(APP.)", new Integer(122));
        mapFormRQ.put("CR.TOP./OV.(APPL.)", new Integer(117));
        mapFormRQ.put("PD. POUR INH. (APP", new Integer(136));
        mapFormRQ.put("STY", new Integer(197));
        mapFormRQ.put("PD. INJ.", new Integer(197));
        mapFormRQ.put("PANS. MINCE", new Integer(159));
        mapFormRQ.put("TIMBRE CUT.", new Integer(160));
        mapFormRQ.put("HUILE TOP.", new Integer(146));
        mapFormRQ.put("CO. ENT.", new Integer(183));
        mapFormRQ.put("PAST. OR.", new Integer(135));
        mapFormRQ.put("SUSP. ORALE", new Integer(226));
        mapFormRQ.put("SOL.", new Integer(197));
        mapFormRQ.put("SUSP. INJ.", new Integer(223));
        mapFormRQ.put("CAPS. LA OU CO. LA", new Integer(171));
        mapFormRQ.put("SHAMP.", new Integer(142));
        mapFormRQ.put("GEL", new Integer(125));
        mapFormRQ.put("SOL. IRR.", new Integer(203));
        mapFormRQ.put("SOL. OPH./OT.", new Integer(216));
        mapFormRQ.put("LOT.", new Integer(143));
        mapFormRQ.put("CR. TOP.", new Integer(115));
        mapFormRQ.put("SOL. OPH.", new Integer(206));
        mapFormRQ.put("SUSP. INJ. S.C.", new Integer(223));
        mapFormRQ.put("CR. VAG. (UNIDOSE)", new Integer(117));
        mapFormRQ.put("PD./SOL. PERF. I.V", new Integer(207));
        mapFormRQ.put("TIMBRE CUT. (3)", new Integer(160));
        mapFormRQ.put("PATE", new Integer(158));
        mapFormRQ.put("SOL. ORALE", new Integer(208));
        mapFormRQ.put("SOL. INJ. (APP.)", new Integer(223));
        mapFormRQ.put("AERO OU VAP NASAL", new Integer(105));
        mapFormRQ.put("CAPS.", new Integer(167));
        mapFormRQ.put("SUSP. OPH.", new Integer(225));
        mapFormRQ.put("ELIX. SANS SUCRE", new Integer(209));
        mapFormRQ.put("PD. ORALE", new Integer(191));
        mapFormRQ.put("SOL. DE RINCAGE", new Integer(211));
        mapFormRQ.put("GEL RECTAL", new Integer(125));
        mapFormRQ.put("VAP. NASAL", new Integer(105));
        mapFormRQ.put("PD. ORALE PED.", new Integer(191));
        mapFormRQ.put("SOL. OPH. GEL", new Integer(128));
        mapFormRQ.put("SOL. RECT. PED.", new Integer(213));
        mapFormRQ.put("SOL. SANS ALCOOL", new Integer(197));
        mapFormRQ.put("CR. VAG.", new Integer(116));
        mapFormRQ.put("CO. L.A. (24 H)", new Integer(187));
        mapFormRQ.put("CO. L.A. (12 H)", new Integer(186));
        mapFormRQ.put("SAC", new Integer(197));
        mapFormRQ.put("CO. EFF.", new Integer(181));
        mapFormRQ.put("GEL OPH.", new Integer(128));
        mapFormRQ.put("PULV. S.- LING.", new Integer(218));
        mapFormRQ.put("SOL. INJ. I.V.", new Integer(207));
        mapFormRQ.put("LIQ.", new Integer(197));
        mapFormRQ.put("SOL. ORALE PED.", new Integer(226));
        mapFormRQ.put("CR. TOP. HUIL.", new Integer(115));
        mapFormRQ.put("SOL. INJ. S.C. (SE", new Integer(197));
        mapFormRQ.put("CO. CROQ.", new Integer(179));
        mapFormRQ.put("SOL. TOP.", new Integer(214));
        mapFormRQ.put("ANNEAU VAG.", new Integer(227));
        mapFormRQ.put("PD. POUR INH.", new Integer(138));
        mapFormRQ.put("ELIX. PED.", new Integer(209));
        mapFormRQ.put("GEL TOP.", new Integer(130));
        mapFormRQ.put("CAPS. L.A.", new Integer(171));
        mapFormRQ.put("SUSP. INJ. I.M.", new Integer(223));
        mapFormRQ.put("SIR.", new Integer(212));
        mapFormRQ.put("SOL. INJ.", new Integer(197));
        mapFormRQ.put("CAPS. A SAUPOUDRER", new Integer(167));
        mapFormRQ.put("PD. (USAGE EXTERNE", new Integer(214));
        mapFormRQ.put("SOL. POUR INH.", new Integer(103));
        mapFormRQ.put("PD. PERF. I.V.", new Integer(207));
        mapFormRQ.put("CO. (91)", new Integer(175));
        mapFormRQ.put("SOL. UROL.", new Integer(203));
        mapFormRQ.put("CR. TOP. (EMOL.)", new Integer(115));
        mapFormRQ.put("GEL TOP. (ORAL)", new Integer(130));
        mapFormRQ.put("PD. INJ. I.M.", new Integer(197));
        mapFormRQ.put("LIQ. (RECT.)", new Integer(213));
        mapFormRQ.put("SOL. INJ. S.C.", new Integer(197));
        mapFormRQ.put("CO. VAG. (EFF.)", new Integer(190));
        mapFormRQ.put("PANS.", new Integer(159));
        mapFormRQ.put("POM. TOP. (ORALE)", new Integer(153));
        mapFormRQ.put("CAPS. OU CO.", new Integer(166));
        mapFormRQ.put("SOL. INJ. HUIL.", new Integer(197));
        mapFormRQ.put("CO. OU CO. DISS. O", new Integer(181));
        mapFormRQ.put("CO. L.A.", new Integer(184));
        mapFormRQ.put("CO. VAG.", new Integer(190));
        mapFormRQ.put("CO. DISS. ORALE", new Integer(181));
        mapFormRQ.put("APRES-SHAMP.", new Integer(142));
        mapFormRQ.put("GEL VAG.", new Integer(132));
        mapFormRQ.put("SOL. INJ. I.M.", new Integer(197));
        mapFormRQ.put("PD.", new Integer(223));
        mapFormRQ.put("PD. INJ. S.C.", new Integer(197));
        mapFormRQ.put("SOL. CAP.", new Integer(144));
        mapFormRQ.put("IMPLANT", new Integer(227));
        mapFormRQ.put("GOMME A MACHER", new Integer(135));
        mapFormRQ.put("CAPS. ENT.", new Integer(169));
        mapFormRQ.put("EMULS. TOP.", new Integer(214));
        mapFormRQ.put("LOT. CAP.", new Integer(144));
        mapFormRQ.put("CAPS. L.A. (12 H)", new Integer(173));
        mapFormRQ.put("CARTOUCHE", new Integer(197));
        mapFormRQ.put("PD. POUR INH. NAS.", new Integer(136));
        mapFormRQ.put("SOL. INJ. S.C. (AP", new Integer(197));
        mapFormRQ.put("PD. INJ./TOP.", new Integer(197));
        mapFormRQ.put("SOL. INJ. EPI.", new Integer(197));
        mapFormRQ.put("ELIX.", new Integer(209));
        mapFormRQ.put("GEL VAG. (APP.)", new Integer(133));
        mapFormRQ.put("BANDELETTE", new Integer(232));
        mapFormRQ.put("SOL. PERF. I.V.", new Integer(197));
        mapFormRQ.put("POM. RECT. (APP.)", new Integer(152));
        mapFormRQ.put("MECHE", new Integer(157));
        mapFormRQ.put("TROUSSE", new Integer(174));
        mapFormRQ.put("SERINGUE", new Integer(197));
        mapFormRQ.put("VAP. TOP.", new Integer(218));
        mapFormRQ.put("POM. OPH.", new Integer(150));
        mapFormRQ.put("SUPP.", new Integer(219));
        mapFormRQ.put("SOL. NAS.", new Integer(216));
        mapFormRQ.put("BAND.", new Integer(158));
        mapFormRQ.put("SOL. OT.", new Integer(197));
        mapFormRQ.put("CO L.A.", new Integer(184));
        mapFormRQ.put("CR. VAG. (APP.)", new Integer(117));
        mapFormRQ.put("CO. (28)", new Integer(175));
        mapFormRQ.put("CO. S-LING.", new Integer(189));
        mapFormRQ.put("POM. TOP.", new Integer(153));
        mapFormRQ.put("SOL. RECT.", new Integer(213));
        mapFormRQ.put("GRAN.", new Integer(134));
        mapFormRQ.put("CAPS. L.A. (24 H)", new Integer(187));
        mapFormRQ.put("CO.", new Integer(174));
        mapFormSC = new HashMap<String, Integer>();
        mapFormSC.put("TABLET (ENTERIC-COATED)", new Integer(183));
        mapFormSC.put("CAPSULE (SUSTAINED-RELEASE)", new Integer(171));
        mapFormSC.put("PATCH (EXTENDED RELEASE)", new Integer(160));
        mapFormSC.put("SOAP BAR", new Integer(106));
        mapFormSC.put("LEAF", new Integer(248));
        mapFormSC.put("SOLUTION (LONG-ACTING)", new Integer(197));
        mapFormSC.put("PIECE (CHEWABLE)", new Integer(247));
        mapFormSC.put("RING (SLOW-RELEASE)", new Integer(227));
        mapFormSC.put("LIPOSOMES", new Integer(223));
        mapFormSC.put("GRANULES FOR SUSPENSION,EXTENDED RELEASE", new Integer(134));
        mapFormSC.put("CAPSULE (ENTERIC-COATED)", new Integer(169));
        mapFormSC.put("MOUTHWASH/GARGLE", new Integer(211));
        mapFormSC.put("TABLET (EFFERVESCENT)", new Integer(181));
        mapFormSC.put("CAPSULE (IMMEDIATE RELEASE)", new Integer(167));
        mapFormSC.put("AEROSOL, METERED DOSE", new Integer(104));
        mapFormSC.put("SEED", new Integer(134));
        mapFormSC.put("PAD", new Integer(156));
        mapFormSC.put("TOOTHPASTE", new Integer(238));
        mapFormSC.put("GLOBULES", new Integer(108));
        mapFormSC.put("SUPPOSITORY (SUSTAINED-RELEASE)", new Integer(219));
        mapFormSC.put("POWDER (EFFERVESCENT)", new Integer(191));
        mapFormSC.put("SOLUTION", new Integer(197));
        mapFormSC.put("SPRAY, METERED DOSE", new Integer(104));
        mapFormSC.put("TABLET (ORALLY DISINTEGRATING)", new Integer(181));
        mapFormSC.put("GRANULES FOR SUSPENSION, DELAYED RELEASE", new Integer(134));
        mapFormSC.put("GEL", new Integer(125));
        mapFormSC.put("SHAMPOO", new Integer(142));
        mapFormSC.put("SUSPENSION (ULTRA-LENTE)", new Integer(227));
        mapFormSC.put("TABLET (COMBINED RELEASE)", new Integer(180));
        mapFormSC.put("SPRAY, BAG-ON-VALVE", new Integer(218));
        mapFormSC.put("BAR (CHEWABLE)", new Integer(247));
        mapFormSC.put("DRESSING", new Integer(156));
        mapFormSC.put("POWDER (EXTENDED RELEASE)", new Integer(191));
        mapFormSC.put("DRUG PREMIX", new Integer(166));
        mapFormSC.put("PENCIL", new Integer(232));
        mapFormSC.put("CAPSULE (DELAYED RELEASE)", new Integer(171));
        mapFormSC.put("POWDER", new Integer(191));
        mapFormSC.put("SYRUP (EXTENDED-RELEASE)", new Integer(212));
        mapFormSC.put("GAS", new Integer(242));
        mapFormSC.put("TAPE", new Integer(158));
        mapFormSC.put("POWDER (ENTERIC-COATED)", new Integer(191));
        mapFormSC.put("METERED-DOSE (AEROSOL)", new Integer(104));
        mapFormSC.put("PACKAGE", new Integer(174));
        mapFormSC.put("TABLET", new Integer(174));
        mapFormSC.put("DISC", new Integer(119));
        mapFormSC.put("CAPSULE", new Integer(167));
        mapFormSC.put("METERED-DOSE PUMP", new Integer(104));
        mapFormSC.put("LOTION", new Integer(143));
        mapFormSC.put("INSERT", new Integer(166));
        mapFormSC.put("TEA (HERBAL)", new Integer(208));
        mapFormSC.put("PILL", new Integer(166));
        mapFormSC.put("VAGINAL TABLET", new Integer(190));
        mapFormSC.put("SUSPENSION (LENTE)", new Integer(227));
        mapFormSC.put("LIQUID", new Integer(197));
        mapFormSC.put("LOZENGE", new Integer(188));
        mapFormSC.put("SOLUTION (EXTENDED RELEASE)", new Integer(197));
        mapFormSC.put("0-UNASSIGNED", new Integer(166));
        mapFormSC.put("CORD", new Integer(166));
        mapFormSC.put("TABLET FOR SUSPENSION", new Integer(181));
        mapFormSC.put("STRIP", new Integer(232));
        mapFormSC.put("DISC (EXTENDED-RELEASE)", new Integer(119));
        mapFormSC.put("TABLET (DELAYED AND IMMEDIATE RELEASE)", new Integer(182));
        mapFormSC.put("WIPE", new Integer(156));
        mapFormSC.put("VAGINAL TABLET, EFFERVESCENT", new Integer(190));
        mapFormSC.put("OVULE", new Integer(222));
        mapFormSC.put("CARTRIDGE", new Integer(156));
        mapFormSC.put("SUSPENSION", new Integer(223));
        mapFormSC.put("ENEMA", new Integer(205));
        mapFormSC.put("SUPPOSITORY", new Integer(219));
        mapFormSC.put("PELLET", new Integer(237));
        mapFormSC.put("TINCTURE", new Integer(217));
        mapFormSC.put("TABLET (IMMEDIATE RELEASE)", new Integer(174));
        mapFormSC.put("GRANULES", new Integer(134));
        mapFormSC.put("GEL (CONTROLLED-RELEASE)", new Integer(125));
        mapFormSC.put("PAINT", new Integer(118));
        mapFormSC.put("DOUCHE", new Integer(204));
        mapFormSC.put("KIT", new Integer(166));
        mapFormSC.put("TABLET (CHEWABLE)", new Integer(179));
        mapFormSC.put("TABLET (DELAYED AND EXTENDED RELEASE)", new Integer(182));
        mapFormSC.put("SWAB", new Integer(232));
        mapFormSC.put("PLASTER", new Integer(245));
        mapFormSC.put("EMULSION", new Integer(197));
        mapFormSC.put("JAM", new Integer(239));
        mapFormSC.put("STICK", new Integer(232));
        mapFormSC.put("BLOOD COLLECTION", new Integer(197));
        mapFormSC.put("PATCH", new Integer(159));
        mapFormSC.put("IMPLANT", new Integer(227));
        mapFormSC.put("SPONGE", new Integer(246));
        mapFormSC.put("ELIXIR", new Integer(209));
        mapFormSC.put("TABLET (EXTENDED-RELEASE)", new Integer(184));
        mapFormSC.put("AEROSOL", new Integer(101));
        mapFormSC.put("DROPS", new Integer(198));
        mapFormSC.put("PASTE", new Integer(158));
        mapFormSC.put("CAPSULE (EXTENDED RELEASE)", new Integer(171));
        mapFormSC.put("TABLET (DELAYED-RELEASE)", new Integer(182));
        mapFormSC.put("SUSPENSION (EXTENDED-RELEASE)", new Integer(227));
        mapFormSC.put("OINTMENT", new Integer(147));
        mapFormSC.put("CAPSULE (CONTROLLED-DELIVERY)", new Integer(167));
        mapFormSC.put("FLOSS", new Integer(166));
        mapFormSC.put("GRANULES FOR SUSPENSION", new Integer(134));
        mapFormSC.put("GUM", new Integer(135));
        mapFormSC.put("BOLUS", new Integer(197));
        mapFormSC.put("SYRUP", new Integer(212));
        mapFormSC.put("INSERT (EXTENDED-RELEASE)", new Integer(227));
        mapFormSC.put("POWDER FOR SOLUTION", new Integer(191));
        mapFormSC.put("SPRAY", new Integer(218));
        mapFormSC.put("POWDER FOR SUSPENSION, SUSTAINED-RELEASE", new Integer(191));
        mapFormSC.put("CREAM", new Integer(109));
        mapFormSC.put("TABLET (SLOW-RELEASE)", new Integer(180));
        mapFormSC.put("POWDER FOR SUSPENSION", new Integer(191));
        mapFormSC.put("WAFER", new Integer(248));
        mapFormSC.put("PELLET (DENTAL)", new Integer(237));
        mapFormSC.put("JELLY", new Integer(125));
        ROUTE_TEXT = new String[]{Messages.getString("PER_OS", new String[0]), Messages.getString("RECTAL", new String[0]), Messages.getString("VAGINAL", new String[0]), Messages.getString("LOCAL", new String[0]), Messages.getString("INTRANASAL", new String[0]), Messages.getString("SUBLINGUAL", new String[0]), Messages.getString("OEIL_G", new String[0]), Messages.getString("OEIL_D", new String[0]), Messages.getString("YEUX", new String[0]), Messages.getString("OREILLE_G", new String[0]), Messages.getString("OREILLE_D", new String[0]), Messages.getString("OREILLES", new String[0]), Messages.getString("SC", new String[0]), Messages.getString("INTRAMUSCULAIRE", new String[0]), Messages.getString("AUTRE_PRECISEZ", new String[0]), Messages.getString("INTRAVEINEUX", new String[0]), Messages.getString("INTRATHECALE", new String[0]), Messages.getString("INTRAVESICAL", new String[0]), Messages.getString("INTRALESIONNEL", new String[0])};
        FORMAT_TEXT = new String[]{Messages.getString("CO", new String[0]), Messages.getString("CO_ENTER", new String[0]), Messages.getString("CO_MASTIC", new String[0]), Messages.getString("CO_DISSOL_ORALE", new String[0]), Messages.getString("CO_LA", new String[0]), Messages.getString("CO_28J", new String[0]), Messages.getString("CO_21J", new String[0]), Messages.getString("CAPS", new String[0]), Messages.getString("CAPS_CO", new String[0]), Messages.getString("CAPS_LA", new String[0]), Messages.getString("OVULE", new String[0]), Messages.getString("SUPPOSITOIRE", new String[0]), Messages.getString("SUSP", new String[0]), Messages.getString("SOL", new String[0]), Messages.getString("CREME", new String[0]), Messages.getString("ONGUENT", new String[0]), Messages.getString("POMMADE", new String[0]), Messages.getString("TIMBRE_CUTANE", new String[0]), Messages.getString("AEROSOL_DOSEUR", new String[0]), Messages.getString("INHAL", new String[0]), Messages.getString("POUDRE_INHALATION", new String[0]), Messages.getString("PULVERISATEUR_SL", new String[0]), Messages.getString("VAPORISATEUR", new String[0]), Messages.getString("AUTRE_PRECISEZ", new String[0]), Messages.getString("BATONNET", new String[0])};
    }

    public static class RxData
    implements Serializable {
        public final String pos;
        public final String freq;
        public final Integer qte;
        public final Integer jrs;
        public final Integer rep;

        public RxData(String pos, String freq, Integer qte, Integer jrs, Integer rep) {
            this.pos = pos;
            this.freq = freq;
            this.qte = qte;
            this.jrs = jrs;
            this.rep = rep;
        }
    }

    protected class StrengthClosure
    implements Closure,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected StrengthClosure() {
        }

        public void execute(Object o) {
            XDrugStrength str = (XDrugStrength)o;
            if (str != null) {
                XPrescription.this.setDin(str.getDin());
            }
        }
    }
}

