/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.medication;

import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDevice;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugStrength;
import ca.infodata.ofys.data.middle.dataobjects.medication.XDrugType;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyHumanSubstanceAdministrationSite;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyOrderableDrugForm;
import ca.infodata.ofys.data.middle.dataobjects.medication.XMyRouteOfAdministration;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.util1.JoinList;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public final class XFavPrescription
extends EditableDataObject {
    private static final long serialVersionUID = 1L;
    public Integer din;
    public Integer quantity;
    public Integer treatmentDuration;
    public XMyRouteOfAdministration route;
    public XMyOrderableDrugForm format;
    public XMyHumanSubstanceAdministrationSite site;
    public Integer rx;
    public String posology;
    public Boolean noSubstitution;
    public XDevice device;
    public XDrugStrength strength;
    public String frequency;
    public Boolean toReprescribeB;
    public Integer id;
    public String note;
    public Boolean isDeleted;
    public String dsqIt1;
    public String dsqIt2;
    public String dsqIt3;
    public String dsqIt4;
    public String dsqIt5;
    public Integer professionnal;
    public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);
    private String completeNameForFavorites;

    public EnumSet<XEncounterLabel> getEncLabel() {
        return this.encLabel;
    }

    public void setEncLabel(EnumSet<XEncounterLabel> status) {
        this.encLabel = status;
        this.setUpdated();
    }

    public void removeXEncounterLabel(XEncounterLabel x) {
        this.encLabel.remove(x);
        this.setUpdated();
    }

    public void addXEncounterLabel(XEncounterLabel x) {
        this.encLabel.add(x);
        this.setUpdated();
    }

    public XFavPrescription() {
    }

    public XFavPrescription(XPrescription x) {
        this.din = x.din;
        this.quantity = x.quantity;
        this.treatmentDuration = x.treatmentDuration;
        this.route = x.route;
        this.site = x.site;
        this.format = x.format;
        this.rx = x.rx;
        this.posology = x.posology;
        this.isDeleted = Boolean.FALSE;
        this.toReprescribeB = x.toReprescribe;
        this.device = x.device == null ? null : x.device.clone();
        this.strength = x.strength == null ? null : x.strength.clone();
        this.frequency = x.frequency;
        this.note = x.note;
        this.dsqIt1 = x.dsqIt1;
        this.dsqIt2 = x.dsqIt2;
        this.dsqIt3 = x.dsqIt3;
        this.dsqIt4 = x.dsqIt4;
        this.dsqIt5 = x.dsqIt5;
        this.encLabel = x.encLabel.clone();
        this.setNew();
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    @Override
    public boolean isDirty() {
        boolean dirty = super.isDirty() || this.strength != null && this.strength.isDirty() || this.device != null && this.device.isDirty();
        return dirty;
    }

    public String getGenericDrugNameStrengthPosol() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.getStrength() != null) {
            lst.add(this.getStrength().getGenericName());
        }
        lst.add(this.getPosology());
        return new JoinList(" ", lst).toString();
    }

    public final String getCompleteNameForFavorites() {
        if (this.completeNameForFavorites == null) {
            this.completeNameForFavorites = this.getGenericDrugNameStrengthPosol() + this.getFormat().value() + this.getFrequency() + this.getRx().toString();
        }
        return this.completeNameForFavorites;
    }

    public String getCommercialDrugNameStrengthPosol() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.getStrength() != null) {
            lst.add(this.getStrength().getCommercialName());
        }
        lst.add(this.getPosology());
        return new JoinList(" ", lst).toString();
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
        this.setUpdated();
    }

    public Integer getTreatmentDuration() {
        return this.treatmentDuration;
    }

    public void setTreatmentDuration(Integer treatmentDuration) {
        this.treatmentDuration = treatmentDuration;
        this.setUpdated();
    }

    public XMyRouteOfAdministration getRoute() {
        return this.route;
    }

    public void setRoute(XMyRouteOfAdministration route) {
        this.route = route;
        this.setUpdated();
    }

    public XMyOrderableDrugForm getFormat() {
        return this.format;
    }

    public void setFormat(XMyOrderableDrugForm format) {
        this.format = format;
        this.setUpdated();
    }

    public Integer getRx() {
        return this.rx;
    }

    public void setRx(Integer rx) {
        this.rx = rx;
        this.setUpdated();
    }

    public String getPosology() {
        return this.posology;
    }

    public void setPosology(String posology) {
        this.posology = posology;
        this.setUpdated();
    }

    public Boolean getNoSubstitution() {
        return this.noSubstitution;
    }

    public void setNoSubstitution(Boolean noSubstitution) {
        this.noSubstitution = noSubstitution;
        this.setUpdated();
    }

    public Integer getProfessionnal() {
        return this.professionnal;
    }

    public void setProfessionnal(Integer professionnal) {
        this.professionnal = professionnal;
        this.setUpdated();
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    public XDevice getDevice() {
        return this.device;
    }

    public void setDevice(XDevice d) {
        this.device = d;
        this.setUpdated();
    }

    public XDrugStrength getStrength() {
        return this.strength;
    }

    public void setStrength(XDrugStrength strength) {
        this.strength = strength;
        this.setUpdated();
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
        this.setUpdated();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public void useInformationFrom(XFavPrescription prescription) {
        if (prescription == null) {
            throw new NullPointerException("prescription");
        }
        ObjectListenerManager.disable(this);
        this.setQuantity(prescription.getQuantity());
        this.setTreatmentDuration(prescription.getTreatmentDuration());
        this.setRoute(prescription.getRoute());
        this.setFormat(prescription.getFormat());
        this.setRx(prescription.getRx());
        this.setPosology(prescription.getPosology());
        this.setIsDeleted(prescription.getIsDeleted());
        this.setDevice(prescription.getDevice());
        this.setStrength(prescription.getStrength());
        this.setFrequency(prescription.getFrequency());
        this.setToReprescribeB(prescription.getToReprescribeB());
        this.setNote(prescription.getNote());
        this.setDsqIt1(prescription.getDsqIt1());
        this.setDsqIt2(prescription.getDsqIt2());
        this.setDsqIt3(prescription.getDsqIt3());
        this.setDsqIt4(prescription.getDsqIt4());
        this.setDsqIt5(prescription.getDsqIt5());
        ObjectListenerManager.enable(this, true);
    }

    @Override
    public XFavPrescription clone() {
        XFavPrescription c = (XFavPrescription)super.clone();
        c.id = this.id;
        c.din = this.din;
        c.quantity = this.quantity;
        c.treatmentDuration = this.treatmentDuration;
        c.route = this.route;
        c.site = this.site;
        c.format = this.format;
        c.rx = this.rx;
        c.posology = this.posology;
        c.isDeleted = this.isDeleted;
        c.toReprescribeB = this.toReprescribeB;
        c.device = this.device == null ? null : this.device.clone();
        c.strength = this.strength == null ? null : this.strength.clone();
        c.frequency = this.frequency;
        c.note = this.note;
        c.dsqIt1 = this.dsqIt1;
        c.dsqIt2 = this.dsqIt2;
        c.dsqIt3 = this.dsqIt3;
        c.dsqIt4 = this.dsqIt4;
        c.dsqIt5 = this.dsqIt5;
        c.encLabel = this.encLabel.clone();
        return c;
    }

    public Boolean getToReprescribeB() {
        return this.toReprescribeB;
    }

    public void setToReprescribeB(Boolean toReprescribe) {
        this.toReprescribeB = toReprescribe;
    }

    public XMyHumanSubstanceAdministrationSite getSite() {
        return this.site;
    }

    public void setSite(XMyHumanSubstanceAdministrationSite site) {
        this.site = site;
    }

    @Override
    public String toString() {
        return String.format("XPrescription [id=%s, quantity=%s, treatmentDuration=%s, route=%s, format=%s, site=%s, rx=%s, posology=%s, isDeleted=%s, strength=%s, frequency=%s, toReprescribeB=%s]", new Object[]{this.getId(), this.quantity, this.treatmentDuration, this.route, this.format, this.site, this.rx, this.posology, this.isDeleted, this.strength, this.frequency, this.toReprescribeB});
    }

    @Override
    protected void childModified(Object object) {
        if (this.getStrength() != null && this.getStrength().getDrugType() == XDrugType.FOURNITURE) {
            ObjectListenerManager.disable(this);
            this.setStrength(null);
            this.setFormat(null);
            this.setSite(null);
            this.setFrequency(null);
            this.setRoute(null);
            ObjectListenerManager.enable(this, false);
        }
        super.childModified(object);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XFavPrescription) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XPrescription" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    public Integer getDin() {
        return this.din;
    }

    public void setDin(Integer din) {
        this.din = din;
        this.setUpdated();
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.setUpdated();
    }

    public String getDsqIt1() {
        return this.dsqIt1;
    }

    public void setDsqIt1(String dsqIt1) {
        this.dsqIt1 = dsqIt1;
        this.setUpdated();
    }

    public String getDsqIt2() {
        return this.dsqIt2;
    }

    public void setDsqIt2(String dsqIt2) {
        this.dsqIt2 = dsqIt2;
        this.setUpdated();
    }

    public String getDsqIt3() {
        return this.dsqIt3;
    }

    public void setDsqIt3(String dsqIt3) {
        this.dsqIt3 = dsqIt3;
        this.setUpdated();
    }

    public String getDsqIt4() {
        return this.dsqIt4;
    }

    public void setDsqIt4(String dsqIt4) {
        this.dsqIt4 = dsqIt4;
        this.setUpdated();
    }

    public String getDsqIt5() {
        return this.dsqIt5;
    }

    public void setDsqIt5(String dsqIt5) {
        this.dsqIt5 = dsqIt5;
        this.setUpdated();
    }

    public String formatName(XPrescriptionDrugNameFormat format) {
        StringBuilder ret = new StringBuilder(30);
        switch (format) {
            case GENERIC_AND_COMMERCIAL: {
                ret.append(this.getStrength().getGenericName());
                ret.append(" (");
                ret.append(this.getStrength().getCommercialName());
                ret.append(")");
                break;
            }
            case COMMERCIAL_AND_GENERIC: {
                ret.append(this.getStrength().getCommercialName());
                ret.append(" (");
                ret.append(this.getStrength().getGenericName());
                ret.append(")");
                break;
            }
            case COMMERCIAL: {
                ret.append(this.getStrength().getCommercialName());
                break;
            }
            case GENERIC: {
                ret.append(this.getStrength().getGenericName());
            }
        }
        return ret.toString();
    }

    public String getDsqIt() {
        ArrayList<String> lst = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.getDsqIt1())) {
            lst.add("P1:" + this.getDsqIt1().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDsqIt2())) {
            lst.add("P2:" + this.getDsqIt2().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDsqIt3())) {
            lst.add("P3:" + this.getDsqIt3().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDsqIt4())) {
            lst.add("P4:" + this.getDsqIt4().trim());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDsqIt5())) {
            lst.add("P5:" + this.getDsqIt5().trim());
        }
        String ss = lst.size() == 0 ? "" : new JoinList(", ", lst).toString();
        return ss;
    }
}

