/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.MultiIntegerRange;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class XAppointmentDateStatistics2
implements Serializable {
    private static final long serialVersionUID = 1L;
    public List<Appointment> appointments;
    public List<Period> periods;
    public LocalDate date;
    public int idDate;
    public int idProf;

    public XAppointmentDateStatistics2(int idProf, int idDate, LocalDate date, int professionalId) {
        this.idProf = idProf;
        this.idDate = idDate;
        this.date = date;
        this.appointments = Collections.emptyList();
        this.periods = Collections.emptyList();
    }

    public XAppointmentDateStatistics2(int idProf, int idDate, LocalDate date, List<Appointment> appointments, List<Period> periods) {
        this.idProf = idProf;
        this.idDate = idDate;
        this.date = date;
        this.appointments = appointments;
        this.periods = periods;
    }

    public int computeNbAppointmentOutsidePeriods() {
        if (this.periods.isEmpty()) {
            return this.appointments.size();
        }
        ArrayList<IntegerRange> ranges = new ArrayList<IntegerRange>();
        for (Period period : this.periods) {
            ranges.add(new IntegerRange(Integer.valueOf(period.startTime), Integer.valueOf(period.endTime), RangeNotation.LEFT_CLOSED));
        }
        int count = 0;
        IntegerRange range2 = new IntegerRange();
        range2.notation = RangeNotation.LEFT_CLOSED;
        for (Appointment a : this.appointments) {
            range2.start = Integer.valueOf(a.startTime);
            range2.end = Integer.valueOf(a.endTime);
            if ((Integer)range2.start >= (Integer)range2.end) continue;
            boolean intersect = false;
            for (int i = 0; i < ranges.size() && !intersect; ++i) {
                intersect = ((IntegerRange)ranges.get(i)).intersect((Range)range2);
            }
            if (intersect) continue;
            ++count;
        }
        return count;
    }

    public boolean hasFreeSpaceAbsolute(int[] periodTypesToExclude) {
        MultiIntegerRange ranges = new MultiIntegerRange();
        for (Period period : this.periods) {
            if (period.isClosed || periodTypesToExclude != null && Arrays.binarySearch(periodTypesToExclude, period.idType) >= 0) continue;
            ranges.add(new IntegerRange(Integer.valueOf(period.startTime), Integer.valueOf(period.endTime), RangeNotation.LEFT_CLOSED));
        }
        if (ranges.getRanges().isEmpty()) {
            return false;
        }
        IntegerRange arange = new IntegerRange(null, null, RangeNotation.LEFT_CLOSED);
        for (Appointment a : this.appointments) {
            arange.start = Integer.valueOf(a.startTime);
            arange.end = Integer.valueOf(a.endTime);
            if ((Integer)arange.start >= (Integer)arange.end) continue;
            ranges.remove(arange);
        }
        return ranges.getRanges().size() > 0;
    }

    public int computeNbSpaceUsed(int[] periodTypesToExclude, boolean countOverbooking) {
        ArrayList<IntegerRange> ranges = new ArrayList<IntegerRange>();
        for (Period period : this.periods) {
            if (period.isClosed || periodTypesToExclude != null && Arrays.binarySearch(periodTypesToExclude, period.idType) >= 0) continue;
            int count = (period.endTime - period.startTime) / period.defaultAppointmentLength;
            for (int i = 0; i < count; ++i) {
                int start = period.startTime + period.defaultAppointmentLength * i;
                int end = start + period.defaultAppointmentLength;
                ranges.add(new IntegerRange(Integer.valueOf(start), Integer.valueOf(end), RangeNotation.LEFT_CLOSED));
            }
        }
        if (ranges.isEmpty()) {
            return 0;
        }
        int count = 0;
        IntegerRange arange = new IntegerRange(null, null, RangeNotation.LEFT_CLOSED);
        for (Appointment a : this.appointments) {
            arange.start = Integer.valueOf(a.startTime);
            arange.end = Integer.valueOf(a.endTime);
            Iterator iterator = ranges.iterator();
            while (iterator.hasNext()) {
                IntegerRange prange = (IntegerRange)iterator.next();
                if (!prange.intersect((Range)arange)) continue;
                if (!countOverbooking) {
                    iterator.remove();
                }
                ++count;
            }
        }
        return count;
    }

    public int computeNbSpace(int[] periodTypesToExclude) {
        int count = 0;
        for (Period period : this.periods) {
            if (period.isClosed || periodTypesToExclude != null && Arrays.binarySearch(periodTypesToExclude, period.idType) >= 0) continue;
            count += (period.endTime - period.startTime) / period.defaultAppointmentLength;
        }
        return count;
    }

    public String toString() {
        return String.format("XAppointmentDateStatistics2 [idProf=%s, date=%s, periods=%s, appointments=%s]", this.idProf, this.date, this.periods, this.appointments);
    }

    public static final class Period
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int id;
        public int startTime;
        public int endTime;
        public int defaultAppointmentLength;
        public int idType;
        public boolean isClosed;
    }

    public static final class Appointment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int id;
        public int startTime;
        public int endTime;
        public XAppointmentStatus status;
        public XPatientStatus patientStatus;
    }
}

