/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentCancelledBy;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentContactMethod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.chat.MessageLink;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.Listenable;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.patient.IPatientRelated;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.EnumWithValues;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.ofys.util.json.IJsonWriter;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class XAppointment
extends EditableDataObject
implements Comparable<XAppointment>,
IPatientRelated,
IVisualAppointment,
IAppointment,
KryoSerializable {
    private static final long serialVersionUID = 1L;
    public EditableDataObject.Property<Integer> id = this.newProperty("id", null);
    public EditableDataObject.Property<Short> startTime = this.newProperty("startTime", (short)0);
    public EditableDataObject.Property<Short> endTime = this.newProperty("endTime", (short)0);
    public EditableDataObject.Property<Short> arrivedTime = this.newProperty("arrivedTime", null);
    public EditableDataObject.Property<Short> seenTime = this.newProperty("seenTime", null);
    public EditableDataObject.Property<XPatientStatus> patientStatus;
    public EditableDataObject.Property<XAppointmentStatus> status = this.newProperty("status", XAppointmentStatus.NORMAL, true);
    public EditableDataObject.Property<Boolean> isAnnualExam;
    public EditableDataObject.Property<String> note;
    public EditableDataObject.Property<String> statusNote;
    public EditableDataObject.Property<Boolean> autoSendReminder;
    public EditableDataObject.Property<Long> timeReminderDone;
    public EditableDataObject.Property<Short> nbHreBeforeAppt;
    public EditableDataObject.Property<Boolean> isDeleted;
    public EditableDataObject.Property<Boolean> isConfidential;
    public EditableDataObject.Property<Short> categoryType;
    public EditableDataObject.Property<Long> dateCreated;
    public EditableDataObject.Property<Long> dateEntryLast;
    public EditableDataObject.Property<String> nameUser;
    public EditableDataObject.Property<Integer> idAppointmentDate;
    public EditableDataObject.Property<LocalDate> date;
    public EditableDataObject.Property<Integer> idProfessional;
    public EditableDataObject.Property<Set<Integer>> idProfessionals;
    public EditableDataObject.Property<List<XPatient>> patients;
    public EditableDataObject.Property<Integer> typeAppointment;
    public EditableDataObject.Property<Integer> idSite;
    public EditableDataObject.Property<Integer> professionnalReferer;
    public EditableDataObject.Property<Integer> externalId;
    public EditableDataObject.Property<String> consultationReason;
    public EditableDataObject.Property<Boolean> wasProfNameHidden;
    public EditableDataObject.Property<String> notePatient;
    public EditableDataObject.Property<Integer> idService;
    public EditableDataObject.Property<String> availabilityId;
    public EditableDataObject.Property<Boolean> hasOldAvailabilityId;
    public EditableDataObject.Property<Boolean> cancelled;
    public EditableDataObject.Property<Long> cancelledDate;
    public EditableDataObject.Property<XAppointmentCancelledBy> cancelledBy;
    public EditableDataObject.Property<EnumSet<XEncounterLabel>> encLabel;
    public EditableDataObject.Property<String> adhocPatient;
    private EditableDataObject.Property<XPatient> adhocXPatient;
    private transient boolean parsedAdhocPatient;
    private String contactMethods;
    private transient List<XAppointmentContactMethod> contactMethodsList;
    private transient boolean parsedContactMethods;

    @Override
    public void write(Kryo k, Output output) {
        output.writeInt(MiscUtil.fromInt(this.id.get()));
        output.writeShort((int)MiscUtil.fromShort(this.startTime.get()));
        output.writeShort((int)MiscUtil.fromShort(this.endTime.get()));
        output.writeShort((int)MiscUtil.fromShort(this.arrivedTime.get()));
        output.writeShort((int)MiscUtil.fromShort(this.seenTime.get()));
        output.writeByte(MiscUtil.fromIntToByte(this.patientStatus.get() == null ? null : Integer.valueOf(this.patientStatus.get().getValue())));
        output.writeByte(MiscUtil.fromIntToByte(this.status.get() == null ? null : Integer.valueOf(this.status.get().getValue())));
        output.writeByte(MiscUtil.fromBoolean(this.isAnnualExam.get()));
        output.writeString(MiscUtil.fromString(this.note.get()));
        output.writeString(MiscUtil.fromString(this.statusNote.get()));
        output.writeByte(MiscUtil.fromBoolean(this.autoSendReminder.get()));
        output.writeLong(MiscUtil.fromLong(this.timeReminderDone.get()));
        output.writeShort((int)MiscUtil.fromShort(this.nbHreBeforeAppt.get()));
        output.writeByte(MiscUtil.fromBoolean(this.isDeleted.get()));
        output.writeByte(MiscUtil.fromBoolean(this.isConfidential.get()));
        output.writeShort((int)MiscUtil.fromShort(this.categoryType.get()));
        output.writeLong(MiscUtil.fromLong(this.dateCreated.get()));
        output.writeLong(MiscUtil.fromLong(this.dateEntryLast.get()));
        output.writeString(MiscUtil.fromString(this.nameUser.get()));
        output.writeInt(MiscUtil.fromInt(this.idAppointmentDate.get()));
        output.writeInt(MiscUtil.fromLocalDate(this.date.get()));
        output.writeInt(MiscUtil.fromInt(this.idProfessional.get()));
        output.writeInt(MiscUtil.fromInt(this.typeAppointment.get()));
        output.writeInt(MiscUtil.fromInt(this.idSite.get()));
        output.writeInt(MiscUtil.fromInt(this.professionnalReferer.get()));
        output.writeInt(MiscUtil.fromInt(this.externalId.get()));
        output.writeString(MiscUtil.fromString(this.consultationReason.get()));
        output.writeByte(MiscUtil.fromBoolean(this.cancelled.get()));
        output.writeLong(MiscUtil.fromLong(this.cancelledDate.get()));
        output.writeInt(MiscUtil.fromInt(this.cancelledBy.get() == null ? null : Integer.valueOf(this.cancelledBy.get().getValue())));
        output.writeString(MiscUtil.fromString(this.availabilityId.get()));
        output.writeByte(MiscUtil.fromBoolean(this.hasOldAvailabilityId.get()));
        output.writeInt(MiscUtil.fromInt(this.idService.get()));
        output.writeByte(MiscUtil.fromBoolean(this.wasProfNameHidden.get()));
        output.writeString(MiscUtil.fromString(this.notePatient.get()));
        short s = (short)this.idProfessionals.get().size();
        output.writeShort((int)s);
        if (s > 0) {
            ArrayList lst = new ArrayList(this.idProfessionals.get());
            for (short i = 0; i < s; i = (short)(i + 1)) {
                output.writeInt(MiscUtil.fromInt((Integer)lst.get(i)));
            }
        }
        short readByte2 = (short)this.patients.get().size();
        output.writeShort((int)readByte2);
        if (readByte2 > 0) {
            ArrayList lst = new ArrayList(this.patients.get());
            for (short i = 0; i < readByte2; i = (short)(i + 1)) {
                k.writeObject(output, lst.get(i));
            }
        }
        output.writeString(this.adhocPatient.get());
        output.writeString(this.contactMethods);
        super.write(k, output);
    }

    @Override
    public void read(Kryo k, Input input) {
        short readByte2;
        short i;
        this.id.plain_set(MiscUtil.toInt(input.readInt()));
        this.startTime.plain_set(MiscUtil.toShort(input.readShort()));
        this.endTime.plain_set(MiscUtil.toShort(input.readShort()));
        this.arrivedTime.plain_set(MiscUtil.toShort(input.readShort()));
        this.seenTime.plain_set(MiscUtil.toShort(input.readShort()));
        this.patientStatus.plain_set(XPatientStatus.from(MiscUtil.toInt(input.readByte())));
        this.status.plain_set(XAppointmentStatus.from(MiscUtil.toInt(input.readByte())));
        this.isAnnualExam.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.note.plain_set(MiscUtil.toString(input.readString()));
        this.statusNote.plain_set(MiscUtil.toString(input.readString()));
        this.autoSendReminder.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.timeReminderDone.plain_set(MiscUtil.toLong(input.readLong()));
        this.nbHreBeforeAppt.plain_set(MiscUtil.toShort(input.readShort()));
        this.isDeleted.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.isConfidential.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.categoryType.plain_set(MiscUtil.toShort(input.readShort()));
        this.dateCreated.plain_set(MiscUtil.toLong(input.readLong()));
        this.dateEntryLast.plain_set(MiscUtil.toLong(input.readLong()));
        this.nameUser.plain_set(MiscUtil.toString(input.readString()));
        this.idAppointmentDate.plain_set(MiscUtil.toInt(input.readInt()));
        this.date.plain_set(MiscUtil.toLocalDate(input.readInt()));
        this.idProfessional.plain_set(MiscUtil.toInt(input.readInt()));
        this.typeAppointment.plain_set(MiscUtil.toInt(input.readInt()));
        this.idSite.plain_set(MiscUtil.toInt(input.readInt()));
        this.professionnalReferer.plain_set(MiscUtil.toInt(input.readInt()));
        this.externalId.plain_set(MiscUtil.toInt(input.readInt()));
        this.consultationReason.plain_set(MiscUtil.toString(input.readString()));
        this.cancelled.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.cancelledDate.plain_set(MiscUtil.toLong(input.readLong()));
        this.cancelledBy.plain_set(EnumWithValues.from(XAppointmentCancelledBy.class, MiscUtil.toInt(input.readInt())));
        this.availabilityId.plain_set(MiscUtil.toString(input.readString()));
        this.hasOldAvailabilityId.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.idService.plain_set(MiscUtil.toInt(input.readInt()));
        this.wasProfNameHidden.plain_set(MiscUtil.toBoolean(input.readByte()));
        this.notePatient.plain_set(MiscUtil.toString(input.readString()));
        short readByte1 = input.readShort();
        if (readByte1 > 0) {
            for (i = 0; i < readByte1; i = (short)((byte)(i + 1))) {
                this.idProfessionals.get().add(input.readInt());
            }
        }
        if ((readByte2 = input.readShort()) > 0) {
            for (i = 0; i < readByte2; i = (short)((byte)(i + 1))) {
                XPatient xp = (XPatient)k.readObject(input, XPatient.class);
                if (xp == null) continue;
                this.patients.get().add(xp);
            }
        }
        this.adhocPatient.plain_set(input.readString());
        this.contactMethods = input.readString();
        super.read(k, input);
    }

    public EnumSet<XEncounterLabel> getEncLabel() {
        return this.encLabel.get();
    }

    public void setEncLabel(EnumSet<XEncounterLabel> status) {
        this.encLabel.set(status);
        this.setUpdated();
    }

    public void removeXEncounterLabel(XEncounterLabel x) {
        this.encLabel.get().remove(x);
        this.setUpdated();
    }

    public void addXEncounterLabel(XEncounterLabel x) {
        this.encLabel.get().add(x);
        this.setUpdated();
    }

    public XAppointment() {
        this.patientStatus = this.newProperty("patientStatus", XPatientStatus.NONE, true);
        this.isAnnualExam = this.newProperty("isAnnualExam", false);
        this.note = this.newProperty("note", "");
        this.statusNote = this.newProperty("statusNote", "");
        this.autoSendReminder = this.newProperty("autoSendReminder", false);
        this.nbHreBeforeAppt = this.newProperty("nbHreBeforeAppt", null, false);
        this.timeReminderDone = this.newProperty("timeReminderDone", null);
        this.isDeleted = this.newProperty("isDeleted", false);
        this.typeAppointment = this.newProperty("typeAppointment", null);
        this.idService = this.newProperty("idService", null);
        ArrayList set = new ArrayList(1);
        this.patients = this.newProperty("patients", set, true);
        this.adhocPatient = this.newProperty("adhocPatient", null);
        this.adhocXPatient = this.newProperty("adhocXPatient", null, true);
        this.idSite = this.newProperty("idSite", null, false);
        this.date = this.newProperty("date", null, false);
        this.idAppointmentDate = this.newProperty("idAppointmentDate", null, false);
        HashSet initialValue = new HashSet(1);
        this.idProfessionals = this.newProperty("professionals", initialValue, true);
        this.idProfessional = this.newProperty("professional", null, false);
        this.professionnalReferer = this.newProperty("professionnalReferer", null);
        this.isConfidential = this.newProperty("confidential", null);
        this.categoryType = this.newProperty("categoryType", null);
        this.dateCreated = this.newProperty("dateCreated", DateUtil.nowUTC(), false);
        this.dateEntryLast = this.newProperty("dateEntryLast", null, true);
        this.nameUser = this.newProperty("nameUser", "");
        this.externalId = this.newProperty("externalId", null);
        this.wasProfNameHidden = this.newProperty("wasProfNameHidden", Boolean.FALSE);
        this.notePatient = this.newProperty("notePatient", null);
        this.encLabel = this.newProperty("encLabel", EnumSet.noneOf(XEncounterLabel.class));
        this.adhocPatient = this.newProperty("adhocPatient", null);
        this.availabilityId = this.newProperty("availabilityId", null);
        this.hasOldAvailabilityId = this.newProperty("hasOldAvailabilityId", null);
        this.cancelled = this.newProperty("cancelled", null);
        this.cancelledDate = this.newProperty("cancelledDate", null);
        this.cancelledBy = this.newProperty("cancelledBy", null);
        this.consultationReason = this.newProperty("consultationReason", null);
    }

    @Override
    protected void childModified(Object object) {
        if (object == this.patients.get() || object == this.idProfessionals.get() || object == this.adhocXPatient.get()) {
            this.setUpdated();
        } else {
            super.childModified(object);
        }
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    @Override
    public boolean isDirty() {
        boolean patientDirty = false;
        if (this.getPatients() != null) {
            for (XPatient p : this.getPatients()) {
                patientDirty = patientDirty || p.isDirty();
            }
        }
        if (!patientDirty && this.adhocXPatient.get() != null) {
            patientDirty = this.adhocXPatient.get().isDirty();
        }
        if (this.isChildrenUpdated() && !patientDirty) {
            this.modificationStatus.plain_set(ModificationStatus.STATUS_NEUTRAL);
        }
        boolean dirty = super.isDirty() || patientDirty;
        return dirty;
    }

    @Override
    public Integer getId() {
        return this.id.get();
    }

    @Override
    public void setId(Integer id) {
        this.id.set(id);
    }

    @Override
    public Short getStartTime() {
        return this.startTime.get();
    }

    public void setStartTime(Short startTime) {
        this.startTime.set(startTime);
    }

    @Override
    public Short getEndTime() {
        return this.endTime.get();
    }

    public void setEndTime(Short endTime) {
        this.endTime.set(endTime);
    }

    @Override
    public Short getSeenTime() {
        return this.seenTime.get();
    }

    public void setSeenTime(Short seenTime) {
        this.seenTime.set(seenTime);
    }

    @Override
    public Short getArrivedTime() {
        return this.arrivedTime.get();
    }

    public void setArrivedTime(Short arrivedTime) {
        this.arrivedTime.set(arrivedTime);
    }

    @Override
    public XAppointmentStatus getStatus() {
        return this.status.get();
    }

    public void setStatus(XAppointmentStatus status) {
        this.status.set(status);
    }

    @Override
    public XPatientStatus getPatientStatus() {
        return this.patientStatus.get();
    }

    public void setPatientStatus(XPatientStatus status) {
        this.patientStatus.set(status);
    }

    @Override
    public Boolean getIsAnnualExam() {
        return this.isAnnualExam.get();
    }

    public void setIsAnnualExam(Boolean isAnnualExam) {
        this.isAnnualExam.set(isAnnualExam);
    }

    @Override
    public String getNote() {
        return this.note.get();
    }

    public void setNote(String note) {
        this.note.set(note);
    }

    @Override
    public String getStatusNote() {
        return this.statusNote.get();
    }

    public void setStatusNote(String note) {
        this.statusNote.set(note);
    }

    @Override
    public final Boolean getAutoSendReminder() {
        return this.autoSendReminder.get();
    }

    public final void setAutoSendReminder(Boolean autoSendReminder) {
        this.autoSendReminder.set(autoSendReminder);
    }

    @Override
    public final Long getTimeReminderDone() {
        return this.timeReminderDone.get();
    }

    public final void setTimeReminderDone(Long timeReminderDone) {
        this.timeReminderDone.set(timeReminderDone);
    }

    @Override
    public final Short getNbHreBeforeAppt() {
        return this.nbHreBeforeAppt.get();
    }

    public final void setNbHreBeforeAppt(Short nbHreBeforeAppt) {
        this.nbHreBeforeAppt.set(nbHreBeforeAppt);
    }

    @Override
    public Boolean getIsDeleted() {
        return this.isDeleted.get();
    }

    public void setIsDeleted(Boolean isDeleted) {
        if (this.isNewOrNewUpdated() && isDeleted.booleanValue()) {
            this.isDeleted.set(isDeleted, ModificationStatus.STATUS_DELETED);
        } else {
            this.isDeleted.set(isDeleted);
        }
    }

    @Override
    public XPatient getPatient() {
        if (this.patients.get() != null && this.patients.get().size() != 1) {
            return null;
        }
        return this.patients.get().iterator().next();
    }

    @Override
    public Integer getTypeAppointment() {
        return this.typeAppointment.get();
    }

    public void setTypeAppointment(Integer type) {
        this.typeAppointment.set(type);
    }

    @Override
    public Integer getIdService() {
        return this.idService.get();
    }

    public void setIdService(Integer type) {
        this.idService.set(type);
    }

    @Override
    public LocalDate getDate() {
        return this.date.get();
    }

    public void setDate(LocalDate date) {
        this.date.set(date);
    }

    @Override
    public Integer getIdAppointmentDate() {
        return this.idAppointmentDate.get();
    }

    public void setIdAppointmentDate(Integer id) {
        this.idAppointmentDate.set(id);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj instanceof XAppointment) {
            equals = this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XAppointment" + this.getId()).hashCode();
        return hashCode;
    }

    @Override
    public String getDateTimeDuree() {
        String dateText = LocalDateFormat.format((LocalDate)this.getDate(), (String)FormatDateProvider.getFormatDate().toString());
        return dateText + " " + this.getStartTimeInString() + this.getDuree();
    }

    @Override
    public String getStartTimeInString() {
        return this.getTimeInString(this.getStartTime() == null ? null : Integer.valueOf(this.getStartTime().intValue()));
    }

    private String getTimeInString(Integer i) {
        if (i == null) {
            return "??:??";
        }
        return DateUtil.convertTimeToString((Integer)i, (Character)Character.valueOf(':'));
    }

    @Override
    public String getDuree() {
        return " (" + String.valueOf(this.getEndTime().intValue() - this.getStartTime().intValue()) + "M) ";
    }

    @Override
    public Integer getLength() {
        if (this.getStartTime() != null && this.getEndTime() != null) {
            return this.getEndTime() - this.getStartTime();
        }
        return null;
    }

    @Override
    public Integer getSite() {
        return this.idSite.get();
    }

    public void setSite(Integer site) {
        this.idSite.set(site);
    }

    @Override
    public String toString() {
        return "XAppointment " + this.id + ", " + this.modificationStatus + ", " + this.tag + ", " + this.version + "]";
    }

    @Override
    public XAppointment clone() {
        XAppointment c = (XAppointment)super.clone();
        c.id = this.clonePropertyTo(c, this.id);
        c.startTime = this.clonePropertyTo(c, this.startTime);
        c.endTime = this.clonePropertyTo(c, this.endTime);
        c.arrivedTime = this.clonePropertyTo(c, this.arrivedTime);
        c.seenTime = this.clonePropertyTo(c, this.seenTime);
        c.patientStatus = this.clonePropertyTo(c, this.patientStatus);
        c.status = this.clonePropertyTo(c, this.status);
        c.isAnnualExam = this.clonePropertyTo(c, this.isAnnualExam);
        c.note = this.clonePropertyTo(c, this.note);
        c.statusNote = this.clonePropertyTo(c, this.statusNote);
        c.autoSendReminder = this.clonePropertyTo(c, this.autoSendReminder);
        c.timeReminderDone = this.clonePropertyTo(c, this.timeReminderDone);
        c.nbHreBeforeAppt = this.clonePropertyTo(c, this.nbHreBeforeAppt);
        c.isDeleted = this.clonePropertyTo(c, this.isDeleted);
        c.isConfidential = this.clonePropertyTo(c, this.isConfidential);
        c.categoryType = this.clonePropertyTo(c, this.categoryType);
        c.dateCreated = this.clonePropertyTo(c, this.dateCreated);
        c.dateEntryLast = this.clonePropertyTo(c, this.dateEntryLast);
        c.nameUser = this.clonePropertyTo(c, this.nameUser);
        c.idAppointmentDate = this.clonePropertyTo(c, this.idAppointmentDate);
        c.date = this.clonePropertyTo(c, this.date);
        c.idProfessional = this.clonePropertyTo(c, this.idProfessional);
        c.idProfessionals = this.clonePropertyTo(c, this.idProfessionals);
        c.patients = this.clonePropertyTo(c, this.patients);
        c.adhocPatient = this.clonePropertyTo(c, this.adhocPatient);
        c.adhocXPatient = this.clonePropertyTo(c, this.adhocXPatient);
        c.parsedAdhocPatient = this.parsedAdhocPatient;
        if (c.patients != null) {
            if (c.patients.get() instanceof Listenable) {
                Listenable listenable = (Listenable)((Object)c.patients.get());
                boolean enabled = listenable.isListenerEnabled();
                listenable.setListenerEnabled(false);
                List<XPatient> list = c.patients.get();
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, list.get(i).clone());
                }
                listenable.setListenerEnabled(enabled);
            } else {
                List<XPatient> list = c.patients.get();
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, list.get(i).clone());
                }
            }
        }
        c.typeAppointment = this.clonePropertyTo(c, this.typeAppointment);
        c.idService = this.clonePropertyTo(c, this.idService);
        c.idSite = this.clonePropertyTo(c, this.idSite);
        c.professionnalReferer = this.clonePropertyTo(c, this.professionnalReferer);
        c.externalId = this.clonePropertyTo(c, this.externalId);
        c.wasProfNameHidden = this.clonePropertyTo(c, this.wasProfNameHidden);
        c.notePatient = this.clonePropertyTo(c, this.notePatient);
        c.encLabel = this.clonePropertyTo(c, this.encLabel);
        c.consultationReason = this.clonePropertyTo(c, this.consultationReason);
        c.cancelled = this.clonePropertyTo(c, this.cancelled);
        c.cancelledDate = this.clonePropertyTo(c, this.cancelledDate);
        c.cancelledBy = this.clonePropertyTo(c, this.cancelledBy);
        c.availabilityId = this.clonePropertyTo(c, this.availabilityId);
        c.hasOldAvailabilityId = this.clonePropertyTo(c, this.hasOldAvailabilityId);
        return c;
    }

    @Override
    public int compareTo(XAppointment o) {
        int i = o.getDate().compareTo((IPartialDate)this.getDate());
        if (i == 0) {
            if (this.getStartTime() != null && o.getStartTime() != null) {
                return o.getStartTime().compareTo(this.getStartTime());
            }
            if (this.getStartTime() != null) {
                return -1;
            }
            if (o.getStartTime() != null) {
                return 1;
            }
        }
        return i;
    }

    @Override
    public MessageLink getMessageLink() {
        return null;
    }

    public void setProfessionnalReferer(EditableDataObject.Property<Integer> professionnalReferer) {
        this.professionnalReferer = professionnalReferer;
    }

    public void setProfessionnalReferer(Integer professionnalReferer) {
        this.professionnalReferer.set(professionnalReferer);
    }

    @Override
    public Integer getProfessionnalReferer() {
        return this.professionnalReferer.get();
    }

    @Override
    public Set<Integer> getIdProfessionals() {
        return this.idProfessionals.get();
    }

    public void setIdProfessionals(Set<Integer> idProfessionals) {
        this.idProfessionals.set(idProfessionals);
    }

    @Override
    public Integer getIdProfessional() {
        return this.idProfessional.get();
    }

    public void setIdProfessional(Integer idProfessional) {
        this.idProfessional.set(idProfessional);
    }

    public List<XPatient> getPatients() {
        return this.patients.get();
    }

    public void setIsConfidential(Boolean b) {
        this.isConfidential.set(b);
    }

    @Override
    public Boolean getIsConfidential() {
        return this.isConfidential.get();
    }

    public final Short getCategoryType() {
        return this.categoryType.get();
    }

    public final void setCategoryType(Short categoryType) {
        this.categoryType.set(categoryType);
    }

    @Override
    public Long getDateCreated() {
        return this.dateCreated.get();
    }

    public void setDateCreated(Long d) {
        this.dateCreated.set(d);
    }

    @Override
    public Long getDateEntryLast() {
        return this.dateEntryLast.get();
    }

    public void setDateEntryLast(Long d) {
        this.dateEntryLast.set(d);
    }

    @Override
    public String getNameUser() {
        return this.nameUser.get();
    }

    public void setNameUser(String s) {
        this.nameUser.set(s);
    }

    public Integer getExternalId() {
        return this.externalId.get();
    }

    public void setExternalId(Integer extId) {
        this.externalId.set(extId);
    }

    @Override
    public String getConsultationReason() {
        return this.consultationReason.get();
    }

    public void setConsultationReason(String v) {
        this.consultationReason.set(v);
    }

    @Override
    public Boolean getWasProfNameHidden() {
        return this.wasProfNameHidden.get();
    }

    public void setWasProfNameHidden(Boolean s) {
        this.wasProfNameHidden.set(s);
    }

    @Override
    public String getNotePatient() {
        return this.notePatient.get();
    }

    public void setNotePatient(String b) {
        this.notePatient.set(b);
    }

    @Override
    public String getAvailabilityId() {
        return this.availabilityId.get();
    }

    public void setAvailabilityId(String hubAvailabilityId) {
        this.availabilityId.set(hubAvailabilityId);
    }

    public Boolean getHasOldAvailabilityId() {
        return this.hasOldAvailabilityId.get();
    }

    @Override
    public Boolean getCancelled() {
        return this.cancelled.get();
    }

    public void setCancelled(Boolean cancelled) {
        this.cancelled.set(cancelled);
    }

    @Override
    public XAppointmentCancelledBy getCancelledBy() {
        return this.cancelledBy.get();
    }

    public void setCancelledBy(XAppointmentCancelledBy cancelledBy) {
        this.cancelledBy.set(cancelledBy);
    }

    @Override
    public Long getCancelledDate() {
        return this.cancelledDate.get();
    }

    public void setCancelledDate(Long cancelledDate) {
        this.cancelledDate.set(cancelledDate);
    }

    @Override
    public XPatient getAdhocPatient(IJsonReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        if (this.parsedAdhocPatient) {
            return this.adhocXPatient.get();
        }
        this.adhocXPatient.plain_set2(reader.fromJson(this.adhocPatient.get(), XPatient.class));
        this.parsedAdhocPatient = true;
        return this.adhocXPatient.get();
    }

    public String getAdhocPatient() {
        return this.adhocPatient.get();
    }

    public void setAdhocPatient(IJsonWriter writer, XPatient value) {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        this.parsedAdhocPatient = true;
        this.adhocXPatient.set(value);
        this.adhocPatient.set(writer.toJson(value));
    }

    public void setContactMethods(String jsonContactMethods) {
        this.contactMethods = jsonContactMethods;
        this.contactMethodsList = null;
    }

    public String getContactMethods() {
        return this.contactMethods;
    }

    public void setContactMethodsList(IJsonWriter writer, List<XAppointmentContactMethod> list) {
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        this.parsedContactMethods = true;
        this.contactMethodsList = list;
        this.contactMethods = writer.toJson(list);
    }

    @Override
    public List<XAppointmentContactMethod> getContactMethodsList(IJsonReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        if (this.parsedContactMethods) {
            return this.contactMethodsList;
        }
        this.contactMethodsList = reader.fromJsonList(this.contactMethods, new TypeToken<List<XAppointmentContactMethod>>(XAppointmentContactMethod.class){});
        this.parsedContactMethods = true;
        return this.contactMethodsList;
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        if (this.getPatients() == null || this.getPatients().isEmpty()) {
            status.add(new Status(IStatus.Severity.ERROR, "Un RV doit avoir un patient / An appointment needs a patient."));
        } else {
            for (XPatient x : this.getPatients()) {
                if (StringUtils.isBlank((CharSequence)x.getLastName()) || StringUtils.isBlank((CharSequence)x.getFirstName()) || StringUtils.isBlank((CharSequence)x.getGender()) || x.getBirthDate() == null) {
                    status.add(new Status(IStatus.Severity.ERROR, "Un patient doit avoir un nom, une DDN et un sexe / A patient needs a name, a DOB and a sex."));
                }
                if (x.lstContactInformation == null || x.lstContactInformation.isEmpty()) {
                    status.add(new Status(IStatus.Severity.ERROR, "Un patient doit avoir un nom, une DDN et un sexe / A patient needs a name, a DOB and a sex."));
                    continue;
                }
                if (x.getContactInformation1() != null && !StringUtils.isBlank((CharSequence)x.getContactInformation1().getContact()) || x.getContactInformation2() != null && !StringUtils.isBlank((CharSequence)x.getContactInformation2().getContact()) || x.getContactInformationCellAutre() != null && !StringUtils.isBlank((CharSequence)x.getContactInformationCellAutre().getContact()) || x.getContactInformationCellPrinc() != null && !StringUtils.isBlank((CharSequence)x.getContactInformationCellPrinc().getContact())) continue;
                status.add(new Status(IStatus.Severity.ERROR, "Un patient doit avoir un moyen de communication / A patient needs at least one contact info."));
            }
        }
        return status;
    }
}

