/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPerson;
import ca.infodata.ofys.data.middle.dataobjects.XPersonType;
import ca.infodata.ofys.data.middle.dataobjects.employee.XEmployeeType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public final class XEmployee
extends XPerson
implements ICompletionComboItem,
KryoSerializable {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public XEmployeeType type;
    public String number;

    @Override
    public void write(Kryo k, Output out) {
        out.writeInt(MiscUtil.fromInt(this.id));
        out.writeShort(this.type.getValue());
        out.writeString(MiscUtil.fromString(this.number));
        super.write(k, out);
    }

    @Override
    public void read(Kryo k, Input in) {
        this.id = MiscUtil.toInt(in.readInt());
        this.type = XEmployeeType.from(Integer.valueOf(in.readShort()));
        this.number = MiscUtil.toString(in.readString());
        super.read(k, in);
    }

    @Override
    public void initialize() {
        this.setNew();
        this.setNumber("");
        this.setPersonType(XPersonType.EMP);
        this.setEmployeeType(XEmployeeType.RECEPTIONISTE);
        super.initialize();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public XEmployeeType getEmployeeType() {
        return this.type;
    }

    public void setEmployeeType(XEmployeeType type) {
        this.type = type;
        this.setUpdated();
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XEmployee) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XEmployee" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public String toString() {
        String ret = this.str;
        if (ret == null) {
            ret = this.isNewOrNewUpdated() ? Messages.getString("NOUVEL_EMPLOYE", new String[0]) : this.getName();
        }
        return ret;
    }

    @Override
    public XEmployee clone() {
        XEmployee c = (XEmployee)super.clone();
        c.id = this.id;
        c.type = this.type;
        c.number = this.number;
        c.personType = XPersonType.EMP;
        super.copyTo(c);
        return c;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getText() {
        return StringUtils.isEmpty((String)this.str) ? this.getName() : this.str;
    }

    @Override
    public boolean isActive() {
        return !Boolean.TRUE.equals(this.getIsDeleted());
    }
}

