/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.util;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IMessageQueueConnectionInfo;
import ca.infodata.ofys.data.dataaccess.LoginAccessorClient;
import ca.infodata.ofys.data.dataaccess.MessageQueueConnectionInfo;
import ca.infodata.ofys.data.dataaccess.PreferencesAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.dataaccess.util.IGlobalInstances;
import ca.infodata.ofys.data.dataaccess.util.ISessionLock;
import ca.infodata.ofys.data.dataaccess.util.SessionLock;
import ca.infodata.ofys.data.dataaccess.util.SessionLockException;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumer;
import ca.infodata.ofys.data.dataaccess.util.notification.NotificationHandler;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqConsumer2;
import ca.infodata.ofys.data.dataaccess.util.notification.rabbitmq.RabbitMqThreadFactory;
import ca.infodata.ofys.data.middle.dataobjects.XRight;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XUser;
import ca.infodata.ofys.data.middle.dataobjects.XUserRole;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Ping;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateSource;
import ca.infodata.ofys.data.middle.dataobjects.preferences.GlobalFormatDateStrategy;
import ca.infodata.ofys.data.middle.dataobjects.preferences.XFormatDate;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.date.GlobalLocaleStrategy;
import ca.infodata.util1.date.GlobalTimeZoneStrategy;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.LocaleSource;
import ca.infodata.util1.date.TimeZoneProvider;
import ca.infodata.util1.date.TimeZoneSource;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public class GlobalInstances
implements IGlobalInstances {
    private static final Logger logger = Logger.getLogger(GlobalInstances.class.getName());
    private static boolean myReadyApp = false;
    public boolean testing = false;
    private final NotificationHandler pingNotificationHandler;
    private final NotificationHandler sessionNotificationHandler;
    private final List<WeakReference<GlobalInstancesListener>> listeners = new CopyOnWriteArrayList<WeakReference<GlobalInstancesListener>>();
    private Integer patientCopy;
    private XSession session;
    private IConnectionInfo connectionInfo;
    private IConnectionInfo sofiapayConnectionInfo;
    private IConnectionInfo sqlDirectoryConnectionInfo;
    private IConnectionInfo autologConnectionInfo;
    private IConnectionInfo templateConnectionInfo;
    private IConnectionInfo dxConnectionInfo;
    private IConnectionInfo keysetConnectionInfo;
    private IConnectionInfo rxDrugRefConnectionInfo;
    private IConnectionInfo rxVigilanceConnectionInfo;
    private IMessageQueueConnectionInfo messageQueueConnectionInfo;
    private IConsumer notificationSystem;
    private ConcurrentMap<String, Object> localSessionBindedValues;
    private ISessionLock sessionLock;
    private boolean isLoggingOut = false;
    private boolean debugModeOn;
    private ScheduledThreadPoolExecutor mqScheduledThreadPoolExecutor;
    private ScheduledFuture<?> scheduledFuture;

    public GlobalInstances() {
        this.sessionNotificationHandler = new SessionNotificationHandler();
        this.pingNotificationHandler = new PingNotificationHandler();
        this.localSessionBindedValues = new ConcurrentHashMap<String, Object>();
        TimeZoneProvider.setTimeZoneSource((TimeZoneSource)new GlobalTimeZoneStrategy());
        LocaleProvider.setLocaleSource((LocaleSource)new GlobalLocaleStrategy());
        this.setTimeZone(TimeZone.getDefault());
        this.setLocale(Locale.getDefault());
        FormatDateProvider.setFormatDateSource((FormatDateSource)new GlobalFormatDateStrategy());
        this.setFormatDate(XFormatDate.YYYY_MM_DD);
        this.getNotificationSystem().addNotificationHandler(this.sessionNotificationHandler);
        this.getNotificationSystem().addNotificationHandler(this.pingNotificationHandler);
        ConnectionInfo.trustAllHttpsServerCertificate();
        try {
            this.debugModeOn = Platform.isRunning() ? Platform.inDebugMode() : true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set default debug mode ", e);
        }
    }

    public boolean isDashboardVisible() {
        XUser user;
        XSession session2 = this.getSession();
        if (session2 != null && session2 != null && session2.getClient() != null && session2.getClient().getClientCode() != null && (user = session2.getUser()) != null) {
            return user.hasOneOfRoles(new XUserRole[]{XUserRole.HEALTHCARE_PROVIDER, XUserRole.MEDICAL_SECRETARY, XUserRole.SECRETARY, XUserRole.STAGIAIRE});
        }
        return false;
    }

    public void setLocale(Locale locale) {
        if (LocaleProvider.isSupported((Locale)locale)) {
            LocaleProvider.setLocale((Locale)locale);
            Locale.setDefault(locale);
            LocaleProvider.setLocale((Locale)locale);
        } else {
            logger.log(Level.WARNING, "locale " + locale + " is not supported. Default to " + Locale.FRENCH);
            this.setLocale(Locale.FRENCH);
        }
    }

    private void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            logger.log(Level.INFO, "set timeZone to default " + TimeZone.getDefault().getDisplayName());
            timeZone = TimeZone.getDefault();
        } else {
            timeZone = (TimeZone)timeZone.clone();
        }
        TimeZone.setDefault(timeZone);
        TimeZoneProvider.setTimeZone((TimeZone)timeZone);
    }

    private void setFormatDate(XFormatDate formatDate) {
        formatDate = formatDate == null ? XFormatDate.YYYY_MM_DD : XFormatDate.from((Integer)formatDate.id);
        XFormatDate.setDefault((XFormatDate)formatDate);
        FormatDateProvider.setFormatDate((XFormatDate)formatDate);
    }

    public void addGlobalInstancesListener(GlobalInstancesListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cant be null");
        }
        this.listeners.add(new WeakReference<GlobalInstancesListener>(listener));
    }

    public void removeGlobalInstancesListener(GlobalInstancesListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cant be null");
        }
        Iterator<WeakReference<GlobalInstancesListener>> iterator = new ArrayList<WeakReference<GlobalInstancesListener>>(this.listeners).iterator();
        while (iterator.hasNext()) {
            WeakReference<GlobalInstancesListener> next = iterator.next();
            if (next != null && next.get() != listener) continue;
            iterator.remove();
        }
    }

    private void fireAppReady() {
        Iterator<WeakReference<GlobalInstancesListener>> iterator = new ArrayList<WeakReference<GlobalInstancesListener>>(this.listeners).iterator();
        while (iterator.hasNext()) {
            WeakReference<GlobalInstancesListener> next = iterator.next();
            if (next == null || next.get() == null) {
                iterator.remove();
                continue;
            }
            try {
                ((GlobalInstancesListener)next.get()).appReady();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unexpected exception", e);
            }
        }
    }

    private void firePreSessionChanged() {
        Iterator<WeakReference<GlobalInstancesListener>> iterator = new ArrayList<WeakReference<GlobalInstancesListener>>(this.listeners).iterator();
        while (iterator.hasNext()) {
            WeakReference<GlobalInstancesListener> next = iterator.next();
            if (next == null || next.get() == null) {
                iterator.remove();
                continue;
            }
            try {
                ((GlobalInstancesListener)next.get()).preSessionChanged();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unexpected exception", e);
            }
        }
    }

    private void fireSessionChanged() {
        Iterator<WeakReference<GlobalInstancesListener>> iterator = new ArrayList<WeakReference<GlobalInstancesListener>>(this.listeners).iterator();
        while (iterator.hasNext()) {
            WeakReference<GlobalInstancesListener> next = iterator.next();
            if (next == null || next.get() == null) {
                iterator.remove();
                continue;
            }
            try {
                ((GlobalInstancesListener)next.get()).sessionChanged();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unexpected exception", e);
            }
        }
    }

    private void fireLogout() {
        Iterator<WeakReference<GlobalInstancesListener>> iterator = new ArrayList<WeakReference<GlobalInstancesListener>>(this.listeners).iterator();
        while (iterator.hasNext()) {
            WeakReference<GlobalInstancesListener> next = iterator.next();
            if (next == null || next.get() == null) {
                iterator.remove();
                continue;
            }
            try {
                ((GlobalInstancesListener)next.get()).logout();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unexpected exception", e);
            }
        }
    }

    public IConsumer getNotificationSystem() {
        if (this.notificationSystem == null) {
            this.notificationSystem = this.getMessageQueueConnectionInfo().getConsumer();
        }
        return this.notificationSystem;
    }

    public Integer getSessionPerson() {
        XUser user;
        XSession session = this.getSession();
        if (session != null && (user = session.getUser()) != null) {
            return user.getBasePerson();
        }
        return null;
    }

    public Integer getSessionIdUser() {
        XUser user;
        XSession session = this.getSession();
        if (session != null && (user = session.getUser()) != null) {
            return user.getId();
        }
        return null;
    }

    public XSession getSession() {
        return this.session;
    }

    public Object getLocalSessionValue(String key, Object defaultValue) {
        Object value = this.localSessionBindedValues.get(key);
        return value == null ? defaultValue : value;
    }

    public void setLocalSessionValue(String key, Object value) {
        this.localSessionBindedValues.put(key, value);
    }

    public boolean hasRight(XRight right) {
        try {
            XUser user;
            XSession session = this.getSession();
            if (session != null && (user = session.getUser()) != null) {
                return XRight.hasRight((XRight)right, (EnumSet)user.getCrisisManagedRole());
            }
            return false;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to determine if user has right " + right, e);
            return false;
        }
    }

    public boolean hasOneOfRoles(XUserRole ... roles) {
        try {
            XUser user;
            XSession session = this.getSession();
            return session != null && (user = session.getUser()) != null && user.hasOneOfRoles(roles);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to determine if user has one of roles " + Arrays.toString(roles), e);
            return false;
        }
    }

    public boolean isAppReady() {
        return myReadyApp;
    }

    public void appReady() {
        myReadyApp = true;
        this.fireAppReady();
    }

    public void setSession(XSession session) throws Exception {
        boolean changed;
        boolean bl = changed = session != this.session;
        if (changed) {
            this.validSessionLock(session);
            this.firePreSessionChanged();
            if (session != null && session.getId() != null) {
                boolean shouldReconfigureNotificationSystem;
                boolean bl2 = shouldReconfigureNotificationSystem = this.session == null || !session.getId().equals(this.session.getId());
                if (!this.testing && shouldReconfigureNotificationSystem) {
                    this.getNotificationSystem().close();
                    this.makeMqConnection(new MqConnectTask(session));
                }
                session.setLocale(Locale.getDefault());
                this.isLoggingOut = false;
            } else if (!this.testing) {
                this.getNotificationSystem().setEnabledFalse();
                new DaemonThread("closeNotificationSystemTask"){

                    public void run() {
                        GlobalInstances.this.getNotificationSystem().close();
                    }
                }.start();
            }
            this.session = session;
            this.localSessionBindedValues.clear();
            this.fireSessionChanged();
            this.actualiseTimeZone();
            this.actualiseFormatDate();
        }
    }

    private void validSessionLock(XSession newSession) throws SessionLockException {
        if (this.session == null) {
            if (newSession != null) {
                this.sessionLock = new SessionLock(newSession);
                this.sessionLock.tryLock();
            }
        } else if (newSession == null) {
            this.sessionLock.releaseLock();
        } else if (!newSession.getClient().equals((Object)this.session.getClient()) || !newSession.getUser().getName().equals(this.getSession().getUser().getName())) {
            this.sessionLock.releaseLock();
            this.sessionLock = new SessionLock(newSession);
            this.sessionLock.tryLock();
        }
    }

    private void actualiseTimeZone() {
        TimeZone tz = null;
        if (this.session != null) {
            tz = this.session.getClientPreferences().getTimeZone();
        }
        this.setTimeZone(tz);
    }

    public void actualiseFormatDate() {
        XFormatDate fd = null;
        if (this.session != null) {
            fd = this.session.getClientPreferences().getFormatDate();
        }
        this.setFormatDate(fd);
    }

    public Integer getPatientCopy() {
        return this.patientCopy;
    }

    public void setPatientCopy(Integer patientCopy) {
        this.patientCopy = patientCopy;
    }

    public IConnectionInfo getConnectionInfo() {
        if (this.connectionInfo == null) {
            this.connectionInfo = this.getConnectionInfoFromSystemProperties();
            if (this.connectionInfo == null) {
                this.setConnectionInfo(ConnectionInfo.localhostTest);
            }
            logger.info(String.format("using connection info %s", this.connectionInfo));
        }
        return this.connectionInfo;
    }

    public IConnectionInfo getSofiapayConnectionInfo() {
        if (this.sofiapayConnectionInfo == null) {
            this.sofiapayConnectionInfo = this.getSofiapayConnectionInfoFromSystemProperties();
            if (this.sofiapayConnectionInfo == null) {
                this.setSofiapayConnectionInfo(ConnectionInfo.localhostSofiapayTest);
            }
            logger.info(String.format("using connection info %s", this.sofiapayConnectionInfo));
        }
        return this.sofiapayConnectionInfo;
    }

    public IConnectionInfo getRxVigilanceConnectionInfo() {
        if (this.rxVigilanceConnectionInfo == null) {
            this.rxVigilanceConnectionInfo = GlobalInstances.getRxVigilanceConnectionInfoFromSystemProperties();
            if (this.rxVigilanceConnectionInfo == null) {
                this.rxVigilanceConnectionInfo = ConnectionInfo.rxVigilanceTest;
            }
            logger.info(String.format("using connection info %s", this.connectionInfo));
        }
        return this.rxVigilanceConnectionInfo;
    }

    private IConnectionInfo getConnectionInfoFromSystemProperties() {
        ConnectionInfo info = null;
        String url = null;
        try {
            url = System.getProperty("ca.infodata.ofys.server.url");
            if (url == null) {
                logger.log(Level.INFO, "No connection info from system properties ca.infodata.ofys.server.url");
            } else {
                info = new ConnectionInfo(url);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get connection info from system properties ca.infodata.ofys.server.url " + url, e);
        }
        return info;
    }

    private IConnectionInfo getSofiapayConnectionInfoFromSystemProperties() {
        ConnectionInfo info = null;
        String url = null;
        try {
            url = System.getProperty("sofiapay.server.url");
            if (url == null) {
                url = this.getTemplateConnectionInfo().getServerAddress().contains("test.ofys.biz") ? "https://test.ofys.biz/sofiapay" : (this.getTemplateConnectionInfo().getServerAddress().contains("ofyspro.ca") ? "https://ofyspro.ca/sofiapay" : "http://127.0.0.1:8099/sofiapay");
                logger.log(Level.WARNING, "No connection info from system properties sofiapay.server.url the env variable was not set defaulting to " + url + " add the vmArgument -Dsofiapay.server.url=http://127.0.0.1:8099/sofiapay to be specific");
            }
            info = new ConnectionInfo(url);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get connection info from system properties sofiapay.server.url " + url, e);
        }
        return info;
    }

    private static IConnectionInfo getRxVigilanceConnectionInfoFromSystemProperties() {
        ConnectionInfo info = null;
        String url = null;
        try {
            url = System.getProperty("rx.vigilance.url");
            if (url == null) {
                logger.log(Level.INFO, "No connection info from system properties rx.vigilance.url");
            } else {
                if (url.contains("rxstage")) {
                    url = "https://rx.stg.vigilance.ca:443/";
                }
                info = new ConnectionInfo(url);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get connection info from system properties rx.vigilance.url " + url, e);
        }
        return info;
    }

    public IMessageQueueConnectionInfo getMessageQueueConnectionInfo() {
        if (this.messageQueueConnectionInfo == null) {
            this.messageQueueConnectionInfo = this.getMQConnectionInfoFromSystemProperties();
            if (this.messageQueueConnectionInfo == null) {
                if (MessageQueueConnectionInfo.shamMqConnection == null) {
                    MessageQueueConnectionInfo.shamMqConnection = new MessageQueueConnectionInfo("", 0, false, "ca.infodata.ofys.data.dataaccess.util.notification.ShamConsumer");
                }
                this.setMQConnectionInfo(MessageQueueConnectionInfo.shamMqConnection);
            }
            logger.info(String.format("using connection info %s", this.messageQueueConnectionInfo));
        }
        return this.messageQueueConnectionInfo;
    }

    private IMessageQueueConnectionInfo getMQConnectionInfoFromSystemProperties() {
        MessageQueueConnectionInfo info;
        block7: {
            info = null;
            String url = null;
            String mqPort = null;
            boolean mqSSL = true;
            String clazz = null;
            try {
                url = System.getProperty("ca.infodata.ofys.jmsserver.url");
                mqSSL = !"false".equals(System.getProperty("mq_ssl"));
                mqPort = System.getProperty("mq_port");
                clazz = System.getProperty("mq.consumer.class");
                if (url == null) {
                    logger.log(Level.INFO, "No connection info from system properties ca.infodata.ofys.jmsserver.url");
                    break block7;
                }
                if (clazz == null) {
                    clazz = RabbitMqConsumer2.class.getName();
                }
                int port = 5672;
                if (mqPort != null) {
                    try {
                        port = Integer.parseInt(mqPort);
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.WARNING, "Integer.parseInt(mqPort)", nfe);
                    }
                }
                info = new MessageQueueConnectionInfo(url, port, mqSSL, clazz);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to get connection info from system properties ca.infodata.ofys.jmsserver.url " + url, e);
            }
        }
        return info;
    }

    public void setConnectionInfo(IConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("connectionInfo cant be null");
        }
        logger.log(Level.INFO, "Using connection info " + connectionInfo);
        if (this.connectionInfo != connectionInfo) {
            this.connectionInfo = connectionInfo;
        }
    }

    public void setSofiapayConnectionInfo(IConnectionInfo sofiapayConnectionInfo) {
        if (sofiapayConnectionInfo == null) {
            throw new IllegalArgumentException("sofiapay connectionInfo cant be null");
        }
        logger.log(Level.INFO, "Using sofiapay connection info " + sofiapayConnectionInfo);
        if (this.sofiapayConnectionInfo != sofiapayConnectionInfo) {
            this.sofiapayConnectionInfo = sofiapayConnectionInfo;
        }
    }

    public void setMQConnectionInfo(IMessageQueueConnectionInfo connectionInfo) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("connectionInfo cant be null");
        }
        logger.log(Level.INFO, "Using jms connection info " + connectionInfo);
        if (this.messageQueueConnectionInfo != connectionInfo) {
            block8: {
                if (this.messageQueueConnectionInfo != null) {
                    try {
                        try {
                            this.messageQueueConnectionInfo.close();
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            this.messageQueueConnectionInfo.setConsumer(null);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        this.messageQueueConnectionInfo.setConsumer(null);
                        throw throwable;
                    }
                    this.messageQueueConnectionInfo.setConsumer(null);
                }
            }
            this.messageQueueConnectionInfo = connectionInfo;
        }
    }

    public boolean isLoggingOut() {
        return this.isLoggingOut;
    }

    public void logout() {
        this.isLoggingOut = true;
        logger.info("logging out");
        if (this.session != null) {
            try {
                LoginAccessorClient.getInstance().logOut(this.session, new Callback(new JustLogStatusHandler()){

                    @Override
                    public void exception(Exception e) {
                        logger.log(Level.INFO, "Error while trying to logout", e);
                    }
                });
            }
            catch (CannotConnectToServerException e) {
                logger.log(Level.FINE, "Error while trying to logout", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while trying to logout", e);
            }
            try {
                this.setSession(null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while trying to logout", e);
            }
            this.fireLogout();
        }
    }

    public boolean canConnectToServer() {
        try {
            LoginAccessorClient.getInstance();
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            return false;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            return false;
        }
        return true;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public boolean inDebugMode() {
        return this.debugModeOn;
    }

    public void setDebugMode(boolean state) {
        this.debugModeOn = state;
    }

    private void makeMqConnection(MqConnectTask task) throws InterruptedException, TimeoutException, Exception {
        System.out.println("================= dans makeMqConnection");
        if (this.mqScheduledThreadPoolExecutor != null && !this.mqScheduledThreadPoolExecutor.isTerminated()) {
            this.mqScheduledThreadPoolExecutor.shutdownNow();
        }
        this.mqScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new RabbitMqThreadFactory("rabbitmq-connect"));
        this.scheduledFuture = this.mqScheduledThreadPoolExecutor.scheduleWithFixedDelay(task, 1L, 30000L, TimeUnit.MILLISECONDS);
    }

    public void dispose() {
    }

    public IConnectionInfo getSqlDirectoryConnectionInfo() {
        if (this.sqlDirectoryConnectionInfo == null) {
            this.sqlDirectoryConnectionInfo = GlobalInstances.getSqlDirectoryConnectionInfoFromSystemProperties();
            logger.info(String.format("using sql directory connection info %s", this.sqlDirectoryConnectionInfo));
        }
        return this.sqlDirectoryConnectionInfo;
    }

    private static IConnectionInfo getSqlDirectoryConnectionInfoFromSystemProperties() {
        String key = "ca.infodata.ofys.sqldir.url";
        return GlobalInstances.getConnectionInfoFromSystemProperties(key);
    }

    public IConnectionInfo getAutologConnectionInfo() {
        if (this.autologConnectionInfo == null) {
            this.autologConnectionInfo = GlobalInstances.getAutologConnectionInfoFromSystemProperties();
            logger.info(String.format("using autolog connection info %s", this.autologConnectionInfo));
        }
        return this.autologConnectionInfo;
    }

    private static IConnectionInfo getAutologConnectionInfoFromSystemProperties() {
        String key = "ca.infodata.ofys.autolog.url";
        ConnectionInfo c = GlobalInstances.getConnectionInfoFromSystemProperties(key);
        if (c != null) {
            c.setTimeoutInMillis((int)TimeUnit.SECONDS.toMillis(5L));
        }
        return c;
    }

    public IConnectionInfo getTemplateConnectionInfo() {
        if (this.templateConnectionInfo == null) {
            this.templateConnectionInfo = GlobalInstances.getTemplateConnectionInfoFromSystemProperties();
            logger.info(String.format("using template connection info %s", this.templateConnectionInfo));
        }
        return this.templateConnectionInfo;
    }

    private static IConnectionInfo getTemplateConnectionInfoFromSystemProperties() {
        ConnectionInfo c = GlobalInstances.getConnectionInfoFromSystemProperties("ca.infodata.ofys.server.url");
        if (c != null) {
            c.setTimeoutInMillis((int)TimeUnit.SECONDS.toMillis(5L));
        }
        return c;
    }

    public IConnectionInfo getRxDrugRefConnectionInfo() {
        if (this.rxDrugRefConnectionInfo == null) {
            this.rxDrugRefConnectionInfo = GlobalInstances.getRxDrugRefConnectionInfoFromSystemProperties();
            if (this.rxDrugRefConnectionInfo == null) {
                this.rxDrugRefConnectionInfo = new ConnectionInfo("https://www.ofys.ca:443", (int)TimeUnit.MINUTES.toMillis(1L));
            }
            logger.info(String.format("using rxDrugRef connection info %s", this.rxDrugRefConnectionInfo));
        }
        return this.rxDrugRefConnectionInfo;
    }

    private static IConnectionInfo getRxDrugRefConnectionInfoFromSystemProperties() {
        ConnectionInfo c = GlobalInstances.getConnectionInfoFromSystemProperties("ca.infodata.ofys.drugref.url");
        if (c != null) {
            c.setTimeoutInMillis((int)TimeUnit.MINUTES.toMillis(1L));
        }
        return c;
    }

    public IConnectionInfo getKeysetConnectionInfo() {
        if (this.keysetConnectionInfo == null) {
            this.keysetConnectionInfo = GlobalInstances.getKeysetConnectionInfoFromSystemProperties();
            logger.info(String.format("using keyset connection info %s", this.keysetConnectionInfo));
        }
        return this.keysetConnectionInfo;
    }

    private static IConnectionInfo getKeysetConnectionInfoFromSystemProperties() {
        ConnectionInfo c = GlobalInstances.getConnectionInfoFromSystemProperties("ca.infodata.ofys.postalcode.url");
        if (c != null) {
            c.setTimeoutInMillis((int)TimeUnit.SECONDS.toMillis(5L));
        }
        return c;
    }

    public IConnectionInfo getDxConnectionInfo() {
        if (this.dxConnectionInfo == null) {
            this.dxConnectionInfo = GlobalInstances.getDxConnectionInfoFromSystemProperties();
            logger.info(String.format("using dx server connection info %s", this.dxConnectionInfo));
        }
        return this.dxConnectionInfo;
    }

    private static IConnectionInfo getDxConnectionInfoFromSystemProperties() {
        ConnectionInfo c = GlobalInstances.getConnectionInfoFromSystemProperties("ca.infodata.ofys.dxserver.url");
        if (c != null) {
            c.setTimeoutInMillis((int)TimeUnit.SECONDS.toMillis(5L));
        }
        return c;
    }

    private static ConnectionInfo getConnectionInfoFromSystemProperties(String key) {
        ConnectionInfo info = null;
        String url = null;
        try {
            url = System.getProperty(key);
            if (url == null) {
                logger.log(Level.INFO, "No connection info from system properties " + key);
            } else {
                info = new ConnectionInfo(url);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get connection info from system properties " + key + " : " + url, e);
        }
        return info;
    }

    public boolean isAutologEnabled() {
        return this.autologConnectionInfo != null;
    }

    public boolean isQCClient() {
        return !this.isNBClient();
    }

    public boolean isNBClient() {
        XSession session = Application.get().getGlobalInstances().getSession();
        if (session != null) {
            TimeZone timeZone = session.getClientPreferences().getTimeZone();
            boolean isNb = timeZone != null && timeZone.getRawOffset() == TimeZone.getTimeZone("America/Moncton").getRawOffset();
            return isNb;
        }
        return false;
    }

    public void updateSession(XSession session) throws Exception {
    }

    private class MqConnectTask
    implements Runnable {
        private XSession xSession;

        public MqConnectTask(XSession sess) {
            this.xSession = sess;
        }

        @Override
        public void run() {
            try {
                if (!GlobalInstances.this.getNotificationSystem().isActive() && this.xSession != null && this.xSession.getId() != null) {
                    System.out.println("================= dans MqConnectTask - start(session)");
                    GlobalInstances.this.getNotificationSystem().start(this.xSession);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in MqConnectTask", e);
            }
        }
    }

    private class PingNotificationHandler
    implements NotificationHandler {
        private PingNotificationHandler() {
        }

        public void handle(Notification notification) {
            if (notification instanceof Ping) {
                Ping ping = (Ping)notification;
                if (GlobalInstances.this.session != null && GlobalInstances.this.session.getId().equals(ping.getSessionId())) {
                    try {
                        PreferencesAccessorClient.getInstance().executeTask("ping", GlobalInstances.this.session.getId(), GlobalInstances.this.session, new DefaultCallback());
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private class SessionNotificationHandler
    implements NotificationHandler {
        private SessionNotificationHandler() {
        }

        public void handle(Notification notification) {
            if (notification instanceof DataObjectUpdatedNotification) {
                IDataObject object = ((DataObjectUpdatedNotification)notification).getObject();
                if (object instanceof XSession && this.areSessionsEquals((XSession)object, GlobalInstances.this.session)) {
                    try {
                        GlobalInstances.this.setSession((XSession)object);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Failed to update session. new=" + object + " old=" + GlobalInstances.this.getSession(), e);
                    }
                } else if (GlobalInstances.this.session != null && object instanceof XUser && object.equals(GlobalInstances.this.session.getUser())) {
                    XSession newSession = GlobalInstances.this.getSession().clone();
                    try {
                        newSession.user = (XUser)object.clone();
                        GlobalInstances.this.setSession(newSession);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Failed to update session. new=" + newSession + " old=" + GlobalInstances.this.getSession(), e);
                    }
                }
            }
        }

        private boolean areSessionsEquals(XSession session1, XSession session2) {
            if (session1 == session2) {
                return true;
            }
            if (session1 == null || session2 == null) {
                return false;
            }
            return MiscUtil.areObjectsEquals((Object)session1.getId(), (Object)session2.getId());
        }
    }
}

