/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IReportAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XReportContainer;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(ReportAccessorClient.class.getName());
    private static ReportAccessorClient instance;
    private final IReportAccessor accessor;

    public static ReportAccessorClient getInstance() throws CannotConnectToServerException {
        return ReportAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static ReportAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new ReportAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private ReportAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getReportAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public void getReports(final int uniqueKey, final String nip, XSession session, final ICallback callback, final Serializable dataObj) {
        if (this.isOkToCallFunction("ReportAccessorClient.getReports" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.getReports(dataObj, nip);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ReportAccessorClient.this.functionCallEnded("ReportAccessorClient.getReports" + uniqueKey, callback);
                        }
                    }
                    finally {
                        ReportAccessorClient.this.functionCallEnded("ReportAccessorClient.getReports" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getReportsSync(int uniqueKey, String nip, XSession session, ICallback callback, Serializable dataObj) {
        if (this.isOkToCallFunction("ReportAccessorClient.getReports" + uniqueKey, callback)) {
            try {
                try {
                    ReturnObject returnObject = ReportAccessorClient.instance.accessor.getReports(dataObj, nip);
                    callback.response(returnObject);
                }
                catch (Exception e) {
                    callback.exception(e);
                    logger.log(Level.SEVERE, "Erreur", e);
                    this.functionCallEnded("ReportAccessorClient.getReports" + uniqueKey, callback);
                }
            }
            finally {
                this.functionCallEnded("ReportAccessorClient.getReports" + uniqueKey, callback);
            }
        }
    }

    public void getFinishedReports(final int uniqueKey, final String nip, XSession session, final Serializable obj, final XReportContainer container, final ICallback callback) {
        try {
            if (this.isOkToCallFunction("ReportAccessorClient.getPdf" + uniqueKey, callback)) {
                new BaseAccessorClient.DoThread(this){

                    @Override
                    public ICallback run() {
                        try {
                            try {
                                ReturnObject returnObject = instance.accessor.getFinishedReports(obj, container, nip);
                                callback.response(returnObject);
                            }
                            catch (Exception e) {
                                callback.exception(e);
                                logger.log(Level.SEVERE, "Erreur", e);
                                ReportAccessorClient.this.functionCallEnded("ReportAccessorClient.getPdf" + uniqueKey, callback);
                            }
                        }
                        finally {
                            ReportAccessorClient.this.functionCallEnded("ReportAccessorClient.getPdf" + uniqueKey, callback);
                        }
                        return callback;
                    }
                };
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
        }
    }

    public ReturnObject getFinishedReportsSync(int uniqueKey, String nip, XSession session, Serializable obj, XReportContainer container) {
        String function = "ReportAccessorClient.getPdf" + uniqueKey;
        if (this.isOkToCallFunction(function, null)) {
            try {
                ReturnObject returnObject = ReportAccessorClient.instance.accessor.getFinishedReports(obj, container, nip);
                return returnObject;
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return null;
    }

    public void reset(final int uniqueKey, final boolean useFileAsSource, XSession session) {
        try {
            if (this.isOkToCallFunction("ReportAccessorClient.getPdf" + uniqueKey, null)) {
                new BaseAccessorClient.DoThread(this){

                    @Override
                    public ICallback run() {
                        try {
                            try {
                                ReportAccessorClient.this.getAccessor().reset(useFileAsSource);
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Erreur", e);
                                ReportAccessorClient.this.functionCallEnded("ReportAccessorClient.getPdf" + uniqueKey, null);
                            }
                        }
                        finally {
                            ReportAccessorClient.this.functionCallEnded("ReportAccessorClient.getPdf" + uniqueKey, null);
                        }
                        return null;
                    }
                };
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
        }
    }

    protected IReportAccessor getAccessor() {
        return this.accessor;
    }
}

