/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IProfessionnalAccessor;
import ca.infodata.ofys.data.dataaccess.ISearchTextAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnalCriteria;
import ca.infodata.ofys.data.middle.dataobjects.XProfessionnalWebCriteria;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.XWebSearchProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.library.log.Log;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfessionnalAccessorClient
extends BaseAccessorClient
implements ISearchTextAccessor {
    private static final Logger logger = Logger.getLogger(ProfessionnalAccessorClient.class.getName());
    private static ProfessionnalAccessorClient instance;
    private final IProfessionnalAccessor accessor;

    public static ProfessionnalAccessorClient getInstance() throws CannotConnectToServerException {
        return ProfessionnalAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static ProfessionnalAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new ProfessionnalAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", (Throwable)e2);
            throw e2;
        }
        return instance;
    }

    private ProfessionnalAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getProfessionnalAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", (Throwable)e2);
            throw e2;
        }
    }

    public IProfessionnalAccessor getAccessor() {
        return this.accessor;
    }

    public void countAllAppointmentProfessionnals(final int uniqueKey, XSession session, final ICallback callback) {
        if (this.isOkToCallFunction("ProfessionnalAccessorClient.countAllAppointmentProfessionnals" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.countAllAppointmentProfessionnals());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.countAllAppointmentProfessionnals" + uniqueKey, callback);
                        }
                    }
                    finally {
                        ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.countAllAppointmentProfessionnals" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public Object getProfessionnalSync(XSession session, int professionnalId, boolean xbase) throws Exception {
        String function = "ProfessionnalAccessorClient.getProfessionnal" + professionnalId + xbase;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = ProfessionnalAccessorClient.instance.accessor.getProfessionnal(professionnalId, xbase);
                Object object = returnObject == null ? null : returnObject.getObj();
                return object;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get Professionnal " + professionnalId, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public Object getProfessionnalByIdPersonSync(XSession session, int personId, boolean xbase) throws Exception {
        String function = "ProfessionnalAccessorClient.getProfessionnalByIdPersonSync" + personId + xbase;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = ProfessionnalAccessorClient.instance.accessor.getProfessionnalByIdPerson(personId, xbase);
                Object object = returnObject == null ? null : returnObject.getObj();
                return object;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to get Professionnal " + personId, e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    @Override
    public void findFromId(int uniqueKey, XSession session, ICallback callback, int professionnalId) {
        this.getProfessionnal(uniqueKey, session, callback, professionnalId, false);
    }

    public void getProfessionnal(final int uniqueKey, XSession session, final ICallback callback, final int professionnalId, final boolean xbase) {
        if (this.isOkToCallFunction("ProfessionnalAccessorClient.getProfessionnal" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getProfessionnal(professionnalId, xbase));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.getProfessionnal" + uniqueKey, callback);
                        }
                    }
                    finally {
                        ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.getProfessionnal" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findTreatingProfessionnals(final int uniqueKey, XSession session, final ICallback callback, final int type) throws RemoteException {
        if (this.isOkToCallFunction("ProfessionnalAccessorClient.findTreatingProfessionnals" + uniqueKey, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findTreatingProfessionnals(type));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.findTreatingProfessionnals" + uniqueKey, callback);
                        }
                    }
                    finally {
                        ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.findTreatingProfessionnals" + uniqueKey, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void synchronizedFindTreatingProfessionnals(int uniqueKey, XSession session, ICallback callback, int type) throws Exception {
        if (this.isOkToCallFunction("ProfessionnalAccessorClient.findTreatingProfessionnals" + uniqueKey, callback)) {
            try {
                try {
                    logger.fine("ca.infodata.ofys.client.Application.get().getGlobalInstances().getSession().getId().intValue() = " + Application.get().getGlobalInstances().getSession().getId() + ", type = " + type);
                    callback.response(ProfessionnalAccessorClient.instance.accessor.findTreatingProfessionnals(type));
                }
                catch (Exception e) {
                    callback.exception(e);
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded("ProfessionnalAccessorClient.findTreatingProfessionnals" + uniqueKey, callback);
                }
            }
            finally {
                this.functionCallEnded("ProfessionnalAccessorClient.findTreatingProfessionnals" + uniqueKey, callback);
            }
        }
    }

    @Override
    public void findFromSearchText(int uniqueKey, XSession session, ICallback callback, int type, String text) {
        this.findProfesssionnals(session, callback, text, type, false, true, null, true);
    }

    public void findProfesssionnals(XSession session, final ICallback callback, final String nameOrCode, final Integer type, final boolean web, final boolean returnOneOrNone, final XWebSearchProvince webProvince, final Boolean isActive) {
        if (this.isOkToCallFunction("ProfessionnalAccessorClient.findProfessional", callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    block6: {
                        try {
                            try {
                                if (web) {
                                    XProfessionnalWebCriteria c = new XProfessionnalWebCriteria();
                                    c.nameOrCode = nameOrCode;
                                    c.webProvince = webProvince;
                                    c.returnOneOrNone = returnOneOrNone;
                                    callback.response(instance.accessor.find(c));
                                    break block6;
                                }
                                XProfessionnalCriteria c = new XProfessionnalCriteria();
                                c.nameOrCode = nameOrCode;
                                c.returnOneOrNone = returnOneOrNone;
                                int t = type != null ? type : -1;
                                c.isTreating = t == 1 || t == 0 || t == 4 || t == 8 || t == 2;
                                c.useAppointment = t == 1 || t == 0;
                                c.isActive = isActive;
                                callback.response(instance.accessor.find(c));
                            }
                            catch (Exception e) {
                                callback.exception(e);
                                Log.severe((String)"Erreur", (Exception)e);
                                ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.findProfessional", callback);
                            }
                        }
                        finally {
                            ProfessionnalAccessorClient.this.functionCallEnded("ProfessionnalAccessorClient.findProfessional", callback);
                        }
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findProfesssionnalsSync(XSession session, String nameOrCode, Integer type, boolean web, boolean returnOneOrNone, XWebSearchProvince webProvince) {
        if (web) {
            XProfessionnalWebCriteria c = new XProfessionnalWebCriteria();
            c.nameOrCode = nameOrCode;
            c.webProvince = webProvince;
            c.returnOneOrNone = returnOneOrNone;
            return this.accessor.find(c);
        }
        XProfessionnalCriteria c = new XProfessionnalCriteria();
        c.nameOrCode = nameOrCode;
        c.returnOneOrNone = returnOneOrNone;
        int t = type != null ? type : -1;
        c.isTreating = t == 1 || t == 0 || t == 4 || t == 8 || t == 2;
        c.useAppointment = t == 1 || t == 0;
        return this.accessor.find(c);
    }

    public void findProfessionnalTypeInUse(int uniqueKey, XSession session, final ICallback callback) {
        final String function = "ProfessionnalAccessorClient.findProfessionnalTypeInUse" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findProfessionnalTypeInUse());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ProfessionnalAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ProfessionnalAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject findProfessionnalTypeInUseSync(XSession session) {
        return ProfessionnalAccessorClient.instance.accessor.findProfessionnalTypeInUse();
    }

    public void findAllPersonReplacements(int uniqueKey, XSession session, final ICallback callback) {
        final String function = "ProfessionnalAccessorClient.findAllPersonReplacements" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findAllPersonReplacements());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ProfessionnalAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ProfessionnalAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findAllPersonReplacementsSync(int uniqueKey, XSession session, ICallback callback) {
        String function = "ProfessionnalAccessorClient.findAllPersonReplacementsSync" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    callback.response(ProfessionnalAccessorClient.instance.accessor.findAllPersonReplacements());
                }
                catch (Exception e) {
                    callback.exception(e);
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void findAllOtherProviders(int uniqueKey, XSession session, final ICallback callback) {
        final String function = "ProfessionnalAccessorClient.findAllOtherProviders" + uniqueKey;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findAllOtherProviders());
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            ProfessionnalAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ProfessionnalAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }
}

