/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.ILaboResultsAccessor;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XBaseLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsCriteria;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalQuery;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XLaboResultsProfessionnalStatus;
import ca.infodata.ofys.data.middle.dataobjects.laboresults.XNumberByLaboResultsProfessionnalQuery;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.JoinList;
import java.util.logging.Level;

public class LaboResultsAccessorClient
extends BaseAccessorClient {
    private static LaboResultsAccessorClient instance;
    private ILaboResultsAccessor accessor;

    public static LaboResultsAccessorClient getInstance() throws CannotConnectToServerException {
        return LaboResultsAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static LaboResultsAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new LaboResultsAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private LaboResultsAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getLaboResultsAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected ILaboResultsAccessor getAccessor() {
        return this.accessor;
    }

    public XNumberByLaboResultsProfessionnalQuery getNumberByLaboResultsContainer(XSession session, XLaboResultsProfessionnalQuery container) throws Exception {
        String function = "LaboResultsAccessorClient.getNumberByLaboResultsContainer" + container.hashCode();
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = LaboResultsAccessorClient.instance.accessor.countLaboResultsProfessionnal(container);
                XNumberByLaboResultsProfessionnalQuery xNumberByLaboResultsProfessionnalQuery = (XNumberByLaboResultsProfessionnalQuery)(returnObject == null ? null : returnObject.getObj());
                return xNumberByLaboResultsProfessionnalQuery;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
                throw e;
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public void getNumberByLaboResultsContainerAsync(XSession session, final XLaboResultsProfessionnalQuery container, final ICallback callback) throws Exception {
        final String function = "LaboResultsAccessorClient.getNumberByLaboResultsContainerAsync" + container.hashCode();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.countLaboResultsProfessionnal(container);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getYearsOfLaboResults(XSession session, final ICallback callback, final Integer idPatient, final Integer idProfessionnal) {
        if (idPatient == null) {
            throw new NullPointerException("patient");
        }
        final String function = "LaboResultsAccessorClient.getYearsOfLaboResults" + idPatient.hashCode() + (idProfessionnal == null ? null : Integer.valueOf(idProfessionnal.hashCode()));
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getYearsOfLaboResults(idPatient.intValue(), idProfessionnal));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findLaboResultsProfessionnal(XSession session, final ICallback callback, final XLaboResultsProfessionnalQuery container) {
        final String function = "LaboResultsAccessorClient.findBaseLaboResults" + container.hashCode();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findLaboResultsProfessionnal(container));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPartialLaboResultsText(XSession session, final ICallback callback, final String labNo, final Integer idPatient) {
        final String function = "LaboResultsAccessorClient.findPartialLaboResultsText" + labNo;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findPartialLaboResultsText(labNo, idPatient));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findLaboResults(XSession session, final ICallback callback, final XLaboResultsCriteria criteria) {
        final String function = "LaboResultsAccessorClient.findLaboResults" + criteria;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findLaboResults(criteria));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findLaboResultsSync(XSession session, ICallback callback, XLaboResultsCriteria criteria) {
        String function = "LaboResultsAccessorClient.findLaboResults" + criteria;
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    callback.response(LaboResultsAccessorClient.instance.accessor.findLaboResults(criteria));
                }
                catch (Exception e) {
                    callback.exception(e);
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void computePatientCreatinineClearance(XSession session, final ICallback callback, final int patientId) {
        final String function = "LaboResultsAccessorClient.computePatientCreatinineClearance" + patientId;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.computePatientCreatinineClearance(patientId));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject computePatientCreatinineClearanceSync(XSession session, int patientId) {
        String function = "LaboResultsAccessorClient.computePatientCreatinineClearance" + patientId;
        ReturnObject ro = null;
        if (this.isOkToCallFunction(function)) {
            try {
                try {
                    ro = LaboResultsAccessorClient.instance.accessor.computePatientCreatinineClearance(patientId);
                }
                catch (Exception e) {
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded(function);
                }
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return ro;
    }

    public void reassignLaboResultsToPatient(XSession session, final ICallback callback, final XBaseLaboResultsProfessionnal laboResultsProfessionnal, final int patientId) {
        final String function = "LaboResultsAccessorClient.reassignLaboResultsToPatient" + laboResultsProfessionnal.getId() + patientId;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.reassignLaboResultsToPatient(laboResultsProfessionnal.getId().intValue(), patientId));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getLaboResultsProfessionnal(XSession session, final ICallback callback, final XBaseLaboResultsProfessionnal laboResultsProfessionnal) {
        final String function = "LaboResultsAccessorClient.getLaboResultsProfessionnal " + laboResultsProfessionnal.getId();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getLaboResultsProfessionnal(laboResultsProfessionnal.getId(), Boolean.FALSE));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getLaboResultsProfessionnalByIdText(XSession session, final ICallback callback, final Integer idText) {
        final String function = "LaboResultsAccessorClient.getLaboResultsProfessionnalByIdText " + idText;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getLaboResultsProfessionnalByIdText(idText));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getLaboResultsProfessionnalNoThread(XSession session, ICallback callback, XLaboResultsProfessionnal laboResultsProfessionnal) {
        String function = "LaboResultsAccessorClient.getLaboResultsProfessionnal " + laboResultsProfessionnal.getId();
        if (this.isOkToCallFunction(function, callback)) {
            try {
                try {
                    callback.response(LaboResultsAccessorClient.instance.accessor.getLaboResultsProfessionnal(laboResultsProfessionnal.getId(), Boolean.FALSE));
                }
                catch (Exception e) {
                    callback.exception(e);
                    Log.severe((String)"Erreur", (Exception)e);
                    this.functionCallEnded(function, callback);
                }
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
    }

    public void getLaboResultsProfessionnal(XSession session, final ICallback callback, final XLaboResultsProfessionnal laboResultsProfessionnal) {
        final String function = "LaboResultsAccessorClient.getLaboResultsProfessionnal " + laboResultsProfessionnal.getId();
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getLaboResultsProfessionnal(laboResultsProfessionnal.getId(), Boolean.FALSE));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void setLaboResultsProfessionnalEnumSetStatus(XSession session, final ICallback callback, final int[] ids, final Integer enumSetStatus, final Integer idPatient) {
        final String function = "LaboResultsAccessorClient.setLaboResultsProfessionnalEnumSetStatus:" + new JoinList("'", ids).toString() + ":" + enumSetStatus;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.setLaboResultsProfessionnalEnumSetStatus(ids, enumSetStatus, idPatient));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void setLaboResultsProfessionnalStatus(XSession session, final ICallback callback, final XBaseLaboResultsProfessionnal laboResultsProfessionnal, final XLaboResultsProfessionnalStatus status) {
        final String function = "LaboResultsAccessorClient.setLaboResultsProfessionnalStatus" + laboResultsProfessionnal.getId() + status.id;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.setLaboResultsProfessionnalStatus(laboResultsProfessionnal.getId(), Integer.valueOf(status.id)));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            Log.severe((String)"Erreur", (Exception)e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getPatientLastSpecificResultsAsync(final XSession session, final Callback callback, final Integer idPatient, final String labTypeCode) {
        final String function = "LaboResultsAccessorClient.getPatientLastSpecificResults" + idPatient + labTypeCode;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            ReturnObject returnObject = instance.accessor.getPatientLastSpecificResults(idPatient.intValue(), labTypeCode);
                            callback.response(returnObject);
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, null, idPatient), e);
                            LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        LaboResultsAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject getPatientLastSpecificResultsSync(XSession session, Integer idPatient, String labTypeCode) {
        ReturnObject returnObject = null;
        String function = "LaboResultsAccessorClient.getPatientLastSpecificResults" + idPatient + labTypeCode;
        if (this.isOkToCallFunction(function, null)) {
            try {
                try {
                    returnObject = LaboResultsAccessorClient.instance.accessor.getPatientLastSpecificResults(idPatient.intValue(), labTypeCode);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, String.format("Error in %s call. {session=%s, callback=%s, patientId=%s}", function, session, null, idPatient), e);
                    this.functionCallEnded(function, null);
                }
            }
            finally {
                this.functionCallEnded(function, null);
            }
        }
        return returnObject;
    }
}

