/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.derivative;

import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ejml.UtilEjml;

public class NumericalGradientForward
implements FunctionNtoN {
    private final int N;
    private FunctionNtoS function;
    private double differenceScale;

    public NumericalGradientForward(FunctionNtoS function, double differenceScale) {
        this.function = function;
        this.differenceScale = differenceScale;
        this.N = function.getNumOfInputsN();
    }

    public NumericalGradientForward(FunctionNtoS function) {
        this(function, Math.sqrt(UtilEjml.EPS));
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public void process(double[] input, double[] output) {
        double valueOrig = this.function.process(input);
        for (int i = 0; i < this.N; ++i) {
            double x = input[i];
            double h = x != 0.0 ? this.differenceScale * Math.abs(x) : this.differenceScale;
            double temp = x + h;
            h = temp - x;
            input[i] = temp;
            double perturbed = this.function.process(input);
            output[i] = (perturbed - valueOrig) / h;
            input[i] = x;
        }
    }
}

