/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.misc.GrlConstants;
import georegression.struct.EulerType;
import georegression.struct.so.Quaternion_F32;
import georegression.struct.so.Rodrigues_F32;
import org.ejml.data.FMatrixRMaj;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.dense.row.factory.DecompositionFactory_FDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F32;

public class ConvertRotation3D_F32 {
    public static FMatrixRMaj rodriguesToMatrix(Rodrigues_F32 rodrigues, FMatrixRMaj R) {
        return ConvertRotation3D_F32.rodriguesToMatrix(rodrigues.unitAxisRotation.x, rodrigues.unitAxisRotation.y, rodrigues.unitAxisRotation.z, rodrigues.theta, R);
    }

    public static FMatrixRMaj rodriguesToMatrix(float axisX, float axisY, float axisZ, float theta, FMatrixRMaj R) {
        R = ConvertRotation3D_F32.checkDeclare3x3(R);
        float x = axisX;
        float y = axisY;
        float z = axisZ;
        float c = (float)Math.cos(theta);
        float s = (float)Math.sin(theta);
        float oc = 1.0f - c;
        R.data[0] = c + x * x * oc;
        R.data[1] = x * y * oc - z * s;
        R.data[2] = x * z * oc + y * s;
        R.data[3] = y * x * oc + z * s;
        R.data[4] = c + y * y * oc;
        R.data[5] = y * z * oc - x * s;
        R.data[6] = z * x * oc - y * s;
        R.data[7] = z * y * oc + x * s;
        R.data[8] = c + z * z * oc;
        return R;
    }

    public static float[] rodriguesToEuler(Rodrigues_F32 rodrigues, EulerType type, float[] euler) {
        FMatrixRMaj R = ConvertRotation3D_F32.rodriguesToMatrix(rodrigues, null);
        return ConvertRotation3D_F32.matrixToEuler(R, type, euler);
    }

    public static Quaternion_F32 rodriguesToQuaternion(Rodrigues_F32 rodrigues, Quaternion_F32 quat) {
        if (quat == null) {
            quat = new Quaternion_F32();
        }
        quat.w = (float)Math.cos(rodrigues.theta / 2.0f);
        float s = (float)Math.sin(rodrigues.theta / 2.0f);
        quat.x = rodrigues.unitAxisRotation.x * s;
        quat.y = rodrigues.unitAxisRotation.y * s;
        quat.z = rodrigues.unitAxisRotation.z * s;
        return quat;
    }

    public static Rodrigues_F32 quaternionToRodrigues(Quaternion_F32 quat, Rodrigues_F32 rodrigues) {
        if (rodrigues == null) {
            rodrigues = new Rodrigues_F32();
        }
        rodrigues.unitAxisRotation.set(quat.x, quat.y, quat.z);
        rodrigues.unitAxisRotation.normalize();
        rodrigues.theta = 2.0f * (float)Math.acos(quat.w);
        return rodrigues;
    }

    public static float[] quaternionToEuler(Quaternion_F32 q, EulerType type, float[] euler) {
        FMatrixRMaj R = ConvertRotation3D_F32.quaternionToMatrix(q, null);
        return ConvertRotation3D_F32.matrixToEuler(R, type, euler);
    }

    public static float[] matrixToEuler(FMatrixRMaj R, EulerType type, float[] euler) {
        if (euler == null) {
            euler = new float[3];
        }
        switch (type) {
            case ZYX: {
                ConvertRotation3D_F32.TanSinTan(-2, 1, 3, -6, 9, 5, -7, 4, 8, R, euler);
                break;
            }
            case ZYZ: {
                ConvertRotation3D_F32.TanCosTan(8, -7, 9, 6, 3, 5, -7, 4, 8, R, euler);
                break;
            }
            case ZXY: {
                ConvertRotation3D_F32.TanSinTan(4, 5, -6, 3, 9, 1, 8, -2, 7, R, euler);
                break;
            }
            case ZXZ: {
                ConvertRotation3D_F32.TanCosTan(7, 8, 9, 3, -6, 1, 8, -2, 7, R, euler);
                break;
            }
            case YXZ: {
                ConvertRotation3D_F32.TanSinTan(-7, 9, 8, -2, 5, 1, -6, 3, 4, R, euler);
                break;
            }
            case YXY: {
                ConvertRotation3D_F32.TanCosTan(4, -6, 5, 2, 8, 1, -6, 3, 4, R, euler);
                break;
            }
            case YZX: {
                ConvertRotation3D_F32.TanSinTan(3, 1, -2, 8, 5, 9, 4, -7, 6, R, euler);
                break;
            }
            case YZY: {
                ConvertRotation3D_F32.TanCosTan(6, 4, 5, 8, -2, 9, 4, -7, 6, R, euler);
                break;
            }
            case XYZ: {
                ConvertRotation3D_F32.TanSinTan(8, 9, -7, 4, 1, 5, 3, -6, 2, R, euler);
                break;
            }
            case XYX: {
                ConvertRotation3D_F32.TanCosTan(2, 3, 1, 4, -7, 5, 3, -6, 2, R, euler);
                break;
            }
            case XZY: {
                ConvertRotation3D_F32.TanSinTan(-6, 5, 4, -7, 1, 9, -2, 8, 3, R, euler);
                break;
            }
            case XZX: {
                ConvertRotation3D_F32.TanCosTan(3, -2, 1, 7, 4, 9, -2, 8, 3, R, euler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rotation sequence");
            }
        }
        return euler;
    }

    private static void TanSinTan(int y0, int x0, int sin1, int y2, int x2, int cos0a, int cos0b, int sin0a, int sin0b, FMatrixRMaj R, float[] euler) {
        float val_y0 = ConvertRotation3D_F32.get(R, y0);
        float val_x0 = ConvertRotation3D_F32.get(R, x0);
        float val_sin1 = ConvertRotation3D_F32.get(R, sin1);
        float val_y2 = ConvertRotation3D_F32.get(R, y2);
        float val_x2 = ConvertRotation3D_F32.get(R, x2);
        if (1.0f - Math.abs(val_sin1) <= GrlConstants.F_EPS) {
            float sign = Math.signum(val_sin1);
            float sin0 = (ConvertRotation3D_F32.get(R, sin0a) + sign * ConvertRotation3D_F32.get(R, sin0b)) / 2.0f;
            float cos0 = (ConvertRotation3D_F32.get(R, cos0a) + sign * ConvertRotation3D_F32.get(R, cos0b)) / 2.0f;
            euler[0] = (float)Math.atan2(sin0, cos0);
            euler[1] = sign * (float)Math.PI / 2.0f;
            euler[2] = 0.0f;
        } else {
            euler[0] = (float)Math.atan2(val_y0, val_x0);
            euler[1] = (float)Math.asin(val_sin1);
            euler[2] = (float)Math.atan2(val_y2, val_x2);
        }
    }

    private static void TanCosTan(int y0, int x0, int cos1, int y2, int x2, int cos0a, int cos0b, int sin0a, int sin0b, FMatrixRMaj R, float[] euler) {
        float val_y0 = ConvertRotation3D_F32.get(R, y0);
        float val_x0 = ConvertRotation3D_F32.get(R, x0);
        float val_cos1 = ConvertRotation3D_F32.get(R, cos1);
        float val_y2 = ConvertRotation3D_F32.get(R, y2);
        float val_x2 = ConvertRotation3D_F32.get(R, x2);
        if (1.0f - Math.abs(val_cos1) <= GrlConstants.F_EPS) {
            float sin0 = (ConvertRotation3D_F32.get(R, sin0a) + ConvertRotation3D_F32.get(R, sin0b)) / 2.0f;
            float cos0 = (ConvertRotation3D_F32.get(R, cos0a) + ConvertRotation3D_F32.get(R, cos0b)) / 2.0f;
            euler[0] = (float)Math.atan2(sin0, cos0);
            euler[1] = 0.0f;
            euler[2] = 0.0f;
        } else {
            euler[0] = (float)Math.atan2(val_y0, val_x0);
            euler[1] = (float)Math.acos(val_cos1);
            euler[2] = (float)Math.atan2(val_y2, val_x2);
        }
    }

    private static float get(FMatrixRMaj M, int index) {
        if (index < 0) {
            return -M.data[-index - 1];
        }
        return M.data[index - 1];
    }

    public static Quaternion_F32 matrixToQuaternion(FMatrixRMaj R, Quaternion_F32 quat) {
        if (quat == null) {
            quat = new Quaternion_F32();
        }
        float m00 = R.unsafe_get(0, 0);
        float m01 = R.unsafe_get(0, 1);
        float m02 = R.unsafe_get(0, 2);
        float m10 = R.unsafe_get(1, 0);
        float m11 = R.unsafe_get(1, 1);
        float m12 = R.unsafe_get(1, 2);
        float m20 = R.unsafe_get(2, 0);
        float m21 = R.unsafe_get(2, 1);
        float m22 = R.unsafe_get(2, 2);
        float trace = m00 + m11 + m22;
        if (trace > 0.0f) {
            float S = (float)Math.sqrt(trace + 1.0f) * 2.0f;
            quat.w = 0.25f * S;
            quat.x = (m21 - m12) / S;
            quat.y = (m02 - m20) / S;
            quat.z = (m10 - m01) / S;
        } else if (m00 > m11 & m00 > m22) {
            float S = (float)Math.sqrt(1.0f + m00 - m11 - m22) * 2.0f;
            quat.w = (m21 - m12) / S;
            quat.x = 0.25f * S;
            quat.y = (m01 + m10) / S;
            quat.z = (m02 + m20) / S;
        } else if (m11 > m22) {
            float S = (float)Math.sqrt(1.0f + m11 - m00 - m22) * 2.0f;
            quat.w = (m02 - m20) / S;
            quat.x = (m01 + m10) / S;
            quat.y = 0.25f * S;
            quat.z = (m12 + m21) / S;
        } else {
            float S = (float)Math.sqrt(1.0f + m22 - m00 - m11) * 2.0f;
            quat.w = (m10 - m01) / S;
            quat.x = (m02 + m20) / S;
            quat.y = (m12 + m21) / S;
            quat.z = 0.25f * S;
        }
        return quat;
    }

    public static Rodrigues_F32 matrixToRodrigues(FMatrixRMaj R, Rodrigues_F32 rodrigues) {
        float diagSum;
        float absDiagSum;
        if (rodrigues == null) {
            rodrigues = new Rodrigues_F32();
        }
        if ((absDiagSum = Math.abs(diagSum = (R.unsafe_get(0, 0) + R.unsafe_get(1, 1) + R.unsafe_get(2, 2) - 1.0f) / 2.0f)) <= 1.0f && 1.0f - absDiagSum > 10.0f * GrlConstants.F_EPS) {
            rodrigues.theta = (float)Math.acos(diagSum);
            float bottom = 2.0f * (float)Math.sin(rodrigues.theta);
            rodrigues.unitAxisRotation.x = (R.unsafe_get(2, 1) - R.unsafe_get(1, 2)) / bottom;
            rodrigues.unitAxisRotation.y = (R.unsafe_get(0, 2) - R.unsafe_get(2, 0)) / bottom;
            rodrigues.unitAxisRotation.z = (R.unsafe_get(1, 0) - R.unsafe_get(0, 1)) / bottom;
            rodrigues.unitAxisRotation.normalize();
        } else {
            rodrigues.theta = diagSum >= 1.0f ? 0.0f : (diagSum <= -1.0f ? (float)Math.PI : (float)Math.acos(diagSum));
            rodrigues.unitAxisRotation.x = (float)Math.sqrt((R.get(0, 0) + 1.0f) / 2.0f);
            rodrigues.unitAxisRotation.y = (float)Math.sqrt((R.get(1, 1) + 1.0f) / 2.0f);
            rodrigues.unitAxisRotation.z = (float)Math.sqrt((R.get(2, 2) + 1.0f) / 2.0f);
            float x = rodrigues.unitAxisRotation.x;
            float y = rodrigues.unitAxisRotation.y;
            float z = rodrigues.unitAxisRotation.z;
            if (Math.abs(R.get(1, 0) - 2.0f * x * y) > GrlConstants.F_EPS) {
                x *= -1.0f;
            }
            if (Math.abs(R.get(2, 0) - 2.0f * x * z) > GrlConstants.F_EPS) {
                z *= -1.0f;
            }
            if (Math.abs(R.get(2, 1) - 2.0f * z * y) > GrlConstants.F_EPS) {
                y *= -1.0f;
                x *= -1.0f;
            }
            rodrigues.unitAxisRotation.x = x;
            rodrigues.unitAxisRotation.y = y;
            rodrigues.unitAxisRotation.z = z;
        }
        return rodrigues;
    }

    public static FMatrixRMaj rotX(float ang, FMatrixRMaj R) {
        if (R == null) {
            R = new FMatrixRMaj(3, 3);
        }
        ConvertRotation3D_F32.setRotX(ang, R);
        return R;
    }

    public static void setRotX(float ang, FMatrixRMaj R) {
        float c = (float)Math.cos(ang);
        float s = (float)Math.sin(ang);
        R.set(0, 0, 1.0f);
        R.set(1, 1, c);
        R.set(1, 2, -s);
        R.set(2, 1, s);
        R.set(2, 2, c);
    }

    public static FMatrixRMaj rotY(float ang, FMatrixRMaj R) {
        R = ConvertRotation3D_F32.checkDeclare3x3(R);
        ConvertRotation3D_F32.setRotY(ang, R);
        return R;
    }

    public static void setRotY(float ang, FMatrixRMaj r) {
        float c = (float)Math.cos(ang);
        float s = (float)Math.sin(ang);
        r.set(0, 0, c);
        r.set(0, 2, s);
        r.set(1, 1, 1.0f);
        r.set(2, 0, -s);
        r.set(2, 2, c);
    }

    public static FMatrixRMaj rotZ(float ang, FMatrixRMaj R) {
        R = ConvertRotation3D_F32.checkDeclare3x3(R);
        ConvertRotation3D_F32.setRotZ(ang, R);
        return R;
    }

    public static void setRotZ(float ang, FMatrixRMaj r) {
        float c = (float)Math.cos(ang);
        float s = (float)Math.sin(ang);
        r.set(0, 0, c);
        r.set(0, 1, -s);
        r.set(1, 0, s);
        r.set(1, 1, c);
        r.set(2, 2, 1.0f);
    }

    public static FMatrixRMaj eulerToMatrix(EulerType type, float rotA, float rotB, float rotC, FMatrixRMaj R) {
        R = ConvertRotation3D_F32.checkDeclare3x3(R);
        FMatrixRMaj R_a = ConvertRotation3D_F32.rotationAboutAxis(type.getAxisA(), rotA, null);
        FMatrixRMaj R_b = ConvertRotation3D_F32.rotationAboutAxis(type.getAxisB(), rotB, null);
        FMatrixRMaj R_c = ConvertRotation3D_F32.rotationAboutAxis(type.getAxisC(), rotC, null);
        FMatrixRMaj A = new FMatrixRMaj(3, 3);
        CommonOps_FDRM.mult(R_b, R_a, A);
        CommonOps_FDRM.mult(R_c, A, R);
        return R;
    }

    public static Quaternion_F32 eulerToQuaternion(EulerType type, float rotA, float rotB, float rotC, Quaternion_F32 q) {
        if (q == null) {
            q = new Quaternion_F32();
        }
        float ca = (float)Math.cos(rotA * 0.5f);
        float sa = (float)Math.sin(rotA * 0.5f);
        float cb = (float)Math.cos(rotB * 0.5f);
        float sb = (float)Math.sin(rotB * 0.5f);
        float cc = (float)Math.cos(rotC * 0.5f);
        float sc = (float)Math.sin(rotC * 0.5f);
        float w = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        switch (type) {
            case ZYX: {
                w = ca * cb * cc - sa * sb * sc;
                x = cc * sa * sb + ca * cb * sc;
                y = ca * cc * sb - cb * sa * sc;
                z = cb * cc * sa + ca * sb * sc;
                break;
            }
            case ZYZ: {
                w = ca * cb * cc - cb * sa * sc;
                x = cc * sa * sb - ca * sb * sc;
                y = ca * cc * sb + sa * sb * sc;
                z = cb * cc * sa + ca * cb * sc;
                break;
            }
            case ZXY: {
                w = ca * cb * cc + sa * sb * sc;
                x = ca * cc * sb + cb * sa * sc;
                y = -cc * sa * sb + ca * cb * sc;
                z = cb * cc * sa - ca * sb * sc;
                break;
            }
            case ZXZ: {
                w = ca * cb * cc - cb * sa * sc;
                x = ca * cc * sb + sa * sb * sc;
                y = -cc * sa * sb + ca * sb * sc;
                z = cb * cc * sa + ca * cb * sc;
                break;
            }
            case YXZ: {
                w = ca * cb * cc - sa * sb * sc;
                x = ca * cc * sb - cb * sa * sc;
                y = cb * cc * sa + ca * sb * sc;
                z = cc * sa * sb + ca * cb * sc;
                break;
            }
            case YXY: {
                w = ca * cb * cc - cb * sa * sc;
                x = ca * cc * sb + sa * sb * sc;
                y = cb * cc * sa + ca * cb * sc;
                z = cc * sa * sb - ca * sb * sc;
                break;
            }
            case YZX: {
                w = ca * cb * cc + sa * sb * sc;
                x = -cc * sa * sb + ca * cb * sc;
                y = cb * cc * sa - ca * sb * sc;
                z = ca * cc * sb + cb * sa * sc;
                break;
            }
            case YZY: {
                w = ca * cb * cc - cb * sa * sc;
                x = -cc * sa * sb + ca * sb * sc;
                y = cb * cc * sa + ca * cb * sc;
                z = ca * cc * sb + sa * sb * sc;
                break;
            }
            case XYZ: {
                w = ca * cb * cc + sa * sb * sc;
                x = cb * cc * sa - ca * sb * sc;
                y = ca * cc * sb + cb * sa * sc;
                z = -cc * sa * sb + ca * cb * sc;
                break;
            }
            case XYX: {
                w = ca * cb * cc - cb * sa * sc;
                x = cb * cc * sa + ca * cb * sc;
                y = ca * cc * sb + sa * sb * sc;
                z = -cc * sa * sb + ca * sb * sc;
                break;
            }
            case XZY: {
                w = ca * cb * cc - sa * sb * sc;
                x = cb * cc * sa + ca * sb * sc;
                y = cc * sa * sb + ca * cb * sc;
                z = ca * cc * sb - cb * sa * sc;
                break;
            }
            case XZX: {
                w = ca * cb * cc - cb * sa * sc;
                x = cb * cc * sa + ca * cb * sc;
                y = cc * sa * sb - ca * sb * sc;
                z = ca * cc * sb + sa * sb * sc;
            }
        }
        q.set(w, x, y, z);
        return q;
    }

    private static FMatrixRMaj rotationAboutAxis(int axis, float angle, FMatrixRMaj R) {
        switch (axis) {
            case 0: {
                return ConvertRotation3D_F32.rotX(angle, R);
            }
            case 1: {
                return ConvertRotation3D_F32.rotY(angle, R);
            }
            case 2: {
                return ConvertRotation3D_F32.rotZ(angle, R);
            }
        }
        throw new IllegalArgumentException("Unknown which");
    }

    public static FMatrixRMaj approximateRotationMatrix(FMatrixRMaj orig, FMatrixRMaj R) {
        R = ConvertRotation3D_F32.checkDeclare3x3(R);
        SingularValueDecomposition_F32<FMatrixRMaj> svd = DecompositionFactory_FDRM.svd(orig.numRows, orig.numCols, true, true, false);
        if (!svd.decompose(orig)) {
            throw new RuntimeException("SVD Failed");
        }
        CommonOps_FDRM.mult(svd.getU(null, false), svd.getV(null, true), R);
        float det = CommonOps_FDRM.det(R);
        if (det < 0.0f) {
            CommonOps_FDRM.scale(-1.0f, R);
        }
        return R;
    }

    public static FMatrixRMaj quaternionToMatrix(Quaternion_F32 quat, FMatrixRMaj R) {
        return ConvertRotation3D_F32.quaternionToMatrix(quat.w, quat.x, quat.y, quat.z, R);
    }

    public static FMatrixRMaj quaternionToMatrix(float w, float x, float y, float z, FMatrixRMaj R) {
        R = ConvertRotation3D_F32.checkDeclare3x3(R);
        float q0 = w;
        float q1 = x;
        float q2 = y;
        float q3 = z;
        R.data[0] = q0 * q0 + q1 * q1 - q2 * q2 - q3 * q3;
        R.data[1] = 2.0f * (q1 * q2 - q0 * q3);
        R.data[2] = 2.0f * (q1 * q3 + q0 * q2);
        R.data[3] = 2.0f * (q1 * q2 + q0 * q3);
        R.data[4] = q0 * q0 - q1 * q1 + q2 * q2 - q3 * q3;
        R.data[5] = 2.0f * (q2 * q3 - q0 * q1);
        R.data[6] = 2.0f * (q1 * q3 - q0 * q2);
        R.data[7] = 2.0f * (q2 * q3 + q0 * q1);
        R.data[8] = q0 * q0 - q1 * q1 - q2 * q2 + q3 * q3;
        return R;
    }

    private static FMatrixRMaj checkDeclare3x3(FMatrixRMaj R) {
        if (R == null) {
            R = new FMatrixRMaj(3, 3);
        } else if (R.numRows != 3 || R.numCols != 3) {
            throw new IllegalArgumentException("Expected 3 by 3 matrix.");
        }
        return R;
    }
}

